/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;

class ObjectWriterImplIterable
extends ObjectWriterBaseModule.PrimitiveImpl {
    static final ObjectWriterImplIterable INSTANCE = new ObjectWriterImplIterable();
    Type itemType;
    long features;

    ObjectWriterImplIterable() {
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        Iterable iterable = (Iterable)object;
        ArrayList list = new ArrayList();
        for (Object o : iterable) {
            list.add(o);
        }
        boolean refDetect = jsonWriter.isRefDetect();
        jsonWriter.startArray(list.size());
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        for (int i = 0; i < list.size(); ++i) {
            String refPath;
            boolean itemRefDetect;
            ObjectWriter itemObjectWriter;
            Object item = list.get(i);
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                itemObjectWriter = jsonWriter.getObjectWriter(itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
            }
            boolean bl = itemRefDetect = refDetect && !ObjectWriterProvider.isNotReferenceDetect(itemClass);
            if (itemRefDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemType, this.features);
            if (!itemRefDetect) continue;
            jsonWriter.popPath(item);
        }
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        Iterable iterable = (Iterable)object;
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        jsonWriter.startArray();
        int i = 0;
        Iterator it = iterable.iterator();
        while (it.hasNext()) {
            ObjectWriter itemObjectWriter;
            Object item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = it.next()) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                itemObjectWriter = jsonWriter.getObjectWriter(itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
            }
            itemObjectWriter.write(jsonWriter, item, i, this.itemType, this.features);
            ++i;
        }
        jsonWriter.endArray();
    }
}

