/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import com.alibaba.fastjson2.writer.ObjectWriterImplListEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplListStr;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;

abstract class FieldWriterList<T>
extends FieldWriter<T> {
    final Type itemType;
    final Class itemClass;
    final boolean itemClassNotReferenceDetect;
    ObjectWriter listWriter;
    ObjectWriter itemObjectWriter;

    FieldWriterList(String name, Type itemType, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, label, fieldType, fieldClass, field, method);
        Object object = this.itemType = itemType == null ? Object.class : itemType;
        if (this.itemType instanceof Class) {
            this.itemClass = (Class)itemType;
            if (this.itemClass != null) {
                this.listWriter = Enum.class.isAssignableFrom(this.itemClass) ? new ObjectWriterImplListEnum(fieldClass, this.itemClass, features) : (this.itemClass == String.class ? ObjectWriterImplListStr.INSTANCE : new ObjectWriterImplList(fieldClass, fieldType, this.itemClass, itemType, features));
            }
        } else {
            this.itemClass = TypeUtils.getMapping(itemType);
        }
        boolean bl = this.itemClassNotReferenceDetect = this.itemClass == null ? false : ObjectWriterProvider.isNotReferenceDetect(this.itemClass);
        if (format != null && this.itemClass == Date.class) {
            this.itemObjectWriter = new ObjectWriterImplDate(format, null);
        }
    }

    @Override
    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public Class getItemClass() {
        return this.itemClass;
    }

    @Override
    public ObjectWriter getItemWriter(JSONWriter jsonWriter, Type itemType) {
        if (itemType == null || itemType == this.itemType) {
            if (this.itemObjectWriter != null) {
                return this.itemObjectWriter;
            }
            this.itemObjectWriter = jsonWriter.getObjectWriter(this.itemType, this.itemClass);
            return this.itemObjectWriter;
        }
        return jsonWriter.getObjectWriter(itemType, null);
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (this.listWriter != null && this.fieldClass.isAssignableFrom(valueClass)) {
            return this.listWriter;
        }
        if (this.listWriter == null && valueClass == this.fieldClass) {
            this.listWriter = jsonWriter.getObjectWriter(valueClass);
            return this.listWriter;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }

    @Override
    public void writeList(JSONWriter jsonWriter, boolean writeFieldName, List list) {
        boolean refDetect;
        boolean beanToArray;
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        long features = this.features | jsonWriter.getFeatures();
        boolean bl = beanToArray = (features & JSONWriter.Feature.BeanToArray.mask) != 0L;
        if ((features & JSONWriter.Feature.NotWriteEmptyArray.mask) != 0L && list.isEmpty() && writeFieldName) {
            return;
        }
        boolean previousItemRefDetect = refDetect = (features & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
        if (writeFieldName) {
            this.writeFieldName(jsonWriter);
        }
        if (jsonWriter.isJSONB()) {
            int size = list.size();
            if (jsonWriter.isWriteTypeInfo((Object)list, this.fieldClass)) {
                jsonWriter.writeTypeName(TypeUtils.getTypeName(list.getClass()));
            }
            jsonWriter.startArray(size);
            for (int i = 0; i < size; ++i) {
                String refPath;
                Object item = list.get(i);
                if (item == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                Class<?> itemClass = item.getClass();
                if (itemClass != previousClass) {
                    refDetect = jsonWriter.isRefDetect();
                    previousObjectWriter = itemClass == this.itemType && this.itemObjectWriter != null ? this.itemObjectWriter : this.getItemWriter(jsonWriter, itemClass);
                    previousClass = itemClass;
                    if (refDetect) {
                        refDetect = itemClass == this.itemClass ? !this.itemClassNotReferenceDetect : !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                    }
                }
                ObjectWriter itemObjectWriter = previousObjectWriter;
                if (refDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                    jsonWriter.writeReference(refPath);
                    jsonWriter.popPath(item);
                    continue;
                }
                if (beanToArray) {
                    itemObjectWriter.writeArrayMappingJSONB(jsonWriter, item, i, this.itemType, features);
                } else {
                    itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemType, features);
                }
                if (!refDetect) continue;
                jsonWriter.popPath(item);
            }
            return;
        }
        jsonWriter.startArray();
        for (int i = 0; i < list.size(); ++i) {
            String refPath;
            boolean itemRefDetect;
            ObjectWriter itemObjectWriter;
            Object item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list.get(i)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == String.class) {
                jsonWriter.writeString((String)item);
                continue;
            }
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
                itemRefDetect = previousItemRefDetect;
            } else {
                itemRefDetect = jsonWriter.isRefDetect();
                itemObjectWriter = this.getItemWriter(jsonWriter, itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
                if (itemRefDetect) {
                    itemRefDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                }
                previousItemRefDetect = itemRefDetect;
            }
            if (itemRefDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.write(jsonWriter, item, null, this.itemType, features);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeListStr(JSONWriter jsonWriter, boolean writeFieldName, List<String> list) {
        if (writeFieldName) {
            this.writeFieldName(jsonWriter);
        }
        if (jsonWriter.isJSONB()) {
            if (jsonWriter.isWriteTypeInfo(list, this.fieldClass)) {
                jsonWriter.writeTypeName(TypeUtils.getTypeName(list.getClass()));
            }
            int listSize = list.size();
            jsonWriter.startArray(listSize);
            int size = listSize;
            for (int i = 0; i < size; ++i) {
                String str = list.get(i);
                jsonWriter.writeString(str);
            }
            return;
        }
        jsonWriter.startArray();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                jsonWriter.writeComma();
            }
            String str = list.get(i);
            jsonWriter.writeString(str);
        }
        jsonWriter.endArray();
    }
}

