/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.AnnotationUtils;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class JSONObject
extends LinkedHashMap<String, Object>
implements InvocationHandler {
    private static final long serialVersionUID = 1L;
    static ObjectReader<JSONArray> arrayReader;
    static final long NONE_DIRECT_FEATURES;

    public JSONObject() {
    }

    public JSONObject(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONObject(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JSONObject(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
    }

    public JSONObject(Map map) {
        super(map);
    }

    public Object get(String key) {
        return super.get(key);
    }

    @Override
    public Object get(Object key) {
        Object value;
        if ((key instanceof Number || key instanceof Character || key instanceof Boolean || key instanceof UUID) && (value = super.get(key.toString())) != null) {
            return value;
        }
        return super.get(key);
    }

    public Object getByPath(String jsonPath) {
        JSONPath path = JSONPath.of(jsonPath);
        if (path instanceof JSONPathSingleName) {
            String name = ((JSONPathSingleName)path).name;
            return this.get(name);
        }
        return path.eval(this);
    }

    public boolean containsKey(String key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Number || key instanceof Character || key instanceof Boolean || key instanceof UUID) {
            return super.containsKey(key) || super.containsKey(key.toString());
        }
        return super.containsKey(key);
    }

    public Object getOrDefault(String key, Object defaultValue) {
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        if (key instanceof Number || key instanceof Character || key instanceof Boolean || key instanceof UUID) {
            return super.getOrDefault(key.toString(), defaultValue);
        }
        return super.getOrDefault(key, defaultValue);
    }

    public JSONArray getJSONArray(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof JSONObject) {
            return JSONArray.of(value);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (arrayReader == null) {
                arrayReader = reader.getObjectReader((Type)((Object)JSONArray.class));
            }
            return arrayReader.readObject(reader, null, null, 0L);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection<?>)((Collection)value));
        }
        if (value instanceof Object[]) {
            return JSONArray.of((Object[])value);
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            int length = Array.getLength(value);
            JSONArray jsonArray = new JSONArray(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                jsonArray.add(item);
            }
            return jsonArray;
        }
        return null;
    }

    public <T> List<T> getList(String key, Class<T> itemClass, JSONReader.Feature ... features) {
        JSONArray jsonArray = this.getJSONArray(key);
        if (jsonArray == null) {
            return null;
        }
        return jsonArray.toList(itemClass, features);
    }

    public JSONObject getJSONObject(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            return JSONFactory.OBJECT_READER.readObject(reader, null, null, 0L);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value);
        }
        Class<?> valueClass = value.getClass();
        ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(valueClass);
        if (objectWriter instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter writerAdapter = (ObjectWriterAdapter)objectWriter;
            return writerAdapter.toJSONObject(value);
        }
        return null;
    }

    public String getString(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            long timeMillis = ((Date)value).getTime();
            return DateUtils.toString(timeMillis, false, IOUtils.DEFAULT_ZONE_ID);
        }
        if (value instanceof Boolean || value instanceof Character || value instanceof Number || value instanceof UUID || value instanceof Enum) {
            return value.toString();
        }
        return JSON.toJSONString(value);
    }

    public Double getDouble(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Double");
    }

    public double getDoubleValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to double value");
    }

    public Float getFloat(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Float");
    }

    public float getFloatValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to float value");
    }

    public Long getLong(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            if (str.indexOf(46) != -1) {
                return (long)Double.parseDouble(str);
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Long");
    }

    public long getLongValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0L;
            }
            if (str.indexOf(46) != -1) {
                return (long)Double.parseDouble(str);
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to long value");
    }

    public long getLongValue(String key, long defaultValue) {
        Object value = super.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return defaultValue;
            }
            if (str.indexOf(46) != -1) {
                return (long)Double.parseDouble(str);
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to long value");
    }

    public Integer getInteger(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            if (str.indexOf(46) != -1) {
                return (int)Double.parseDouble(str);
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Integer");
    }

    public int getIntValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            if (str.indexOf(46) != -1) {
                return (int)Double.parseDouble(str);
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to int value");
    }

    public int getIntValue(String key, int defaultValue) {
        Object value = super.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return defaultValue;
            }
            if (str.indexOf(46) != -1) {
                return (int)Double.parseDouble(str);
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to int value");
    }

    public Short getShort(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Short");
    }

    public short getShortValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to short value");
    }

    public Byte getByte(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Byte");
    }

    public byte getByteValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to byte value");
    }

    public Boolean getBoolean(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to Boolean");
    }

    public boolean getBooleanValue(String key) {
        Object value = super.get(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to boolean value");
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        Object value = super.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to boolean value");
    }

    public BigInteger getBigInteger(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            long longValue = ((Number)value).longValue();
            return BigInteger.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigInteger");
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof Float || value instanceof Double) {
                return new BigDecimal(value.toString());
            }
            long longValue = ((Number)value).longValue();
            return BigDecimal.valueOf(longValue);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return new BigDecimal(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        throw new JSONException("Can not cast '" + value.getClass() + "' to BigDecimal");
    }

    public Date getDate(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof String) {
            return DateUtils.parseDate((String)value);
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            return new Date(millis);
        }
        return TypeUtils.toDate(value);
    }

    public Instant getInstant(String key) {
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            if (millis == 0L) {
                return null;
            }
            return Instant.ofEpochMilli(millis);
        }
        return TypeUtils.toInstant(value);
    }

    @Override
    public String toString() {
        try (JSONWriter writer = JSONWriter.of();){
            writer.setRootObject(this);
            writer.write(this);
            String string = writer.toString();
            return string;
        }
    }

    public String toString(JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            writer.setRootObject(this);
            writer.write(this);
            String string = writer.toString();
            return string;
        }
    }

    public String toJSONString(JSONWriter.Feature ... features) {
        return this.toString(features);
    }

    public static String toJSONString(Object object, JSONWriter.Feature ... features) {
        return JSON.toJSONString(object, features);
    }

    public byte[] toJSONBBytes(JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.setRootObject(this);
            writer.write(this);
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public <T> T to(Function<JSONObject, T> function) {
        return function.apply(this);
    }

    public <T> T to(Type type, JSONReader.Feature ... features) {
        long featuresValue = 0L;
        boolean fieldBased = false;
        for (JSONReader.Feature feature : features) {
            if (feature == JSONReader.Feature.FieldBased) {
                fieldBased = true;
            }
            featuresValue |= feature.mask;
        }
        if (type == String.class) {
            return (T)this.toString();
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        return objectReader.createInstance((Map)this, featuresValue);
    }

    public <T> T to(TypeReference<?> typeReference, JSONReader.Feature ... features) {
        return this.to(typeReference.getType(), features);
    }

    public <T> T to(Class<T> clazz, JSONReader.Feature ... features) {
        long featuresValue = 0L;
        boolean fieldBased = false;
        for (JSONReader.Feature feature : features) {
            if (feature == JSONReader.Feature.FieldBased) {
                fieldBased = true;
            }
            featuresValue |= feature.mask;
        }
        if (clazz == String.class) {
            return (T)this.toString();
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(clazz, fieldBased);
        return objectReader.createInstance((Map)this, featuresValue);
    }

    public <T> T toJavaObject(Class<T> clazz, JSONReader.Feature ... features) {
        return this.to(clazz, features);
    }

    public <T> T toJavaObject(Type type, JSONReader.Feature ... features) {
        return this.to(type, features);
    }

    public <T> T toJavaObject(TypeReference<?> typeReference, JSONReader.Feature ... features) {
        return this.to(typeReference, features);
    }

    public <T> T getObject(String key, Class<T> type, JSONReader.Feature ... features) {
        ObjectReader objectReader;
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (type == Object.class && features.length == 0) {
            return (T)value;
        }
        boolean fieldBased = false;
        for (JSONReader.Feature feature : features) {
            if (feature != JSONReader.Feature.FieldBased) continue;
            fieldBased = true;
            break;
        }
        Class<?> valueClass = value.getClass();
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(valueClass, type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(value);
        }
        if (value instanceof Map) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Map)value, features);
        }
        if (value instanceof Collection) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Collection)value);
        }
        Class<?> clazz = TypeUtils.getMapping(type);
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        ObjectReader objectReader2 = null;
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            if (clazz.isEnum() && (objectReader2 = provider.getObjectReader(clazz, fieldBased)) instanceof ObjectReaderImplEnum) {
                long hashCode64 = Fnv.hashCode64(str);
                ObjectReaderImplEnum enumReader = (ObjectReaderImplEnum)objectReader2;
                return (T)enumReader.getEnumByHashCode(hashCode64);
            }
        }
        String json = JSON.toJSONString(value);
        JSONReader jsonReader = JSONReader.of(json);
        jsonReader.context.config(features);
        if (objectReader2 == null) {
            objectReader2 = provider.getObjectReader(clazz, fieldBased);
        }
        Object object = objectReader2.readObject(jsonReader, null, null, 0L);
        if (!jsonReader.isEnd()) {
            throw new JSONException("not support input " + json);
        }
        return object;
    }

    public <T> T getObject(String key, Type type, JSONReader.Feature ... features) {
        String str;
        Class clazz;
        ObjectReader objectReader;
        Object value = super.get(key);
        if (value == null) {
            return null;
        }
        if (type == Object.class && features.length == 0) {
            return (T)value;
        }
        boolean fieldBased = false;
        for (JSONReader.Feature feature : features) {
            if (feature != JSONReader.Feature.FieldBased) continue;
            fieldBased = true;
            break;
        }
        Class<?> valueClass = value.getClass();
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(valueClass, type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(value);
        }
        if (value instanceof Map) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Map)value, features);
        }
        if (value instanceof Collection) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Collection)value);
        }
        if (type instanceof Class && (clazz = (Class)type).isInstance(value)) {
            return (T)value;
        }
        if (value instanceof String && ((str = (String)value).isEmpty() || "null".equals(str))) {
            return null;
        }
        String json = JSON.toJSONString(value);
        JSONReader jsonReader = JSONReader.of(json);
        jsonReader.context.config(features);
        ObjectReader objectReader2 = provider.getObjectReader(type, fieldBased);
        return objectReader2.readObject(jsonReader, null, null, 0L);
    }

    public <T> T getObject(String key, TypeReference<?> typeReference, JSONReader.Feature ... features) {
        return this.getObject(key, typeReference.type, features);
    }

    public <T> T getObject(String key, Function<JSONObject, T> creator) {
        JSONObject object = this.getJSONObject(key);
        if (object == null) {
            return null;
        }
        return creator.apply(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Function typeConvert;
        Object value;
        block23: {
            String name;
            block24: {
                String methodName;
                block25: {
                    methodName = method.getName();
                    int parameterCount = method.getParameterCount();
                    if (parameterCount == 1) {
                        if ("equals".equals(methodName)) {
                            return this.equals(args[0]);
                        }
                        if (method.getReturnType() != Void.TYPE) {
                            throw new JSONException("This method '" + methodName + "' is not a setter");
                        }
                        String name2 = this.getJSONFieldName(method);
                        if (name2 == null) {
                            name2 = methodName;
                            if (!name2.startsWith("set")) {
                                throw new JSONException("This method '" + methodName + "' is not a setter");
                            }
                            if ((name2 = name2.substring(3)).length() == 0) {
                                throw new JSONException("This method '" + methodName + "' is an illegal setter");
                            }
                            name2 = Character.toLowerCase(name2.charAt(0)) + name2.substring(1);
                        }
                        this.put(name2, args[0]);
                        return null;
                    }
                    if (parameterCount != 0) {
                        throw new UnsupportedOperationException(method.toGenericString());
                    }
                    if (method.getReturnType() == Void.TYPE) {
                        throw new JSONException("This method '" + methodName + "' is not a getter");
                    }
                    name = this.getJSONFieldName(method);
                    if (name != null) break block24;
                    name = methodName;
                    if (!name.startsWith("get")) break block25;
                    if ((name = name.substring(3)).isEmpty()) {
                        throw new JSONException("This method '" + methodName + "' is an illegal getter");
                    }
                    value = this.get(name = Character.toLowerCase(name.charAt(0)) + name.substring(1));
                    if (value == null) {
                        return null;
                    }
                    break block23;
                }
                if (name.startsWith("is")) {
                    if ("isEmpty".equals(name)) {
                        value = this.get("empty");
                        if (value == null) {
                            return this.isEmpty();
                        }
                        break block23;
                    } else {
                        if ((name = name.substring(2)).isEmpty()) {
                            throw new JSONException("This method '" + methodName + "' is an illegal getter");
                        }
                        value = this.get(name = Character.toLowerCase(name.charAt(0)) + name.substring(1));
                        if (value == null) {
                            return false;
                        }
                    }
                    break block23;
                } else {
                    if ("hashCode".equals(name)) {
                        return this.hashCode();
                    }
                    if ("toString".equals(name)) {
                        return this.toString();
                    }
                    if (name.startsWith("entrySet")) {
                        return this.entrySet();
                    }
                    if ("size".equals(name)) {
                        return this.size();
                    }
                    throw new JSONException("This method '" + methodName + "' is not a getter");
                }
            }
            value = this.get(name);
            if (value == null) {
                return null;
            }
        }
        if ((typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(value.getClass(), method.getGenericReturnType())) != null) {
            return typeConvert.apply(value);
        }
        return value;
    }

    private String getJSONFieldName(Method method) {
        Annotation[] annotations;
        String name = null;
        for (Annotation annotation : annotations = AnnotationUtils.getAnnotations(method)) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONField jsonField = AnnotationUtils.findAnnotation(annotation, JSONField.class);
            if (Objects.nonNull(jsonField)) {
                name = jsonField.name();
                if (!name.isEmpty()) continue;
                name = null;
                continue;
            }
            if (!"com.alibaba.fastjson.annotation.JSONField".equals(annotationType.getName())) continue;
            NameConsumer nameConsumer = new NameConsumer(annotation);
            BeanUtils.annotationMethods(annotationType, nameConsumer);
            if (nameConsumer.name == null) continue;
            name = nameConsumer.name;
        }
        return name;
    }

    public JSONArray putArray(String name) {
        JSONArray array = new JSONArray();
        this.put(name, array);
        return array;
    }

    public JSONObject putObject(String name) {
        JSONObject object = new JSONObject();
        this.put(name, object);
        return object;
    }

    public JSONObject fluentPut(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public boolean isValid(JSONSchema schema) {
        return schema.isValid(this);
    }

    static void nameFilter(Iterable<?> iterable, NameFilter nameFilter) {
        for (Object item : iterable) {
            if (item instanceof JSONObject) {
                ((JSONObject)item).nameFilter(nameFilter);
                continue;
            }
            if (!(item instanceof Iterable)) continue;
            JSONObject.nameFilter((Iterable)item, nameFilter);
        }
    }

    static void nameFilter(Map map, NameFilter nameFilter) {
        JSONObject changed = null;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            String key;
            String processName;
            Map.Entry entry = it.next();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue instanceof JSONObject) {
                ((JSONObject)entryValue).nameFilter(nameFilter);
            } else if (entryValue instanceof Iterable) {
                JSONObject.nameFilter((Iterable)entryValue, nameFilter);
            }
            if (!(entryKey instanceof String) || (processName = nameFilter.process(map, key = (String)entryKey, entryValue)) == null || processName.equals(key)) continue;
            if (changed == null) {
                changed = new JSONObject();
            }
            changed.put(processName, entryValue);
            it.remove();
        }
        if (changed != null) {
            map.putAll(changed);
        }
    }

    static void valueFilter(Iterable<?> iterable, ValueFilter valueFilter) {
        for (Object item : iterable) {
            if (item instanceof Map) {
                JSONObject.valueFilter((Map)item, valueFilter);
                continue;
            }
            if (!(item instanceof Iterable)) continue;
            JSONObject.valueFilter((Iterable)item, valueFilter);
        }
    }

    static void valueFilter(Map map, ValueFilter valueFilter) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String key;
            Object applyValue;
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JSONObject.valueFilter((Map)entryValue, valueFilter);
            } else if (entryValue instanceof Iterable) {
                JSONObject.valueFilter((Iterable)entryValue, valueFilter);
            }
            if (!(entryKey instanceof String) || (applyValue = valueFilter.apply(map, key = (String)entryKey, entryValue)) == entryValue) continue;
            entry.setValue(applyValue);
        }
    }

    public void valueFilter(ValueFilter valueFilter) {
        JSONObject.valueFilter(this, valueFilter);
    }

    public void nameFilter(NameFilter nameFilter) {
        JSONObject.nameFilter(this, nameFilter);
    }

    @Override
    public JSONObject clone() {
        return new JSONObject((Map)this);
    }

    public Object eval(JSONPath path) {
        return path.eval(this);
    }

    public static JSONObject of() {
        return new JSONObject();
    }

    public static JSONObject of(String key, Object value) {
        JSONObject object = new JSONObject(2);
        object.put(key, value);
        return object;
    }

    public static JSONObject of(String k1, Object v1, String k2, Object v2) {
        JSONObject object = new JSONObject(3);
        object.put(k1, v1);
        object.put(k2, v2);
        return object;
    }

    public static JSONObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        JSONObject object = new JSONObject(5);
        object.put(k1, v1);
        object.put(k2, v2);
        object.put(k3, v3);
        return object;
    }

    public static JSONObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        JSONObject object = new JSONObject(5);
        object.put(k1, v1);
        object.put(k2, v2);
        object.put(k3, v3);
        object.put(k4, v4);
        return object;
    }

    public static <T> T parseObject(String text, Class<T> objectClass) {
        return JSON.parseObject(text, objectClass);
    }

    public static <T> T parseObject(String text, Class<T> objectClass, JSONReader.Feature ... features) {
        return JSON.parseObject(text, objectClass, features);
    }

    public static <T> T parseObject(String text, Type objectType, JSONReader.Feature ... features) {
        return JSON.parseObject(text, objectType, features);
    }

    public static <T> T parseObject(String text, TypeReference<?> typeReference, JSONReader.Feature ... features) {
        return JSON.parseObject(text, typeReference, features);
    }

    public static JSONObject parseObject(String text) {
        return JSON.parseObject(text);
    }

    public static JSONObject parse(String text, JSONReader.Feature ... features) {
        return JSON.parseObject(text, features);
    }

    static {
        NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
    }

    static class NameConsumer
    implements Consumer<Method> {
        final Annotation annotation;
        String name;

        NameConsumer(Annotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public void accept(Method method) {
            String methodName = method.getName();
            if ("name".equals(methodName)) {
                try {
                    String result = (String)method.invoke((Object)this.annotation, new Object[0]);
                    if (!result.isEmpty()) {
                        this.name = result;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
    }
}

