/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegmentName;
import com.alibaba.fastjson2.JSONPathSingleIndex;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTwoSegment;
import com.alibaba.fastjson2.JSONPathTypedMulti;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.util.ObjectHolder;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Map;
import java.util.function.BiConsumer;

final class JSONPathTypedMultiNames
extends JSONPathTypedMulti {
    final JSONPath prefix;
    final JSONPath[] namePaths;
    final String[] names;
    final long[] nameHashCodes;
    final ObjectReader objectReader;
    final ObjectReader prefixObjectReader;

    JSONPathTypedMultiNames(JSONPath[] paths, JSONPath prefix, JSONPath[] namePaths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(paths, types, formats, pathFeatures, zoneId, features);
        this.prefix = prefix;
        this.namePaths = namePaths;
        this.names = new String[paths.length];
        this.nameHashCodes = new long[paths.length];
        FieldReader[] fieldReaders = new FieldReader[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String fieldName;
            JSONPathSingleName jsonPathSingleName = (JSONPathSingleName)namePaths[i];
            this.names[i] = fieldName = jsonPathSingleName.name;
            this.nameHashCodes[i] = jsonPathSingleName.nameHashCode;
            String format = formats != null ? formats[i] : null;
            Type fieldType = types[i];
            Class<?> fieldClass = TypeUtils.getClass(fieldType);
            FieldValueCallback function = new FieldValueCallback(i);
            long fieldFeatures = 0L;
            if (this.isIgnoreError(i)) {
                fieldFeatures |= JSONReader.Feature.NullOnError.mask;
            }
            fieldReaders[i] = ObjectReaderCreator.INSTANCE.createFieldReader(null, null, fieldName, fieldType, fieldClass, i, fieldFeatures, format, null, null, null, function, null);
        }
        this.objectReader = ObjectReaderCreator.INSTANCE.createObjectReader(Object[].class, null, features, null, () -> new Object[paths.length], null, fieldReaders);
        ObjectReader<ObjectHolder> prefixObjectReader = null;
        if (prefix instanceof JSONPathSingleName) {
            JSONPathSingleName prefixSingleName = (JSONPathSingleName)prefix;
            FieldReader prefixFieldReader = ObjectReaderCreator.INSTANCE.createFieldReader((Class)ObjectHolder.class, (Type)((Object)ObjectHolder.class), prefixSingleName.name, (Type)((Object)Object.class), Object.class, 0, 0L, null, (Object)null, null, null, ObjectHolder::setObject, this.objectReader);
            prefixObjectReader = ObjectReaderCreator.INSTANCE.createObjectReader(ObjectHolder.class, null, 0L, null, () -> new ObjectHolder(), null, prefixFieldReader);
        } else if (prefix instanceof JSONPathTwoSegment) {
            JSONPathTwoSegment two = (JSONPathTwoSegment)prefix;
            if (two.first instanceof JSONPathSegmentName && two.second instanceof JSONPathSegmentName) {
                JSONPathSegmentName firstName = (JSONPathSegmentName)two.first;
                JSONPathSegmentName secondName = (JSONPathSegmentName)two.second;
                FieldReader secondFieldReader = ObjectReaderCreator.INSTANCE.createFieldReader((Class)ObjectHolder.class, (Type)((Object)ObjectHolder.class), secondName.name, (Type)((Object)Object.class), Object.class, 0, 0L, null, (Object)null, null, null, ObjectHolder::setObject, this.objectReader);
                prefixObjectReader = ObjectReaderCreator.INSTANCE.createObjectReader(ObjectHolder.class, null, 0L, null, () -> new ObjectHolder(), null, secondFieldReader);
                FieldReader firstFieldReader = ObjectReaderCreator.INSTANCE.createFieldReader((Class)ObjectHolder.class, (Type)((Object)ObjectHolder.class), firstName.name, (Type)((Object)Object.class), Object.class, 0, 0L, null, (Object)null, null, null, ObjectHolder::setObject, (ObjectReader)prefixObjectReader);
                prefixObjectReader = ObjectReaderCreator.INSTANCE.createObjectReader(ObjectHolder.class, null, 0L, null, () -> new ObjectHolder(), null, firstFieldReader);
            }
        }
        this.prefixObjectReader = prefixObjectReader;
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public boolean contains(Object object) {
        for (JSONPath jsonPath : this.paths) {
            if (!jsonPath.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object eval(Object root) {
        Object[] array = new Object[this.paths.length];
        Object object = root;
        if (this.prefix != null) {
            object = this.prefix.eval(root);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (int i = 0; i < this.names.length; ++i) {
                Object result = map.get(this.names[i]);
                Type type = this.types[i];
                if (result != null && result.getClass() != type) {
                    result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                }
                array[i] = result;
            }
        } else {
            for (int i = 0; i < this.paths.length; ++i) {
                JSONPath jsonPath = this.namePaths[i];
                Type type = this.types[i];
                try {
                    Object result = jsonPath.eval(object);
                    if (result != null && result.getClass() != type) {
                        result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                    }
                    array[i] = result;
                    continue;
                }
                catch (Exception e) {
                    if (this.isIgnoreError(i)) continue;
                    throw new JSONException("jsonpath eval path, path : " + this.paths[i] + ", msg : " + e.getMessage(), e);
                }
            }
        }
        return array;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        if (this.prefix == null) {
            return this.objectReader.readObject(jsonReader, null, null, this.features);
        }
        if (jsonReader.nextIfNull()) {
            return null;
        }
        if (this.prefix instanceof JSONPathSingleIndex) {
            int index = ((JSONPathSingleIndex)this.prefix).index;
            if (index >= 0) {
                int max = jsonReader.startArray();
                for (int i = 0; i < index && i < max; ++i) {
                    jsonReader.skipValue();
                }
                if (jsonReader.nextIfNull()) {
                    return null;
                }
                return this.objectReader.readObject(jsonReader, null, null, this.features);
            }
        } else {
            if (this.prefix instanceof JSONPathSingleName) {
                JSONPathSingleName prefixName = (JSONPathSingleName)this.prefix;
                long prefixNameHash = prefixName.nameHashCode;
                if (!jsonReader.nextIfObjectStart()) {
                    throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
                }
                while (!jsonReader.nextIfObjectEnd()) {
                    boolean match;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == prefixNameHash;
                    if (match || jsonReader.isObject() || jsonReader.isArray()) break;
                    jsonReader.skipValue();
                }
                if (jsonReader.nextIfNull()) {
                    return null;
                }
                return this.objectReader.readObject(jsonReader, null, null, this.features);
            }
            if (this.prefixObjectReader != null) {
                ObjectHolder holder = (ObjectHolder)this.prefixObjectReader.readObject(jsonReader, null, null, this.features);
                Object object = holder.object;
                if (object instanceof ObjectHolder) {
                    object = ((ObjectHolder)object).object;
                }
                return object;
            }
        }
        Object object = jsonReader.readAny();
        return this.eval(object);
    }

    static class FieldValueCallback
    implements BiConsumer {
        final int index;

        FieldValueCallback(int index) {
            this.index = index;
        }

        public void accept(Object object, Object value) {
            Object[] array = (Object[])object;
            array[this.index] = value;
        }
    }
}

