/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF8;
import java.nio.charset.StandardCharsets;

class JSONReaderASCII
extends JSONReaderUTF8 {
    final String str;

    JSONReaderASCII(JSONReader.Context ctx, String str, byte[] bytes, int offset, int length) {
        super(ctx, bytes, offset, length);
        this.str = str;
        this.nameAscii = true;
    }

    @Override
    public void next() {
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = (char)(this.bytes[this.offset] & 0xFF);
        while (this.ch == '\u0000' || this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = (char)(this.bytes[this.offset] & 0xFF);
        }
        ++this.offset;
    }

    @Override
    public boolean nextIfMatch(char ch) {
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch != ch) {
            return false;
        }
        boolean bl = this.comma = ch == ',';
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = (char)(this.bytes[this.offset] & 0xFF);
        while (this.ch == '\u0000' || this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = (char)(this.bytes[this.offset] & 0xFF);
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfEmptyString() {
        char first = this.ch;
        if (first != '\"' && first != '\'' || this.offset >= this.end || this.bytes[this.offset] != first) {
            return false;
        }
        ++this.offset;
        this.ch = (char)(this.offset == this.end ? 26 : (char)this.bytes[this.offset]);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            ++this.offset;
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset];
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        ++this.offset;
        return true;
    }

    @Override
    public long readFieldNameHashCode() {
        int c;
        long hashCode;
        if (this.ch != '\"' && this.ch != '\'') {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderASCII.isFirstIdentifier(this.ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            String errorMsg = this.ch == '[' && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + this.ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + this.ch;
            throw new JSONException(this.info(errorMsg));
        }
        char quote = this.ch;
        this.stringValue = null;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (JSONFactory.MIXED_HASH_ALGORITHM && offset + 9 < this.end) {
            byte c0 = this.bytes[offset];
            if (c0 == quote) {
                nameValue = 0L;
            } else {
                byte c1 = this.bytes[offset + 1];
                if (c1 == quote && c0 != 0 && c0 != 92 && c0 <= 255) {
                    nameValue = c0;
                    this.nameLength = 1;
                    this.nameEnd = offset + 1;
                    offset += 2;
                } else {
                    byte c2 = this.bytes[offset + 2];
                    if (c2 == quote && c1 != 0 && c0 != 92 && c1 != 92 && c0 <= 255 && c1 <= 255) {
                        nameValue = (c1 << 8) + (c0 & 0xFF);
                        this.nameLength = 2;
                        this.nameEnd = offset + 2;
                        offset += 3;
                    } else {
                        byte c3 = this.bytes[offset + 3];
                        if (c3 == quote && c2 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c0 <= 255 && c1 <= 255 && c2 <= 255) {
                            nameValue = (c2 << 16) + ((c1 & 0xFF) << 8) + (c0 & 0xFF);
                            this.nameLength = 3;
                            this.nameEnd = offset + 3;
                            offset += 4;
                        } else {
                            byte c4 = this.bytes[offset + 4];
                            if (c4 == quote && c3 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c0 <= 255 && c1 <= 255 && c2 <= 255 && c3 <= 255) {
                                nameValue = (c3 << 24) + ((c2 & 0xFF) << 16) + ((c1 & 0xFF) << 8) + (c0 & 0xFF);
                                this.nameLength = 4;
                                this.nameEnd = offset + 4;
                                offset += 5;
                            } else {
                                byte c5 = this.bytes[offset + 5];
                                if (c5 == quote && c4 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c0 <= 255 && c1 <= 255 && c2 <= 255 && c3 <= 255 && c4 <= 255) {
                                    nameValue = ((long)c4 << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c0 & 0xFFL);
                                    this.nameLength = 5;
                                    this.nameEnd = offset + 5;
                                    offset += 6;
                                } else {
                                    byte c6 = this.bytes[offset + 6];
                                    if (c6 == quote && c5 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c0 <= 255 && c1 <= 255 && c2 <= 255 && c3 <= 255 && c4 <= 255 && c5 <= 255) {
                                        nameValue = ((long)c5 << 40) + (((long)c4 & 0xFFL) << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c0 & 0xFFL);
                                        this.nameLength = 6;
                                        this.nameEnd = offset + 6;
                                        offset += 7;
                                    } else {
                                        byte c7 = this.bytes[offset + 7];
                                        if (c7 == quote && c6 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c0 <= 255 && c1 <= 255 && c2 <= 255 && c3 <= 255 && c4 <= 255 && c5 <= 255 && c6 <= 255) {
                                            nameValue = ((long)c6 << 48) + (((long)c5 & 0xFFL) << 40) + (((long)c4 & 0xFFL) << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c0 & 0xFFL);
                                            this.nameLength = 7;
                                            this.nameEnd = offset + 7;
                                            offset += 8;
                                        } else if (this.bytes[offset + 8] == quote && c7 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c7 != 92 && c0 <= 255 && c1 <= 255 && c2 <= 255 && c3 <= 255 && c4 <= 255 && c5 <= 255 && c6 <= 255 && c7 <= 255) {
                                            nameValue = ((long)c7 << 56) + (((long)c6 & 0xFFL) << 48) + (((long)c5 & 0xFFL) << 40) + (((long)c4 & 0xFFL) << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c0 & 0xFFL);
                                            this.nameLength = 8;
                                            this.nameEnd = offset + 8;
                                            offset += 9;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (JSONFactory.MIXED_HASH_ALGORITHM && nameValue == 0L) {
            int i = 0;
            while (offset < this.end) {
                char c2 = this.bytes[offset];
                if (c2 == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c2 == '\\') {
                    this.nameEscape = true;
                    c2 = this.bytes[++offset];
                    switch (c2) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c22 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c2 = JSONReaderASCII.char4(c1, c22, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c22 = this.bytes[++offset];
                            c2 = JSONReaderASCII.char2(c1, c22);
                            break;
                        }
                        default: {
                            c2 = JSONReaderASCII.char1(c2);
                        }
                    }
                }
                if (c2 > '\u00ff' || i >= 8 || i == 0 && c2 == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c2;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c2 << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c2 << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c2 << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c2) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c2) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c2) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c2) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                char c3;
                if ((c3 = this.bytes[offset]) == '\\') {
                    this.nameEscape = true;
                    c3 = this.bytes[++offset];
                    switch (c3) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c32 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c3 = JSONReaderASCII.char4(c1, c2, c32, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c3 = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        default: {
                            c3 = JSONReaderASCII.char1(c3);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                } else {
                    if (c3 == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)(c3 & 0xFF);
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        if (offset < this.end) {
            c = this.bytes[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = this.bytes[++offset];
            }
        } else {
            c = 26;
        }
        if (c != 58) {
            throw new JSONException(this.info("expect ':', but " + c));
        }
        c = ++offset == this.end ? 26 : this.bytes[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = this.bytes[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        long hashCode;
        if (this.ch != '\"' && this.ch != '\'') {
            return -1L;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (JSONFactory.MIXED_HASH_ALGORITHM) {
            int i = 0;
            while (offset < this.end) {
                char c = this.bytes[offset];
                if (c == quote) {
                    if (i == 0) {
                        nameValue = 0L;
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c == '\\') {
                    this.nameEscape = true;
                    c = this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = JSONReaderASCII.char1(c);
                        }
                    }
                }
                if (c > '\u00ff' || i >= 8 || i == 0 && c == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                char c;
                if ((c = this.bytes[offset]) == '\\') {
                    this.nameEscape = true;
                    c = this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = JSONReaderASCII.char1(c);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                } else {
                    if (c == '\"') {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        this.stringValue = null;
                        break;
                    }
                    ++offset;
                    hashCode ^= c < '\u0000' ? (long)(c & 0xFF) : (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int c = offset == this.end ? 26 : this.bytes[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = this.bytes[++offset];
        }
        this.comma = c == 44;
        if (this.comma) {
            c = ++offset == this.end ? 26 : this.bytes[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = this.bytes[++offset];
            }
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        int offset;
        if (JSONFactory.MIXED_HASH_ALGORITHM) {
            long nameValue = 0L;
            int i = 0;
            for (offset = this.nameBegin; offset < this.end; ++offset) {
                byte c1;
                char c = this.bytes[offset];
                if (c == '\\') {
                    c = this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = JSONReaderASCII.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                if (c > '\u00ff' || c < '\u0000' || i >= 8 || i == 0 && c == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                if ((c == '_' || c == '-') && (c1 = this.bytes[offset + 1]) != 34 && c1 != 39 && c1 != c) continue;
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++i;
            }
            if (nameValue != 0L) {
                return nameValue;
            }
        }
        long hashCode = -3750763034362895579L;
        while (offset < this.end) {
            byte c1;
            char c = this.bytes[offset];
            if (c == '\\') {
                c = this.bytes[++offset];
                switch (c) {
                    case 'u': {
                        c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderASCII.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderASCII.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderASCII.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if ((c == '_' || c == '-') && (c1 = this.bytes[++offset]) != 34 && c1 != 39 && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= c < '\u0000' ? (long)(c & 0xFF) : (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.bytes, this.nameBegin, length, StandardCharsets.ISO_8859_1);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            char c = (char)this.bytes[offset];
            if (c == '\\') {
                c = (char)this.bytes[++offset];
                switch (c) {
                    case 'u': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderASCII.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderASCII.char2(c1, c2);
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': {
                        break;
                    }
                    default: {
                        c = JSONReaderASCII.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        if (this.ch != '\"' && this.ch != '\'') {
            return null;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (offset < this.end) {
            byte c = this.bytes[offset];
            if (c == 92) {
                this.nameEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = this.bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    if (c != 58) {
                        throw new JSONException("syntax error : " + offset);
                    }
                    if (++offset >= this.end) {
                        this.ch = (char)26;
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = this.bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    this.offset = offset + 1;
                    this.ch = (char)c;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        if (this.nameEnd < this.nameBegin) {
            throw new JSONException("syntax error : " + offset);
        }
        if (!this.nameEscape) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            int length = this.nameEnd - this.nameBegin;
            switch (length) {
                case 1: {
                    nameValue0 = this.bytes[this.nameBegin];
                    break;
                }
                case 2: {
                    nameValue0 = (this.bytes[this.nameBegin + 1] << 8) + (this.bytes[this.nameBegin] & 0xFF);
                    break;
                }
                case 3: {
                    nameValue0 = (this.bytes[this.nameBegin + 2] << 16) + ((this.bytes[this.nameBegin + 1] & 0xFF) << 8) + (this.bytes[this.nameBegin] & 0xFF);
                    break;
                }
                case 4: {
                    nameValue0 = (this.bytes[this.nameBegin + 3] << 24) + ((this.bytes[this.nameBegin + 2] & 0xFF) << 16) + ((this.bytes[this.nameBegin + 1] & 0xFF) << 8) + (this.bytes[this.nameBegin] & 0xFF);
                    break;
                }
                case 5: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 4] << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 6: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 5] << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 7: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 6] << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 8: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 7] << 56) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 9: {
                    nameValue0 = this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 8] << 56) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 1] & 0xFFL);
                    break;
                }
                case 10: {
                    nameValue0 = (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 9] << 56) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 2] & 0xFFL);
                    break;
                }
                case 11: {
                    nameValue0 = (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 10] << 56) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 3] & 0xFFL);
                    break;
                }
                case 12: {
                    nameValue0 = (this.bytes[this.nameBegin + 3] << 24) + (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 11] << 56) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 4] & 0xFFL);
                    break;
                }
                case 13: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 12] << 56) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 5] & 0xFFL);
                    break;
                }
                case 14: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 5] << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    nameValue1 = ((long)this.bytes[this.nameBegin + 13] << 56) + (((long)this.bytes[this.nameBegin + 12] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 6] & 0xFFL);
                    break;
                }
                case 15: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 6] << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    nameValue1 = ((long)this.bytes[this.nameBegin + 14] << 56) + (((long)this.bytes[this.nameBegin + 13] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 12] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 7] & 0xFFL);
                    break;
                }
                case 16: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 7] << 56) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    nameValue1 = ((long)this.bytes[this.nameBegin + 15] << 56) + (((long)this.bytes[this.nameBegin + 14] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 13] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 12] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 8] & 0xFFL);
                    break;
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    int indexMask = (int)nameValue1 & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        char[] chars = new char[length];
                        for (int i2 = 0; i2 < length; ++i2) {
                            chars[i2] = (char)(this.bytes[this.nameBegin + i2] & 0xFF);
                        }
                        String name = new String(chars);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)nameValue0 & JSONFactory.NAME_CACHE.length - 1;
                    JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        char[] chars = new char[length];
                        for (int i3 = 0; i3 < length; ++i3) {
                            chars[i3] = (char)(this.bytes[this.nameBegin + i3] & 0xFF);
                        }
                        String name = new String(chars);
                        JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, nameValue0);
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        return entry.name;
                    }
                }
            }
        }
        return this.getFieldName();
    }

    @Override
    protected void readString0() {
        String str;
        char quote = this.ch;
        int start = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            byte c;
            if ((c = this.bytes[this.offset]) == 92) {
                this.valueEscape = true;
                c = this.bytes[++this.offset];
                switch (c) {
                    case 117: {
                        this.offset += 4;
                        break;
                    }
                    case 120: {
                        this.offset += 2;
                        break;
                    }
                }
                ++this.offset;
            } else {
                if (c == quote) break;
                ++this.offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            this.offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = (char)this.bytes[this.offset]) == '\\') {
                    c = (char)this.bytes[++this.offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++this.offset];
                            byte c2 = this.bytes[++this.offset];
                            byte c3 = this.bytes[++this.offset];
                            byte c4 = this.bytes[++this.offset];
                            c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++this.offset];
                            byte c2 = this.bytes[++this.offset];
                            c = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderASCII.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i2] = c;
                ++this.offset;
                ++i2;
            }
            str = new String(chars);
        } else {
            str = new String(this.bytes, start, this.offset - start, StandardCharsets.US_ASCII);
        }
        byte b = this.bytes[++this.offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.bytes[++this.offset];
        }
        this.comma = b == 44;
        if (this.comma) {
            ++this.offset;
            this.next();
        } else {
            ++this.offset;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int valueLength;
            int offset;
            byte quote = (byte)this.ch;
            int slash = 92;
            int start = offset = this.offset;
            boolean valueEscape = false;
            int i = 0;
            byte c0 = 0;
            byte c1 = 0;
            byte c2 = 0;
            byte c3 = 0;
            boolean quoted = false;
            int upperBound = offset + (this.end - offset & 0xFFFFFFFC);
            while (offset < upperBound) {
                c0 = this.bytes[offset];
                c1 = this.bytes[offset + 1];
                c2 = this.bytes[offset + 2];
                c3 = this.bytes[offset + 3];
                if (c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92) break;
                if (c0 == quote || c1 == quote || c2 == quote || c3 == quote) {
                    quoted = true;
                    break;
                }
                offset += 4;
                i += 4;
            }
            if (quoted) {
                if (c0 != quote) {
                    if (c1 == quote) {
                        ++offset;
                        ++i;
                    } else if (c2 == quote) {
                        offset += 2;
                        i += 2;
                    } else if (c3 == quote) {
                        offset += 3;
                        i += 3;
                    }
                }
                valueLength = i;
            } else {
                while (true) {
                    if (offset >= this.end) {
                        throw new JSONException("invalid escape character EOI");
                    }
                    byte c = this.bytes[offset];
                    if (c == 92) {
                        valueEscape = true;
                        c = this.bytes[++offset];
                        switch (c) {
                            case 117: {
                                offset += 4;
                                break;
                            }
                            case 120: {
                                offset += 2;
                                break;
                            }
                        }
                        ++offset;
                    } else {
                        if (c == quote) {
                            valueLength = i;
                            break;
                        }
                        ++offset;
                    }
                    ++i;
                }
            }
            if (valueEscape) {
                char[] chars = new char[valueLength];
                offset = start;
                int i2 = 0;
                while (true) {
                    char c;
                    if ((c = (char)this.bytes[offset]) == '\\') {
                        c = (char)this.bytes[++offset];
                        switch (c) {
                            case 'u': {
                                char c12 = (char)this.bytes[++offset];
                                char c22 = (char)this.bytes[++offset];
                                char c32 = (char)this.bytes[++offset];
                                char c4 = (char)this.bytes[++offset];
                                c = JSONReaderASCII.char4(c12, c22, c32, c4);
                                break;
                            }
                            case 'x': {
                                char c12 = (char)this.bytes[++offset];
                                char c22 = (char)this.bytes[++offset];
                                c = JSONReaderASCII.char2(c12, c22);
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            default: {
                                c = JSONReaderASCII.char1(c);
                                break;
                            }
                        }
                    } else if (c == quote) break;
                    chars[i2] = c;
                    ++offset;
                    ++i2;
                }
                str = new String(chars);
            } else {
                str = this.str != null ? this.str.substring(this.offset, offset) : new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.US_ASCII);
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (offset + 1 == this.end) {
                this.offset = this.end;
                this.ch = (char)26;
                this.comma = false;
                return str;
            }
            byte b = this.bytes[++offset];
            while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
                b = this.bytes[++offset];
            }
            this.comma = b == 44;
            if (this.comma) {
                this.offset = offset + 1;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = (char)this.bytes[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = (char)this.bytes[this.offset++];
                    }
                }
            } else {
                this.offset = offset + 1;
                this.ch = (char)b;
            }
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException("TODO : " + this.ch);
    }
}

