/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectCodecProvider;
import com.alibaba.fastjson2.modules.ObjectWriterAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.FieldWriterObject;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplCollection;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptional;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ObjectWriterProvider
implements ObjectCodecProvider {
    static final int TYPE_INT32_MASK = 2;
    static final int TYPE_INT64_MASK = 4;
    static final int TYPE_DECIMAL_MASK = 8;
    static final int TYPE_DATE_MASK = 16;
    static final int TYPE_ENUM_MASK = 32;
    final ConcurrentMap<Type, ObjectWriter> cache = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Type, ObjectWriter> cacheFieldBased = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final ObjectWriterCreator creator;
    final List<ObjectWriterModule> modules = new ArrayList<ObjectWriterModule>();
    volatile long userDefineMask;
    static final int ENUM = 16384;
    static final int[] PRIMITIVE_HASH_CODES;
    static final int[] NOT_REFERENCES_TYPE_HASH_CODES;

    public ObjectWriterProvider() {
        this.init();
        this.creator = ObjectWriterCreator.INSTANCE;
    }

    public ObjectWriterProvider(ObjectWriterCreator creator) {
        this.init();
        this.creator = creator;
    }

    public void mixIn(Class target, Class mixinSource) {
        if (mixinSource == null) {
            this.mixInCache.remove(target);
        } else {
            this.mixInCache.put(target, mixinSource);
        }
        this.cache.remove(target);
    }

    public void cleanupMixIn() {
        this.mixInCache.clear();
    }

    public ObjectWriterCreator getCreator() {
        ObjectWriterCreator contextCreator = JSONFactory.getContextWriterCreator();
        if (contextCreator != null) {
            return contextCreator;
        }
        return this.creator;
    }

    public ObjectWriter register(Type type, ObjectWriter objectWriter) {
        return this.register(type, objectWriter, false);
    }

    public ObjectWriter register(Type type, ObjectWriter objectWriter, boolean fieldBased) {
        if (type == Integer.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplInt32.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFFDL) : (this.userDefineMask |= 2L);
        } else if (type == Long.class || type == Long.TYPE) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplInt64.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFFBL) : (this.userDefineMask |= 4L);
        } else if (type == BigDecimal.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplBigDecimal.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFF7L) : (this.userDefineMask |= 8L);
        } else if (type == Date.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplDate.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFEFL) : (this.userDefineMask |= 0x10L);
        } else if (type == Enum.class) {
            this.userDefineMask = objectWriter == null ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFDFL) : (this.userDefineMask |= 0x20L);
        }
        if (objectWriter == null) {
            if (fieldBased) {
                return (ObjectWriter)this.cacheFieldBased.remove(type);
            }
            return (ObjectWriter)this.cache.remove(type);
        }
        if (fieldBased) {
            return this.cacheFieldBased.put(type, objectWriter);
        }
        return this.cache.put(type, objectWriter);
    }

    public ObjectWriter registerIfAbsent(Type type, ObjectWriter objectWriter) {
        return this.cache.putIfAbsent(type, objectWriter);
    }

    public ObjectWriter unregister(Type type) {
        return (ObjectWriter)this.cache.remove(type);
    }

    public boolean unregister(Type type, ObjectWriter objectWriter) {
        return this.cache.remove(type, objectWriter);
    }

    public boolean register(ObjectWriterModule module) {
        for (int i = this.modules.size() - 1; i >= 0; --i) {
            if (this.modules.get(i) != module) continue;
            return false;
        }
        module.init(this);
        this.modules.add(0, module);
        return true;
    }

    public boolean unregister(ObjectWriterModule module) {
        return this.modules.remove(module);
    }

    @Override
    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void init() {
        this.modules.add(new ObjectWriterBaseModule(this));
    }

    public List<ObjectWriterModule> getModules() {
        return this.modules;
    }

    public void getFieldInfo(BeanInfo beanInfo, FieldInfo fieldInfo, Class objectClass, Field field) {
        for (ObjectWriterModule module : this.modules) {
            ObjectWriterAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(beanInfo, fieldInfo, objectClass, field);
        }
    }

    public void getFieldInfo(BeanInfo beanInfo, FieldInfo fieldInfo, Class objectClass, Method method) {
        for (ObjectWriterModule module : this.modules) {
            ObjectWriterAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(beanInfo, fieldInfo, objectClass, method);
        }
    }

    public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
        for (ObjectWriterModule module : this.modules) {
            ObjectWriterAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getBeanInfo(beanInfo, objectClass);
        }
    }

    public ObjectWriter getObjectWriter(Class objectClass) {
        return this.getObjectWriter(objectClass, objectClass, false);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        return this.getObjectWriter(objectType, objectClass, false);
    }

    public ObjectWriter getObjectWriter(Type objectType) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        return this.getObjectWriter(objectType, objectClass, false);
    }

    public ObjectWriter getObjectWriterFromCache(Type objectType, Class objectClass, boolean fieldBased) {
        return fieldBased ? (ObjectWriter)this.cacheFieldBased.get(objectType) : (ObjectWriter)this.cache.get(objectType);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass, boolean fieldBased) {
        ObjectWriter objectWriter;
        Class superclass;
        if (fieldBased && (superclass = objectClass.getSuperclass()) != null && superclass != Object.class && superclass.getName().equals("com.google.protobuf.GeneratedMessageV3")) {
            fieldBased = false;
        }
        ObjectWriter objectWriter2 = objectWriter = fieldBased ? (ObjectWriter)this.cacheFieldBased.get(objectType) : (ObjectWriter)this.cache.get(objectType);
        if (objectWriter != null) {
            return objectWriter;
        }
        boolean useModules = true;
        if (fieldBased && objectClass != null && Iterable.class.isAssignableFrom(objectClass) && !Collection.class.isAssignableFrom(objectClass)) {
            useModules = false;
        }
        if (useModules) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ObjectWriter previous;
                Object module = this.modules.get(i);
                objectWriter = module.getObjectWriter(objectType, objectClass);
                if (objectWriter == null) continue;
                ObjectWriter objectWriter3 = previous = fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, objectWriter) : this.cache.putIfAbsent(objectType, objectWriter);
                if (previous != null) {
                    objectWriter = previous;
                }
                return objectWriter;
            }
        }
        if (objectWriter == null && objectClass != null && !fieldBased) {
            String className = objectClass.getName();
            switch (className) {
                case "com.google.common.collect.HashMultimap": 
                case "com.google.common.collect.LinkedListMultimap": 
                case "com.google.common.collect.LinkedHashMultimap": 
                case "com.google.common.collect.ArrayListMultimap": 
                case "com.google.common.collect.TreeMultimap": {
                    objectWriter = GuavaSupport.createAsMapWriter(objectClass);
                    break;
                }
                case "com.alibaba.fastjson.JSONObject": {
                    objectWriter = ObjectWriterImplMap.of(objectClass);
                    break;
                }
            }
        }
        if (objectWriter == null) {
            ObjectWriter previous;
            ObjectWriterCreator creator = this.getCreator();
            if (objectClass == null) {
                objectClass = TypeUtils.getMapping(objectType);
            }
            objectWriter = creator.createObjectWriter(objectClass, fieldBased ? JSONWriter.Feature.FieldBased.mask : 0L, this);
            ObjectWriter objectWriter4 = previous = fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, objectWriter) : this.cache.putIfAbsent(objectType, objectWriter);
            if (previous != null) {
                objectWriter = previous;
            }
        }
        return objectWriter;
    }

    public static boolean isPrimitiveOrEnum(Class<?> clazz) {
        return Arrays.binarySearch(PRIMITIVE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    public static boolean isNotReferenceDetect(Class<?> clazz) {
        return Arrays.binarySearch(NOT_REFERENCES_TYPE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    public void cleanup(Class objectClass) {
        this.mixInCache.remove(objectClass);
        this.cache.remove(objectClass);
        this.cacheFieldBased.remove(objectClass);
        BeanUtils.cleanupCache(objectClass);
    }

    static boolean match(Type objectType, ObjectWriter objectWriter, ClassLoader classLoader, IdentityHashMap<ObjectWriter, Object> checkedMap) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        if (objectClass != null && objectClass.getClassLoader() == classLoader) {
            return true;
        }
        if (checkedMap.containsKey(objectWriter)) {
            return false;
        }
        if (objectWriter instanceof ObjectWriterImplMap) {
            ObjectWriterImplMap mapTyped = (ObjectWriterImplMap)objectWriter;
            Class<?> valueClass = TypeUtils.getClass(mapTyped.valueType);
            if (valueClass != null && valueClass.getClassLoader() == classLoader) {
                return true;
            }
            Class<?> keyClass = TypeUtils.getClass(mapTyped.keyType);
            if (keyClass != null && keyClass.getClassLoader() == classLoader) {
                return true;
            }
        } else if (objectWriter instanceof ObjectWriterImplCollection) {
            Class<?> itemClass = TypeUtils.getClass(((ObjectWriterImplCollection)objectWriter).itemType);
            if (itemClass != null && itemClass.getClassLoader() == classLoader) {
                return true;
            }
        } else if (objectWriter instanceof ObjectWriterImplOptional) {
            Class<?> itemClass = TypeUtils.getClass(((ObjectWriterImplOptional)objectWriter).valueType);
            if (itemClass != null && itemClass.getClassLoader() == classLoader) {
                return true;
            }
        } else if (objectWriter instanceof ObjectWriterAdapter) {
            checkedMap.put(objectWriter, null);
            List<FieldWriter> fieldWriters = ((ObjectWriterAdapter)objectWriter).fieldWriters;
            for (FieldWriter fieldWriter : fieldWriters) {
                ObjectWriter initObjectWriter;
                if (!(fieldWriter instanceof FieldWriterObject) || !ObjectWriterProvider.match(null, initObjectWriter = ((FieldWriterObject)fieldWriter).initObjectWriter, classLoader, checkedMap)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanup(ClassLoader classLoader) {
        Map.Entry entry;
        Iterator it = this.mixInCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            if (((Class)entry2.getKey()).getClassLoader() != classLoader) continue;
            it.remove();
        }
        IdentityHashMap<ObjectWriter, Object> checkedMap = new IdentityHashMap<ObjectWriter, Object>();
        Iterator it2 = this.cache.entrySet().iterator();
        while (it2.hasNext()) {
            entry = it2.next();
            if (!ObjectWriterProvider.match((Type)entry.getKey(), (ObjectWriter)entry.getValue(), classLoader, checkedMap)) continue;
            it2.remove();
        }
        it2 = this.cacheFieldBased.entrySet().iterator();
        while (it2.hasNext()) {
            entry = it2.next();
            if (!ObjectWriterProvider.match((Type)entry.getKey(), (ObjectWriter)entry.getValue(), classLoader, checkedMap)) continue;
            it2.remove();
        }
        BeanUtils.cleanupCache(classLoader);
    }

    static {
        Class[] classes = new Class[]{Boolean.TYPE, Boolean.class, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigInteger.class, BigDecimal.class, String.class, Currency.class, Date.class, UUID.class, Locale.class, LocalTime.class, LocalDate.class, LocalDateTime.class, Instant.class, ZoneId.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class, String.class, StackTraceElement.class, Collections.emptyList().getClass(), Collections.emptyMap().getClass(), Collections.emptySet().getClass()};
        int[] codes = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            codes[i] = System.identityHashCode(classes[i]);
        }
        Arrays.sort(codes);
        PRIMITIVE_HASH_CODES = codes;
        int[] codes2 = Arrays.copyOf(codes, codes.length + 3);
        codes2[codes2.length - 1] = System.identityHashCode(Class.class);
        codes2[codes2.length - 2] = System.identityHashCode(int[].class);
        codes2[codes2.length - 3] = System.identityHashCode(long[].class);
        Arrays.sort(codes2);
        NOT_REFERENCES_TYPE_HASH_CODES = codes2;
    }
}

