/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathFilter;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

abstract class JSONPathSegment {
    JSONPathSegment() {
    }

    public abstract void accept(JSONReader var1, JSONPath.Context var2);

    public abstract void eval(JSONPath.Context var1);

    public boolean contains(JSONPath.Context context) {
        this.eval(context);
        return context.value != null;
    }

    public boolean remove(JSONPath.Context context) {
        throw new JSONException("UnsupportedOperation " + this.getClass());
    }

    public void set(JSONPath.Context context, Object value) {
        throw new JSONException("UnsupportedOperation " + this.getClass());
    }

    public void setCallback(JSONPath.Context context, BiFunction callback) {
        throw new JSONException("UnsupportedOperation " + this.getClass());
    }

    public void setInt(JSONPath.Context context, int value) {
        this.set(context, value);
    }

    public void setLong(JSONPath.Context context, long value) {
        this.set(context, value);
    }

    static final class EntrySetSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final EntrySetSegment INSTANCE = new EntrySetSegment();

        EntrySetSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (jsonReader.isObject()) {
                jsonReader.next();
                JSONArray array = new JSONArray();
                while (!jsonReader.nextIfObjectEnd()) {
                    String fieldName = jsonReader.readFieldName();
                    Object value = jsonReader.readAny();
                    array.add(JSONObject.of("key", fieldName, "value", value));
                }
                context.value = array;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(map.size());
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    array.add(JSONObject.of("key", entry.getKey(), "value", entry.getValue()));
                }
                context.value = array;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class KeysSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final KeysSegment INSTANCE = new KeysSegment();

        KeysSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (jsonReader.isObject()) {
                jsonReader.next();
                JSONArray array = new JSONArray();
                while (!jsonReader.nextIfObjectEnd()) {
                    String fieldName = jsonReader.readFieldName();
                    array.add(fieldName);
                    jsonReader.skipValue();
                }
                context.value = array;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                context.value = new JSONArray((Collection<?>)((Map)object).keySet());
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class ValuesSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final ValuesSegment INSTANCE = new ValuesSegment();

        ValuesSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                context.value = null;
                context.eval = true;
                return;
            }
            if (object instanceof Map) {
                context.value = new JSONArray((Collection<?>)((Map)object).values());
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class LengthSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final LengthSegment INSTANCE = new LengthSegment();

        LengthSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
                context.eval = true;
            }
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            int length = 1;
            if (value instanceof Collection) {
                length = ((Collection)value).size();
            } else if (value.getClass().isArray()) {
                length = Array.getLength(value);
            } else if (value instanceof Map) {
                length = ((Map)value).size();
            } else if (value instanceof String) {
                length = ((String)value).length();
            } else if (value instanceof JSONPath.Sequence) {
                length = ((JSONPath.Sequence)value).values.size();
            }
            context.value = length;
        }
    }

    static final class SumSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final SumSegment INSTANCE = new SumSegment();

        SumSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        static Number add(Number a, Number b) {
            boolean bIsInt;
            boolean aIsInt = a instanceof Byte || a instanceof Short || a instanceof Integer || a instanceof Long;
            boolean bl = bIsInt = b instanceof Byte || b instanceof Short || b instanceof Integer || b instanceof Long;
            if (aIsInt && bIsInt) {
                return a.longValue() + b.longValue();
            }
            throw new JSONException("not support operation");
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Number sum = 0;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else if (value instanceof JSONPath.Sequence) {
                for (Object item : ((JSONPath.Sequence)value).values) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = sum;
            context.eval = true;
        }
    }

    static final class MaxSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final MaxSegment INSTANCE = new MaxSegment();

        MaxSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Object max = null;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else if (value instanceof JSONPath.Sequence) {
                for (Object item : ((JSONPath.Sequence)value).values) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = max;
            context.eval = true;
        }
    }

    static final class MinSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final MinSegment INSTANCE = new MinSegment();

        MinSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Object min = null;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else if (value instanceof JSONPath.Sequence) {
                for (Object item : ((JSONPath.Sequence)value).values) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = min;
            context.eval = true;
        }
    }

    static final class CycleNameSegment
    extends JSONPathSegment {
        static final long HASH_STAR = Fnv.hashCode64("*");
        final String name;
        final long nameHashCode;

        public CycleNameSegment(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        public String toString() {
            return ".." + this.name;
        }

        @Override
        public boolean remove(JSONPath.Context context) {
            this.set(context, null);
            context.eval = true;
            return true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            ObjectWriter<?> objectWriter;
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray values = new JSONArray();
            MapLoop action = new MapLoop(context, values);
            if (object instanceof Map) {
                Map map = (Map)object;
                map.forEach(action);
            } else if (object instanceof Collection) {
                ((Collection)object).forEach(action);
            } else if (object != null && (objectWriter = context.path.getWriterContext().getObjectWriter(object.getClass())) instanceof ObjectWriterAdapter) {
                action.accept(object);
            }
            context.value = values.size() == 1 && values.get(0) instanceof Collection ? values.get(0) : values;
            context.eval = true;
        }

        @Override
        public void set(JSONPath.Context context, Object value) {
            Object object = context.parent == null ? context.root : context.parent.value;
            LoopSet action = new LoopSet(context, value);
            action.accept(object);
        }

        @Override
        public void setCallback(JSONPath.Context context, BiFunction callback) {
            Object object = context.parent == null ? context.root : context.parent.value;
            LoopCallback action = new LoopCallback(context, callback);
            action.accept(object);
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            JSONArray values = new JSONArray();
            this.accept(jsonReader, context, values);
            context.value = values;
            context.eval = true;
        }

        public void accept(JSONReader jsonReader, JSONPath.Context context, List<Object> values) {
            if (jsonReader.isJSONB()) {
                if (jsonReader.nextIfMatch((byte)-90)) {
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        boolean match;
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        if (nameHashCode == 0L) continue;
                        boolean bl = match = nameHashCode == this.nameHashCode;
                        if (match) {
                            if (jsonReader.isArray()) {
                                values.addAll(jsonReader.readArray());
                                continue;
                            }
                            values.add(jsonReader.readAny());
                            continue;
                        }
                        if (jsonReader.isObject() || jsonReader.isArray()) {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                    return;
                }
                if (jsonReader.isArray()) {
                    int itemCnt = jsonReader.startArray();
                    for (int i = 0; i < itemCnt; ++i) {
                        if (jsonReader.isObject() || jsonReader.isArray()) {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                } else {
                    jsonReader.skipValue();
                }
                return;
            }
            if (jsonReader.ch == '{') {
                jsonReader.next();
                block9: while (true) {
                    Object val;
                    if (jsonReader.ch == '}') break;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean match = nameHashCode == this.nameHashCode;
                    char ch = jsonReader.ch;
                    if (!match && ch != '{' && ch != '[') {
                        jsonReader.skipValue();
                        continue;
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': 
                        case '{': {
                            if (match) {
                                val = ch == '[' ? jsonReader.readArray() : jsonReader.readObject();
                                break;
                            }
                            this.accept(jsonReader, context, values);
                            continue block9;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val instanceof Collection) {
                        values.addAll((Collection)val);
                    } else {
                        values.add(val);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                jsonReader.next();
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else if (jsonReader.ch == '[') {
                block31: {
                    jsonReader.next();
                    do {
                        if (jsonReader.ch == ']') {
                            jsonReader.next();
                            break block31;
                        }
                        if (jsonReader.ch == '{' || jsonReader.ch == '[') {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    } while (jsonReader.ch != ',');
                    jsonReader.next();
                }
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else {
                jsonReader.skipValue();
            }
        }

        class MapLoop
        implements BiConsumer,
        Consumer {
            final JSONPath.Context context;
            final List values;

            public MapLoop(JSONPath.Context context, List values) {
                this.context = context;
                this.values = values;
            }

            public void accept(Object key, Object value) {
                if (CycleNameSegment.this.name.equals(key)) {
                    this.values.add(value);
                    return;
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                } else if (CycleNameSegment.this.nameHashCode == HASH_STAR) {
                    this.values.add(value);
                }
            }

            public void accept(Object value) {
                if (value == null) {
                    return;
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                } else {
                    ObjectWriter<?> objectWriter = this.context.path.getWriterContext().getObjectWriter(value.getClass());
                    if (objectWriter instanceof ObjectWriterAdapter) {
                        FieldWriter fieldWriter = objectWriter.getFieldWriter(CycleNameSegment.this.nameHashCode);
                        if (fieldWriter != null) {
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            if (fieldValue != null) {
                                this.values.add(fieldValue);
                            }
                            return;
                        }
                        for (int i = 0; i < objectWriter.getFieldWriters().size(); ++i) {
                            fieldWriter = objectWriter.getFieldWriters().get(i);
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            this.accept(fieldValue);
                        }
                        return;
                    }
                    if (CycleNameSegment.this.nameHashCode == HASH_STAR) {
                        this.values.add(value);
                    }
                }
            }
        }

        class LoopSet {
            final JSONPath.Context context;
            final Object value;

            public LoopSet(JSONPath.Context context, Object value) {
                this.context = context;
                this.value = value;
            }

            public void accept(Object object) {
                if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        if (CycleNameSegment.this.name.equals(entry.getKey())) {
                            entry.setValue(this.value);
                            this.context.eval = true;
                            continue;
                        }
                        Object entryValue = entry.getValue();
                        if (entryValue == null) continue;
                        this.accept(entryValue);
                    }
                } else if (object instanceof Collection) {
                    for (Object e : (List)object) {
                        this.accept(e);
                    }
                } else {
                    FieldReader fieldReader;
                    Class<?> entryValueClass = object.getClass();
                    ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(entryValueClass);
                    if (objectReader instanceof ObjectReaderBean && (fieldReader = objectReader.getFieldReader(CycleNameSegment.this.nameHashCode)) != null) {
                        fieldReader.accept(object, this.value);
                        this.context.eval = true;
                        return;
                    }
                    ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(entryValueClass);
                    List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
                    for (FieldWriter fieldWriter : fieldWriters) {
                        Object fieldValue = fieldWriter.getFieldValue(object);
                        this.accept(fieldValue);
                    }
                }
            }
        }

        class LoopCallback {
            final JSONPath.Context context;
            final BiFunction callback;

            public LoopCallback(JSONPath.Context context, BiFunction callback) {
                this.context = context;
                this.callback = callback;
            }

            public void accept(Object object) {
                if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        Object entryValue = entry.getValue();
                        if (CycleNameSegment.this.name.equals(entry.getKey())) {
                            Object applyValue = this.callback.apply(object, entryValue);
                            entry.setValue(applyValue);
                            this.context.eval = true;
                            continue;
                        }
                        if (entryValue == null) continue;
                        this.accept(entryValue);
                    }
                } else if (object instanceof Collection) {
                    for (Object e : (List)object) {
                        this.accept(e);
                    }
                } else {
                    Class<?> entryValueClass = object.getClass();
                    ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(entryValueClass);
                    ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(entryValueClass);
                    if (objectReader instanceof ObjectReaderBean) {
                        FieldReader fieldReader = objectReader.getFieldReader(CycleNameSegment.this.nameHashCode);
                        FieldWriter fieldWriter = objectWriter.getFieldWriter(CycleNameSegment.this.nameHashCode);
                        if (fieldWriter != null && fieldReader != null) {
                            Object fieldValue = fieldWriter.getFieldValue(object);
                            fieldValue = this.callback.apply(object, fieldValue);
                            fieldReader.accept(object, fieldValue);
                            this.context.eval = true;
                            return;
                        }
                    }
                    List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
                    for (FieldWriter fieldWriter : fieldWriters) {
                        Object fieldValue = fieldWriter.getFieldValue(object);
                        this.accept(fieldValue);
                    }
                }
            }
        }
    }

    static final class RootSegment
    extends JSONPathSegment {
        static final RootSegment INSTANCE = new RootSegment();

        protected RootSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null) {
                throw new JSONException("not support operation");
            }
            context.value = jsonReader.readAny();
            context.eval = true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            context.value = object = context.parent == null ? context.root : context.parent.root;
        }
    }

    static final class SelfSegment
    extends JSONPathSegment {
        static final SelfSegment INSTANCE = new SelfSegment();

        protected SelfSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            context.value = jsonReader.readAny();
            context.eval = true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            context.value = object = context.parent == null ? context.root : context.parent.value;
        }
    }

    static final class AllSegment
    extends JSONPathSegment {
        static final AllSegment INSTANCE = new AllSegment(false);
        static final AllSegment INSTANCE_ARRAY = new AllSegment(true);
        final boolean array;

        AllSegment(boolean array) {
            this.array = array;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                context.value = null;
                context.eval = true;
                return;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(map.size());
                for (Object value : map.values()) {
                    if (this.array && value instanceof Collection) {
                        array.addAll((Collection)value);
                        continue;
                    }
                    array.add(value);
                }
                context.value = context.next != null ? new JSONPath.Sequence(array) : array;
                context.eval = true;
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                JSONArray values = new JSONArray(list.size());
                if (context.next == null && !this.array) {
                    for (Object item : list) {
                        if (item instanceof Map) {
                            values.addAll(((Map)item).values());
                            continue;
                        }
                        values.add(item);
                    }
                    context.value = values;
                    context.eval = true;
                    return;
                }
                context.value = context.next != null ? new JSONPath.Sequence(list) : object;
                context.eval = true;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                context.eval = true;
                return;
            }
            if (object instanceof JSONPath.Sequence) {
                List list = ((JSONPath.Sequence)object).values;
                JSONArray values = new JSONArray(list.size());
                if (context.next == null && !this.array) {
                    for (Object item : list) {
                        if (item instanceof Map) {
                            values.addAll(((Map)item).values());
                            continue;
                        }
                        values.add(item);
                    }
                    context.value = values;
                    context.eval = true;
                    return;
                }
                context.value = context.next != null ? new JSONPath.Sequence(list) : object;
                context.eval = true;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().provider;
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            int size = fieldWriters.size();
            JSONArray array = new JSONArray(size);
            for (int i = 0; i < size; ++i) {
                Object fieldValue = fieldWriters.get(i).getFieldValue(object);
                array.add(fieldValue);
            }
            context.value = array;
            context.eval = true;
        }

        @Override
        public boolean remove(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                ((Map)object).clear();
                return true;
            }
            if (object instanceof Collection) {
                ((Collection)object).clear();
                return true;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && context.parent.eval) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray values = new JSONArray();
                if (jsonReader.nextIfMatch((byte)-90)) {
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        if (!jsonReader.skipName()) continue;
                        Object val = jsonReader.readAny();
                        if (this.array && val instanceof Collection) {
                            values.addAll((Collection)val);
                            continue;
                        }
                        values.add(val);
                    }
                    context.value = values;
                    return;
                }
                if (jsonReader.isArray() && context.next != null) {
                    return;
                }
                throw new JSONException("TODO");
            }
            boolean alwaysReturnList = context.next == null && (context.path.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L;
            JSONArray values = new JSONArray();
            if (jsonReader.nextIfMatch('{')) {
                block10: while (true) {
                    Object val;
                    if (jsonReader.ch == '}') {
                        jsonReader.next();
                        break;
                    }
                    jsonReader.skipName();
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        case ']': {
                            jsonReader.next();
                            break block10;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val instanceof Collection) {
                        if (alwaysReturnList) {
                            values.add(val);
                        } else {
                            values.addAll((Collection)val);
                        }
                    } else {
                        values.add(val);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                context.value = values;
                context.eval = true;
                return;
            }
            if (jsonReader.ch == '[') {
                jsonReader.next();
                while (true) {
                    if (jsonReader.ch == ']') break;
                    Object value = jsonReader.readAny();
                    if (context.next == null && value instanceof Map) {
                        values.addAll(((Map)value).values());
                    } else {
                        values.add(value);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                jsonReader.next();
                context.value = context.next != null ? new JSONPath.Sequence(values) : values;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class MultiNameSegment
    extends JSONPathSegment {
        final String[] names;
        final long[] nameHashCodes;
        final Set<String> nameSet;

        public MultiNameSegment(String[] names) {
            this.names = names;
            this.nameHashCodes = new long[names.length];
            this.nameSet = new HashSet<String>();
            for (int i = 0; i < names.length; ++i) {
                this.nameHashCodes[i] = Fnv.hashCode64(names[i]);
                this.nameSet.add(names[i]);
            }
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(this.names.length);
                for (String name : this.names) {
                    Object value = map.get(name);
                    array.add(value);
                }
                context.value = array;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().provider;
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            JSONArray array = new JSONArray(this.names.length);
            for (int i = 0; i < this.names.length; ++i) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCodes[i]);
                Object fieldValue = null;
                if (fieldWriter != null) {
                    fieldValue = fieldWriter.getFieldValue(object);
                }
                array.add(fieldValue);
            }
            context.value = array;
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof JSONPathFilter || context.parent.current instanceof MultiIndexSegment)) {
                this.eval(context);
                return;
            }
            Object object = jsonReader.readAny();
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(this.names.length);
                for (String name : this.names) {
                    Object value = map.get(name);
                    array.add(value);
                }
                context.value = array;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().provider;
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            JSONArray array = new JSONArray(this.names.length);
            for (int i = 0; i < this.names.length; ++i) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCodes[i]);
                Object fieldValue = null;
                if (fieldWriter != null) {
                    fieldValue = fieldWriter.getFieldValue(object);
                }
                array.add(fieldValue);
            }
            context.value = array;
        }
    }

    static final class MultiIndexSegment
    extends JSONPathSegment {
        final int[] indexes;

        public MultiIndexSegment(int[] indexes) {
            this.indexes = indexes;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof JSONPath.Sequence) {
                List list = ((JSONPath.Sequence)object).values;
                for (Object item : list) {
                    context.value = item;
                    JSONPath.Context itemContext = new JSONPath.Context(context.path, context, context.current, context.next, context.readerFeatures);
                    this.eval(itemContext);
                    Object value = itemContext.value;
                    if (value instanceof Collection) {
                        result.addAll((Collection)value);
                        continue;
                    }
                    result.add(value);
                }
                context.value = result;
                return;
            }
            for (int index : this.indexes) {
                int itemIndex;
                Object value;
                if (object instanceof List) {
                    List list = (List)object;
                    if (index >= 0) {
                        if (index >= list.size()) continue;
                        value = list.get(index);
                    } else {
                        itemIndex = list.size() + index;
                        if (itemIndex < 0) continue;
                        value = list.get(itemIndex);
                    }
                } else {
                    if (!(object instanceof Object[])) continue;
                    Object[] array = (Object[])object;
                    if (index >= 0) {
                        if (index >= array.length) continue;
                        value = array[index];
                    } else {
                        itemIndex = array.length + index;
                        if (itemIndex < 0) continue;
                        value = array[itemIndex];
                    }
                }
                if (value instanceof Collection) {
                    result.addAll((Collection)value);
                    continue;
                }
                result.add(value);
            }
            context.value = result;
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && context.parent.current instanceof CycleNameSegment && context.next == null) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (int i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                context.value = array;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val);
                }
                ++i;
            }
            context.value = array;
        }
    }

    static final class RangeIndexSegment
    extends JSONPathSegment {
        final int begin;
        final int end;

        public RangeIndexSegment(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i >= this.begin && i < this.end;
                    } else {
                        int ni = i - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    result.add(list.get(i));
                }
                context.value = result;
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                for (int i = 0; i < array.length; ++i) {
                    boolean match;
                    boolean bl = match = i >= this.begin && i <= this.end || i - array.length > this.begin && i - array.length <= this.end;
                    if (!match) continue;
                    result.add(array[i]);
                }
                context.value = result;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof CycleNameSegment && context.next == null)) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                int i;
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = this.begin < 0 || i >= this.begin && i < this.end;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                if (this.begin < 0) {
                    int size = array.size();
                    for (i = size - 1; i >= 0; --i) {
                        int ni = i - size;
                        if (ni >= this.begin && ni < this.end) continue;
                        array.remove(i);
                    }
                }
                context.value = array;
                context.eval = true;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = this.begin < 0 || i >= this.begin && i < this.end;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val);
                }
                ++i;
            }
            if (this.begin < 0) {
                int size = array.size();
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    int ni = i2 - size;
                    if (ni >= this.begin && ni < this.end) continue;
                    array.remove(i2);
                }
            }
            context.value = array;
            context.eval = true;
        }

        @Override
        public void set(JSONPath.Context context, Object value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i >= this.begin && i < this.end;
                    } else {
                        int ni = i - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    list.set(i, value);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public boolean remove(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                int removeCount = 0;
                int size = list.size();
                for (int i = size - 1; i >= 0; --i) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i >= this.begin && i < this.end;
                    } else {
                        int ni = i - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    list.remove(i);
                    ++removeCount;
                }
                return removeCount > 0;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }
    }

    static final class RandomIndexSegment
    extends JSONPathSegment {
        public static final RandomIndexSegment INSTANCE = new RandomIndexSegment();
        Random random;

        RandomIndexSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof CycleNameSegment && context.next == null)) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (int i = 0; i < itemCnt; ++i) {
                    array.add(jsonReader.readAny());
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int index = Math.abs(this.random.nextInt()) % array.size();
                context.value = array.get(index);
                context.eval = true;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                Object val;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber0();
                        val = jsonReader.getNumber();
                        break;
                    }
                    case '[': {
                        val = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        val = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val = null;
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
                array.add(val);
                ++i;
            }
            if (this.random == null) {
                this.random = new Random();
            }
            int index = Math.abs(this.random.nextInt()) % array.size();
            context.value = array.get(index);
            context.eval = true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return;
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int randomIndex = Math.abs(this.random.nextInt()) % list.size();
                context.value = list.get(randomIndex);
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (array.length == 0) {
                    return;
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int randomIndex = this.random.nextInt() % array.length;
                context.value = array[randomIndex];
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static interface EvalSegment {
    }
}

