/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTypedMulti;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;

class JSONPathTypedMultiNames
extends JSONPathTypedMulti {
    final JSONPath prefix;
    final JSONPath[] namePaths;
    final String[] names;
    final long[] hashCodes;
    final short[] mapping;
    final FieldReader[] fieldReaders;

    JSONPathTypedMultiNames(JSONPath[] paths, JSONPath prefix, JSONPath[] namePaths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(paths, types, formats, pathFeatures, zoneId, features);
        int i;
        this.prefix = prefix;
        this.namePaths = namePaths;
        this.names = new String[paths.length];
        long[] hashCodes = new long[paths.length];
        this.fieldReaders = new FieldReader[paths.length];
        for (i = 0; i < paths.length; ++i) {
            String fieldName;
            JSONPathSingleName jsonPathSingleName = (JSONPathSingleName)namePaths[i];
            this.names[i] = fieldName = jsonPathSingleName.name;
            hashCodes[i] = jsonPathSingleName.nameHashCode;
            String format = formats != null ? formats[i] : null;
            Type fieldType = types[i];
            Class<?> fieldClass = TypeUtils.getClass(fieldType);
            long fieldFeatures = 0L;
            if (this.isIgnoreError(i)) {
                fieldFeatures |= JSONReader.Feature.NullOnError.mask;
            }
            this.fieldReaders[i] = ObjectReaderCreator.INSTANCE.createFieldReader(null, null, fieldName, fieldType, fieldClass, i, fieldFeatures, format, null, null, null, null, null, null);
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i = 0; i < hashCodes.length; ++i) {
            long hashCode = hashCodes[i];
            int index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i;
        }
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public boolean contains(Object object) {
        for (JSONPath jsonPath : this.paths) {
            if (!jsonPath.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object eval(Object root) {
        Object[] array = new Object[this.paths.length];
        Object object = root;
        if (this.prefix != null) {
            object = this.prefix.eval(root);
        }
        if (object == null) {
            return new Object[this.paths.length];
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (int i = 0; i < this.names.length; ++i) {
                Object result = map.get(this.names[i]);
                Type type = this.types[i];
                if (result != null && result.getClass() != type) {
                    result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                }
                array[i] = result;
            }
        } else {
            Class<?> objectClass = object.getClass();
            ObjectWriter objectReader = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(objectClass);
            for (int i = 0; i < this.names.length; ++i) {
                FieldWriter fieldWriter = objectReader.getFieldWriter(this.names[i]);
                if (fieldWriter == null) continue;
                Object result = fieldWriter.getFieldValue(object);
                Type type = this.types[i];
                if (result != null && result.getClass() != type) {
                    result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                }
                array[i] = result;
            }
        }
        return array;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        if (this.prefix != null) {
            Object object = jsonReader.readAny();
            return this.eval(object);
        }
        if (jsonReader.nextIfNull()) {
            return new Object[this.paths.length];
        }
        if (!jsonReader.nextIfObjectStart()) {
            throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
        }
        Object[] values = new Object[this.paths.length];
        while (!jsonReader.nextIfObjectEnd()) {
            Object fieldValue;
            long nameHashCode = jsonReader.readFieldNameHashCode();
            int m = Arrays.binarySearch(this.hashCodes, nameHashCode);
            if (m < 0) {
                jsonReader.skipValue();
                continue;
            }
            short index = this.mapping[m];
            FieldReader fieldReader = this.fieldReaders[index];
            try {
                fieldValue = fieldReader.readFieldValue(jsonReader);
            }
            catch (Exception e) {
                long features = 0L;
                if (index < this.pathFeatures.length) {
                    features = this.pathFeatures[index];
                }
                if ((features & JSONPath.Feature.NullOnError.mask) == 0L) {
                    throw e;
                }
                fieldValue = null;
            }
            values[index] = fieldValue;
        }
        return values;
    }
}

