/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UUIDUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONReaderJSONB
extends JSONReader {
    static final byte[] SHANGHAI_ZONE_ID_NAME_BYTES = JSONB.toBytes("Asia/Shanghai");
    static Charset GB18030;
    protected final byte[] bytes;
    protected final int length;
    protected final int end;
    protected byte type;
    protected int strlen;
    protected byte strtype;
    protected int strBegin;
    protected byte[] valueBytes;
    protected final int cachedIndex = System.identityHashCode(Thread.currentThread()) & 3;
    protected final SymbolTable symbolTable;
    protected long symbol0Hash;
    protected int symbol0Begin;
    protected int symbol0Length;
    protected byte symbol0StrType;
    protected long[] symbols;

    JSONReaderJSONB(JSONReader.Context ctx, byte[] bytes, int off, int length) {
        super(ctx);
        this.bytes = bytes;
        this.offset = off;
        this.length = length;
        this.end = off + length;
        this.symbolTable = ctx.symbolTable;
    }

    @Override
    public boolean isJSONB() {
        return true;
    }

    @Override
    public String getString() {
        Charset charset;
        if (this.strtype == -81) {
            return null;
        }
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        if (this.strtype == 121) {
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype >= 73 && this.strtype <= 120) {
            if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                char[] chars = new char[this.strlen];
                for (int i = 0; i < this.strlen; ++i) {
                    chars[i] = (char)this.bytes[this.strBegin + i];
                }
                return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
            }
            if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                byte[] chars = new byte[this.strlen];
                System.arraycopy(this.bytes, this.strBegin, chars, 0, this.strlen);
                return JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.LATIN1);
            }
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype == 122) {
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            charset = StandardCharsets.UTF_16BE;
        } else {
            if (this.strtype == 127) {
                int symbol = this.strlen;
                if (symbol < 0) {
                    return this.symbolTable.getName(-symbol);
                }
                int index = symbol * 2;
                throw new JSONException("TODO : " + JSONB.typeName(this.strtype));
            }
            throw new JSONException("TODO : " + JSONB.typeName(this.strtype));
        }
        return new String(this.bytes, this.strBegin, this.strlen, charset);
    }

    public int readLength() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type == 72) {
            int len;
            if ((len = (this.bytes[this.offset++] << 24) + ((this.bytes[this.offset++] & 0xFF) << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF)) > 0x10000000) {
                throw new JSONException("input length overflow");
            }
            return len;
        }
        throw new JSONException("not support length type : " + JSONB.typeName(type));
    }

    @Override
    public final boolean isArray() {
        if (this.offset >= this.bytes.length) {
            return false;
        }
        byte type = this.bytes[this.offset];
        return type >= -108 && type <= -92;
    }

    @Override
    public final boolean isObject() {
        return this.offset < this.end && this.bytes[this.offset] == -90;
    }

    @Override
    public boolean isNumber() {
        byte type = this.bytes[this.offset];
        return type >= -78 && type <= 72;
    }

    @Override
    public boolean isString() {
        return this.offset < this.bytes.length && (this.type = this.bytes[this.offset]) >= 73;
    }

    @Override
    public boolean nextIfMatch(char ch) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfObjectStart() {
        if (this.bytes[this.offset] != -90) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public final boolean nextIfObjectEnd() {
        if (this.bytes[this.offset] != -91) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public final boolean nextIfNullOrEmptyString() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        if (this.bytes[this.offset] != 73) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public <T> T read(Type type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public Map<String, Object> readObject() {
        this.type = this.bytes[this.offset++];
        if (this.type == -81) {
            return null;
        }
        if (this.type >= -90) {
            HashMap map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? (JDKUtils.JVM_VERSION == 8 && this.bytes[this.offset] != -91 ? new HashMap(10) : new HashMap()) : (JDKUtils.JVM_VERSION == 8 && this.bytes[this.offset] != -91 ? new JSONObject(10) : new JSONObject());
            int i = 0;
            while (true) {
                this.type = this.bytes[this.offset];
                if (this.type == -91) {
                    ++this.offset;
                    break;
                }
                String name = this.readFieldName();
                if (this.offset < this.bytes.length && this.bytes[this.offset] == -109) {
                    String reference = this.readReference();
                    if ("..".equals(reference)) {
                        map.put(name, map);
                    } else {
                        this.addResolveTask(map, (Object)name, JSONPath.of(reference));
                    }
                } else {
                    List value;
                    byte valueType = this.bytes[this.offset];
                    if (valueType >= 73 && valueType <= 126) {
                        value = this.readString();
                    } else if (valueType >= -16 && valueType <= 47) {
                        ++this.offset;
                        value = (int)valueType;
                    } else if (valueType == -79) {
                        ++this.offset;
                        value = Boolean.TRUE;
                    } else if (valueType == -80) {
                        ++this.offset;
                        value = Boolean.FALSE;
                    } else if (valueType == -90) {
                        value = this.readObject();
                    } else if (valueType == -66) {
                        ++this.offset;
                        long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                        this.offset += 8;
                        value = int64Value;
                    } else if (valueType >= -108 && valueType <= -92) {
                        int len;
                        ++this.offset;
                        if (valueType == -92) {
                            int itemType = this.bytes[this.offset];
                            if (itemType >= -16 && itemType <= 47) {
                                ++this.offset;
                                len = itemType;
                            } else {
                                len = this.readLength();
                            }
                        } else {
                            len = valueType - -108;
                        }
                        if (len == 0) {
                            value = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList() : (this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray());
                        } else {
                            JSONArray list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
                            for (int j = 0; j < len; ++j) {
                                if (this.isReference()) {
                                    String reference = this.readReference();
                                    if ("..".equals(reference)) {
                                        list.add(list);
                                        continue;
                                    }
                                    list.add(null);
                                    this.addResolveTask(list, j, JSONPath.of(reference));
                                    continue;
                                }
                                byte itemType = this.bytes[this.offset];
                                Object item = itemType >= 73 && itemType <= 126 ? this.readString() : (itemType == -90 ? this.readObject() : this.readAny());
                                list.add(item);
                            }
                            value = list;
                        }
                    } else if (valueType >= 48 && valueType <= 63) {
                        ++this.offset;
                        value = (valueType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
                    } else if (valueType >= 64 && valueType <= 71) {
                        ++this.offset;
                        int int32Value = (valueType - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
                        value = new Integer(int32Value);
                    } else if (valueType == 72) {
                        ++this.offset;
                        int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                        this.offset += 4;
                        value = new Integer(int32Value);
                    } else {
                        value = this.readAny();
                    }
                    map.put(name, value);
                }
                ++i;
            }
            return map;
        }
        if (this.type == -110) {
            ObjectReader objectReader = this.checkAutoType(Map.class, 0L, 0L);
            return (Map)objectReader.readObject(this, null, null, 0L);
        }
        throw new JSONException("object not support input " + this.error(this.type));
    }

    @Override
    public Object readAny() {
        if (this.offset >= this.bytes.length) {
            throw new JSONException("readAny overflow : " + this.offset + "/" + this.bytes.length);
        }
        this.type = this.bytes[this.offset++];
        switch (this.type) {
            case -81: {
                return null;
            }
            case -79: {
                return true;
            }
            case -80: {
                return false;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                return (short)((this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF));
            }
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Integer(int32Value);
            }
            case -65: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Long(int32Value);
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return Double.longBitsToDouble(int64Value);
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case 122: {
                int strlen = this.readLength();
                if (JDKUtils.STRING_CREATOR_JDK11 != null && !JDKUtils.BIG_ENDIAN) {
                    if (this.valueBytes == null) {
                        this.valueBytes = JSONFactory.allocateByteArray(this.cachedIndex);
                    }
                    int minCapacity = strlen << 1;
                    if (this.valueBytes == null) {
                        this.valueBytes = new byte[minCapacity];
                    } else if (minCapacity > this.valueBytes.length) {
                        this.valueBytes = new byte[minCapacity];
                    }
                    int utf16_len = IOUtils.decodeUTF8(this.bytes, this.offset, strlen, this.valueBytes);
                    if (utf16_len != -1) {
                        byte[] value = new byte[utf16_len];
                        System.arraycopy(this.valueBytes, 0, value, 0, utf16_len);
                        String str = JDKUtils.STRING_CREATOR_JDK11.apply(value, JDKUtils.UTF16);
                        this.offset += strlen;
                        return str;
                    }
                }
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return str;
            }
            case 123: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16);
                this.offset += strlen;
                return str;
            }
            case 124: {
                String str;
                int strlen = this.readLength();
                if (JDKUtils.STRING_CREATOR_JDK11 != null && !JDKUtils.BIG_ENDIAN) {
                    byte[] chars = new byte[strlen];
                    System.arraycopy(this.bytes, this.offset, chars, 0, strlen);
                    str = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.UTF16);
                } else {
                    str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                }
                this.offset += strlen;
                return str;
            }
            case 125: {
                String str;
                int strlen = this.readLength();
                if (JDKUtils.STRING_CREATOR_JDK11 != null && JDKUtils.BIG_ENDIAN) {
                    byte[] chars = new byte[strlen];
                    System.arraycopy(this.bytes, this.offset, chars, 0, strlen);
                    str = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.UTF16);
                } else {
                    str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16BE);
                }
                this.offset += strlen;
                return str;
            }
            case 126: {
                if (GB18030 == null) {
                    GB18030 = Charset.forName("GB18030");
                }
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, GB18030);
                this.offset += strlen;
                return str;
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal;
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case -111: {
                int len = this.readLength();
                byte[] binary = Arrays.copyOfRange(this.bytes, this.offset, this.offset + len);
                this.offset += len;
                return binary;
            }
            case -83: {
                long minutes = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Date(minutes * 60L * 1000L);
            }
            case -84: {
                long seconds = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Date(seconds * 1000L);
            }
            case -87: {
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                return LocalDate.of(year, month, (int)dayOfMonth);
            }
            case -89: {
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                return LocalTime.of(hour, minute, second, nano);
            }
            case -88: {
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
            }
            case -86: {
                ZoneId zoneId;
                boolean shanghai;
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                byte[] shanghaiZoneIdNameBytes = SHANGHAI_ZONE_ID_NAME_BYTES;
                if (this.offset + shanghaiZoneIdNameBytes.length < this.bytes.length) {
                    shanghai = true;
                    for (int i = 0; i < shanghaiZoneIdNameBytes.length; ++i) {
                        if (this.bytes[this.offset + i] == shanghaiZoneIdNameBytes[i]) continue;
                        shanghai = false;
                    }
                } else {
                    shanghai = false;
                }
                if (shanghai) {
                    this.offset += shanghaiZoneIdNameBytes.length;
                    zoneId = DateUtils.SHANGHAI_ZONE_ID;
                } else {
                    String zoneIdStr = this.readString();
                    zoneId = ZoneId.of(zoneIdStr);
                }
                LocalDateTime ldt = LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
                return ZonedDateTime.of(ldt, zoneId);
            }
            case -82: {
                long epochSeconds = this.readInt64Value();
                int nano = this.readInt32Value();
                return Instant.ofEpochSecond(epochSeconds, nano);
            }
            case -85: {
                long millis = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return new Date(millis);
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -110: {
                String typeName;
                boolean supportAutoType;
                ObjectReader autoTypeObjectReader;
                long typeHash = this.readTypeHashCode();
                if (this.context.autoTypeBeforeHandler != null) {
                    Class<?> filterClass = this.context.autoTypeBeforeHandler.apply(typeHash, null, this.context.features);
                    if (filterClass == null) {
                        String typeName2 = this.getString();
                        filterClass = this.context.autoTypeBeforeHandler.apply(typeName2, null, this.context.features);
                    }
                    if (filterClass != null) {
                        autoTypeObjectReader = this.context.getObjectReader(filterClass);
                        return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
                    }
                }
                boolean bl = supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                if (!supportAutoType) {
                    if (this.isObject()) {
                        return this.readObject();
                    }
                    if (this.isArray()) {
                        return this.readArray();
                    }
                    throw new JSONException("auoType not support , offset " + this.offset + "/" + this.bytes.length);
                }
                autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                    throw new JSONException("auoType not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                }
                return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
            }
            case -78: {
                return 0.0;
            }
            case -77: {
                return 1.0;
            }
            case -112: {
                int intValue = this.readInt32Value();
                return Character.valueOf((char)intValue);
            }
            case -90: {
                HashMap map = null;
                boolean supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                int i = 0;
                while (true) {
                    Object name;
                    byte type;
                    if ((type = this.bytes[this.offset]) == -91) {
                        ++this.offset;
                        break;
                    }
                    if (supportAutoType && i == 0 && type >= 73 && type <= 127) {
                        long hash = this.readFieldNameHashCode();
                        if (hash == ObjectReader.HASH_TYPE && supportAutoType) {
                            String typeName;
                            long typeHash = this.readValueHashCode();
                            ObjectReader autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                            if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                                throw new JSONException("auotype not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                            }
                            this.typeRedirect = true;
                            return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
                        }
                        name = this.getFieldName();
                    } else {
                        name = type >= 73 && type <= 127 ? this.readFieldName() : this.readAny();
                    }
                    if (map == null) {
                        map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
                    }
                    if (this.isReference()) {
                        String reference = this.readReference();
                        if ("..".equals(reference)) {
                            map.put(name, map);
                        } else {
                            this.addResolveTask(map, name, JSONPath.of(reference));
                            map.put(name, null);
                        }
                    } else {
                        Object value;
                        byte valueType = this.bytes[this.offset];
                        if (valueType >= 73 && valueType <= 126) {
                            value = this.readString();
                        } else if (valueType >= -16 && valueType <= 47) {
                            ++this.offset;
                            value = (int)valueType;
                        } else if (valueType == -79) {
                            ++this.offset;
                            value = Boolean.TRUE;
                        } else if (valueType == -80) {
                            ++this.offset;
                            value = Boolean.FALSE;
                        } else {
                            value = valueType == -90 ? this.readObject() : this.readAny();
                        }
                        map.put(name, value);
                    }
                    ++i;
                }
                if (map == null) {
                    map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
                }
                return map;
            }
        }
        if (this.type >= -16 && this.type <= 47) {
            return (int)this.type;
        }
        if (this.type >= 48 && this.type <= 63) {
            return (this.type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= 64 && this.type <= 71) {
            return (this.type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= -40 && this.type <= -17) {
            return -8L + (long)(this.type - -40);
        }
        if (this.type >= -56 && this.type <= -41) {
            return (long)(this.type - -48 << 8) + (long)(this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= -64 && this.type <= -57) {
            return (long)((this.type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF));
        }
        if (this.type >= -108 && this.type <= -92) {
            int len;
            int n = len = this.type == -92 ? this.readLength() : this.type - -108;
            if (len == 0) {
                if ((this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L) {
                    return new ArrayList();
                }
                if (this.context.arraySupplier != null) {
                    return this.context.arraySupplier.get();
                }
                return new JSONArray();
            }
            JSONArray list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                if (this.isReference()) {
                    String reference = this.readReference();
                    if ("..".equals(reference)) {
                        list.add(list);
                        continue;
                    }
                    list.add(null);
                    this.addResolveTask(list, i, JSONPath.of(reference));
                    continue;
                }
                Object item = this.readAny();
                list.add(item);
            }
            return list;
        }
        if (this.type >= 73 && this.type <= 121) {
            int n = this.strlen = this.type == 121 ? this.readLength() : this.type - 73;
            if (this.strlen < 0) {
                return this.symbolTable.getName(-this.strlen);
            }
            if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                char[] chars = new char[this.strlen];
                for (int i = 0; i < this.strlen; ++i) {
                    chars[i] = (char)this.bytes[this.offset + i];
                }
                this.offset += this.strlen;
                String str = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str = str.trim();
                }
                return str;
            }
            if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                byte[] chars = new byte[this.strlen];
                System.arraycopy(this.bytes, this.offset, chars, 0, this.strlen);
                this.offset += this.strlen;
                String str = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.LATIN1);
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str = str.trim();
                }
                return str;
            }
            String str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
            this.offset += this.strlen;
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            return str;
        }
        if (this.type == 127) {
            this.strlen = this.readLength();
            if (this.strlen >= 0) {
                throw new JSONException("not support symbol : " + this.strlen);
            }
            return this.symbolTable.getName(-this.strlen);
        }
        throw new JSONException("not support type : " + this.error(this.type));
    }

    @Override
    public byte getType() {
        return this.bytes[this.offset];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List readArray() {
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        int i = 0;
        while (true) {
            block20: {
                List value;
                block6: {
                    JSONArray list;
                    int len;
                    block14: {
                        block18: {
                            String reference;
                            block19: {
                                byte valueType;
                                block17: {
                                    block16: {
                                        block15: {
                                            block12: {
                                                block13: {
                                                    block11: {
                                                        block10: {
                                                            block9: {
                                                                block8: {
                                                                    block7: {
                                                                        block5: {
                                                                            if (i >= entryCnt) {
                                                                                return array;
                                                                            }
                                                                            valueType = this.bytes[this.offset];
                                                                            if (valueType < 73 || valueType > 126) break block5;
                                                                            value = this.readString();
                                                                            break block6;
                                                                        }
                                                                        if (valueType < -16 || valueType > 47) break block7;
                                                                        ++this.offset;
                                                                        value = (int)valueType;
                                                                        break block6;
                                                                    }
                                                                    if (valueType != -79) break block8;
                                                                    ++this.offset;
                                                                    value = Boolean.TRUE;
                                                                    break block6;
                                                                }
                                                                if (valueType != -80) break block9;
                                                                ++this.offset;
                                                                value = Boolean.FALSE;
                                                                break block6;
                                                            }
                                                            if (valueType != -90) break block10;
                                                            value = this.readObject();
                                                            break block6;
                                                        }
                                                        if (valueType != -66) break block11;
                                                        ++this.offset;
                                                        long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                                                        this.offset += 8;
                                                        value = int64Value;
                                                        break block6;
                                                    }
                                                    if (valueType < -108 || valueType > -92) break block12;
                                                    ++this.offset;
                                                    int n = len = valueType == -92 ? this.readLength() : valueType - -108;
                                                    if (len != 0) break block13;
                                                    value = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList() : (this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray());
                                                    break block6;
                                                }
                                                list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
                                                break block14;
                                            }
                                            if (valueType < 48 || valueType > 63) break block15;
                                            ++this.offset;
                                            value = (valueType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
                                            break block6;
                                        }
                                        if (valueType < 64 || valueType > 71) break block16;
                                        ++this.offset;
                                        int int32Value = (valueType - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
                                        value = new Integer(int32Value);
                                        break block6;
                                    }
                                    if (valueType != 72) break block17;
                                    ++this.offset;
                                    int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                                    this.offset += 4;
                                    value = new Integer(int32Value);
                                    break block6;
                                }
                                if (valueType != -109) break block18;
                                reference = this.readReference();
                                if (!"..".equals(reference)) break block19;
                                value = array;
                                break block6;
                            }
                            this.addResolveTask(array, i, JSONPath.of(reference));
                            break block20;
                        }
                        value = this.readAny();
                        break block6;
                    }
                    for (int j = 0; j < len; ++j) {
                        if (this.isReference()) {
                            String reference = this.readReference();
                            if ("..".equals(reference)) {
                                list.add(list);
                                continue;
                            }
                            list.add(null);
                            this.addResolveTask(list, j, JSONPath.of(reference));
                            continue;
                        }
                        byte itemType = this.bytes[this.offset];
                        Object item = itemType >= 73 && itemType <= 126 ? this.readString() : (itemType == -90 ? this.readObject() : this.readAny());
                        list.add(item);
                    }
                    value = list;
                }
                array.add(value);
            }
            ++i;
        }
    }

    @Override
    public List readArray(Type itemType) {
        if (this.nextIfNull()) {
            return null;
        }
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            array.add(this.read(itemType));
        }
        return array;
    }

    @Override
    public List readList(Type[] types) {
        if (this.nextIfNull()) {
            return null;
        }
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            Type itemType = types[i];
            array.add(this.read(itemType));
        }
        return array;
    }

    @Override
    public byte[] readHex() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean isReference() {
        return this.offset < this.bytes.length && this.bytes[this.offset] == -109;
    }

    @Override
    public final String readReference() {
        if (this.bytes[this.offset] != -109) {
            return null;
        }
        ++this.offset;
        if (this.isString()) {
            return this.readString();
        }
        throw new JSONException("reference not support input " + this.error(this.type));
    }

    @Override
    public final ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        ObjectReader autoTypeObjectReader = null;
        this.type = this.bytes[this.offset];
        if (this.type == -110) {
            ClassLoader contextClassLoader;
            ClassLoader objectClassLoader;
            Class objectClass;
            boolean isSupportAutoType;
            String typeName;
            ObjectReader objectReader;
            Class objectClass2;
            ++this.offset;
            long typeHash = this.readTypeHashCode();
            if (expectClassHash == typeHash && (objectClass2 = (objectReader = this.context.getObjectReader(expectClass)).getObjectClass()) != null && objectClass2 == expectClass) {
                this.context.getProvider().registerIfAbsent(typeHash, objectReader);
                return objectReader;
            }
            if (this.context.autoTypeBeforeHandler != null) {
                ObjectReader objectReader2;
                Class<?> objectClass3 = this.context.autoTypeBeforeHandler.apply(typeHash, expectClass, features);
                if (objectClass3 == null) {
                    typeName = this.getString();
                    objectClass3 = this.context.autoTypeBeforeHandler.apply(typeName, expectClass, features);
                }
                if (objectClass3 != null && (objectReader2 = this.context.getObjectReader(objectClass3)) != null) {
                    return objectReader2;
                }
            }
            boolean bl = isSupportAutoType = ((this.context.features | features) & JSONReader.Feature.SupportAutoType.mask) != 0L;
            if (!isSupportAutoType) {
                typeName = this.getString();
                throw new JSONException("autoType not support input " + typeName);
            }
            ObjectReaderProvider provider = this.context.provider;
            autoTypeObjectReader = provider.getObjectReader(typeHash);
            if (autoTypeObjectReader != null && (objectClass = autoTypeObjectReader.getObjectClass()) != null && (objectClassLoader = objectClass.getClassLoader()) != null && objectClassLoader != (contextClassLoader = Thread.currentThread().getContextClassLoader())) {
                String typeName2 = this.getString();
                Class<?> contextClass = TypeUtils.getMapping(typeName2);
                if (contextClass == null) {
                    try {
                        if (contextClassLoader == null) {
                            contextClassLoader = JSON.class.getClassLoader();
                        }
                        contextClass = contextClassLoader.loadClass(typeName2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (contextClass != null && !objectClass.equals(contextClass)) {
                    autoTypeObjectReader = this.getObjectReader(contextClass);
                }
            }
            if (autoTypeObjectReader == null) {
                String typeName3 = this.getString();
                autoTypeObjectReader = provider.getObjectReader(typeName3, expectClass, this.context.features | features);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException("auotype not support : " + this.getString());
            }
            this.type = this.bytes[this.offset];
        }
        return autoTypeObjectReader;
    }

    @Override
    public int startArray() {
        this.type = this.bytes[this.offset++];
        if (this.type == -81) {
            return -1;
        }
        if (this.type >= -108 && this.type <= -93) {
            this.ch = (char)(-this.type);
            return this.type - -108;
        }
        if (this.type == -111) {
            return this.readInt32Value();
        }
        if (this.type != -92) {
            throw new JSONException("array not support input " + this.error(this.type));
        }
        return this.readInt32Value();
    }

    public String error(byte type) {
        StringBuilder buf = new StringBuilder();
        buf.append(JSONB.typeName(type));
        if (this.isString()) {
            int mark = this.offset--;
            String str = null;
            try {
                str = this.readString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (str != null) {
                buf.append(' ');
                buf.append(str);
            }
            this.offset = mark;
        }
        buf.append(", offset ");
        buf.append(this.offset);
        buf.append('/');
        buf.append(this.bytes.length);
        return buf.toString();
    }

    @Override
    public final void next() {
        ++this.offset;
    }

    @Override
    public long readFieldNameHashCode() {
        long hashCode;
        boolean typeSymbol;
        this.strtype = this.bytes[this.offset++];
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            this.strtype = this.bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol;
                if (this.strtype >= -16 && this.strtype <= 47) {
                    ++this.offset;
                    symbol = this.strtype;
                } else {
                    symbol = this.readInt32Value();
                }
                if (symbol < 0) {
                    return this.symbolTable.getHashCode(-symbol);
                }
                if (symbol == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    if (this.symbol0Hash == 0L) {
                        this.symbol0Hash = this.getNameHashCode();
                    }
                    return this.symbol0Hash;
                }
                int index = symbol * 2;
                long strInfo = this.symbols[index + 1];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                long nameHashCode = this.symbols[index];
                if (nameHashCode == 0L) {
                    this.symbols[index] = nameHashCode = this.getNameHashCode();
                }
                return nameHashCode;
            }
            ++this.offset;
        }
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            StringBuffer message = new StringBuffer().append("fieldName not support input type ").append(JSONB.typeName(this.strtype));
            if (this.strtype == -109) {
                message.append(" ").append(this.readString());
            }
            message.append(", offset ").append(this.offset);
            throw new JSONException(message.toString());
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else {
            long nameValue = 0L;
            if (JSONFactory.MIXED_HASH_ALGORITHM && this.strlen <= 8) {
                switch (this.strlen) {
                    case 1: {
                        nameValue = this.bytes[this.offset];
                        break;
                    }
                    case 2: {
                        nameValue = (this.bytes[this.offset + 1] << 8) + (this.bytes[this.offset] & 0xFF);
                        break;
                    }
                    case 3: {
                        nameValue = (this.bytes[this.offset + 2] << 16) + ((this.bytes[this.offset + 1] & 0xFF) << 8) + (this.bytes[this.offset] & 0xFF);
                        break;
                    }
                    case 4: {
                        nameValue = (this.bytes[this.offset + 3] << 24) + ((this.bytes[this.offset + 2] & 0xFF) << 16) + ((this.bytes[this.offset + 1] & 0xFF) << 8) + (this.bytes[this.offset] & 0xFF);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)this.bytes[this.offset + 4] << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 8: {
                        nameValue = ((long)this.bytes[this.offset + 7] << 56) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                }
            }
            if (nameValue != 0L) {
                this.offset += this.strlen;
                hashCode = nameValue;
            } else {
                hashCode = -3750763034362895579L;
                for (int i = 0; i < this.strlen; ++i) {
                    byte c = this.bytes[this.offset++];
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
            }
        }
        if (typeSymbol) {
            int symbol;
            this.type = this.bytes[this.offset];
            if (this.type >= -16 && this.type <= 47) {
                symbol = this.type;
                ++this.offset;
            } else {
                symbol = this.readInt32Value();
            }
            if (symbol == 0) {
                this.symbol0Begin = this.strBegin;
                this.symbol0Length = this.strlen;
                this.symbol0StrType = this.strtype;
                this.symbol0Hash = hashCode;
                return hashCode;
            }
            long strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
            int minCapacity = symbol * 2 + 2;
            if (this.symbols == null) {
                this.symbols = new long[minCapacity < 32 ? 32 : minCapacity];
            } else if (this.symbols.length < minCapacity) {
                this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
            }
            this.symbols[symbol * 2] = hashCode;
            this.symbols[symbol * 2 + 1] = strInfo;
        }
        return hashCode;
    }

    @Override
    public boolean isInt() {
        byte type = this.bytes[this.offset];
        return type >= -70 && type <= 72 || type == -84 || type == -83 || type == -85;
    }

    @Override
    public boolean isNull() {
        return this.bytes[this.offset] == -81;
    }

    @Override
    public Date readNullOrNewDate() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public void readNull() {
        this.type = this.bytes[this.offset++];
        if (this.type != -81) {
            throw new JSONException("null not match, " + this.type);
        }
    }

    @Override
    public boolean readIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public long readTypeHashCode() {
        int symbol;
        byte c1;
        byte c0;
        long hashCode;
        this.strtype = this.bytes[this.offset];
        if (this.strtype >= -16 && this.strtype <= 72) {
            long refTypeHash;
            int typeIndex;
            if (this.strtype >= -16 && this.strtype <= 47) {
                ++this.offset;
                typeIndex = this.strtype;
            } else {
                if (this.strtype >= 48 && this.strtype <= 63) {
                    ++this.offset;
                    return (this.strtype - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
                }
                typeIndex = this.readInt32Value();
            }
            if (typeIndex == 0) {
                this.strtype = this.symbol0StrType;
                this.strlen = this.symbol0Length;
                this.strBegin = this.symbol0Begin;
                if (this.symbol0Hash == 0L) {
                    this.symbol0Hash = Fnv.hashCode64(this.getString());
                }
                refTypeHash = this.symbol0Hash;
            } else if (typeIndex < 0) {
                this.strlen = this.strtype;
                refTypeHash = this.symbolTable.getHashCode(-typeIndex);
            } else {
                refTypeHash = this.symbols[typeIndex * 2];
                if (refTypeHash == 0L) {
                    long strInfo = this.symbols[typeIndex * 2 + 1];
                    this.strtype = (byte)strInfo;
                    this.strlen = (int)strInfo >> 8;
                    this.strBegin = (int)(strInfo >> 32);
                    refTypeHash = Fnv.hashCode64(this.getString());
                }
            }
            if (refTypeHash == -1L) {
                throw new JSONException("type ref not found : " + typeIndex);
            }
            return refTypeHash;
        }
        ++this.offset;
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            int strType = this.bytes[this.offset];
            if (strType >= -16 && strType <= 47) {
                ++this.offset;
                this.strlen = strType;
            } else if (strType >= 48 && strType <= 63) {
                ++this.offset;
                this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            } else {
                this.strlen = this.readLength();
            }
            this.strBegin = this.offset;
        } else {
            throw new JSONException("string value not support input " + JSONB.typeName(this.type) + " offset " + this.offset + "/" + this.bytes.length);
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (this.strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                int c = this.bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[this.offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[this.offset + 1];
                            byte c3 = this.bytes[this.offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 123 || this.strtype == 125) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                c0 = this.bytes[this.offset + i];
                c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 124) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                c0 = this.bytes[this.offset + i];
                c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            int i;
            long nameValue = 0L;
            if (JSONFactory.MIXED_HASH_ALGORITHM && this.strlen <= 8) {
                int start = this.offset;
                for (i = 0; i < this.strlen; ++i) {
                    byte c = this.bytes[this.offset];
                    if (c < 0 || c == 0 && this.bytes[start] == 0) {
                        nameValue = 0L;
                        this.offset = start;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++this.offset;
                }
            }
            if (nameValue != 0L) {
                hashCode = nameValue;
            } else {
                hashCode = -3750763034362895579L;
                for (i = 0; i < this.strlen; ++i) {
                    byte c = this.bytes[this.offset++];
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
            }
        }
        this.type = this.bytes[this.offset];
        if (this.type >= -16 && this.type <= 47) {
            symbol = this.type;
            ++this.offset;
        } else {
            symbol = this.readInt32Value();
        }
        if (symbol == 0) {
            this.symbol0Begin = this.strBegin;
            this.symbol0Length = this.strlen;
            this.symbol0StrType = this.strtype;
            this.symbol0Hash = hashCode;
        } else {
            long strInfo;
            int minCapacity = symbol * 2 + 2;
            if (this.symbols == null) {
                this.symbols = new long[minCapacity < 32 ? 32 : minCapacity];
            } else if (this.symbols.length < minCapacity) {
                this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
            }
            this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
        }
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        long hashCode;
        this.strtype = this.bytes[this.offset];
        ++this.offset;
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else if (this.strtype == 127) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            throw new JSONException("string value not support input " + JSONB.typeName(this.type) + " offset " + this.offset + "/" + this.bytes.length);
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (this.strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                int c = this.bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[this.offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[this.offset + 1];
                            byte c3 = this.bytes[this.offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 123) {
            hashCode = -3750763034362895579L;
            if (this.bytes[this.offset] == -2 && this.bytes[this.offset + 1] == -1) {
                if (JSONFactory.MIXED_HASH_ALGORITHM && this.strlen <= 16) {
                    long nameValue = 0L;
                    block45: for (int i = 2; i < this.strlen; i += 2) {
                        byte c1 = this.bytes[this.offset + i + 1];
                        byte c0 = this.bytes[this.offset + i];
                        char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                        if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                            nameValue = 0L;
                            break;
                        }
                        byte c = (byte)ch;
                        switch (i - 2 >> 1) {
                            case 0: {
                                nameValue = c;
                                continue block45;
                            }
                            case 1: {
                                nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                                continue block45;
                            }
                            case 2: {
                                nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                                continue block45;
                            }
                            case 3: {
                                nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                                continue block45;
                            }
                            case 4: {
                                nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                                continue block45;
                            }
                            case 5: {
                                nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                                continue block45;
                            }
                            case 6: {
                                nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                                continue block45;
                            }
                            case 7: {
                                nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                                continue block45;
                            }
                        }
                    }
                    if (nameValue != 0L) {
                        return nameValue;
                    }
                }
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else if (this.bytes[this.offset] == -1 && this.bytes[this.offset + 1] == -2) {
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c1 = this.bytes[this.offset + i];
                    byte c0 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else {
                for (int i = 0; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            }
        } else if (this.strtype == 125) {
            if (JSONFactory.MIXED_HASH_ALGORITHM && this.strlen <= 16) {
                long nameValue = 0L;
                block49: for (int i = 0; i < this.strlen; i += 2) {
                    byte c1 = this.bytes[this.offset + i + 1];
                    byte c0 = this.bytes[this.offset + i];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                        nameValue = 0L;
                        break;
                    }
                    byte c = (byte)ch;
                    switch (i >> 1) {
                        case 0: {
                            nameValue = c;
                            continue block49;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            continue block49;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            continue block49;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            continue block49;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            continue block49;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            continue block49;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            continue block49;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            continue block49;
                        }
                    }
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = this.bytes[this.offset + i];
                byte c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 124) {
            if (JSONFactory.MIXED_HASH_ALGORITHM && this.strlen <= 16) {
                long nameValue = 0L;
                block51: for (int i = 0; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                    if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                        nameValue = 0L;
                        break;
                    }
                    byte c = (byte)ch;
                    switch (i >> 1) {
                        case 0: {
                            nameValue = c;
                            continue block51;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            continue block51;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            continue block51;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            continue block51;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            continue block51;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            continue block51;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            continue block51;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            continue block51;
                        }
                    }
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = this.bytes[this.offset + i];
                byte c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            if (JSONFactory.MIXED_HASH_ALGORITHM && this.strlen <= 8) {
                long nameValue = 0L;
                int start = this.offset;
                for (int i = 0; i < this.strlen; ++i) {
                    byte c = this.bytes[this.offset];
                    if (c < 0 || c == 0 && this.bytes[start] == 0) {
                        nameValue = 0L;
                        this.offset = start;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++this.offset;
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; ++i) {
                byte c = this.bytes[this.offset++];
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        }
        return hashCode;
    }

    protected long getNameHashCode() {
        byte c;
        int i;
        int offset = this.strBegin;
        if (JSONFactory.MIXED_HASH_ALGORITHM) {
            long nameValue = 0L;
            i = 0;
            while (i < this.strlen) {
                c = this.bytes[offset];
                if (c < 0 || i >= 8 || i == 0 && this.bytes[this.strBegin] == 0) {
                    offset = this.strBegin;
                    nameValue = 0L;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++i;
                ++offset;
            }
            if (nameValue != 0L) {
                return nameValue;
            }
        }
        long hashCode = -3750763034362895579L;
        for (i = 0; i < this.strlen; ++i) {
            c = this.bytes[offset++];
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        byte c;
        int i;
        int offset = this.strBegin;
        if (JSONFactory.MIXED_HASH_ALGORITHM) {
            long nameValue = 0L;
            i = 0;
            while (i < this.strlen) {
                byte c1;
                c = this.bytes[offset];
                if (c < 0 || i >= 8 || i == 0 && this.bytes[this.strBegin] == 0) {
                    offset = this.strBegin;
                    nameValue = 0L;
                    break;
                }
                if (c != 95 && c != 45 || (c1 = this.bytes[offset + 1]) == c) {
                    if (c >= 65 && c <= 90) {
                        c = (byte)(c + 32);
                    }
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++i;
                }
                ++offset;
            }
            if (nameValue != 0L) {
                return nameValue;
            }
        }
        long hashCode = -3750763034362895579L;
        for (i = 0; i < this.strlen; ++i) {
            if ((c = this.bytes[offset++]) >= 65 && c <= 90) {
                c = (byte)(c + 32);
            }
            if (c == 95 || c == 45) continue;
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public void skipValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -108: 
            case -81: 
            case -80: 
            case -79: 
            case 73: {
                return;
            }
            case -67: {
                ++this.offset;
                return;
            }
            case -68: {
                this.offset += 2;
                return;
            }
            case -84: 
            case -83: 
            case -73: 
            case 72: {
                this.offset += 4;
                return;
            }
            case -74: {
                this.readInt32Value();
                return;
            }
            case -85: 
            case -75: 
            case -66: {
                this.offset += 8;
                return;
            }
            case -76: {
                this.readInt64Value();
                return;
            }
            case -71: {
                this.readInt32Value();
                this.readBigInteger();
                return;
            }
            case -72: {
                this.readInt64Value();
                return;
            }
            case -89: {
                this.offset += 3;
                this.readInt32Value();
                return;
            }
            case -88: {
                this.offset += 7;
                this.readInt32Value();
                return;
            }
            case -86: {
                this.offset += 7;
                this.readInt32Value();
                this.readString();
                return;
            }
            case -111: {
                int byteslen = this.readInt32Value();
                this.offset += byteslen;
                return;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                int strlen = this.readInt32Value();
                this.offset += strlen;
                return;
            }
            case -110: {
                this.readTypeHashCode();
                this.skipValue();
                return;
            }
            case -90: {
                int i = 0;
                while (true) {
                    if (this.bytes[this.offset] == -91) {
                        ++this.offset;
                        break;
                    }
                    this.skipName();
                    this.skipValue();
                    ++i;
                }
                return;
            }
            case -109: {
                if (this.isString()) {
                    this.skipName();
                    return;
                }
                throw new JSONException("skip not support type " + JSONB.typeName(type));
            }
        }
        if (type >= -16 && type <= 47) {
            return;
        }
        if (type >= -40 && type <= -17) {
            return;
        }
        if (type >= 48 && type <= 63) {
            ++this.offset;
            return;
        }
        if (type >= 73 && type <= 120) {
            this.offset += type - 73;
            return;
        }
        if (type >= -40 && type <= -17) {
            return;
        }
        if (type >= -56 && type <= -41) {
            ++this.offset;
            return;
        }
        if (type >= -108 && type <= -92) {
            int itemCnt = type == -92 ? this.readInt32Value() : type - -108;
            for (int i = 0; i < itemCnt; ++i) {
                this.skipValue();
            }
            return;
        }
        throw new JSONException("skip not support type " + JSONB.typeName(type));
    }

    @Override
    public boolean skipName() {
        this.strtype = this.bytes[this.offset++];
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.offset += this.strtype - 73;
            return true;
        }
        if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.offset += this.strlen;
            return true;
        }
        if (this.strtype >= 73 && this.strtype <= 125) {
            return true;
        }
        if (this.strtype == 127) {
            byte type = this.bytes[this.offset];
            if (type >= -16 && type <= 72) {
                this.readInt32Value();
                return true;
            }
            String str = this.readString();
            this.readInt32Value();
            return true;
        }
        throw new JSONException("name not support input : " + JSONB.typeName(this.strtype));
    }

    @Override
    public String readFieldName() {
        boolean typeSymbol;
        this.strtype = this.bytes[this.offset];
        if (this.strtype == -81) {
            ++this.offset;
            return null;
        }
        ++this.offset;
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            this.strtype = this.bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol = this.readInt32Value();
                if (symbol < 0) {
                    return this.symbolTable.getName(-symbol);
                }
                if (symbol == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    return this.getString();
                }
                int index = symbol * 2 + 1;
                long strInfo = this.symbols[index];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                return this.getString();
            }
            ++this.offset;
        }
        this.strBegin = this.offset;
        Charset charset = null;
        String str = null;
        if (this.strtype >= 73 && this.strtype <= 121) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            if (this.strtype == 121) {
                this.strlen = this.readLength();
                this.strBegin = this.offset;
            } else {
                this.strlen = this.strtype - 73;
                switch (this.strlen) {
                    case 1: {
                        nameValue0 = this.bytes[this.offset];
                        break;
                    }
                    case 2: {
                        nameValue0 = (long)(this.bytes[this.offset + 1] << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 3: {
                        nameValue0 = (long)(this.bytes[this.offset + 2] << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 4: {
                        nameValue0 = (long)(this.bytes[this.offset + 3] << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 5: {
                        nameValue0 = ((long)this.bytes[this.offset + 4] << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 6: {
                        nameValue0 = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 0] & 0xFFL);
                        break;
                    }
                    case 7: {
                        nameValue0 = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 8: {
                        nameValue0 = ((long)this.bytes[this.offset + 7] << 56) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        break;
                    }
                    case 9: {
                        nameValue0 = this.bytes[this.offset + 0];
                        nameValue1 = ((long)this.bytes[this.offset + 8] << 56) + (long)(this.bytes[this.offset + 7] << 48) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 1] & 0xFFL);
                        break;
                    }
                    case 10: {
                        nameValue0 = (long)(this.bytes[this.offset + 1] << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        nameValue1 = ((long)this.bytes[this.offset + 9] << 56) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 2] & 0xFFL);
                        break;
                    }
                    case 11: {
                        nameValue0 = (long)(this.bytes[this.offset + 2] << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        nameValue1 = ((long)this.bytes[this.offset + 10] << 56) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 3] & 0xFFL);
                        break;
                    }
                    case 12: {
                        nameValue0 = (long)(this.bytes[this.offset + 3] << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        nameValue1 = ((long)this.bytes[this.offset + 11] << 56) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 4] & 0xFFL);
                        break;
                    }
                    case 13: {
                        nameValue0 = ((long)this.bytes[this.offset + 4] << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        nameValue1 = ((long)this.bytes[this.offset + 12] << 56) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 5] & 0xFFL);
                        break;
                    }
                    case 14: {
                        nameValue0 = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        nameValue1 = ((long)this.bytes[this.offset + 13] << 56) + (((long)this.bytes[this.offset + 12] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 6] & 0xFFL);
                        break;
                    }
                    case 15: {
                        nameValue0 = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        nameValue1 = ((long)this.bytes[this.offset + 14] << 56) + (((long)this.bytes[this.offset + 13] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 12] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 7] & 0xFFL);
                        break;
                    }
                    case 16: {
                        nameValue0 = ((long)this.bytes[this.offset + 7] << 56) + (long)(this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                        nameValue1 = ((long)this.bytes[this.offset + 15] << 56) + (((long)this.bytes[this.offset + 14] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 13] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 12] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 8] & 0xFFL);
                        break;
                    }
                }
            }
            if (nameValue0 != -1L) {
                int i;
                char[] chars;
                Object entry;
                int indexMask;
                if (nameValue1 != -1L) {
                    indexMask = (int)nameValue1 & JSONFactory.NAME_CACHE2.length - 1;
                    entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                            chars = new char[this.strlen];
                            for (i = 0; i < this.strlen; ++i) {
                                chars[i] = (char)this.bytes[this.offset + i];
                            }
                            str = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                        } else {
                            str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
                        }
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(str, nameValue0, nameValue1);
                        this.offset += this.strlen;
                    } else if (((JSONFactory.NameCacheEntry2)entry).value0 == nameValue0 && ((JSONFactory.NameCacheEntry2)entry).value1 == nameValue1) {
                        this.offset += this.strlen;
                        str = ((JSONFactory.NameCacheEntry2)entry).name;
                    }
                } else {
                    indexMask = (int)nameValue0 & JSONFactory.NAME_CACHE.length - 1;
                    entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                            chars = new char[this.strlen];
                            for (i = 0; i < this.strlen; ++i) {
                                chars[i] = (char)this.bytes[this.offset + i];
                            }
                            str = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                        } else {
                            str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
                        }
                        JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(str, nameValue0);
                        this.offset += this.strlen;
                    } else if (((JSONFactory.NameCacheEntry)entry).value == nameValue0) {
                        this.offset += this.strlen;
                        str = ((JSONFactory.NameCacheEntry)entry).name;
                    }
                }
            }
            if (str == null) {
                if (JDKUtils.STRING_CREATOR_JDK8 != null && this.strlen >= 0) {
                    char[] chars = new char[this.strlen];
                    for (int i = 0; i < this.strlen; ++i) {
                        chars[i] = (char)this.bytes[this.offset + i];
                    }
                    this.offset += this.strlen;
                    str = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                } else if (JDKUtils.STRING_CREATOR_JDK11 != null && this.strlen >= 0) {
                    byte[] chars = new byte[this.strlen];
                    System.arraycopy(this.bytes, this.offset, chars, 0, this.strlen);
                    str = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.LATIN1);
                    this.offset += this.strlen;
                }
            }
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype == 122) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            if (JDKUtils.STRING_CREATOR_JDK11 != null && !JDKUtils.BIG_ENDIAN) {
                if (this.valueBytes == null) {
                    this.valueBytes = JSONFactory.allocateByteArray(this.cachedIndex);
                }
                int minCapacity = this.strlen << 1;
                if (this.valueBytes == null) {
                    this.valueBytes = new byte[minCapacity];
                } else if (minCapacity > this.valueBytes.length) {
                    this.valueBytes = new byte[minCapacity];
                }
                int utf16_len = IOUtils.decodeUTF8(this.bytes, this.offset, this.strlen, this.valueBytes);
                if (utf16_len != -1) {
                    byte[] value = new byte[utf16_len];
                    System.arraycopy(this.valueBytes, 0, value, 0, utf16_len);
                    str = JDKUtils.STRING_CREATOR_JDK11.apply(value, JDKUtils.UTF16);
                    this.offset += this.strlen;
                }
            }
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            if (JDKUtils.STRING_CREATOR_JDK11 != null && !JDKUtils.BIG_ENDIAN) {
                byte[] chars = new byte[this.strlen];
                System.arraycopy(this.bytes, this.offset, chars, 0, this.strlen);
                str = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.UTF16);
                this.offset += this.strlen;
            }
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            if (JDKUtils.STRING_CREATOR_JDK11 != null && JDKUtils.BIG_ENDIAN) {
                byte[] chars = new byte[this.strlen];
                System.arraycopy(this.bytes, this.offset, chars, 0, this.strlen);
                str = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.UTF16);
                this.offset += this.strlen;
            }
            charset = StandardCharsets.UTF_16BE;
        }
        if (this.strlen < 0) {
            str = this.symbolTable.getName(-this.strlen);
        }
        if (str == null) {
            str = new String(this.bytes, this.offset, this.strlen, charset);
            this.offset += this.strlen;
        }
        if (typeSymbol) {
            int symbol = this.readInt32Value();
            if (symbol == 0) {
                this.symbol0Begin = this.strBegin;
                this.symbol0Length = this.strlen;
                this.symbol0StrType = this.strtype;
            } else {
                long strInfo;
                int symbolIndex;
                int minCapacity = symbolIndex = symbol * 2 + 2;
                if (this.symbols == null) {
                    this.symbols = new long[minCapacity < 32 ? 32 : minCapacity];
                } else if (this.symbols.length < minCapacity) {
                    this.symbols = Arrays.copyOf(this.symbols, this.symbols.length + 16);
                }
                this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
            }
        }
        return str;
    }

    @Override
    public String getFieldName() {
        return this.getString();
    }

    @Override
    public String readString() {
        String str;
        Charset charset;
        int strType;
        this.strtype = this.bytes[this.offset++];
        if (this.strtype == -81) {
            return null;
        }
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 121) {
            if (this.strtype == 121) {
                strType = this.bytes[this.offset];
                if (strType >= -16 && strType <= 47) {
                    ++this.offset;
                    this.strlen = strType;
                } else if (strType >= 48 && strType <= 63) {
                    ++this.offset;
                    this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
                } else {
                    this.strlen = this.readLength();
                }
                this.strBegin = this.offset;
            } else {
                this.strlen = this.strtype - 73;
            }
            if (this.strlen >= 0) {
                if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                    char[] chars = new char[this.strlen];
                    for (int i = 0; i < this.strlen; ++i) {
                        chars[i] = (char)this.bytes[this.offset + i];
                    }
                    this.offset += this.strlen;
                    String str2 = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                    if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                        str2 = str2.trim();
                    }
                    return str2;
                }
                if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                    byte[] chars = new byte[this.strlen];
                    System.arraycopy(this.bytes, this.offset, chars, 0, this.strlen);
                    String str3 = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.LATIN1);
                    this.offset += this.strlen;
                    if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                        str3 = str3.trim();
                    }
                    return str3;
                }
            }
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype == 122) {
            strType = this.bytes[this.offset];
            if (strType >= -16 && strType <= 47) {
                ++this.offset;
                this.strlen = strType;
            } else if (strType >= 48 && strType <= 63) {
                ++this.offset;
                this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            } else {
                this.strlen = this.readLength();
            }
            this.strBegin = this.offset;
            if (JDKUtils.STRING_CREATOR_JDK11 != null && !JDKUtils.BIG_ENDIAN) {
                if (this.valueBytes == null) {
                    this.valueBytes = JSONFactory.allocateByteArray(this.cachedIndex);
                }
                int minCapacity = this.strlen << 1;
                if (this.valueBytes == null) {
                    this.valueBytes = new byte[minCapacity];
                } else if (minCapacity > this.valueBytes.length) {
                    this.valueBytes = new byte[minCapacity];
                }
                int utf16_len = IOUtils.decodeUTF8(this.bytes, this.offset, this.strlen, this.valueBytes);
                if (utf16_len != -1) {
                    byte[] value = new byte[utf16_len];
                    System.arraycopy(this.valueBytes, 0, value, 0, utf16_len);
                    String str4 = JDKUtils.STRING_CREATOR_JDK11.apply(value, JDKUtils.UTF16);
                    this.offset += this.strlen;
                    if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                        str4 = str4.trim();
                    }
                    return str4;
                }
            }
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            strType = this.bytes[this.offset];
            if (strType >= -16 && strType <= 47) {
                ++this.offset;
                this.strlen = strType;
            } else if (strType >= 48 && strType <= 63) {
                ++this.offset;
                this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            } else {
                this.strlen = this.readLength();
            }
            this.strBegin = this.offset;
            if (this.strlen == 0) {
                return "";
            }
            if (JDKUtils.STRING_CREATOR_JDK11 != null && !JDKUtils.BIG_ENDIAN) {
                byte[] chars = new byte[this.strlen];
                System.arraycopy(this.bytes, this.offset, chars, 0, this.strlen);
                String str5 = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.UTF16);
                this.offset += this.strlen;
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str5 = str5.trim();
                }
                return str5;
            }
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            if (JDKUtils.STRING_CREATOR_JDK11 != null && JDKUtils.BIG_ENDIAN) {
                byte[] chars = new byte[this.strlen];
                System.arraycopy(this.bytes, this.offset, chars, 0, this.strlen);
                String str6 = JDKUtils.STRING_CREATOR_JDK11.apply(chars, JDKUtils.UTF16);
                this.offset += this.strlen;
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str6 = str6.trim();
                }
                return str6;
            }
            charset = StandardCharsets.UTF_16BE;
        } else if (this.strtype == 126) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            if (GB18030 == null) {
                GB18030 = Charset.forName("GB18030");
            }
            charset = GB18030;
        } else {
            if (this.strtype >= -16 && this.strtype <= 47) {
                return Byte.toString(this.strtype);
            }
            if (this.strtype >= 48 && this.strtype <= 63) {
                int intValue = (this.strtype - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            if (this.strtype >= 64 && this.strtype <= 71) {
                int intValue = (this.strtype - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            if (this.strtype >= -40 && this.strtype <= -17) {
                int intValue = -8 + (this.strtype - -40);
                return Integer.toString(intValue);
            }
            if (this.strtype >= -56 && this.strtype <= -41) {
                int intValue = (this.strtype - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            if (this.strtype >= -64 && this.strtype <= -57) {
                int intValue = (this.strtype - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            switch (this.strtype) {
                case -81: {
                    return null;
                }
                case -78: {
                    return "0.0";
                }
                case -77: {
                    return "1.0";
                }
                case -65: 
                case 72: {
                    long int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    return Long.toString(int32Value);
                }
                case -74: {
                    return Float.toString(this.readInt32Value());
                }
                case -73: {
                    int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    float floatValue = Float.intBitsToFloat(int32Value);
                    return Float.toString(floatValue);
                }
                case -75: {
                    long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                    this.offset += 8;
                    double doubleValue = Double.longBitsToDouble(int64Value);
                    return Double.toString(doubleValue);
                }
                case -84: {
                    long int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    return Long.toString(int32Value * 1000L);
                }
                case -83: {
                    long minutes = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    return Long.toString(minutes * 60L * 1000L);
                }
                case -85: 
                case -66: {
                    long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                    this.offset += 8;
                    return Long.toString(int64Value);
                }
                case -69: {
                    int len = this.readInt32Value();
                    byte[] bytes = new byte[len];
                    System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                    this.offset += len;
                    return new BigInteger(bytes).toString();
                }
                case -71: {
                    int scale = this.readInt32Value();
                    BigInteger unscaledValue = this.readBigInteger();
                    BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                    return decimal.toString();
                }
                case -110: {
                    Object typedAny = this.readAny();
                    return typedAny == null ? null : typedAny.toString();
                }
                case -72: 
                case -70: {
                    return Long.toString(this.readInt64Value());
                }
                case -76: {
                    double doubleValue = this.readInt64Value();
                    return Double.toString(doubleValue);
                }
            }
            throw new JSONException("readString not support type " + JSONB.typeName(this.strtype) + ", offset " + this.offset + "/" + this.bytes.length);
        }
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        char[] chars = null;
        if (JDKUtils.JVM_VERSION == 8 && this.strtype == 122 && this.strlen < 8192) {
            int cachedIndex = System.identityHashCode(Thread.currentThread()) & 3;
            chars = JSONFactory.allocateCharArray(cachedIndex);
        }
        if (chars != null) {
            int len = IOUtils.decodeUTF8(this.bytes, this.offset, this.strlen, chars);
            str = new String(chars, 0, len);
            JSONFactory.releaseCharArray(this.cachedIndex, chars);
        } else {
            str = new String(this.bytes, this.offset, this.strlen, charset);
        }
        this.offset += this.strlen;
        if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
            str = str.trim();
        }
        return str;
    }

    @Override
    public char readCharValue() {
        byte type = this.bytes[this.offset];
        if (type == -112) {
            ++this.offset;
            return (char)this.readInt32Value();
        }
        if (type >= 73 && type < 120) {
            ++this.offset;
            return (char)this.bytes[this.offset++];
        }
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            this.wasNull = true;
            return '\u0000';
        }
        return str.charAt(0);
    }

    @Override
    public long readInt64Value() {
        byte type;
        this.wasNull = false;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0L;
            }
            case -80: 
            case -78: {
                return 0L;
            }
            case -79: 
            case -77: {
                return 1L;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (long)floatValue;
            }
            case -75: {
                --this.offset;
                return (long)this.readDoubleValue();
            }
            case -74: {
                return (long)((float)this.readInt32Value());
            }
            case -76: {
                return (long)((double)this.readInt64Value());
            }
            case -83: {
                long minutes = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return minutes * 60L * 1000L;
            }
            case -84: {
                long seconds = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return seconds * 1000L;
            }
            case -85: 
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.longValue();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).longValue();
            }
            return new BigDecimal(str).longValue();
        }
        throw new JSONException("readInt64Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    @Override
    public int readInt32Value() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("int value not support input null"));
                }
                this.wasNull = true;
                return 0;
            }
            case -80: 
            case -78: {
                return 0;
            }
            case -79: 
            case -77: {
                return 1;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -76: {
                return (int)this.readInt64Value();
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return (int)int64Value;
            }
            case -74: {
                return (int)((float)this.readInt32Value());
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (int)floatValue;
            }
            case -75: {
                --this.offset;
                return (int)this.readDoubleValue();
            }
            case -84: 
            case -83: 
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return new BigDecimal(str).intValue();
        }
        throw new JSONException("readInt32Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    @Override
    public boolean isBinary() {
        return this.bytes[this.offset] == -111;
    }

    @Override
    public byte[] readBinary() {
        byte type;
        if ((type = this.bytes[this.offset++]) != -111) {
            throw new JSONException("not support input : " + JSONB.typeName(type));
        }
        int len = this.readLength();
        byte[] bytes = new byte[len];
        System.arraycopy(this.bytes, this.offset, bytes, 0, len);
        this.offset += len;
        return bytes;
    }

    @Override
    public Integer readInt32() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        int value = this.readInt32Value();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    @Override
    public Long readInt64() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            this.wasNull = true;
            return null;
        }
        long value = this.readInt64Value();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    protected final String readFixedAsciiString(int strlen) {
        String str;
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            char[] chars = new char[strlen];
            for (int i = 0; i < strlen; ++i) {
                chars[i] = (char)this.bytes[this.offset + i];
            }
            str = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        } else {
            str = new String(this.bytes, this.offset, strlen, StandardCharsets.ISO_8859_1);
        }
        return str;
    }

    @Override
    public float readFloatValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0.0f;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.intBitsToFloat(int32Value);
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return (float)Double.longBitsToDouble(int64Value);
            }
            case -74: {
                return this.readInt32Value();
            }
            case -76: {
                return (float)((double)this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0f;
            }
            case -79: 
            case -77: {
                return 1.0f;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return new BigDecimal(str).intValue();
        }
        throw new JSONException("TODO : " + JSONB.typeName(type));
    }

    @Override
    public double readDoubleValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0.0;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.intBitsToFloat(int32Value);
            }
            case -74: {
                return this.readInt32Value();
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return Double.longBitsToDouble(int64Value);
            }
            case -76: {
                return this.readInt64Value();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return new BigDecimal(str).intValue();
        }
        throw new JSONException("TODO : " + JSONB.typeName(type));
    }

    @Override
    protected void readNumber0() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public Number readNumber() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return (int)type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return (short)int16Value;
            }
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -65: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return (long)int32Value;
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return Double.longBitsToDouble(int64Value);
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                if (scale == 0) {
                    return new BigDecimal(unscaledValue);
                }
                return new BigDecimal(unscaledValue, scale);
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case -110: {
                String typeName = this.readString();
                throw new JSONException("not support input type : " + typeName);
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            return new BigDecimal(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public BigDecimal readBigDecimal() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigDecimal.ZERO;
            }
            case -79: 
            case -77: {
                return BigDecimal.ONE;
            }
            case -67: {
                return BigDecimal.valueOf(this.bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return BigDecimal.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return BigDecimal.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigDecimal.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigDecimal.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(int64Value);
                return BigDecimal.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return BigDecimal.valueOf(int64Value);
            }
            case -69: {
                return new BigDecimal(this.readBigInteger());
            }
            case -71: {
                int scale = this.readInt32Value();
                if (this.bytes[this.offset] == -70) {
                    ++this.offset;
                    long unscaledLongValue = this.readInt64Value();
                    return BigDecimal.valueOf(unscaledLongValue, scale);
                }
                BigInteger unscaledValue = this.readBigInteger();
                if (scale == 0) {
                    return new BigDecimal(unscaledValue);
                }
                return new BigDecimal(unscaledValue, scale);
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigDecimal.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return new BigDecimal(str);
            }
        }
        if (type >= -16 && type <= 47) {
            return BigDecimal.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int intValue = (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            return new BigDecimal(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public BigInteger readBigInteger() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigInteger.ZERO;
            }
            case -79: 
            case -77: {
                return BigInteger.ONE;
            }
            case -67: {
                return BigInteger.valueOf(this.bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return BigInteger.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return BigInteger.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigInteger.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigInteger.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(int64Value);
                return BigInteger.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return BigInteger.valueOf(int64Value);
            }
            case -111: 
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.toBigInteger();
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigInteger.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return new BigDecimal(str).toBigInteger();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return new BigDecimal(str).toBigInteger();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return new BigDecimal(str).toBigInteger();
            }
        }
        if (type >= -16 && type <= 47) {
            return BigInteger.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int intValue = (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            return new BigInteger(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public LocalDate readLocalDate() {
        byte type = this.bytes[this.offset];
        if (type == -87) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            return LocalDate.of(year, month, (int)dayOfMonth);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        if (type == 122 || type == 121) {
            this.strtype = type;
            ++this.offset;
            this.strlen = this.readLength();
            switch (this.strlen) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        byte type = this.bytes[this.offset];
        if (type == -88) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 16: {
                    return this.readLocalDateTime16();
                }
                case 17: {
                    return this.readLocalDateTime17();
                }
                case 18: {
                    return this.readLocalDateTime18();
                }
                case 19: {
                    return this.readLocalDateTime19();
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    LocalDateTime ldt = this.readLocalDateTimeX(len);
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.toLocalDateTime();
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected LocalDateTime readLocalDateTime16() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalDateTime readLocalDateTime17() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalTime readLocalTime10() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalTime readLocalTime11() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalDate readLocalDate11() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected ZonedDateTime readZonedDateTimeX(int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void skipLineComment() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public LocalTime readLocalTime() {
        byte type = this.bytes[this.offset];
        if (type == -89) {
            ++this.offset;
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalTime.of(hour, minute, second, nano);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    return this.readLocalTime8();
                }
                case 10: {
                    return this.readLocalTime10();
                }
                case 11: {
                    return this.readLocalTime11();
                }
                case 12: {
                    return this.readLocalTime12();
                }
                case 18: {
                    return this.readLocalTime18();
                }
            }
            throw new JSONException("not support len : " + len);
        }
        if (type == 122 || type == 121) {
            this.strtype = type;
            ++this.offset;
            this.strlen = this.readLength();
            switch (this.strlen) {
                case 8: {
                    return this.readLocalTime8();
                }
                case 10: {
                    return this.readLocalTime10();
                }
                case 11: {
                    return this.readLocalTime11();
                }
                case 12: {
                    return this.readLocalTime12();
                }
                case 18: {
                    return this.readLocalTime18();
                }
            }
            throw new JSONException("not support len : " + this.strlen);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Instant readInstant() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                return Instant.ofEpochSecond(second, nano);
            }
            case -83: {
                long second = this.readInt32Value() * 60;
                return Instant.ofEpochSecond(second, 0L);
            }
            case -84: {
                long second = this.readInt32Value();
                return Instant.ofEpochSecond(second, 0L);
            }
            case -85: 
            case -66: {
                long millis = this.readInt64Value();
                return Instant.ofEpochMilli(millis);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ZonedDateTime readZonedDateTime() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                Instant instant = Instant.ofEpochSecond(second, nano);
                return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
            }
            case -83: {
                long second = this.readInt32Value() * 60;
                Instant instant = Instant.ofEpochSecond(second);
                return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
            }
            case -84: {
                long second = this.readInt32Value();
                Instant instant = Instant.ofEpochSecond(second);
                return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
            }
            case -85: 
            case -66: {
                long millis = this.readInt64Value();
                Instant instant = Instant.ofEpochMilli(millis);
                return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
            }
            case -86: {
                ZoneId zoneId;
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                LocalDateTime ldt = LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
                long zoneIdHash = this.readValueHashCode();
                if (zoneIdHash == SHANGHAI_ZONE_ID_HASH) {
                    zoneId = DateUtils.SHANGHAI_ZONE_ID;
                } else {
                    String zoneIdStr = this.getString();
                    ZoneId contextZondId = this.context.getZoneId();
                    zoneId = contextZondId.getId().equals(zoneIdStr) ? contextZondId : ZoneId.of(zoneIdStr);
                }
                return ZonedDateTime.ofLocal(ldt, zoneId, null);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID readUUID() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -111: {
                int len = this.readLength();
                if (len != 16) {
                    throw new JSONException("uuid not support " + len);
                }
                long msb = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                long lsb = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return new UUID(msb, lsb);
            }
            case 105: {
                long msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0);
                long msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4);
                long msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 8);
                long msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 12);
                long lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 16);
                long lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 20);
                long lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24);
                long lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28);
                if ((msb1 | msb2 | msb3 | msb4 | lsb1 | lsb2 | lsb3 | lsb4) >= 0L) {
                    this.offset += 32;
                    return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                }
                throw new JSONException("Invalid UUID string:  " + new String(this.bytes, this.offset, 32, StandardCharsets.US_ASCII));
            }
            case 109: {
                long lsb4;
                long lsb3;
                long lsb2;
                long lsb1;
                long msb4;
                long msb3;
                long msb2;
                long msb1;
                byte ch1 = this.bytes[this.offset + 8];
                byte ch2 = this.bytes[this.offset + 13];
                byte ch3 = this.bytes[this.offset + 18];
                byte ch4 = this.bytes[this.offset + 23];
                if (ch1 == 45 && ch2 == 45 && ch3 == 45 && ch4 == 45 && ((msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0)) | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 9)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 14)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 19)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 32))) >= 0L) {
                    this.offset += 36;
                    return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                }
                throw new JSONException("Invalid UUID string:  " + new String(this.bytes, this.offset, 36, StandardCharsets.US_ASCII));
            }
            case 121: 
            case 122: {
                int strlen = this.readLength();
                if (strlen == 32) {
                    long lsb4;
                    long lsb3;
                    long lsb2;
                    long lsb1;
                    long msb4;
                    long msb3;
                    long msb2;
                    long msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0);
                    if ((msb1 | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 8)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 12)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 16)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 20)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28))) >= 0L) {
                        this.offset += 32;
                        return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                    }
                } else if (strlen == 36) {
                    long lsb4;
                    long lsb3;
                    long lsb2;
                    long lsb1;
                    long msb4;
                    long msb3;
                    long msb2;
                    long msb1;
                    byte ch1 = this.bytes[this.offset + 8];
                    byte ch2 = this.bytes[this.offset + 13];
                    byte ch3 = this.bytes[this.offset + 18];
                    byte ch4 = this.bytes[this.offset + 23];
                    if (ch1 == 45 && ch2 == 45 && ch3 == 45 && ch4 == 45 && ((msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0)) | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 9)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 14)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 19)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 32))) >= 0L) {
                        this.offset += 36;
                        return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                    }
                }
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                throw new JSONException("Invalid UUID string:  " + str);
            }
        }
        throw new JSONException("type not support : " + JSONB.typeName(type));
    }

    @Override
    public boolean readBoolValue() {
        this.wasNull = false;
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -79: 
            case 1: {
                return true;
            }
            case -80: 
            case 0: {
                return false;
            }
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return false;
            }
            case 74: {
                if (this.bytes[this.offset] == 49 || this.bytes[this.offset] == 89) {
                    ++this.offset;
                    return true;
                }
                if (this.bytes[this.offset] == 48 || this.bytes[this.offset] == 78) {
                    ++this.offset;
                    return false;
                }
            }
            case 77: {
                if (this.bytes[this.offset] == 116 && this.bytes[this.offset + 1] == 114 && this.bytes[this.offset + 2] == 117 && this.bytes[this.offset + 3] == 101) {
                    this.offset += 4;
                    return true;
                }
                if (this.bytes[this.offset] == 84 && this.bytes[this.offset + 1] == 82 && this.bytes[this.offset + 2] == 85 && this.bytes[this.offset + 3] == 69) {
                    this.offset += 4;
                    return true;
                }
            }
            case 78: {
                if (this.bytes[this.offset] == 102 && this.bytes[this.offset + 1] == 97 && this.bytes[this.offset + 2] == 108 && this.bytes[this.offset + 3] == 115 && this.bytes[this.offset + 4] == 101) {
                    this.offset += 5;
                    return false;
                }
                if (this.bytes[this.offset] == 70 && this.bytes[this.offset + 1] == 65 && this.bytes[this.offset + 2] == 76 && this.bytes[this.offset + 3] == 83 && this.bytes[this.offset + 4] == 69) {
                    this.offset += 5;
                    return false;
                }
            }
            case 121: {
                this.strlen = this.readLength();
                if (this.strlen == 1) {
                    if (this.bytes[this.offset] == 89) {
                        ++this.offset;
                        return true;
                    }
                    if (this.bytes[this.offset] == 78) {
                        ++this.offset;
                        return true;
                    }
                } else {
                    if (this.strlen == 4 && this.bytes[this.offset] == 116 && this.bytes[this.offset + 1] == 114 && this.bytes[this.offset + 2] == 117 && this.bytes[this.offset + 3] == 101) {
                        this.offset += 4;
                        return true;
                    }
                    if (this.strlen == 5) {
                        if (this.bytes[this.offset] == 102 && this.bytes[this.offset + 1] == 97 && this.bytes[this.offset + 2] == 108 && this.bytes[this.offset + 3] == 115 && this.bytes[this.offset + 4] == 101) {
                            this.offset += 5;
                            return false;
                        }
                        if (this.bytes[this.offset] == 70 && this.bytes[this.offset + 1] == 65 && this.bytes[this.offset + 2] == 76 && this.bytes[this.offset + 3] == 83 && this.bytes[this.offset + 4] == 69) {
                            this.offset += 5;
                            return false;
                        }
                    }
                }
                String str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
                this.offset += this.strlen;
                throw new JSONException("not support input " + str);
            }
            case 124: {
                this.strlen = this.readLength();
                String str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.UTF_16LE);
                this.offset += this.strlen;
                switch (str) {
                    case "0": 
                    case "N": {
                        return false;
                    }
                    case "1": 
                    case "Y": {
                        return true;
                    }
                }
                throw new JSONException("not support input " + str);
            }
        }
        throw new JSONException("not support type : " + JSONB.typeName(type));
    }

    @Override
    public boolean nextIfMatch(byte type) {
        if (this.bytes[this.offset] == type) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    protected int getStringLength() {
        this.type = this.bytes[this.offset];
        if (this.type >= 73 && this.type < 120) {
            return this.type - 73;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDate readLocalDate8() {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 81) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        if (c4 == 45 && c6 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c5;
            d0 = 48;
            d1 = (char)c7;
        } else {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = c4;
            m1 = (char)c5;
            d0 = c6;
            d1 = (char)c7;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDate ldt = LocalDate.of(year, month, dom);
        this.offset += 9;
        return ldt;
    }

    @Override
    public LocalDate readLocalDate9() {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 82) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        byte c8 = this.bytes[this.offset + 9];
        if (c4 == 45 && c6 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c5;
            d0 = c7;
            d1 = (char)c8;
        } else if (c4 == 45 && c7 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c5;
            m1 = (char)c6;
            d0 = 48;
            d1 = (char)c8;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDate ldt = LocalDate.of(year, month, dom);
        this.offset += 10;
        return ldt;
    }

    @Override
    protected LocalDate readLocalDate10() {
        byte d1;
        byte d0;
        byte m1;
        byte m0;
        byte y3;
        byte y2;
        byte y1;
        byte y0;
        byte c9;
        byte c8;
        byte c7;
        byte c6;
        byte c5;
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        byte c0;
        if (this.bytes[this.offset] == 83) {
            c0 = this.bytes[this.offset + 1];
            c1 = this.bytes[this.offset + 2];
            c2 = this.bytes[this.offset + 3];
            c3 = this.bytes[this.offset + 4];
            c4 = this.bytes[this.offset + 5];
            c5 = this.bytes[this.offset + 6];
            c6 = this.bytes[this.offset + 7];
            c7 = this.bytes[this.offset + 8];
            c8 = this.bytes[this.offset + 9];
            c9 = this.bytes[this.offset + 10];
        } else if ((this.strtype == 122 || this.strtype == 121) && this.strlen == 10) {
            c0 = this.bytes[this.offset + 0];
            c1 = this.bytes[this.offset + 1];
            c2 = this.bytes[this.offset + 2];
            c3 = this.bytes[this.offset + 3];
            c4 = this.bytes[this.offset + 4];
            c5 = this.bytes[this.offset + 5];
            c6 = this.bytes[this.offset + 6];
            c7 = this.bytes[this.offset + 7];
            c8 = this.bytes[this.offset + 8];
            c9 = this.bytes[this.offset + 9];
        } else {
            throw new JSONException("date only support string input");
        }
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        LocalDate ldt = LocalDate.of(year, month, dom);
        this.offset += 11;
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime5() {
        this.type = this.bytes[this.offset];
        if (this.type != 78) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        if (c2 != 58) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        this.offset += 6;
        return LocalTime.of(hour, minute);
    }

    @Override
    protected LocalTime readLocalTime8() {
        this.type = this.bytes[this.offset];
        if (this.type != 81) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        if (c2 != 58 || c5 != 58) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        this.offset += 9;
        return LocalTime.of(hour, minute, seccond);
    }

    @Override
    protected LocalTime readLocalTime12() {
        byte c11;
        byte c10;
        byte c9;
        byte c8;
        byte c7;
        byte c6;
        byte c5;
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        byte c0;
        if (this.bytes[this.offset] == 85) {
            c0 = this.bytes[this.offset + 1];
            c1 = this.bytes[this.offset + 2];
            c2 = this.bytes[this.offset + 3];
            c3 = this.bytes[this.offset + 4];
            c4 = this.bytes[this.offset + 5];
            c5 = this.bytes[this.offset + 6];
            c6 = this.bytes[this.offset + 7];
            c7 = this.bytes[this.offset + 8];
            c8 = this.bytes[this.offset + 9];
            c9 = this.bytes[this.offset + 10];
            c10 = this.bytes[this.offset + 11];
            c11 = this.bytes[this.offset + 12];
        } else if ((this.strtype == 122 || this.strtype == 121) && this.strlen == 12) {
            c0 = this.bytes[this.offset];
            c1 = this.bytes[this.offset + 1];
            c2 = this.bytes[this.offset + 2];
            c3 = this.bytes[this.offset + 3];
            c4 = this.bytes[this.offset + 4];
            c5 = this.bytes[this.offset + 5];
            c6 = this.bytes[this.offset + 6];
            c7 = this.bytes[this.offset + 7];
            c8 = this.bytes[this.offset + 8];
            c9 = this.bytes[this.offset + 9];
            c10 = this.bytes[this.offset + 10];
            c11 = this.bytes[this.offset + 11];
        } else {
            throw new JSONException("date only support string input");
        }
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57 || m2 < 48 || m2 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
        this.offset += 13;
        return LocalTime.of(hour, minute, seccond, millis *= 1000000);
    }

    @Override
    protected LocalTime readLocalTime18() {
        byte c17;
        byte c16;
        byte c15;
        byte c14;
        byte c13;
        byte c12;
        byte c11;
        byte c10;
        byte c9;
        byte c8;
        byte c7;
        byte c6;
        byte c5;
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        byte c0;
        if (this.bytes[this.offset] == 91) {
            c0 = this.bytes[this.offset + 1];
            c1 = this.bytes[this.offset + 2];
            c2 = this.bytes[this.offset + 3];
            c3 = this.bytes[this.offset + 4];
            c4 = this.bytes[this.offset + 5];
            c5 = this.bytes[this.offset + 6];
            c6 = this.bytes[this.offset + 7];
            c7 = this.bytes[this.offset + 8];
            c8 = this.bytes[this.offset + 9];
            c9 = this.bytes[this.offset + 10];
            c10 = this.bytes[this.offset + 11];
            c11 = this.bytes[this.offset + 12];
            c12 = this.bytes[this.offset + 13];
            c13 = this.bytes[this.offset + 14];
            c14 = this.bytes[this.offset + 15];
            c15 = this.bytes[this.offset + 16];
            c16 = this.bytes[this.offset + 17];
            c17 = this.bytes[this.offset + 18];
        } else if ((this.strtype == 122 || this.strtype == 121) && this.strlen == 18) {
            c0 = this.bytes[this.offset];
            c1 = this.bytes[this.offset + 1];
            c2 = this.bytes[this.offset + 2];
            c3 = this.bytes[this.offset + 3];
            c4 = this.bytes[this.offset + 4];
            c5 = this.bytes[this.offset + 5];
            c6 = this.bytes[this.offset + 6];
            c7 = this.bytes[this.offset + 7];
            c8 = this.bytes[this.offset + 8];
            c9 = this.bytes[this.offset + 9];
            c10 = this.bytes[this.offset + 10];
            c11 = this.bytes[this.offset + 11];
            c12 = this.bytes[this.offset + 12];
            c13 = this.bytes[this.offset + 13];
            c14 = this.bytes[this.offset + 14];
            c15 = this.bytes[this.offset + 15];
            c16 = this.bytes[this.offset + 16];
            c17 = this.bytes[this.offset + 17];
        } else {
            throw new JSONException("date only support string input");
        }
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        byte m3 = c12;
        byte m4 = c13;
        byte m5 = c14;
        byte m6 = c15;
        byte m7 = c16;
        byte m8 = c17;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57 || m2 < 48 || m2 > 57 || m3 < 48 || m3 > 57 || m4 < 48 || m4 > 57 || m5 < 48 || m5 > 57 || m6 < 48 || m6 > 57 || m7 < 48 || m7 > 57 || m8 < 48 || m8 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        this.offset += 19;
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalDateTime readLocalDateTime18() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public long readMillis19() {
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 92) {
            throw new JSONException("date only support string input");
        }
        char c0 = (char)this.bytes[this.offset + 1];
        char c1 = (char)this.bytes[this.offset + 2];
        char c2 = (char)this.bytes[this.offset + 3];
        char c3 = (char)this.bytes[this.offset + 4];
        char c4 = (char)this.bytes[this.offset + 5];
        char c5 = (char)this.bytes[this.offset + 6];
        char c6 = (char)this.bytes[this.offset + 7];
        char c7 = (char)this.bytes[this.offset + 8];
        char c8 = (char)this.bytes[this.offset + 9];
        char c9 = (char)this.bytes[this.offset + 10];
        char c10 = (char)this.bytes[this.offset + 11];
        char c11 = (char)this.bytes[this.offset + 12];
        char c12 = (char)this.bytes[this.offset + 13];
        char c13 = (char)this.bytes[this.offset + 14];
        char c14 = (char)this.bytes[this.offset + 15];
        char c15 = (char)this.bytes[this.offset + 16];
        char c16 = (char)this.bytes[this.offset + 17];
        char c17 = (char)this.bytes[this.offset + 18];
        char c18 = (char)this.bytes[this.offset + 19];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            this.wasNull = true;
            return 0L;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < 48 || S0 > 57 || S1 < 48 || S1 > 57 || S2 < 48 || S2 > 57) {
            this.wasNull = true;
            return 0L;
        }
        int nanoOfSecond = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
        this.offset += 20;
        return DateUtils.millis(this.context.getZoneId(), year, month, dom, hour, minute, second, nanoOfSecond *= 1000000);
    }

    @Override
    protected LocalDateTime readLocalDateTime19() {
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 92) {
            throw new JSONException("date only support string input");
        }
        char c0 = (char)this.bytes[this.offset + 1];
        char c1 = (char)this.bytes[this.offset + 2];
        char c2 = (char)this.bytes[this.offset + 3];
        char c3 = (char)this.bytes[this.offset + 4];
        char c4 = (char)this.bytes[this.offset + 5];
        char c5 = (char)this.bytes[this.offset + 6];
        char c6 = (char)this.bytes[this.offset + 7];
        char c7 = (char)this.bytes[this.offset + 8];
        char c8 = (char)this.bytes[this.offset + 9];
        char c9 = (char)this.bytes[this.offset + 10];
        char c10 = (char)this.bytes[this.offset + 11];
        char c11 = (char)this.bytes[this.offset + 12];
        char c12 = (char)this.bytes[this.offset + 13];
        char c13 = (char)this.bytes[this.offset + 14];
        char c14 = (char)this.bytes[this.offset + 15];
        char c15 = (char)this.bytes[this.offset + 16];
        char c16 = (char)this.bytes[this.offset + 17];
        char c17 = (char)this.bytes[this.offset + 18];
        char c18 = (char)this.bytes[this.offset + 19];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < 48 || S0 > 57 || S1 < 48 || S1 > 57 || S2 < 48 || S2 > 57) {
            return null;
        }
        int millis = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, millis *= 1000000);
        this.offset += 20;
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTimeX(int len) {
        byte c20;
        this.type = this.bytes[this.offset];
        if (this.type < 73 || this.type > 120) {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29) {
            throw new JSONException("illeal localdatetime string : " + this.readString());
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        byte c8 = this.bytes[this.offset + 9];
        byte c9 = this.bytes[this.offset + 10];
        byte c10 = this.bytes[this.offset + 11];
        byte c11 = this.bytes[this.offset + 12];
        byte c12 = this.bytes[this.offset + 13];
        byte c13 = this.bytes[this.offset + 14];
        byte c14 = this.bytes[this.offset + 15];
        byte c15 = this.bytes[this.offset + 16];
        byte c16 = this.bytes[this.offset + 17];
        byte c17 = this.bytes[this.offset + 18];
        byte c18 = this.bytes[this.offset + 19];
        byte c19 = this.bytes[this.offset + 20];
        int c21 = 48;
        int c22 = 48;
        int c23 = 48;
        int c24 = 48;
        int c25 = 48;
        int c26 = 48;
        int c27 = 48;
        int c28 = 48;
        switch (len) {
            case 21: {
                c20 = this.bytes[this.offset + 21];
                break;
            }
            case 22: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                break;
            }
            case 23: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                break;
            }
            case 24: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                break;
            }
            case 25: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                break;
            }
            case 26: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                break;
            }
            case 27: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                c26 = this.bytes[this.offset + 27];
                break;
            }
            case 28: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                c26 = this.bytes[this.offset + 27];
                c27 = this.bytes[this.offset + 28];
                break;
            }
            default: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                c26 = this.bytes[this.offset + 27];
                c27 = this.bytes[this.offset + 28];
                c28 = this.bytes[this.offset + 29];
            }
        }
        if (c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46) {
            return null;
        }
        char y0 = (char)c0;
        char y1 = (char)c1;
        char y2 = (char)c2;
        char y3 = (char)c3;
        char m0 = (char)c5;
        char m1 = (char)c6;
        char d0 = (char)c8;
        char d1 = (char)c9;
        char h0 = (char)c11;
        char h1 = (char)c12;
        char i0 = (char)c14;
        char i1 = (char)c15;
        char s0 = (char)c17;
        char s1 = (char)c18;
        char S0 = (char)c20;
        char S1 = (char)c21;
        char S2 = (char)c22;
        char S3 = (char)c23;
        char S4 = (char)c24;
        char S5 = (char)c25;
        char S6 = (char)c26;
        char S7 = (char)c27;
        char S8 = (char)c28;
        LocalDateTime ldt = DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        return ldt;
    }

    @Override
    public String readPattern() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        return this.readFieldNameHashCode();
    }

    @Override
    public boolean nextIfSet() {
        return false;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public JSONReader.SavePoint mark() {
        return new JSONReader.SavePoint(this.offset, this.type);
    }

    @Override
    public void reset(JSONReader.SavePoint savePoint) {
        this.offset = savePoint.offset;
        this.type = (byte)savePoint.current;
    }

    @Override
    public final void close() {
        if (this.valueBytes != null) {
            JSONFactory.releaseByteArray(this.cachedIndex, this.valueBytes);
        }
    }
}

