/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;

final class FieldReaderBoolValueField<T>
extends FieldReaderObjectField<T> {
    FieldReaderBoolValueField(String fieldName, Class fieldType, int ordinal, long features, String format, Boolean defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        boolean fieldValue = jsonReader.readBoolValue();
        if (this.schema != null) {
            this.schema.assertValidate(fieldValue);
        }
        try {
            this.field.setBoolean(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, int value) {
        this.accept(object, TypeUtils.toBooleanValue(value));
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            if ((this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
                return;
            }
            this.accept(object, false);
            return;
        }
        if (value instanceof Boolean) {
            this.accept(object, (Boolean)value);
            return;
        }
        throw new JSONException("set " + this.fieldName + " error, type not support " + value.getClass());
    }

    @Override
    public void accept(T object, boolean value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        if (this.fieldOffset != -1L) {
            UnsafeUtils.putBoolean(object, this.fieldOffset, value);
            return;
        }
        try {
            this.field.setBoolean(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readBool();
    }
}

