/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectCodecProvider;
import com.alibaba.fastjson2.util.AnnotationUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class BeanUtils {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    static ConcurrentMap<Class, Field[]> fieldCache = new ConcurrentHashMap<Class, Field[]>();
    static ConcurrentMap<Class, Map<String, Field>> fieldMapCache = new ConcurrentHashMap<Class, Map<String, Field>>();
    static ConcurrentMap<Class, Field[]> declaredFieldCache = new ConcurrentHashMap<Class, Field[]>();
    static ConcurrentMap<Class, Method[]> methodCache = new ConcurrentHashMap<Class, Method[]>();
    static ConcurrentMap<Class, Constructor[]> constructorCache = new ConcurrentHashMap<Class, Constructor[]>();
    private static volatile Class RECORD_CLASS;
    private static volatile Method RECORD_GET_RECORD_COMPONENTS;
    private static volatile Method RECORD_COMPONENT_GET_NAME;
    private static volatile boolean kotlinClassKlassError;
    private static volatile Constructor<?> kotlinKClassConstructor;
    private static volatile Method kotlinKClassGetConstructors;
    private static volatile Method kotlinKFunctionGetParameters;
    private static volatile Method kotlinKParameterGetName;
    private static volatile boolean kotlinError;

    public static String[] getRecordFieldNames(Class<?> recordType) {
        if (JDKUtils.JVM_VERSION < 14) {
            return new String[0];
        }
        try {
            if (RECORD_GET_RECORD_COMPONENTS == null) {
                RECORD_GET_RECORD_COMPONENTS = Class.class.getMethod("getRecordComponents", new Class[0]);
            }
            if (RECORD_COMPONENT_GET_NAME == null) {
                Class<?> c = Class.forName("java.lang.reflect.RecordComponent");
                RECORD_COMPONENT_GET_NAME = c.getMethod("getName", new Class[0]);
            }
            Object[] components = (Object[])RECORD_GET_RECORD_COMPONENTS.invoke(recordType, new Object[0]);
            String[] names = new String[components.length];
            for (int i = 0; i < components.length; ++i) {
                names[i] = (String)RECORD_COMPONENT_GET_NAME.invoke(components[i], new Object[0]);
            }
            return names;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to access Methods needed to support `java.lang.Record`: (%s) %s", e.getClass().getName(), e.getMessage()), e);
        }
    }

    public static void getKotlinConstructor(Class<?> objectClass, BeanInfo beanInfo) {
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        Constructor creatorConstructor = null;
        String[] paramNames = beanInfo.createParameterNames;
        for (Constructor constructor : constructors) {
            Class<?>[] parameterTypes;
            int parameterCount = constructor.getParameterCount();
            if (paramNames != null && parameterCount != paramNames.length) continue;
            if (parameterCount > 2 && (parameterTypes = constructor.getParameterTypes())[parameterCount - 2] == Integer.TYPE && "kotlin.jvm.internal.DefaultConstructorMarker".equals(parameterTypes[parameterCount - 1].getName())) {
                beanInfo.markerConstructor = constructor;
                continue;
            }
            if (creatorConstructor != null && creatorConstructor.getParameterCount() >= parameterCount) continue;
            creatorConstructor = constructor;
        }
        beanInfo.creatorConstructor = creatorConstructor;
    }

    public static String[] getKotlinConstructorParameters(Class<?> clazz) {
        Class<?> classKotlinKClass;
        if (kotlinKClassConstructor == null && !kotlinClassKlassError) {
            try {
                classKotlinKClass = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlinKClassConstructor = classKotlinKClass.getConstructor(Class.class);
            }
            catch (Throwable e) {
                kotlinClassKlassError = true;
            }
        }
        if (kotlinKClassConstructor == null) {
            return null;
        }
        if (kotlinKClassGetConstructors == null && !kotlinClassKlassError) {
            try {
                classKotlinKClass = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlinKClassGetConstructors = classKotlinKClass.getMethod("getConstructors", new Class[0]);
            }
            catch (Throwable e) {
                kotlinClassKlassError = true;
            }
        }
        if (kotlinKFunctionGetParameters == null && !kotlinClassKlassError) {
            try {
                Class<?> classKotlinKFunction = Class.forName("kotlin.reflect.KFunction");
                kotlinKFunctionGetParameters = classKotlinKFunction.getMethod("getParameters", new Class[0]);
            }
            catch (Throwable e) {
                kotlinClassKlassError = true;
            }
        }
        if (kotlinKParameterGetName == null && !kotlinClassKlassError) {
            try {
                Class<?> classKotlinKParameter = Class.forName("kotlin.reflect.KParameter");
                kotlinKParameterGetName = classKotlinKParameter.getMethod("getName", new Class[0]);
            }
            catch (Throwable e) {
                kotlinClassKlassError = true;
            }
        }
        if (kotlinError) {
            return null;
        }
        try {
            Object constructor = null;
            Object classImpl = kotlinKClassConstructor.newInstance(clazz);
            Iterable it = (Iterable)kotlinKClassGetConstructors.invoke(classImpl, new Object[0]);
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                List parameters = (List)kotlinKFunctionGetParameters.invoke(item, new Object[0]);
                if (constructor == null || parameters.size() != 0) {
                    constructor = item;
                }
                iterator.hasNext();
            }
            if (constructor == null) {
                return null;
            }
            List parameters = (List)kotlinKFunctionGetParameters.invoke(constructor, new Object[0]);
            String[] names = new String[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                Object param = parameters.get(i);
                names[i] = (String)kotlinKParameterGetName.invoke(param, new Object[0]);
            }
            return names;
        }
        catch (Throwable ignored) {
            kotlinError = true;
            return null;
        }
    }

    public static void fields(Class objectClass, Consumer<Field> fieldReaders) {
        if (TypeUtils.isProxy(objectClass)) {
            Class superclass = objectClass.getSuperclass();
            BeanUtils.fields(superclass, fieldReaders);
            return;
        }
        Field[] fields = (Field[])fieldCache.get(objectClass);
        if (fields == null) {
            fields = objectClass.getFields();
            fieldCache.putIfAbsent(objectClass, fields);
        }
        boolean enumClass = Enum.class.isAssignableFrom(objectClass);
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) && !enumClass) continue;
            fieldReaders.accept(field);
        }
    }

    public static Method getMethod(Class objectClass, String methodName) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Field getDeclaredField(Class objectClass, String fieldName) {
        Map fieldMap = (Map)fieldMapCache.get(objectClass);
        if (fieldMap == null) {
            HashMap map = new HashMap();
            BeanUtils.declaredFields(objectClass, field -> map.put(field.getName(), field));
            fieldMapCache.putIfAbsent(objectClass, map);
            fieldMap = (Map)fieldMapCache.get(objectClass);
        }
        return (Field)fieldMap.get(fieldName);
    }

    public static void declaredFields(Class objectClass, Consumer<Field> fieldConsumer) {
        Field[] fields;
        if (TypeUtils.isProxy(objectClass)) {
            Class superclass = objectClass.getSuperclass();
            BeanUtils.declaredFields(superclass, fieldConsumer);
            return;
        }
        Class superClass = objectClass.getSuperclass();
        boolean protobufMessageV3 = false;
        if (superClass != null && superClass != Object.class && !(protobufMessageV3 = superClass.getName().equals("com.google.protobuf.GeneratedMessageV3"))) {
            BeanUtils.declaredFields(superClass, fieldConsumer);
        }
        if ((fields = (Field[])declaredFieldCache.get(objectClass)) == null) {
            Field[] declaredFields = objectClass.getDeclaredFields();
            boolean allMatch = true;
            for (Field field : declaredFields) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                allMatch = false;
                break;
            }
            if (allMatch) {
                fields = declaredFields;
            } else {
                ArrayList<Field> list = new ArrayList<Field>(declaredFields.length);
                for (Field field : declaredFields) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers)) continue;
                    list.add(field);
                }
                fields = list.toArray(new Field[list.size()]);
            }
            fieldCache.putIfAbsent(objectClass, fields);
        }
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if ((modifiers & 8) != 0) continue;
            if (protobufMessageV3) {
                String fieldName = field.getName();
                Class<?> fieldClass = field.getType();
                if ("cardsmap_".equals(fieldName) && fieldClass.getName().equals("com.google.protobuf.MapField")) {
                    return;
                }
            }
            fieldConsumer.accept(field);
        }
    }

    public static void staticMethod(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            methodConsumer.accept(method);
        }
    }

    public static Method buildMethod(Class objectClass, String methodName) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || method.getParameterCount() != 0 || !method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static void constructor(Class objectClass, Consumer<Constructor> constructorConsumer) {
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        for (Constructor constructor : constructors) {
            constructorConsumer.accept(constructor);
        }
    }

    public static Constructor[] getConstructor(Class objectClass) {
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        return constructors;
    }

    public static Constructor getDefaultConstructor(Class objectClass, boolean includeNoneStaticMember) {
        if (objectClass == StackTraceElement.class && JDKUtils.JVM_VERSION >= 9) {
            return null;
        }
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        for (Constructor constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        if (!includeNoneStaticMember) {
            return null;
        }
        Class<?> declaringClass = objectClass.getDeclaringClass();
        if (declaringClass != null) {
            for (Constructor constructor : constructors) {
                Class<?> firstParamType;
                if (constructor.getParameterCount() != 1 || !declaringClass.equals(firstParamType = constructor.getParameterTypes()[0])) continue;
                return constructor;
            }
        }
        return null;
    }

    public static void setters(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            String methodName;
            int methodNameLength;
            int mods;
            int paramCount = method.getParameterCount();
            if (paramCount == 0) {
                String methodName2 = method.getName();
                if (methodName2.length() <= 3 || !methodName2.startsWith("get")) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == AtomicInteger.class || returnType == AtomicLong.class || returnType == AtomicBoolean.class || returnType == AtomicIntegerArray.class || returnType == AtomicLongArray.class || returnType == AtomicReference.class || Collection.class.isAssignableFrom(returnType) || Map.class.isAssignableFrom(returnType)) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            if (paramCount == 2 && method.getReturnType() == Void.TYPE && method.getParameterTypes()[0] == String.class) {
                Annotation[] annotations = AnnotationUtils.getAnnotations(method);
                boolean unwrapped = false;
                block8: for (Annotation annotation : annotations) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    JSONField jsonField = AnnotationUtils.findAnnotation(annotation, JSONField.class);
                    if (Objects.nonNull(jsonField)) {
                        if (!jsonField.unwrapped()) continue;
                        unwrapped = true;
                        break;
                    }
                    switch (annotationType.getName()) {
                        case "com.fasterxml.jackson.annotation.JsonAnySetter": 
                        case "com.alibaba.fastjson2.adapter.jackson.annotation.JsonAnySetter": {
                            if (!JSONFactory.isUseJacksonAnnotation()) continue block8;
                            unwrapped = true;
                            continue block8;
                        }
                    }
                }
                if (!unwrapped) continue;
                methodConsumer.accept(method);
                continue;
            }
            if (paramCount != 1 || Modifier.isStatic(mods = method.getModifiers()) || (methodNameLength = (methodName = method.getName()).length()) <= 3 || !methodName.startsWith("set")) continue;
            methodConsumer.accept(method);
        }
    }

    public static void setters(Class objectClass, boolean checkPrefix, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            String methodName;
            int methodNameLength;
            int mods;
            int paramType = method.getParameterCount();
            if (paramType == 0) {
                String methodName2 = method.getName();
                if (methodName2.length() <= 3 || checkPrefix && !methodName2.startsWith("get")) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == AtomicInteger.class || returnType == AtomicLong.class || returnType == AtomicBoolean.class || returnType == AtomicIntegerArray.class || returnType == AtomicLongArray.class || Collection.class.isAssignableFrom(returnType)) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            if (paramType != 1 || Modifier.isStatic(mods = method.getModifiers()) || (methodNameLength = (methodName = method.getName()).length()) <= 3 || checkPrefix && !methodName.startsWith("set")) continue;
            methodConsumer.accept(method);
        }
    }

    public static void annotationMethods(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        block12: for (Method method : methods) {
            if (method.getParameterCount() != 0) continue;
            switch (method.getName()) {
                case "toString": 
                case "hashCode": 
                case "annotationType": 
                case "wait": 
                case "notify": 
                case "notifyAll": 
                case "getClass": {
                    continue block12;
                }
                default: {
                    methodConsumer.accept(method);
                }
            }
        }
    }

    public static boolean isWriteEnumAsJavaBean(Class clazz) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = AnnotationUtils.getAnnotations(clazz)) {
            JSONType jsonType = AnnotationUtils.findAnnotation(annotation, JSONType.class);
            if (jsonType != null) {
                return jsonType.writeEnumAsJavaBean();
            }
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String name = annotationType.getName();
            if (!"com.alibaba.fastjson.annotation.JSONType".equals(name)) continue;
            BeanInfo beanInfo = new BeanInfo();
            BeanUtils.annotationMethods(annotationType, method -> BeanUtils.processJSONType1x(beanInfo, annotation, method));
            if (!beanInfo.writeEnumAsJavaBean) continue;
            return true;
        }
        return false;
    }

    public static String[] getEnumAnnotationNames(Class enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        String[] annotationNames = new String[enumConstants.length];
        BeanUtils.fields(enumClass, field -> {
            String fieldName = field.getName();
            for (int i = 0; i < enumConstants.length; ++i) {
                String annotationName;
                Enum e = enumConstants[i];
                String enumName = e.name();
                if (!fieldName.equals(enumName)) continue;
                JSONField annotation = field.getAnnotation(JSONField.class);
                if (annotation == null || (annotationName = annotation.name()).length() == 0 || annotationName.equals(enumName)) break;
                annotationNames[i] = annotationName;
                break;
            }
        });
        int nulls = 0;
        for (int i = 0; i < annotationNames.length; ++i) {
            if (annotationNames[i] != null) continue;
            ++nulls;
        }
        if (nulls == annotationNames.length) {
            return null;
        }
        return annotationNames;
    }

    public static Member getEnumValueField(Class enumClass, ObjectCodecProvider mixinProvider) {
        if (enumClass == null) {
            return null;
        }
        Class<?>[] interfaces = enumClass.getInterfaces();
        Field member = null;
        Method[] methods = (Method[])methodCache.get(enumClass);
        if (methods == null) {
            methods = enumClass.getMethods();
            methodCache.putIfAbsent(enumClass, methods);
        }
        for (Method method : methods) {
            String methodName;
            Class<?> declaringClass;
            if (method.getReturnType() == Void.class || method.getParameterCount() != 0 || (declaringClass = method.getDeclaringClass()) == Enum.class || declaringClass == Object.class || (methodName = method.getName()).equals("values")) continue;
            if (BeanUtils.isJSONField(AnnotationUtils.getAnnotations(method))) {
                return method;
            }
            if (member != null) continue;
            AtomicReference memberRef = new AtomicReference();
            for (Class<?> enumInterface : interfaces) {
                BeanUtils.getters(enumInterface, e -> {
                    if (e.getName().equals(methodName) && BeanUtils.isJSONField(AnnotationUtils.getAnnotations(e))) {
                        memberRef.set(method);
                    }
                });
                Class mixIn = mixinProvider != null ? mixinProvider.getMixIn(enumInterface) : JSONFactory.getDefaultObjectWriterProvider().getMixIn(enumInterface);
                if (mixIn == null) continue;
                BeanUtils.getters(mixIn, e -> {
                    if (e.getName().equals(methodName) && BeanUtils.isJSONField(AnnotationUtils.getAnnotations(e))) {
                        memberRef.set(method);
                    }
                });
            }
            Member refMember = (Member)memberRef.get();
            if (refMember == null) continue;
            return refMember;
        }
        Field[] fields = (Field[])fieldCache.get(enumClass);
        if (fields == null) {
            fields = enumClass.getFields();
            fieldCache.putIfAbsent(enumClass, fields);
        }
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        for (Field field : fields) {
            Annotation[] annotations;
            boolean found = false;
            if (enumConstants != null) {
                String fieldName = field.getName();
                for (Enum e2 : enumConstants) {
                    if (!fieldName.equals(e2.name())) continue;
                    found = true;
                    break;
                }
            }
            if (!BeanUtils.isJSONField(annotations = AnnotationUtils.getAnnotations(field)) || found) continue;
            member = field;
            break;
        }
        return member;
    }

    private static boolean isJSONField(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            switch (annotationType.getName()) {
                case "com.alibaba.fastjson.annotation.JSONField": 
                case "com.alibaba.fastjson2.annotation.JSONField": {
                    return true;
                }
                case "com.fasterxml.jackson.annotation.JsonValue": 
                case "com.alibaba.fastjson2.adapter.jackson.annotation.JsonValue": {
                    return JSONFactory.isUseJacksonAnnotation();
                }
            }
        }
        return false;
    }

    public static void methods(Class objectClass, Consumer<Method> consumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            consumer.accept(method);
        }
    }

    public static void getters(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods;
        Class<?>[] interfaces;
        if (objectClass == null) {
            return;
        }
        if (Proxy.isProxyClass(objectClass) && (interfaces = objectClass.getInterfaces()).length == 1) {
            BeanUtils.getters(interfaces[0], methodConsumer);
            return;
        }
        Class superClass = objectClass.getSuperclass();
        if (TypeUtils.isProxy(objectClass)) {
            Class superclass = superClass;
            BeanUtils.getters(superclass, methodConsumer);
            return;
        }
        boolean record = BeanUtils.isRecord(objectClass);
        String[] recordFieldNames = null;
        if (record) {
            recordFieldNames = BeanUtils.getRecordFieldNames(objectClass);
        }
        if ((methods = (Method[])methodCache.get(objectClass)) == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        boolean protobufMessageV3 = superClass != null && superClass.getName().equals("com.google.protobuf.GeneratedMessageV3");
        for (Method method : methods) {
            char firstChar;
            int methodNameLength;
            boolean nameMatch;
            Class<?> declaringClass;
            Class<?> returnClass;
            int mods;
            int paramType = method.getParameterCount();
            if (paramType != 0 || Modifier.isStatic(mods = method.getModifiers()) || (returnClass = method.getReturnType()) == Void.class || (declaringClass = method.getDeclaringClass()) == Enum.class) continue;
            String methodName = method.getName();
            boolean methodSkip = false;
            switch (methodName) {
                case "isInitialized": 
                case "getInitializationErrorString": 
                case "getSerializedSize": {
                    if (!protobufMessageV3) break;
                    methodSkip = true;
                    break;
                }
                case "equals": 
                case "hashCode": {
                    methodSkip = true;
                    break;
                }
            }
            if (methodSkip || protobufMessageV3 && (methodName.endsWith("Type") || methodName.endsWith("Bytes")) && returnClass.getName().equals("com.google.protobuf.ByteString")) continue;
            if (methodName.startsWith("isSet") && returnClass == Boolean.TYPE) {
                boolean setterFound = false;
                boolean unsetFound = false;
                int getterFound = 0;
                Annotation[] setterName = BeanUtils.getterName(methodName, null);
                String getterName = "g" + setterName.substring(1);
                String unsetName = "un" + (String)setterName;
                for (Method m : methods) {
                    if (m.getName().equals(setterName) && m.getParameterCount() == 1 && m.getReturnType() == Void.TYPE) {
                        setterFound = true;
                        continue;
                    }
                    if (m.getName().equals(getterName) && m.getParameterCount() == 0) {
                        getterFound = 1;
                        continue;
                    }
                    if (!m.getName().equals(unsetName) || m.getParameterCount() != 0 || m.getReturnType() != Void.TYPE) continue;
                    unsetFound = true;
                }
                if (setterFound && unsetFound && getterFound != 0 && AnnotationUtils.findAnnotation(method, JSONField.class) == null) continue;
            }
            if (record) {
                boolean match = false;
                for (String recordFieldName : recordFieldNames) {
                    if (!methodName.equals(recordFieldName)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            boolean bl = nameMatch = (methodNameLength = methodName.length()) > 3 && methodName.startsWith("get");
            if (nameMatch) {
                firstChar = methodName.charAt(3);
                if (firstChar >= 'a' && firstChar <= 'z' && methodNameLength == 4) {
                    nameMatch = false;
                }
            } else if (returnClass == Boolean.TYPE || returnClass == Boolean.class) {
                boolean bl2 = nameMatch = methodNameLength > 2 && methodName.startsWith("is");
                if (nameMatch && (firstChar = methodName.charAt(2)) >= 'a' && firstChar <= 'z' && methodNameLength == 3) {
                    nameMatch = false;
                }
            }
            if (!nameMatch) {
                Annotation[] annotations;
                block37: for (Annotation annotation : annotations = AnnotationUtils.getAnnotations(method)) {
                    String annotationTypeName;
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    switch (annotationTypeName = annotationType.getName()) {
                        case "com.alibaba.fastjson.annotation.JSONField": 
                        case "com.alibaba.fastjson.annotation2.JSONField": {
                            nameMatch = true;
                            continue block37;
                        }
                        case "com.fasterxml.jackson.annotation.JsonValue": 
                        case "com.alibaba.fastjson2.adapter.jackson.annotation.JsonValue": 
                        case "com.fasterxml.jackson.annotation.JsonRawValue": 
                        case "com.fasterxml.jackson.annotation.JsonProperty": 
                        case "com.alibaba.fastjson2.adapter.jackson.annotation.JsonProperty": {
                            if (!JSONFactory.isUseJacksonAnnotation()) continue block37;
                            nameMatch = true;
                            continue block37;
                        }
                    }
                }
            }
            if (!nameMatch || returnClass == Class.class && "getClass".equals(methodName)) continue;
            if (protobufMessageV3) {
                if (method.getDeclaringClass() == superClass) continue;
                Class<?> returnType = method.getReturnType();
                boolean ignore = false;
                switch (methodName) {
                    case "getUnknownFields": 
                    case "getSerializedSize": 
                    case "getParserForType": 
                    case "getMessageBytes": 
                    case "getDefaultInstanceForType": {
                        ignore = returnType.getName().startsWith("com.google.protobuf.") || returnType == objectClass;
                        break;
                    }
                }
                if (ignore) continue;
            }
            methodConsumer.accept(method);
        }
    }

    public static boolean isRecord(Class objectClass) {
        Class superclass = objectClass.getSuperclass();
        if (superclass == null) {
            return false;
        }
        if (RECORD_CLASS == null) {
            String superclassName = superclass.getName();
            if ("java.lang.Record".equals(superclassName)) {
                RECORD_CLASS = superclass;
                return true;
            }
            return false;
        }
        return superclass == RECORD_CLASS;
    }

    public static String setterName(String methodName, String namingStrategy) {
        int methodNameLength;
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        if ((methodNameLength = methodName.length()) <= 3) {
            return methodName;
        }
        int prefixLength = methodName.startsWith("set") ? 3 : 0;
        switch (namingStrategy) {
            case "NeverUseThisValueExceptDefaultValue": 
            case "CamelCase": {
                boolean c1UCase;
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
                if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
                    chars[0] = (char)(c0 + 32);
                }
                return new String(chars);
            }
            case "PascalCase": {
                return BeanUtils.pascal(methodName, methodNameLength, prefixLength);
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, prefixLength);
            }
            case "UpperCaseWithUnderScores": {
                return BeanUtils.underScores(methodName, prefixLength, true);
            }
            case "UpperCase": {
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                for (int i = 0; i < chars.length; ++i) {
                    char ch = chars[i];
                    if (ch < 'a' || c0 > 'z') continue;
                    chars[i] = (char)(ch - 32);
                }
                return new String(chars);
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    public static String setterName(String methodName, int prefixLength) {
        boolean c1UCase;
        int methodNameLength = methodName.length();
        char[] chars = new char[methodNameLength - prefixLength];
        methodName.getChars(prefixLength, methodNameLength, chars, 0);
        char c0 = chars[0];
        boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
        if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
            chars[0] = (char)(c0 + 32);
        }
        return new String(chars);
    }

    public static String getterName(Method method, String namingStrategy) {
        String fieldName = BeanUtils.getterName(method.getName(), namingStrategy);
        if (fieldName.length() > 2 && fieldName.charAt(0) >= 'A' && fieldName.charAt(0) <= 'Z' && fieldName.charAt(1) >= 'A' && fieldName.charAt(1) <= 'Z') {
            char[] chars = fieldName.toCharArray();
            chars[0] = (char)(chars[0] + 32);
            String fieldName1 = new String(chars);
            Field field = BeanUtils.getDeclaredField(method.getDeclaringClass(), fieldName1);
            if (field != null && Modifier.isPublic(field.getModifiers())) {
                fieldName = field.getName();
            }
        }
        return fieldName;
    }

    public static String getterName(String methodName, String namingStrategy) {
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        int methodNameLength = methodName.length();
        boolean is = methodName.startsWith("is");
        boolean get = methodName.startsWith("get");
        int prefixLength = is ? 2 : (get ? 3 : 0);
        switch (namingStrategy) {
            case "NeverUseThisValueExceptDefaultValue": 
            case "CamelCase": {
                boolean c1UCase;
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
                if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
                    chars[0] = (char)(c0 + 32);
                }
                return new String(chars);
            }
            case "CamelCase1x": {
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                if (c0 >= 'A' && c0 <= 'Z') {
                    chars[0] = (char)(c0 + 32);
                }
                return new String(chars);
            }
            case "PascalCase": {
                return BeanUtils.pascal(methodName, methodNameLength, prefixLength);
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, prefixLength);
            }
            case "UpperCaseWithUnderScores": {
                return BeanUtils.underScores(methodName, prefixLength, true);
            }
            case "UpperCamelCaseWithSpaces": {
                return BeanUtils.upperCamelWith(methodName, prefixLength, ' ');
            }
            case "UpperCase": {
                return methodName.substring(prefixLength).toUpperCase();
            }
            case "UpperCaseWithDashes": {
                return BeanUtils.dashes(methodName, prefixLength, true);
            }
            case "UpperCaseWithDots": {
                return BeanUtils.dots(methodName, prefixLength, true);
            }
            case "KebabCase": {
                StringBuilder buf = new StringBuilder();
                int firstIndex = is ? 2 : (get ? 3 : 0);
                for (int i = firstIndex; i < methodName.length(); ++i) {
                    char ch = methodName.charAt(i);
                    if (ch >= 'A' && ch <= 'Z') {
                        char chUcase = (char)(ch + 32);
                        if (i > firstIndex) {
                            buf.append('-');
                        }
                        buf.append(chUcase);
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    private static String pascal(String methodName, int methodNameLength, int prefixLength) {
        char c1;
        char[] chars = new char[methodNameLength - prefixLength];
        methodName.getChars(prefixLength, methodNameLength, chars, 0);
        char c0 = chars[0];
        if (c0 >= 'a' && c0 <= 'z' && chars.length > 1) {
            chars[0] = (char)(c0 - 32);
        } else if (c0 == '_' && chars.length > 2 && (c1 = chars[1]) >= 'a' && c1 <= 'z' && chars[2] >= 'a' && chars[2] <= 'z') {
            chars[1] = (char)(c1 - 32);
        }
        return new String(chars);
    }

    public static String fieldName(String methodName, String namingStrategy) {
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        if (methodName == null || methodName.isEmpty()) {
            return methodName;
        }
        switch (namingStrategy) {
            case "NoChange": 
            case "NeverUseThisValueExceptDefaultValue": 
            case "CamelCase": {
                char c1;
                char c0 = methodName.charAt(0);
                char c = c1 = methodName.length() > 1 ? methodName.charAt(1) : (char)'\u0000';
                if (c0 >= 'A' && c0 <= 'Z' && methodName.length() > 1 && (c1 < 'A' || c1 > 'Z')) {
                    char[] chars = methodName.toCharArray();
                    chars[0] = (char)(c0 + 32);
                    return new String(chars);
                }
                return methodName;
            }
            case "CamelCase1x": {
                char c0 = methodName.charAt(0);
                if (c0 >= 'A' && c0 <= 'Z' && methodName.length() > 1) {
                    char[] chars = methodName.toCharArray();
                    chars[0] = (char)(c0 + 32);
                    return new String(chars);
                }
                return methodName;
            }
            case "PascalCase": {
                char c1;
                if (methodName.isEmpty()) {
                    return methodName;
                }
                char c0 = methodName.charAt(0);
                if (c0 >= 'a' && c0 <= 'z' && methodName.length() > 1 && (c1 = methodName.charAt(1)) >= 'a' && c1 <= 'z') {
                    char[] chars = methodName.toCharArray();
                    chars[0] = (char)(c0 - 32);
                    return new String(chars);
                }
                if (c0 == '_' && methodName.length() > 1 && (c1 = methodName.charAt(1)) >= 'a' && c1 <= 'z') {
                    char[] chars = methodName.toCharArray();
                    chars[1] = (char)(c1 - 32);
                    return new String(chars);
                }
                return methodName;
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, 0);
            }
            case "UpperCaseWithUnderScores": {
                return BeanUtils.underScores(methodName, 0, true);
            }
            case "LowerCaseWithUnderScores": {
                return BeanUtils.underScores(methodName, 0, false);
            }
            case "UpperCaseWithDashes": {
                return BeanUtils.dashes(methodName, 0, true);
            }
            case "LowerCaseWithDashes": {
                return BeanUtils.dashes(methodName, 0, false);
            }
            case "UpperCaseWithDots": {
                return BeanUtils.dots(methodName, 0, true);
            }
            case "LowerCaseWithDots": {
                return BeanUtils.dots(methodName, 0, false);
            }
            case "UpperCase": {
                return methodName.toUpperCase();
            }
            case "LowerCase": {
                return methodName.toLowerCase();
            }
            case "UpperCamelCaseWithSpaces": {
                return BeanUtils.upperCamelWith(methodName, 0, ' ');
            }
            case "UpperCamelCaseWithUnderScores": {
                return BeanUtils.upperCamelWith(methodName, 0, '_');
            }
            case "UpperCamelCaseWithDashes": {
                return BeanUtils.upperCamelWith(methodName, 0, '-');
            }
            case "UpperCamelCaseWithDots": {
                return BeanUtils.upperCamelWith(methodName, 0, '.');
            }
            case "KebabCase": {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < methodName.length(); ++i) {
                    char ch = methodName.charAt(i);
                    if (ch >= 'A' && ch <= 'Z') {
                        char chUcase = (char)(ch + 32);
                        if (i > 0) {
                            buf.append('-');
                        }
                        buf.append(chUcase);
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String snakeCase(String methodName, int prefixLength) {
        int methodNameLength = methodName.length();
        char[] buf = TypeUtils.CHARS_UPDATER.getAndSet(TypeUtils.CACHE, null);
        if (buf == null) {
            buf = new char[128];
        }
        try {
            int off = 0;
            for (int i = prefixLength; i < methodNameLength; ++i) {
                char ch = methodName.charAt(i);
                if (ch >= 'A' && ch <= 'Z') {
                    char chUcase = (char)(ch + 32);
                    if (i > prefixLength) {
                        buf[off++] = 95;
                    }
                    buf[off++] = chUcase;
                    continue;
                }
                buf[off++] = ch;
            }
            String string = new String(buf, 0, off);
            return string;
        }
        finally {
            TypeUtils.CHARS_UPDATER.set(TypeUtils.CACHE, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String upperCamelWith(String methodName, int prefixLength, char separator) {
        int methodNameLength = methodName.length();
        char[] buf = TypeUtils.CHARS_UPDATER.getAndSet(TypeUtils.CACHE, null);
        if (buf == null) {
            buf = new char[128];
        }
        try {
            int off = 0;
            for (int i = prefixLength; i < methodNameLength; ++i) {
                char c1;
                char ch = methodName.charAt(i);
                if (i == prefixLength) {
                    if (ch >= 'a' && ch <= 'z' && i + 1 < methodNameLength && (c1 = methodName.charAt(i + 1)) >= 'a' && c1 <= 'z') {
                        buf[off++] = (char)(ch - 32);
                        continue;
                    }
                    if (ch == '_' && i + 1 < methodNameLength && (c1 = methodName.charAt(i + 1)) >= 'a' && c1 <= 'z') {
                        buf[off++] = ch;
                        buf[off++] = (char)(c1 - 32);
                        ++i;
                        continue;
                    }
                    buf[off++] = ch;
                    continue;
                }
                if (ch >= 'A' && ch <= 'Z' && i + 1 < methodNameLength && ((c1 = methodName.charAt(i + 1)) < 'A' || c1 > 'Z')) {
                    if (i > prefixLength) {
                        buf[off++] = separator;
                    }
                    buf[off++] = ch;
                    continue;
                }
                if (ch >= 'A' && ch <= 'Z' && i > prefixLength && i + 1 < methodNameLength && (c1 = methodName.charAt(i + 1)) >= 'A' && c1 <= 'Z' && (c1 = methodName.charAt(i - 1)) >= 'a' && c1 <= 'z') {
                    if (i > prefixLength) {
                        buf[off++] = separator;
                    }
                    buf[off++] = ch;
                    continue;
                }
                buf[off++] = ch;
            }
            String string = new String(buf, 0, off);
            return string;
        }
        finally {
            TypeUtils.CHARS_UPDATER.set(TypeUtils.CACHE, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String underScores(String methodName, int prefixLength, boolean upper) {
        int methodNameLength = methodName.length();
        char[] buf = TypeUtils.CHARS_UPDATER.getAndSet(TypeUtils.CACHE, null);
        if (buf == null) {
            buf = new char[128];
        }
        try {
            int off = 0;
            for (int i = prefixLength; i < methodNameLength; ++i) {
                char ch = methodName.charAt(i);
                if (upper) {
                    if (ch >= 'A' && ch <= 'Z') {
                        if (i > prefixLength) {
                            buf[off++] = 95;
                        }
                        buf[off++] = ch;
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'z') {
                        ch = (char)(ch - 32);
                    }
                    buf[off++] = ch;
                    continue;
                }
                if (ch >= 'A' && ch <= 'Z') {
                    if (i > prefixLength) {
                        buf[off++] = 95;
                    }
                    buf[off++] = (char)(ch + 32);
                    continue;
                }
                buf[off++] = ch;
            }
            String string = new String(buf, 0, off);
            return string;
        }
        finally {
            TypeUtils.CHARS_UPDATER.set(TypeUtils.CACHE, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String dashes(String methodName, int prefixLength, boolean upper) {
        int methodNameLength = methodName.length();
        char[] buf = TypeUtils.CHARS_UPDATER.getAndSet(TypeUtils.CACHE, null);
        if (buf == null) {
            buf = new char[128];
        }
        try {
            int off = 0;
            for (int i = prefixLength; i < methodNameLength; ++i) {
                char ch = methodName.charAt(i);
                if (upper) {
                    if (ch >= 'A' && ch <= 'Z') {
                        if (i > prefixLength) {
                            buf[off++] = 45;
                        }
                        buf[off++] = ch;
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'z') {
                        ch = (char)(ch - 32);
                    }
                    buf[off++] = ch;
                    continue;
                }
                if (ch >= 'A' && ch <= 'Z') {
                    if (i > prefixLength) {
                        buf[off++] = 45;
                    }
                    buf[off++] = (char)(ch + 32);
                    continue;
                }
                buf[off++] = ch;
            }
            String string = new String(buf, 0, off);
            return string;
        }
        finally {
            TypeUtils.CHARS_UPDATER.set(TypeUtils.CACHE, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String dots(String methodName, int prefixLength, boolean upper) {
        int methodNameLength = methodName.length();
        char[] buf = TypeUtils.CHARS_UPDATER.getAndSet(TypeUtils.CACHE, null);
        if (buf == null) {
            buf = new char[128];
        }
        try {
            int off = 0;
            for (int i = prefixLength; i < methodNameLength; ++i) {
                char ch = methodName.charAt(i);
                if (upper) {
                    if (ch >= 'A' && ch <= 'Z') {
                        if (i > prefixLength) {
                            buf[off++] = 46;
                        }
                        buf[off++] = ch;
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'z') {
                        ch = (char)(ch - 32);
                    }
                    buf[off++] = ch;
                    continue;
                }
                if (ch >= 'A' && ch <= 'Z') {
                    if (i > prefixLength) {
                        buf[off++] = 46;
                    }
                    buf[off++] = (char)(ch + 32);
                    continue;
                }
                buf[off++] = ch;
            }
            String string = new String(buf, 0, off);
            return string;
        }
        finally {
            TypeUtils.CHARS_UPDATER.set(TypeUtils.CACHE, buf);
        }
    }

    public static Type getFieldType(TypeReference type, Class<?> raw, Member field, Type fieldType) {
        Class<?> declaringClass = field.getDeclaringClass();
        while (raw != Object.class) {
            if (declaringClass == raw) {
                return BeanUtils.resolve(type.getType(), declaringClass, fieldType);
            }
            type = TypeReference.get(BeanUtils.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return null;
    }

    public static Type getParamType(TypeReference type, Class<?> raw, Class declaringClass, Parameter field, Type fieldType) {
        while (raw != Object.class) {
            if (declaringClass == raw) {
                return BeanUtils.resolve(type.getType(), declaringClass, fieldType);
            }
            type = TypeReference.get(BeanUtils.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return null;
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static WildcardType subtypeOf(Type bound) {
        Type[] upperBounds = bound instanceof WildcardType ? ((WildcardType)bound).getUpperBounds() : new Type[]{bound};
        return new WildcardTypeImpl(upperBounds, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        Type[] lowerBounds = bound instanceof WildcardType ? ((WildcardType)bound).getLowerBounds() : new Type[]{bound};
        return new WildcardTypeImpl(new Type[]{Object.class}, lowerBounds);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isArray() ? new GenericArrayTypeImpl(BeanUtils.canonicalize(c.getComponentType())) : c;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            BeanUtils.checkArgument(rawType instanceof Class);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(BeanUtils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return BeanUtils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return BeanUtils.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return BeanUtils.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    static int hashCodeOrZero(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return context;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                return BeanUtils.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom(rawSupertype)) {
                    return BeanUtils.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        return BeanUtils.resolve(context, contextRawType, toResolve, new HashMap());
    }

    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve, Map<TypeVariable<?>, Type> visitedTypeVariables) {
        TypeVariable resolving;
        block17: {
            Class<?> componentType;
            Type original;
            resolving = null;
            while (toResolve instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)toResolve;
                Type previouslyResolved = visitedTypeVariables.get(typeVariable);
                if (previouslyResolved != null) {
                    return previouslyResolved == Void.TYPE ? toResolve : previouslyResolved;
                }
                visitedTypeVariables.put(typeVariable, Void.TYPE);
                if (resolving == null) {
                    resolving = typeVariable;
                }
                if ((toResolve = BeanUtils.resolveTypeVariable(context, contextRawType, typeVariable)) != typeVariable) continue;
                break block17;
            }
            if (toResolve instanceof Class && ((Class)toResolve).isArray()) {
                Type newComponentType;
                original = (Class)toResolve;
                componentType = ((Class)original).getComponentType();
                toResolve = BeanUtils.equal(componentType, newComponentType = BeanUtils.resolve(context, contextRawType, componentType, visitedTypeVariables)) ? original : BeanUtils.arrayOf(newComponentType);
            } else if (toResolve instanceof GenericArrayType) {
                Type newComponentType;
                original = (GenericArrayType)toResolve;
                componentType = original.getGenericComponentType();
                toResolve = BeanUtils.equal(componentType, newComponentType = BeanUtils.resolve(context, contextRawType, componentType, visitedTypeVariables)) ? original : BeanUtils.arrayOf(newComponentType);
            } else if (toResolve instanceof ParameterizedType) {
                original = (ParameterizedType)toResolve;
                Type ownerType = original.getOwnerType();
                Type newOwnerType = BeanUtils.resolve(context, contextRawType, ownerType, visitedTypeVariables);
                boolean changed = !BeanUtils.equal(newOwnerType, ownerType);
                Type[] args = original.getActualTypeArguments();
                int length = args.length;
                for (int t = 0; t < length; ++t) {
                    Type resolvedTypeArgument = BeanUtils.resolve(context, contextRawType, args[t], visitedTypeVariables);
                    if (BeanUtils.equal(resolvedTypeArgument, args[t])) continue;
                    if (!changed) {
                        args = (Type[])args.clone();
                        changed = true;
                    }
                    args[t] = resolvedTypeArgument;
                }
                toResolve = changed ? BeanUtils.newParameterizedTypeWithOwner(newOwnerType, original.getRawType(), args) : original;
            } else if (toResolve instanceof WildcardType) {
                Type upperBound;
                original = (WildcardType)toResolve;
                Type[] originalLowerBound = original.getLowerBounds();
                Type[] originalUpperBound = original.getUpperBounds();
                if (originalLowerBound.length == 1) {
                    Type lowerBound = BeanUtils.resolve(context, contextRawType, originalLowerBound[0], visitedTypeVariables);
                    if (lowerBound != originalLowerBound[0]) {
                        toResolve = BeanUtils.supertypeOf(lowerBound);
                    }
                } else if (originalUpperBound.length == 1 && (upperBound = BeanUtils.resolve(context, contextRawType, originalUpperBound[0], visitedTypeVariables)) != originalUpperBound[0]) {
                    toResolve = BeanUtils.subtypeOf(upperBound);
                }
            }
        }
        if (resolving != null) {
            visitedTypeVariables.put(resolving, toResolve);
        }
        return toResolve;
    }

    static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        Class<?> declaredByRaw = BeanUtils.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = BeanUtils.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = BeanUtils.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    private static int indexOf(Object[] array, Object toFind) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    static void checkNotPrimitive(Type type) {
        BeanUtils.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }

    static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> T checkNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static void processJacksonJsonIgnore(FieldInfo fieldInfo, Annotation annotation) {
        fieldInfo.ignore = true;
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "value": {
                        boolean value;
                        fieldInfo.ignore = value = ((Boolean)result).booleanValue();
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static boolean isNoneStaticMemberClass(Class objectClass, Class memberClass) {
        if (memberClass == null || memberClass.isPrimitive() || memberClass == String.class || memberClass == List.class) {
            return false;
        }
        Class<?> enclosingClass = memberClass.getEnclosingClass();
        if (enclosingClass == null) {
            return false;
        }
        if (objectClass != null && !objectClass.equals(enclosingClass)) {
            return false;
        }
        Constructor[] constructors = (Constructor[])constructorCache.get(memberClass);
        if (constructors == null) {
            constructors = memberClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(memberClass, constructors);
        }
        if (constructors.length == 0) {
            return false;
        }
        Constructor firstConstructor = constructors[0];
        if (firstConstructor.getParameterCount() == 0) {
            return false;
        }
        Class<?>[] parameterTypes = firstConstructor.getParameterTypes();
        return enclosingClass.equals(parameterTypes[0]);
    }

    public static void setNoneStaticMemberClassParent(Object object, Object parent) {
        Class<?> objectClass = object.getClass();
        Field[] fields = (Field[])declaredFieldCache.get(objectClass);
        if (fields == null) {
            Field[] declaredFields = objectClass.getDeclaredFields();
            boolean allMatch = true;
            Field[] fieldArray = declaredFields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                allMatch = false;
                break;
            }
            if (allMatch) {
                fields = declaredFields;
            } else {
                ArrayList<Field> list = new ArrayList<Field>(declaredFields.length);
                for (Field field : declaredFields) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers)) continue;
                    list.add(field);
                }
                fields = list.toArray(new Field[list.size()]);
            }
            fieldCache.putIfAbsent(objectClass, fields);
        }
        Field this0 = null;
        for (Field field : fields) {
            if (!"this$0".equals(field.getName())) continue;
            this0 = field;
        }
        if (this0 != null) {
            this0.setAccessible(true);
            try {
                this0.set(object, parent);
            }
            catch (IllegalAccessException e) {
                throw new JSONException("setNoneStaticMemberClassParent error, class " + objectClass);
            }
        }
    }

    public static void cleanupCache(Class objectClass) {
        if (objectClass == null) {
            return;
        }
        fieldCache.remove(objectClass);
        fieldMapCache.remove(objectClass);
        declaredFieldCache.remove(objectClass);
        methodCache.remove(objectClass);
        constructorCache.remove(objectClass);
    }

    public static void cleanupCache(ClassLoader classLoader) {
        Class entryKey;
        Map.Entry entry;
        Iterator it = fieldCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entryKey = (Class)entry.getKey();
            if (entryKey.getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = fieldMapCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entryKey = (Class)entry.getKey();
            if (entryKey.getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = declaredFieldCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entryKey = (Class)entry.getKey();
            if (entryKey.getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = methodCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entryKey = (Class)entry.getKey();
            if (entryKey.getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = constructorCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entryKey = (Class)entry.getKey();
            if (entryKey.getClassLoader() != classLoader) continue;
            it.remove();
        }
    }

    public static void processJSONType1x(BeanInfo beanInfo, Annotation jsonType1x, Method method) {
        try {
            Object result = method.invoke((Object)jsonType1x, new Object[0]);
            switch (method.getName()) {
                case "seeAlso": {
                    Class[] classes = (Class[])result;
                    if (classes.length == 0) break;
                    beanInfo.seeAlso = classes;
                    break;
                }
                case "typeName": {
                    String typeName = (String)result;
                    if (typeName.isEmpty()) break;
                    beanInfo.typeName = typeName;
                    break;
                }
                case "typeKey": {
                    String typeKey = (String)result;
                    if (typeKey.isEmpty()) break;
                    beanInfo.typeKey = typeKey;
                    break;
                }
                case "alphabetic": {
                    Boolean alphabetic = (Boolean)result;
                    if (alphabetic.booleanValue()) break;
                    beanInfo.alphabetic = false;
                    break;
                }
                case "serializeFeatures": 
                case "serialzeFeatures": {
                    Enum[] serializeFeatures;
                    block53: for (Enum feature : serializeFeatures = (Enum[])result) {
                        switch (feature.name()) {
                            case "WriteMapNullValue": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNulls.mask;
                                continue block53;
                            }
                            case "WriteNullListAsEmpty": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNullListAsEmpty.mask;
                                continue block53;
                            }
                            case "WriteNullStringAsEmpty": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNullStringAsEmpty.mask;
                                continue block53;
                            }
                            case "WriteNullNumberAsZero": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNullNumberAsZero.mask;
                                continue block53;
                            }
                            case "WriteNullBooleanAsFalse": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNullBooleanAsFalse.mask;
                                continue block53;
                            }
                            case "BrowserCompatible": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.BrowserCompatible.mask;
                                continue block53;
                            }
                            case "WriteClassName": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteClassName.mask;
                                continue block53;
                            }
                            case "WriteNonStringValueAsString": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
                                continue block53;
                            }
                            case "WriteEnumUsingToString": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteEnumUsingToString.mask;
                                continue block53;
                            }
                            case "NotWriteRootClassName": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.NotWriteRootClassName.mask;
                                continue block53;
                            }
                            case "IgnoreErrorGetter": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.IgnoreErrorGetter.mask;
                                continue block53;
                            }
                        }
                    }
                    break;
                }
                case "serializeEnumAsJavaBean": {
                    boolean serializeEnumAsJavaBean = (Boolean)result;
                    if (!serializeEnumAsJavaBean) break;
                    beanInfo.writeEnumAsJavaBean = true;
                    break;
                }
                case "naming": {
                    Enum naming = (Enum)result;
                    beanInfo.namingStrategy = naming.name();
                    break;
                }
                case "ignores": {
                    String[] fields = (String[])result;
                    if (fields.length == 0) break;
                    if (beanInfo.ignores == null) {
                        beanInfo.ignores = fields;
                        break;
                    }
                    LinkedHashSet<String> ignoresSet = new LinkedHashSet<String>();
                    for (String ignore : beanInfo.ignores) {
                        ignoresSet.add(ignore);
                    }
                    for (String ignore : fields) {
                        ignoresSet.add(ignore);
                    }
                    beanInfo.ignores = ignoresSet.toArray(new String[ignoresSet.size()]);
                    break;
                }
                case "includes": {
                    String[] fields = (String[])result;
                    if (fields.length == 0) break;
                    beanInfo.includes = fields;
                    break;
                }
                case "orders": {
                    String[] fields = (String[])result;
                    if (fields.length == 0) break;
                    beanInfo.orders = fields;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void processJacksonJsonFormat(FieldInfo fieldInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "pattern": {
                        String pattern = (String)result;
                        if (pattern.length() == 0) break;
                        fieldInfo.format = pattern;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void processJacksonJsonFormat(BeanInfo beanInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "pattern": {
                        String pattern = (String)result;
                        if (pattern.length() == 0) break;
                        beanInfo.format = pattern;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void processJacksonJsonInclude(BeanInfo beanInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                block4 : switch (name) {
                    case "value": {
                        String include;
                        switch (include = ((Enum)result).name()) {
                            case "ALWAYS": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.WriteNulls.mask;
                                break block4;
                            }
                            case "NON_DEFAULT": {
                                beanInfo.writerFeatures |= JSONWriter.Feature.NotWriteDefaultValue.mask;
                                break block4;
                            }
                        }
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void processJacksonJsonTypeName(BeanInfo beanInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "value": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        beanInfo.typeName = value;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void processJacksonJsonSubTypesType(BeanInfo beanInfo, int index, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "value": {
                        Class value;
                        beanInfo.seeAlso[index] = value = (Class)result;
                        break;
                    }
                    case "name": {
                        String value;
                        beanInfo.seeAlsoNames[index] = value = (String)result;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class rawTypeAsClass = (Class)rawType;
                boolean isStaticOrTopLevelClass = Modifier.isStatic(rawTypeAsClass.getModifiers()) || rawTypeAsClass.getEnclosingClass() == null;
                BeanUtils.checkArgument(ownerType != null || isStaticOrTopLevelClass);
            }
            this.ownerType = ownerType == null ? null : BeanUtils.canonicalize(ownerType);
            this.rawType = BeanUtils.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            int length = this.typeArguments.length;
            for (int t = 0; t < length; ++t) {
                BeanUtils.checkNotNull(this.typeArguments[t]);
                BeanUtils.checkNotPrimitive(this.typeArguments[t]);
                this.typeArguments[t] = BeanUtils.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && BeanUtils.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ BeanUtils.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            int length = this.typeArguments.length;
            if (length == 0) {
                return BeanUtils.typeToString(this.rawType);
            }
            StringBuilder stringBuilder = new StringBuilder(30 * (length + 1));
            stringBuilder.append(BeanUtils.typeToString(this.rawType)).append("<").append(BeanUtils.typeToString(this.typeArguments[0]));
            for (int i = 1; i < length; ++i) {
                stringBuilder.append(", ").append(BeanUtils.typeToString(this.typeArguments[i]));
            }
            return stringBuilder.append(">").toString();
        }
    }

    public static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = BeanUtils.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && BeanUtils.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return BeanUtils.typeToString(this.componentType) + "[]";
        }
    }

    static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            BeanUtils.checkArgument(lowerBounds.length <= 1);
            BeanUtils.checkArgument(upperBounds.length == 1);
            if (lowerBounds.length == 1) {
                BeanUtils.checkNotNull(lowerBounds[0]);
                BeanUtils.checkNotPrimitive(lowerBounds[0]);
                BeanUtils.checkArgument(upperBounds[0] == Object.class);
                this.lowerBound = BeanUtils.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                BeanUtils.checkNotNull(upperBounds[0]);
                BeanUtils.checkNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = BeanUtils.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && BeanUtils.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + BeanUtils.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + BeanUtils.typeToString(this.upperBound);
        }
    }
}

