/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONValidException;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UUIDUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

class JSONReaderUTF16
extends JSONReader {
    protected final String str;
    protected final char[] chars;
    protected final int length;
    protected final int start;
    protected final int end;
    private int nameBegin;
    private int nameEnd;
    private int nameLength;
    private int referenceBegin;
    private Closeable input;
    private int cacheIndex = -1;
    protected boolean csv;

    JSONReaderUTF16(JSONReader.Context ctx, byte[] bytes, int offset, int length) {
        super(ctx);
        this.str = null;
        this.chars = new char[length / 2];
        int j = 0;
        int bytesEnd = offset + length;
        int i = offset;
        while (i < bytesEnd) {
            byte c0 = bytes[i];
            byte c1 = bytes[i + 1];
            this.chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
            i += 2;
            ++j;
        }
        this.start = offset;
        this.end = this.length = j;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + offset);
        }
    }

    @Override
    public byte[] readHex() {
        this.next();
        if (this.ch != '\'') {
            throw new JSONException("illegal state. " + this.ch);
        }
        int start = this.offset++;
        do {
            this.ch = this.chars[this.offset++];
        } while (this.ch >= '0' && this.ch <= '9' || this.ch >= 'A' && this.ch <= 'F');
        if (this.ch != '\'') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.ch = this.chars[this.offset++];
        int len = this.offset - start - 2;
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 != 0) {
            throw new JSONException("illegal state. " + len);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < bytes.length; ++i) {
            char c0 = this.chars[start + i * 2];
            char c1 = this.chars[start + i * 2 + 1];
            int b0 = c0 - (c0 <= '9' ? 48 : 55);
            int b1 = c1 - (c1 <= '9' ? 48 : 55);
            bytes[i] = (byte)(b0 << 4 | b1);
        }
        this.nextIfMatch(',');
        return bytes;
    }

    @Override
    public boolean isReference() {
        if (this.ch != '{') {
            return false;
        }
        int start = this.offset;
        if (this.offset == this.end) {
            return false;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = this.chars[this.offset];
        }
        char quote = this.ch;
        if (quote != '\"' && quote != '\'' || this.offset + 5 >= this.end) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        if (this.chars[this.offset + 1] != '$' || this.chars[this.offset + 2] != 'r' || this.chars[this.offset + 3] != 'e' || this.chars[this.offset + 4] != 'f' || this.chars[this.offset + 5] != quote || this.offset + 6 >= this.end) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.offset += 6;
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = this.chars[this.offset];
        }
        if (this.ch != ':' || this.offset + 1 >= this.end) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.ch = this.chars[++this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = this.chars[this.offset];
        }
        if (this.ch != quote) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.referenceBegin = this.offset;
        this.offset = start;
        this.ch = (char)123;
        return true;
    }

    @Override
    public String readReference() {
        if (this.referenceBegin == this.end) {
            return null;
        }
        this.offset = this.referenceBegin;
        this.ch = this.chars[this.offset++];
        String reference = this.readString();
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return reference;
            }
            this.ch = this.chars[this.offset];
        }
        if (this.ch != '}') {
            throw new JSONException("illegal reference : " + reference);
        }
        this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = this.chars[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return reference;
    }

    JSONReaderUTF16(JSONReader.Context ctx, Reader input) {
        super(ctx);
        this.input = input;
        this.cacheIndex = System.identityHashCode(Thread.currentThread()) & 3;
        char[] chars = JSONFactory.allocateCharArray(this.cacheIndex);
        if (chars == null) {
            chars = new char[8192];
        }
        int off = 0;
        try {
            int n;
            while ((n = input.read(chars, off, chars.length - off)) != -1) {
                if ((off += n) != chars.length) continue;
                int oldCapacity = chars.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                chars = Arrays.copyOf(chars, newCapacity);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.str = null;
        this.chars = chars;
        this.offset = 0;
        this.length = off;
        this.start = 0;
        this.end = this.length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + this.offset);
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, String str, char[] chars, int offset, int length) {
        super(ctx);
        this.str = str;
        this.chars = chars;
        this.offset = offset;
        this.length = length;
        this.start = offset;
        this.end = offset + length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + offset);
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, InputStream input) {
        super(ctx);
        char[] chars;
        this.input = input;
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & 3;
        byte[] bytes = JSONFactory.allocateByteArray(cacheIndex);
        try {
            int n;
            int off = 0;
            while ((n = input.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + 8192);
            }
            if (off % 2 == 1) {
                throw new JSONException("illegal input utf16 bytes, length " + off);
            }
            chars = new char[off / 2];
            int i = 0;
            int j = 0;
            while (i < off) {
                byte c0 = bytes[i];
                byte c1 = bytes[i + 1];
                chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                i += 2;
                ++j;
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        finally {
            JSONFactory.releaseByteArray(cacheIndex, bytes);
        }
        this.str = null;
        this.chars = chars;
        this.offset = 0;
        this.length = chars.length;
        this.start = 0;
        this.end = this.length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + this.offset);
        }
    }

    @Override
    public boolean nextIfMatch(char ch) {
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch != ch) {
            return false;
        }
        boolean bl = this.comma = ch == ',';
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = this.chars[this.offset];
        while (this.ch == '\u0000' || this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfNullOrEmptyString() {
        char first = this.ch;
        if (first == 'n' && this.offset + 2 < this.end && this.chars[this.offset] == 'u') {
            this.readNull();
            return true;
        }
        if (first != '\"' && first != '\'' || this.offset >= this.end || this.chars[this.offset] != first) {
            return false;
        }
        ++this.offset;
        this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset]);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = this.chars[this.offset];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2) {
        if (this.ch != c0) {
            return false;
        }
        int offset2 = this.offset + 2;
        if (offset2 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2) {
            return false;
        }
        if (offset2 == this.end) {
            this.offset = offset2;
            this.ch = (char)26;
            return true;
        }
        int offset = offset2;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset2) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        if (this.ch != c0) {
            return false;
        }
        int offset3 = this.offset + 3;
        if (offset3 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2 || this.chars[this.offset + 2] != c3) {
            return false;
        }
        if (offset3 == this.end) {
            this.offset = offset3;
            this.ch = (char)26;
            return true;
        }
        int offset = offset3;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset3 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        if (this.ch != c0) {
            return false;
        }
        int offset4 = this.offset + 4;
        if (offset4 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2 || this.chars[this.offset + 2] != c3 || this.chars[this.offset + 3] != c4) {
            return false;
        }
        if (offset4 == this.end) {
            this.offset = offset4;
            this.ch = (char)26;
            return true;
        }
        int offset = offset4;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset4 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        if (this.ch != c0) {
            return false;
        }
        int offset5 = this.offset + 5;
        if (offset5 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2 || this.chars[this.offset + 2] != c3 || this.chars[this.offset + 3] != c4 || this.chars[this.offset + 4] != c5) {
            return false;
        }
        if (offset5 == this.end) {
            this.offset = offset5;
            this.ch = (char)26;
            return true;
        }
        int offset = offset5;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset5 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public boolean nextIfSet() {
        if (this.ch == 'S' && this.offset + 1 < this.end && this.chars[this.offset] == 'e' && this.chars[this.offset + 1] == 't') {
            this.offset += 2;
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = this.chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        break;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean nextIfInfinity() {
        if (this.ch == 'I' && this.offset + 6 < this.end && this.chars[this.offset] == 'n' && this.chars[this.offset + 1] == 'f' && this.chars[this.offset + 2] == 'i' && this.chars[this.offset + 3] == 'n' && this.chars[this.offset + 4] == 'i' && this.chars[this.offset + 5] == 't' && this.chars[this.offset + 6] == 'y') {
            this.offset += 7;
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = this.chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        break;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void next() {
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = this.chars[this.offset];
        while (this.ch == '\u0000' || this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        long hashCode;
        this.nameEscape = false;
        this.nameBegin = this.offset - 1;
        char first = this.ch;
        long nameValue = 0L;
        if (JSONFactory.MIXED_HASH_ALGORITHM) {
            int i = 0;
            block26: while (this.offset <= this.end) {
                switch (this.ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case '\u001a': 
                    case ' ': 
                    case '!': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.nameLength = i;
                        this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                            this.next();
                        }
                        break block26;
                    }
                    default: {
                        if (this.ch == '\\') {
                            this.nameEscape = true;
                            this.ch = this.chars[this.offset++];
                            switch (this.ch) {
                                case 'u': {
                                    char c1 = this.chars[this.offset++];
                                    char c2 = this.chars[this.offset++];
                                    char c3 = this.chars[this.offset++];
                                    char c4 = this.chars[this.offset++];
                                    this.ch = JSONReaderUTF16.char4(c1, c2, c3, c4);
                                    break;
                                }
                                case 'x': {
                                    char c1 = this.chars[this.offset++];
                                    char c2 = this.chars[this.offset++];
                                    this.ch = JSONReaderUTF16.char2(c1, c2);
                                    break;
                                }
                                case '\"': 
                                case '*': 
                                case '+': 
                                case '-': 
                                case '.': 
                                case '/': 
                                case ':': 
                                case '<': 
                                case '=': 
                                case '>': 
                                case '@': 
                                case '\\': {
                                    break;
                                }
                                default: {
                                    this.ch = JSONReaderUTF16.char1(this.ch);
                                }
                            }
                        }
                        if (this.ch > '\u00ff' || i >= 8 || i == 0 && this.ch == '\u0000') {
                            nameValue = 0L;
                            this.ch = first;
                            this.offset = this.nameBegin + 1;
                            break block26;
                        }
                        byte c = (byte)this.ch;
                        switch (i) {
                            case 0: {
                                nameValue = c;
                                break;
                            }
                            case 1: {
                                nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                                break;
                            }
                            case 2: {
                                nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                                break;
                            }
                            case 3: {
                                nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                                break;
                            }
                            case 4: {
                                nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                                break;
                            }
                            case 5: {
                                nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                                break;
                            }
                            case 6: {
                                nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                                break;
                            }
                            case 7: {
                                nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                                break;
                            }
                        }
                        this.ch = (char)(this.offset >= this.end ? 26 : this.chars[this.offset++]);
                        ++i;
                        continue block26;
                    }
                }
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            block28: while (true) {
                if (this.ch == '\\') {
                    this.nameEscape = true;
                    this.ch = this.chars[this.offset++];
                    switch (this.ch) {
                        case 'u': {
                            char c1 = this.chars[this.offset++];
                            char c2 = this.chars[this.offset++];
                            char c3 = this.chars[this.offset++];
                            char c4 = this.chars[this.offset++];
                            this.ch = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[this.offset++];
                            char c2 = this.chars[this.offset++];
                            this.ch = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '@': 
                        case '\\': {
                            break;
                        }
                        default: {
                            this.ch = JSONReaderUTF16.char1(this.ch);
                        }
                    }
                    hashCode ^= (long)this.ch;
                    hashCode *= 1099511628211L;
                    this.next();
                } else {
                    switch (this.ch) {
                        case '\b': 
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case '\u001a': 
                        case ' ': 
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '[': 
                        case ']': 
                        case '{': 
                        case '}': {
                            this.nameLength = i;
                            this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                                this.next();
                            }
                            break block28;
                        }
                        default: {
                            hashCode ^= (long)this.ch;
                            hashCode *= 1099511628211L;
                            this.ch = (char)(this.offset >= this.end ? 26 : this.chars[this.offset++]);
                        }
                    }
                }
                ++i;
            }
        }
        if (this.ch == ':') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        return hashCode;
    }

    @Override
    public long readFieldNameHashCode() {
        char c;
        long hashCode;
        if (this.ch != '\"' && this.ch != '\'') {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF16.isFirstIdentifier(this.ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            String errorMsg = this.ch == '[' && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + this.ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + this.ch;
            throw new JSONException(this.info(errorMsg));
        }
        char quote = this.ch;
        this.stringValue = null;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (JSONFactory.MIXED_HASH_ALGORITHM && offset + 9 < this.end) {
            char c0 = this.chars[offset];
            char c1 = this.chars[offset + 1];
            char c2 = this.chars[offset + 2];
            char c3 = this.chars[offset + 3];
            char c4 = this.chars[offset + 4];
            char c5 = this.chars[offset + 5];
            char c6 = this.chars[offset + 6];
            char c7 = this.chars[offset + 7];
            char c8 = this.chars[offset + 8];
            if (c0 == quote) {
                nameValue = 0L;
            } else if (c1 == quote && c0 != '\u0000' && c0 != '\\' && c0 <= '\u00ff') {
                nameValue = (byte)c0;
                this.nameLength = 1;
                this.nameEnd = offset + 1;
                offset += 2;
            } else if (c2 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff') {
                nameValue = ((byte)c1 << 8) + c0;
                this.nameLength = 2;
                this.nameEnd = offset + 2;
                offset += 3;
            } else if (c3 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff') {
                nameValue = ((byte)c2 << 16) + (c1 << 8) + c0;
                this.nameLength = 3;
                this.nameEnd = offset + 3;
                offset += 4;
            } else if (c4 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff') {
                nameValue = ((byte)c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                this.nameLength = 4;
                this.nameEnd = offset + 4;
                offset += 5;
            } else if (c5 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff') {
                nameValue = ((long)((byte)c4) << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 5;
                this.nameEnd = offset + 5;
                offset += 6;
            } else if (c6 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff') {
                nameValue = ((long)((byte)c5) << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 6;
                this.nameEnd = offset + 6;
                offset += 7;
            } else if (c7 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c6 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff' && c6 <= '\u00ff') {
                nameValue = ((long)((byte)c6) << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 7;
                this.nameEnd = offset + 7;
                offset += 8;
            } else if (c8 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c6 != '\\' && c7 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff' && c6 <= '\u00ff' && c7 <= '\u00ff') {
                nameValue = ((long)((byte)c7) << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 8;
                this.nameEnd = offset + 8;
                offset += 9;
            }
        }
        if (JSONFactory.MIXED_HASH_ALGORITHM && nameValue == 0L) {
            int i = 0;
            while (offset < this.end) {
                char c2 = this.chars[offset];
                if (c2 == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c2 == '\\') {
                    this.nameEscape = true;
                    c2 = this.chars[++offset];
                    switch (c2) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c22 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c2 = JSONReaderUTF16.char4(c1, c22, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c22 = this.chars[++offset];
                            c2 = JSONReaderUTF16.char2(c1, c22);
                            break;
                        }
                        default: {
                            c2 = JSONReaderUTF16.char1(c2);
                        }
                    }
                }
                if (c2 > '\u00ff' || i >= 8 || i == 0 && c2 == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c2;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c2 << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c2 << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c2 << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c2) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c2) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c2) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c2) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                char c3;
                if ((c3 = this.chars[offset]) == '\\') {
                    this.nameEscape = true;
                    c3 = this.chars[++offset];
                    switch (c3) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c32 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c3 = JSONReaderUTF16.char4(c1, c2, c32, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c3 = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        default: {
                            c3 = JSONReaderUTF16.char1(c3);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                } else {
                    if (c3 == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        if (offset < this.end) {
            c = this.chars[offset];
            while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                c = this.chars[++offset];
            }
        } else {
            c = '\u001a';
        }
        if (c != ':') {
            throw new JSONException(this.info("expect ':', but " + c));
        }
        c = ++offset == this.end ? (char)'\u001a' : this.chars[offset];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = this.chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = c;
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        long hashCode;
        if (this.ch != '\"' && this.ch != '\'') {
            return -1L;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (JSONFactory.MIXED_HASH_ALGORITHM) {
            int i = 0;
            while (offset < this.end) {
                char c = this.chars[offset];
                if (c == quote) {
                    if (i == 0) {
                        nameValue = 0L;
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c == '\\') {
                    this.nameEscape = true;
                    c = this.chars[++offset];
                    switch (c) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = JSONReaderUTF16.char1(c);
                        }
                    }
                }
                if (c > '\u00ff' || i >= 8 || i == 0 && c == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                char c;
                if ((c = this.chars[offset]) == '\\') {
                    this.nameEscape = true;
                    c = this.chars[++offset];
                    switch (c) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = JSONReaderUTF16.char1(c);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                } else {
                    if (c == '\"') {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        this.stringValue = null;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int c = offset == this.end ? 26 : this.chars[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = this.chars[++offset];
        }
        this.comma = c == 44;
        if (this.comma) {
            c = ++offset == this.end ? 26 : this.chars[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = this.chars[++offset];
            }
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        int offset;
        if (JSONFactory.MIXED_HASH_ALGORITHM) {
            long nameValue = 0L;
            int i = 0;
            for (offset = this.nameBegin; offset < this.end; ++offset) {
                char c1;
                char c = this.chars[offset];
                if (c == '\\') {
                    c = this.chars[++offset];
                    switch (c) {
                        case 'u': {
                            c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = JSONReaderUTF16.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                if (c > '\u00ff' || i >= 8 || i == 0 && c == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                if ((c == '_' || c == '-') && (c1 = this.chars[offset + 1]) != '\"' && c1 != '\'' && c1 != c) continue;
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++i;
            }
            if (nameValue != 0L) {
                return nameValue;
            }
        }
        long hashCode = -3750763034362895579L;
        while (offset < this.end) {
            char c1;
            char c = this.chars[offset];
            if (c == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if ((c == '_' || c == '-') && (c1 = this.chars[++offset]) != '\"' && c1 != '\'' && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            char c = this.chars[offset];
            if (c == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        if (this.ch == '/') {
            this.skipLineComment();
        }
        if (this.ch != '\"' && this.ch != '\'') {
            return null;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (offset < this.end) {
            char c = this.chars[offset];
            if (c == '\\') {
                this.nameEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = offset < this.end ? this.chars[offset] : (char)'\u001a';
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    if (c != ':') {
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = ++offset == this.end ? (char)'\u001a' : this.chars[offset];
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    this.offset = offset + 1;
                    this.ch = c;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        if (this.nameEnd < this.nameBegin) {
            throw new JSONException("syntax error : " + offset);
        }
        if (!this.nameEscape) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            switch (this.nameLength) {
                case 1: {
                    char c0 = this.chars[this.nameBegin];
                    if ((c0 & 0xFF) != c0) break;
                    nameValue0 = (byte)c0;
                    break;
                }
                case 2: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1) break;
                    nameValue0 = ((byte)c1 << 8) + c0;
                    break;
                }
                case 3: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2) break;
                    nameValue0 = (c2 << 16) + (c1 << 8) + c0;
                    break;
                }
                case 4: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3) break;
                    nameValue0 = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                    break;
                }
                case 5: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4) break;
                    nameValue0 = ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 6: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5) break;
                    nameValue0 = ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 7: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6) break;
                    nameValue0 = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 8: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7) break;
                    nameValue0 = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 9: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8) break;
                    nameValue0 = c0;
                    nameValue1 = ((long)c8 << 56) + ((long)c7 << 48) + ((long)c6 << 40) + ((long)c5 << 32) + ((long)c4 << 24) + ((long)c3 << 16) + ((long)c2 << 8) + (long)c1;
                    break;
                }
                case 10: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9) break;
                    nameValue0 = c1 << 8 + c0;
                    nameValue1 = ((long)c9 << 56) + ((long)c8 << 48) + ((long)c7 << 40) + ((long)c6 << 32) + ((long)c5 << 24) + ((long)c4 << 16) + ((long)c3 << 8) + (long)c2;
                    break;
                }
                case 11: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10) break;
                    nameValue0 = c2 << 16 + (c1 << 8) + c0;
                    nameValue1 = ((long)c10 << 56) + ((long)c9 << 48) + ((long)c8 << 40) + ((long)c7 << 32) + ((long)c6 << 24) + ((long)c5 << 16) + ((long)c4 << 8) + (long)c3;
                    break;
                }
                case 12: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11) break;
                    nameValue0 = c3 << 24 + (c2 << 16) + (c1 << 8) + c0;
                    nameValue1 = ((long)c11 << 56) + ((long)c10 << 48) + ((long)c9 << 40) + ((long)c8 << 32) + ((long)c7 << 24) + ((long)c6 << 16) + ((long)c5 << 8) + (long)c4;
                    break;
                }
                case 13: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12) break;
                    nameValue0 = ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c12 << 56) + ((long)c11 << 48) + ((long)c10 << 40) + ((long)c9 << 32) + ((long)c8 << 24) + ((long)c7 << 16) + ((long)c6 << 8) + (long)c5;
                    break;
                }
                case 14: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    char c13 = this.chars[this.nameBegin + 13];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13) break;
                    nameValue0 = ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c13 << 56) + ((long)c12 << 48) + ((long)c11 << 40) + ((long)c10 << 32) + ((long)c9 << 24) + ((long)c8 << 16) + ((long)c7 << 8) + (long)c6;
                    break;
                }
                case 15: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    char c13 = this.chars[this.nameBegin + 13];
                    char c14 = this.chars[this.nameBegin + 14];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13 || (c14 & 0xFF) != c14) break;
                    nameValue0 = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c14 << 56) + ((long)c13 << 48) + ((long)c12 << 40) + ((long)c11 << 32) + ((long)c10 << 24) + ((long)c9 << 16) + ((long)c8 << 8) + (long)c7;
                    break;
                }
                case 16: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    char c13 = this.chars[this.nameBegin + 13];
                    char c14 = this.chars[this.nameBegin + 14];
                    char c15 = this.chars[this.nameBegin + 15];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13 || (c14 & 0xFF) != c14 || (c15 & 0xFF) != c15) break;
                    nameValue0 = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c15 << 56) + ((long)c14 << 48) + ((long)c13 << 40) + ((long)c12 << 32) + ((long)c11 << 24) + ((long)c10 << 16) + ((long)c9 << 8) + (long)c8;
                    break;
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    int indexMask = (int)nameValue1 & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        String name = this.str != null ? this.str.substring(this.nameBegin, this.nameEnd) : new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value0 == nameValue1) {
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)nameValue0 & JSONFactory.NAME_CACHE.length - 1;
                    JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        String name = this.str != null ? this.str.substring(this.nameBegin, this.nameEnd) : new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
                        JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, nameValue0);
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        return entry.name;
                    }
                }
            }
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
        }
        return this.getFieldName();
    }

    @Override
    public boolean skipName() {
        char c;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException(this.info("not support unquoted name"));
        }
        char quote = this.ch;
        int offset = this.offset;
        while (true) {
            if ((c = this.chars[offset]) == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
                continue;
            }
            if (c == quote) {
                c = this.chars[++offset];
                while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                    c = this.chars[++offset];
                }
                if (c != ':') {
                    throw new JSONException("syntax error, expect ',', but '" + c + "'");
                }
                c = this.chars[++offset];
                while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                    c = this.chars[++offset];
                }
                break;
            }
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = c;
        return true;
    }

    @Override
    public int readInt32Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.intValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("int overflow, value " + bigInteger);
                }
            }
            if (this.valueType == 5 && (this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                throw new JSONException(this.info("int value not support input null"));
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (!this.csv) {
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public Integer readInt32() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.chars[this.offset++];
                    this.nextIfMatch(',');
                }
                return null;
            }
        } else if (this.csv && (this.ch == ',' || this.ch == '\r' || this.ch == '\n')) {
            return null;
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (!this.csv) {
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.chars[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = this.chars[this.offset++];
                    }
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public long readInt64Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.longValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("long overflow, value " + bigInteger);
                }
            }
            return this.getInt64Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (!this.csv) {
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public Long readInt64() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfMatch(',');
                return null;
            }
        } else if (this.csv && (this.ch == ',' || this.ch == '\r' || this.ch == '\n')) {
            return null;
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            return this.getInt64();
        }
        if (quote != '\u0000') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (!this.csv) {
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.chars[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = this.chars[this.offset++];
                    }
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public double readDoubleValue() {
        this.wasNull = false;
        boolean value = false;
        double doubleValue = 0.0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfMatch(',');
                this.wasNull = true;
                return 0.0;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = this.chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = this.chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = this.chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 'l') {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.chars[this.offset++] == 'r' && this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'e') {
                    value = true;
                    doubleValue = 1.0;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.chars[this.offset++] == 'a' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 's' && this.chars[this.offset++] == 'e') {
                    doubleValue = 0.0;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        String str = null;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                str = this.readString();
            } else {
                this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            }
        }
        if (!value) {
            if (str != null) {
                try {
                    doubleValue = Double.parseDouble(str);
                }
                catch (NumberFormatException ex) {
                    throw new JSONException(this.info(), ex);
                }
            } else {
                doubleValue = TypeUtils.parseDouble(this.chars, start - 1, len);
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            }
        }
        if (!this.csv) {
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.chars[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = this.chars[this.offset++];
                    }
                }
            }
        }
        return doubleValue;
    }

    @Override
    public float readFloatValue() {
        this.wasNull = false;
        boolean value = false;
        float floatValue = 0.0f;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfMatch(',');
                this.wasNull = true;
                return 0.0f;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = this.chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = this.chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = this.chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 'l') {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.chars[this.offset++] == 'r' && this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'e') {
                    value = true;
                    floatValue = 1.0f;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.chars[this.offset++] == 'a' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 's' && this.chars[this.offset++] == 'e') {
                    floatValue = 0.0f;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        String str = null;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                str = this.readString();
            } else {
                this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            }
        }
        if (!value) {
            if (str != null) {
                try {
                    floatValue = Float.parseFloat(str);
                }
                catch (NumberFormatException ex) {
                    throw new JSONException(this.info(), ex);
                }
            } else {
                floatValue = TypeUtils.parseFloat(this.chars, start - 1, len);
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            }
        }
        if (!this.csv) {
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.chars[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = this.chars[this.offset++];
                    }
                }
            }
        }
        return floatValue;
    }

    private void skipString() {
        block11: {
            char quote = this.ch;
            this.ch = this.chars[this.offset++];
            while (true) {
                if (this.ch == '\\') {
                    if (this.offset >= this.end) {
                        throw new JSONException(this.info("illegal string, end"));
                    }
                    this.ch = this.chars[this.offset++];
                    if (this.ch == '\\' || this.ch == '\"') {
                        this.ch = this.chars[this.offset++];
                        continue;
                    }
                    if (this.ch == 'u') {
                        this.offset += 4;
                        this.ch = this.chars[this.offset++];
                        continue;
                    }
                    this.ch = JSONReaderUTF16.char1(this.ch);
                    continue;
                }
                if (this.ch == quote) {
                    this.ch = this.offset < this.end ? this.chars[this.offset++] : (char)26;
                    break block11;
                }
                if (this.offset >= this.end) break;
                this.ch = this.chars[this.offset++];
            }
            this.ch = (char)26;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
            }
            ++this.offset;
        }
    }

    @Override
    public String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.chars, this.nameBegin, length);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.chars[offset]) == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    protected void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.chars[offset]) == '\\') {
                this.valueEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) break;
                ++offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.chars[offset]) == '\\') {
                    c = this.chars[++offset];
                    switch (c) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderUTF16.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i2] = c;
                ++offset;
                ++i2;
            }
            str = new String(chars);
        } else {
            str = new String(this.chars, this.offset, offset - this.offset);
        }
        int b = ++offset == this.end ? 26 : this.chars[offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.chars[++offset];
        }
        this.comma = b == 44;
        if (this.comma) {
            this.offset = offset + 1;
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int valueLength;
            int offset;
            char quote = this.ch;
            int start = offset = this.offset;
            boolean valueEscape = false;
            int i = 0;
            char c0 = '\u0000';
            char c1 = '\u0000';
            char c2 = '\u0000';
            char c3 = '\u0000';
            boolean quoted = false;
            int upperBound = offset + (this.end - offset & 0xFFFFFFFC);
            while (offset < upperBound) {
                c0 = this.chars[offset];
                c1 = this.chars[offset + 1];
                c2 = this.chars[offset + 2];
                c3 = this.chars[offset + 3];
                if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\') break;
                if (c0 == quote || c1 == quote || c2 == quote || c3 == quote) {
                    quoted = true;
                    break;
                }
                offset += 4;
                i += 4;
            }
            if (quoted) {
                if (c0 != quote) {
                    if (c1 == quote) {
                        ++offset;
                        ++i;
                    } else if (c2 == quote) {
                        offset += 2;
                        i += 2;
                    } else if (c3 == quote) {
                        offset += 3;
                        i += 3;
                    }
                }
                valueLength = i;
            } else {
                while (true) {
                    if (offset >= this.end) {
                        throw new JSONException(this.info("invalid escape character EOI"));
                    }
                    char c = this.chars[offset];
                    if (c == '\\') {
                        valueEscape = true;
                        c = this.chars[++offset];
                        switch (c) {
                            case 'u': {
                                offset += 4;
                                break;
                            }
                            case 'x': {
                                offset += 2;
                                break;
                            }
                        }
                        ++offset;
                    } else {
                        if (c == quote) {
                            valueLength = i;
                            break;
                        }
                        ++offset;
                    }
                    ++i;
                }
            }
            if (valueEscape) {
                char[] chars = new char[valueLength];
                offset = start;
                int i2 = 0;
                while (true) {
                    char c;
                    if ((c = this.chars[offset]) == '\\') {
                        c = this.chars[++offset];
                        switch (c) {
                            case 'u': {
                                char c12 = this.chars[++offset];
                                char c22 = this.chars[++offset];
                                char c32 = this.chars[++offset];
                                char c4 = this.chars[++offset];
                                c = JSONReaderUTF16.char4(c12, c22, c32, c4);
                                break;
                            }
                            case 'x': {
                                char c12 = this.chars[++offset];
                                char c22 = this.chars[++offset];
                                c = JSONReaderUTF16.char2(c12, c22);
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            default: {
                                c = JSONReaderUTF16.char1(c);
                                break;
                            }
                        }
                    } else if (c == quote) break;
                    chars[i2] = c;
                    ++offset;
                    ++i2;
                }
                str = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
            } else {
                str = this.str != null && (JDKUtils.JVM_VERSION > 8 || JDKUtils.ANDROID) ? this.str.substring(this.offset, offset) : new String(this.chars, this.offset, offset - this.offset);
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (offset + 1 == this.end) {
                this.offset = this.end;
                this.ch = (char)26;
                this.comma = false;
                return str;
            }
            char b = this.chars[++offset];
            while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
                b = this.chars[++offset];
            }
            this.comma = b == ',';
            if (this.comma) {
                this.offset = offset + 1;
                this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            } else {
                this.offset = offset + 1;
                this.ch = b;
            }
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException("TODO : " + this.ch);
    }

    @Override
    public void skipValue() {
        block0 : switch (this.ch) {
            case '[': {
                this.next();
                int i = 0;
                while (true) {
                    if (this.ch == ']') {
                        this.next();
                        break block0;
                    }
                    if (i != 0 && !this.comma) {
                        throw new JSONValidException(this.info("illegal value"));
                    }
                    this.comma = false;
                    this.skipValue();
                    ++i;
                }
            }
            case '{': {
                this.next();
                while (true) {
                    if (this.ch == '}') {
                        this.next();
                        break block0;
                    }
                    this.skipName();
                    this.skipValue();
                }
            }
            case '\"': {
                this.skipString();
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'f': 
            case 'n': 
            case 't': {
                do {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        break block0;
                    }
                    this.ch = this.chars[this.offset++];
                    if (this.ch == '}' || this.ch == ']' || this.ch == '{' || this.ch == '[') break block0;
                    if (this.ch != '\"' && this.ch != '\'') continue;
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                } while (this.ch != ',');
                this.comma = true;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = this.chars[this.offset];
                }
                this.comma = true;
                ++this.offset;
                break;
            }
            case 'S': {
                if (this.nextIfSet()) {
                    this.skipValue();
                    break;
                }
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
            default: {
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.length) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
            }
            ++this.offset;
        } else if (!this.comma && this.ch != '}' && this.ch != ']' && this.ch != '\u001a') {
            throw new JSONValidException("offset " + this.offset);
        }
    }

    @Override
    public void skipLineComment() {
        while (true) {
            if (this.ch == '\n') {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = this.chars[this.offset];
                }
                ++this.offset;
                break;
            }
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
    }

    @Override
    public void readNumber0() {
        int digit;
        int multmin;
        int limit;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        int firstOffset = this.offset;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfMatch(',');
                this.wasNull = true;
                return;
            }
        } else if (this.csv && (this.ch == ',' || this.ch == '\r' || this.ch == '\n')) {
            this.wasNull = true;
            this.valueType = (byte)5;
            return;
        }
        int start = this.offset;
        if (this.ch == '-') {
            limit = Integer.MIN_VALUE;
            multmin = -214748364;
            this.negative = true;
            this.ch = this.chars[this.offset++];
        } else {
            if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            limit = -2147483647;
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                digit = this.ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin || this.mag3 < limit + digit) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = this.chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    digit = this.ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin || this.mag3 < limit + digit) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? this.offset - 2 - numStart : this.offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                this.stringValue = new String(this.chars, numStart, this.offset - 1 - numStart);
            } else {
                this.bigInt(this.chars, numStart, this.offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = this.chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = this.chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 'l') {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.chars[this.offset++] == 'r' && this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'e') {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.chars[this.offset++] == 'a' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 's' && this.chars[this.offset++] == 'e') {
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                this.offset = firstOffset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (!this.csv) {
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.chars[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = this.chars[this.offset++];
                    }
                }
            }
        }
    }

    @Override
    public boolean readIfNull() {
        if (this.ch == 'n' && this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else {
            return false;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        return true;
    }

    @Override
    public Date readNullOrNewDate() {
        Date date = null;
        if (this.offset + 2 < this.end && this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else if (this.offset + 1 < this.end && this.chars[this.offset] == 'e' && this.chars[this.offset + 1] == 'w') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 2];
            this.offset += 3;
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            if (this.offset + 4 < this.end && this.ch == 'D' && this.chars[this.offset] == 'a' && this.chars[this.offset + 1] == 't' && this.chars[this.offset + 2] == 'e') {
                this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
                this.offset += 4;
            } else {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            if (this.ch != '(' || this.offset >= this.end) {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            long millis = this.readInt64Value();
            if (this.ch != ')') {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            date = new Date(millis);
        } else {
            throw new JSONException("json syntax error, not match null or new Date" + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        return date;
    }

    @Override
    public boolean isNull() {
        return this.ch == 'n' && this.offset < this.end && this.chars[this.offset] == 'u';
    }

    @Override
    public boolean nextIfNull() {
        if (this.ch == 'n' && this.offset + 2 < this.end && this.chars[this.offset] == 'u') {
            this.readNull();
            return true;
        }
        return false;
    }

    @Override
    public void readNull() {
        if (this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else {
            throw new JSONException("json syntax error, not match null, offset " + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
    }

    @Override
    public UUID readUUID() {
        if (this.ch == 'n') {
            this.readNull();
            return null;
        }
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException(this.info("syntax error, can not read uuid"));
        }
        char quote = this.ch;
        if (this.offset + 32 < this.chars.length && this.chars[this.offset + 32] == quote) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1 = UUIDUtils.parse4Nibbles(this.chars, this.offset);
            if ((msb1 | (msb2 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 8)) | (msb4 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 12)) | (lsb1 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 16)) | (lsb2 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 20)) | (lsb3 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 24)) | (lsb4 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 28))) >= 0L) {
                this.offset += 33;
                this.ch = this.offset < this.end ? this.chars[this.offset++] : (char)26;
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
                this.comma = this.ch == ',';
                if (this.comma) {
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        } else if (this.offset + 36 < this.chars.length && this.chars[this.offset + 36] == quote) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1;
            char ch1 = this.chars[this.offset + 8];
            char ch2 = this.chars[this.offset + 13];
            char ch3 = this.chars[this.offset + 18];
            char ch4 = this.chars[this.offset + 23];
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-' && ((msb1 = UUIDUtils.parse4Nibbles(this.chars, this.offset)) | (msb2 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 9)) | (msb4 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 14)) | (lsb1 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 19)) | (lsb2 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 24)) | (lsb3 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 28)) | (lsb4 = UUIDUtils.parse4Nibbles(this.chars, this.offset + 32))) >= 0L) {
                this.offset += 37;
                this.ch = this.offset < this.end ? this.chars[this.offset++] : (char)26;
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
                this.comma = this.ch == ',';
                if (this.comma) {
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        }
        String str = this.readString();
        return UUID.fromString(str);
    }

    @Override
    public int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input : " + this.ch);
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        while (i < this.end && this.chars[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    protected LocalDateTime readLocalDateTime16() {
        char i1;
        int i0;
        char h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        int c0 = this.chars[this.offset];
        int c1 = this.chars[this.offset + 1];
        int c2 = this.chars[this.offset + 2];
        int c3 = this.chars[this.offset + 3];
        int c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        int c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        int c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        int c13 = this.chars[this.offset + 13];
        int c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        int s0 = 48;
        int s1 = 48;
        if (c4 == 45 && c7 == 45 && (c10 == 'T' || c10 == ' ') && c13 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
        } else if (c8 == 84 && c15 == 'Z') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c11;
            i1 = c12;
            s0 = c13;
            s1 = c14;
        } else if (c1 == 32 && c5 == 32 && c10 == ' ' && c13 == 58) {
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            int month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                throw new JSONException(this.info("illegal date input"));
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = 48;
            d1 = c0;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 17;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime17() {
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        int c0 = this.chars[this.offset];
        int c1 = this.chars[this.offset + 1];
        int c2 = this.chars[this.offset + 2];
        int c3 = this.chars[this.offset + 3];
        int c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        int c9 = this.chars[this.offset + 9];
        int c10 = this.chars[this.offset + 10];
        int c11 = this.chars[this.offset + 11];
        int c12 = this.chars[this.offset + 12];
        int c13 = this.chars[this.offset + 13];
        int c14 = this.chars[this.offset + 14];
        int c15 = this.chars[this.offset + 15];
        int c16 = this.chars[this.offset + 16];
        int nanoOfSecond = 0;
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58 && c16 == 90) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else if (c4 == 45 && c6 == 45 && (c8 == 32 || c8 == 84) && c11 == 58 && c14 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c12;
            i1 = c13;
            s0 = c15;
            s1 = c16;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            int month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month <= 0) {
                throw new JSONException(this.info("illegal date input"));
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = c0;
            d1 = c1;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = 48;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c8;
            h1 = c9;
            i0 = c10;
            i1 = c11;
            s0 = c12;
            s1 = c13;
            if (c14 >= 48 && c14 <= 57 && c15 >= 48 && c15 <= 57 && c16 >= 48 && c16 <= 57) {
                nanoOfSecond = ((c14 - 48) * 100 + (c15 - 48) * 10 + (c16 - 48)) * 1000000;
            } else {
                return null;
            }
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, nanoOfSecond);
        this.offset += 18;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime18() {
        char s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        int c9 = this.chars[this.offset + 9];
        int c10 = this.chars[this.offset + 10];
        int c11 = this.chars[this.offset + 11];
        int c12 = this.chars[this.offset + 12];
        int c13 = this.chars[this.offset + 13];
        int c14 = this.chars[this.offset + 14];
        int c15 = this.chars[this.offset + 15];
        int c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        if (c4 == '-' && c6 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c12 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime5() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        if (c2 != ':') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        this.offset += 6;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return LocalTime.of(hour, minute);
    }

    @Override
    protected LocalTime readLocalTime8() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        if (c2 != ':' || c5 != ':') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return LocalTime.of(hour, minute, second);
    }

    @Override
    public LocalDate readLocalDate8() {
        LocalDate ldt;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        int c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        if (c4 == 45 && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 49 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 51 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        try {
            ldt = LocalDate.of(year, month, dom);
        }
        catch (DateTimeException e) {
            throw new JSONException(this.info(), e);
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDate readLocalDate9() {
        LocalDate ldt;
        int d1;
        int d0;
        int m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        if (c4 == '\u5e74' && c6 == 26376 && c8 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '\ub144' && c6 == 50900 && c8 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '-' && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == '-' && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        try {
            ldt = LocalDate.of(year, month, dom);
        }
        catch (DateTimeException e) {
            throw new JSONException(this.info(), e);
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDate readLocalDate10() {
        LocalDate ldt;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        int c0 = this.chars[this.offset];
        int c1 = this.chars[this.offset + 1];
        int c2 = this.chars[this.offset + 2];
        int c3 = this.chars[this.offset + 3];
        int c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        int c9 = this.chars[this.offset + 9];
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c4 == 24180 && c6 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 45380 && c6 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 24180 && c7 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == 45380 && c7 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        try {
            ldt = LocalDate.of(year, month, dom);
        }
        catch (DateTimeException e) {
            throw new JSONException(this.info(), e);
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDate readLocalDate11() {
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        if (c4 == '\u5e74' && c7 == '\u6708' && c10 == '\u65e5') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == '\ub144' && c7 == '\uc6d4' && c10 == '\uc77c') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDate ldt = LocalDate.of(year, month, dom);
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected ZonedDateTime readZonedDateTimeX(int len) {
        ZoneId zoneId;
        int month;
        int zoneIdBegin;
        int S8;
        int S7;
        int S6;
        int S5;
        int S4;
        int S3;
        int S2;
        int S1;
        int S0;
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        int c20;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        int c0 = this.chars[this.offset];
        int c1 = this.chars[this.offset + 1];
        int c2 = this.chars[this.offset + 2];
        int c3 = this.chars[this.offset + 3];
        int c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        int c9 = this.chars[this.offset + 9];
        int c10 = this.chars[this.offset + 10];
        int c11 = this.chars[this.offset + 11];
        int c12 = this.chars[this.offset + 12];
        int c13 = this.chars[this.offset + 13];
        int c14 = this.chars[this.offset + 14];
        int c15 = this.chars[this.offset + 15];
        int c16 = this.chars[this.offset + 16];
        int c17 = this.chars[this.offset + 17];
        int c18 = this.chars[this.offset + 18];
        int c19 = len == 19 ? 32 : this.chars[this.offset + 19];
        int c21 = 48;
        int c22 = 48;
        int c23 = 48;
        int c24 = 48;
        int c25 = 48;
        int c26 = 48;
        int c27 = 48;
        int c28 = 48;
        char c29 = '\u0000';
        switch (len) {
            case 19: {
                c20 = 0;
                break;
            }
            case 20: {
                c20 = 0;
                break;
            }
            case 21: {
                c20 = this.chars[this.offset + 20];
                break;
            }
            case 22: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                break;
            }
            case 23: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                break;
            }
            case 24: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                break;
            }
            case 25: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                break;
            }
            case 26: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                break;
            }
            case 27: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                break;
            }
            case 28: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                break;
            }
            case 29: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                c28 = this.chars[this.offset + 28];
                break;
            }
            default: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                c28 = this.chars[this.offset + 28];
                c29 = this.chars[this.offset + 29];
            }
        }
        boolean isTimeZone = false;
        boolean pm = false;
        if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
        } else if (len == 20 && c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c0;
            d1 = c1;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
            isTimeZone = false;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 21 && c21 != 91 && c21 != 43 && c21 != 45 && c21 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 22 && c22 != 91 && c22 != 43 && c22 != 45 && c22 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == 124;
        } else if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 90 && c17 == 91 && len == 22 && c21 == 93) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 23 && c23 != 91 && c23 != 124 && c23 != 43 && c23 != 45 && c23 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == 124;
        } else if (len == 22 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = 48;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = false;
        } else if (len == 23 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = c12;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = false;
        } else if (len == 23 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = 48;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = false;
        } else if (len == 24 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = c13;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = false;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 24 && c24 != 91 && c24 != 124 && c24 != 43 && c24 != 45 && c24 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 25 && c25 != 91 && c25 != 124 && c25 != 43 && c25 != 45 && c25 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 26 && c26 != 91 && c26 != 124 && c26 != 43 && c26 != 45 && c26 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 27 && c27 != 91 && c27 != 124 && c27 != 43 && c27 != 45 && c27 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 27;
            isTimeZone = c27 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (len == 28 && c3 == 44 && c4 == 32 && c6 == 32 && c10 == 32 && c15 == 32 && c18 == 58 && c21 == 58 && c24 == 32) {
            y0 = c11;
            y1 = c12;
            y2 = c13;
            y3 = c14;
            month = DateUtils.month((char)c7, (char)c8, (char)c9);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c5;
            h0 = c16;
            h1 = c17;
            i0 = c19;
            i1 = c20;
            s0 = c22;
            s1 = c23;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = true;
        } else if (len == 29 && c3 == 44 && c4 == 32 && c7 == 32 && c11 == 32 && c16 == 32 && c19 == 58 && c22 == 58 && c25 == 32) {
            y0 = c12;
            y1 = c13;
            y2 = c14;
            y3 = c15;
            month = DateUtils.month((char)c8, (char)c9, (char)c10);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c5;
            d1 = c6;
            h0 = c17;
            h1 = c18;
            i0 = c20;
            i1 = c21;
            s0 = c23;
            s1 = c24;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = true;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 29 && c29 != '[' && c29 != '|' && c29 != '+' && c29 != '-' && c29 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == '|';
        } else {
            return null;
        }
        char first = this.chars[this.offset + zoneIdBegin];
        if (pm) {
            int hourValue = DateUtils.hourAfterNoon((char)h0, (char)h1);
            h0 = (char)(hourValue >> 16);
            h1 = (char)hourValue;
        }
        LocalDateTime ldt = DateUtils.localDateTime((char)y0, (char)y1, (char)y2, (char)y3, (char)m0, (char)m1, (char)d0, (char)d1, (char)h0, (char)h1, (char)i0, (char)i1, (char)s0, (char)s1, (char)S0, (char)S1, (char)S2, (char)S3, (char)S4, (char)S5, (char)S6, (char)S7, (char)S8);
        if (isTimeZone) {
            String tzStr = new String(this.chars, this.offset + zoneIdBegin, len - zoneIdBegin);
            TimeZone timeZone = TimeZone.getTimeZone(tzStr);
            zoneId = timeZone.toZoneId();
        } else if (first == 'Z') {
            zoneId = ZoneOffset.UTC;
        } else {
            String zoneIdStr = first == '+' || first == '-' ? new String(this.chars, this.offset + zoneIdBegin, len - zoneIdBegin) : (first == ' ' ? new String(this.chars, this.offset + zoneIdBegin + 1, len - zoneIdBegin - 1) : (zoneIdBegin < len ? new String(this.chars, this.offset + zoneIdBegin + 1, len - zoneIdBegin - 2) : null));
            zoneId = DateUtils.getZoneId(zoneIdStr, this.context.zoneId);
        }
        ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return zdt;
    }

    @Override
    protected LocalDateTime readLocalDateTime19() {
        int millis;
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        char c18 = this.chars[this.offset + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 >= 48 && S0 <= 57 && S1 >= 48 && S1 <= 57 && S2 >= 48 && S2 <= 57) {
            millis = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, millis);
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public long readMillis19() {
        int nanoOfSecond;
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        int d0;
        char m1;
        char m0;
        char y3;
        int y2;
        char y1;
        char y0;
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            throw new JSONException("date only support string input");
        }
        if (this.offset + 18 >= this.end) {
            this.wasNull = true;
            return 0L;
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        int c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        char c18 = this.chars[this.offset + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            int month = DateUtils.month((char)c2, c3, c4);
            if (month <= 0) {
                throw new JSONException(this.info("illegal date input"));
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = 48;
            d1 = c0;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            this.wasNull = true;
            return 0L;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < 48 || y2 > 57 || y3 < '0' || y3 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 >= 48 && S0 <= 57 && S1 >= 48 && S1 <= 57 && S2 >= 48 && S2 <= 57) {
            nanoOfSecond = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
            nanoOfSecond *= 1000000;
        } else {
            this.wasNull = false;
            return 0L;
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        if (this.chars[this.offset + 19] != quote) {
            throw new JSONException(this.info("illegal date input"));
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return DateUtils.millis(this.context.getZoneId(), year, month, dom, hour, minute, second, nanoOfSecond);
    }

    @Override
    protected LocalDateTime readLocalDateTimeX(int len) {
        char c20;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29) {
            throw new JSONException("illegal localDatetime string : " + this.readString());
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        char c18 = this.chars[this.offset + 18];
        char c19 = this.chars[this.offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = this.chars[this.offset + 20];
                break;
            }
            case 22: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                break;
            }
            case 23: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                break;
            }
            case 24: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                break;
            }
            case 25: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                break;
            }
            case 26: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                break;
            }
            case 27: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                break;
            }
            case 28: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                break;
            }
            default: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                c28 = this.chars[this.offset + 28];
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        LocalDateTime ldt = DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime10() {
        int millis;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        int m1 = 48;
        int m2 = 48;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= 48 && m1 <= 57 && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    protected LocalTime readLocalTime11() {
        int millis;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        int m2 = 48;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9' && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    protected LocalTime readLocalTime12() {
        int millis;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9' && m2 >= '0' && m2 <= '9') {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    protected LocalTime readLocalTime18() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        char m3 = c12;
        char m4 = c13;
        char m5 = c14;
        char m6 = c15;
        char m7 = c16;
        char m8 = c17;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9' || m2 < '0' || m2 > '9' || m3 < '0' || m3 > '9' || m4 < '0' || m4 > '9' || m5 < '0' || m5 > '9' || m6 < '0' || m6 > '9' || m7 < '0' || m7 > '9' || m8 < '0' || m8 > '9') {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    public String readPattern() {
        char c;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        int offset = this.offset;
        while ((c = this.chars[offset]) != '/' && ++offset < this.end) {
        }
        String str = new String(this.chars, this.offset, offset - this.offset);
        if (offset + 1 == this.end) {
            this.offset = this.end;
            this.ch = (char)26;
            return str;
        }
        char b = this.chars[++offset];
        while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
            b = this.chars[++offset];
        }
        this.comma = b == ',';
        if (this.comma) {
            this.offset = offset + 1;
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = b;
        }
        return str;
    }

    @Override
    public String info(String message) {
        int line = 1;
        int column = 1;
        int i = 0;
        while (i < this.offset & i < this.end) {
            if (this.chars[i] == '\n') {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        StringBuilder buf = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            buf.append(message).append(", ");
        }
        buf.append("offset ").append(this.offset).append(", character ").append(this.ch).append(", line ").append(line).append(", column ").append(column).append(", fastjson-version ").append("2.0.24").append(line > 1 ? (char)'\n' : ' ');
        int MAX_OUTPUT_LENGTH = 65535;
        buf.append(this.chars, this.start, this.length < 65535 ? this.length : 65535);
        return buf.toString();
    }

    @Override
    public void close() {
        if (this.cacheIndex != -1) {
            JSONFactory.releaseCharArray(this.cacheIndex, this.chars);
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

