/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONSchemaValidException;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FieldReaderObject<T>
extends FieldReader<T> {
    protected ObjectReader initReader;
    protected BiConsumer function;

    public FieldReaderObject(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method, Field field, BiConsumer function) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, field);
        this.function = function;
    }

    @Override
    public ObjectReader getInitReader() {
        return this.initReader;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.reader != null) {
            return this.reader;
        }
        ObjectReader formattedObjectReader = FieldReaderObject.createFormattedObjectReader(this.fieldType, this.fieldClass, this.format, this.locale);
        if (formattedObjectReader != null) {
            this.reader = formattedObjectReader;
            return this.reader;
        }
        if (this.fieldClass != null && Map.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplMap.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        if (this.fieldClass != null && Collection.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplList.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        this.reader = jsonReader.getObjectReader(this.fieldType);
        return this.reader;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader.Context context) {
        if (this.reader != null) {
            return this.reader;
        }
        ObjectReader formattedObjectReader = FieldReaderObject.createFormattedObjectReader(this.fieldType, this.fieldClass, this.format, this.locale);
        if (formattedObjectReader != null) {
            this.reader = formattedObjectReader;
            return this.reader;
        }
        if (Map.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplMap.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        if (Collection.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplList.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        this.reader = context.getObjectReader(this.fieldType);
        return this.reader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        ObjectReader formattedObjectReader;
        if (!this.fieldClassSerializable) {
            long contextFeatures = jsonReader.getContext().getFeatures();
            if ((contextFeatures & JSONReader.Feature.IgnoreNoneSerializable.mask) != 0L) {
                jsonReader.skipValue();
                return;
            }
            if ((contextFeatures & JSONReader.Feature.ErrorOnNoneSerializable.mask) != 0L) {
                throw new JSONException("not support none-Serializable");
            }
        }
        ObjectReader objectReader = this.initReader != null ? this.initReader : ((formattedObjectReader = FieldReaderObject.createFormattedObjectReader(this.fieldType, this.fieldClass, this.format, this.locale)) != null ? (this.initReader = formattedObjectReader) : (this.initReader = jsonReader.getContext().getObjectReader(this.fieldType)));
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if ("..".equals(reference)) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        try {
            ObjectReader autoTypeObjectReader;
            Object value = jsonReader.nextIfNull() ? (this.fieldClass == OptionalInt.class ? OptionalInt.empty() : (this.fieldClass == OptionalLong.class ? OptionalLong.empty() : (this.fieldClass == OptionalDouble.class ? OptionalDouble.empty() : (this.fieldClass == Optional.class ? Optional.empty() : null)))) : (jsonReader.isJSONB() ? (this.fieldClass == Object.class ? ((autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, this.features)) != null ? autoTypeObjectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features) : jsonReader.readAny()) : objectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features)) : objectReader.readObject(jsonReader, this.fieldType, this.fieldName, this.features));
            this.accept(object, value);
            if (this.noneStaticMemberClass) {
                BeanUtils.setNoneStaticMemberClassParent(value, object);
            }
        }
        catch (JSONSchemaValidException ex) {
            throw ex;
        }
        catch (Exception | IllegalAccessError ex) {
            AccessibleObject member = this.field != null ? this.field : this.method;
            String message = member != null ? "read field '" + member.getDeclaringClass().getName() + "." + member.getName() : "read field " + this.fieldName + " error";
            throw new JSONException(jsonReader.info(message), ex);
        }
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        if (!this.fieldClassSerializable && jsonReader.getType() != -110) {
            long contextFeatures = jsonReader.getContext().getFeatures();
            if ((contextFeatures & JSONReader.Feature.IgnoreNoneSerializable.mask) != 0L) {
                jsonReader.skipValue();
                return;
            }
            if ((contextFeatures & JSONReader.Feature.ErrorOnNoneSerializable.mask) != 0L) {
                throw new JSONException("not support none-Serializable");
            }
        }
        if (this.initReader == null) {
            this.initReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if ("..".equals(reference)) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        Object value = this.initReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features);
        this.accept(object, value);
    }

    @Override
    public void accept(T object, boolean value) {
        this.accept(object, (Object)value);
    }

    @Override
    public void accept(T object, byte value) {
        this.accept(object, (Object)value);
    }

    @Override
    public void accept(T object, short value) {
        this.accept(object, (Object)value);
    }

    @Override
    public void accept(T object, int value) {
        this.accept(object, (Object)value);
    }

    @Override
    public void accept(T object, long value) {
        this.accept(object, (Object)value);
    }

    @Override
    public void accept(T object, float value) {
        this.accept(object, Float.valueOf(value));
    }

    @Override
    public void accept(T object, double value) {
        this.accept(object, (Object)value);
    }

    @Override
    public void accept(T object, char value) {
        this.accept(object, Character.valueOf(value));
    }

    @Override
    public void accept(T object, Object value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        if (value == null && (this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
            return;
        }
        if (this.fieldClass == Character.TYPE && value instanceof String) {
            String str = (String)value;
            value = str.length() > 0 ? Character.valueOf(str.charAt(0)) : Character.valueOf('\u0000');
        }
        if (value != null && !this.fieldClass.isInstance(value)) {
            value = TypeUtils.cast(value, this.fieldType);
        }
        if (this.function != null) {
            try {
                this.function.accept(object, value);
            }
            catch (Exception e) {
                throw new JSONException("set " + super.toString() + " error", e);
            }
            return;
        }
        try {
            if (this.method != null) {
                this.method.invoke(object, value);
                return;
            }
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        if (this.initReader == null) {
            this.initReader = this.getObjectReader(jsonReader);
        }
        Object object = jsonReader.isJSONB() ? this.initReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features) : this.initReader.readObject(jsonReader, this.fieldType, this.fieldName, this.features);
        Function builder = this.initReader.getBuildFunction();
        if (builder != null) {
            object = builder.apply(object);
        }
        return object;
    }

    @Override
    public void processExtra(JSONReader jsonReader, Object object) {
        String name;
        FieldReader extraField;
        if (this.initReader == null) {
            this.initReader = this.getObjectReader(jsonReader);
        }
        if (this.initReader instanceof ObjectReaderBean && this.field != null && (extraField = this.initReader.getFieldReader(name = jsonReader.getFieldName())) != null) {
            try {
                Object unwrappedFieldValue = this.field.get(object);
                if (unwrappedFieldValue == null) {
                    unwrappedFieldValue = this.initReader.createInstance(this.features);
                    this.accept(object, unwrappedFieldValue);
                }
                extraField.readFieldValue(jsonReader, unwrappedFieldValue);
                return;
            }
            catch (Exception e) {
                throw new JSONException("read unwrapped field error", e);
            }
        }
        jsonReader.skipValue();
    }
}

