/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.filter.ExtraProcessor;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class ObjectReaderBean<T>
implements ObjectReader<T> {
    protected final Class objectClass;
    protected final Supplier<T> creator;
    protected final Function buildFunction;
    protected final long features;
    protected final String typeName;
    protected final long typeNameHash;
    protected FieldReader extraFieldReader;
    protected boolean hasDefaultValue;
    protected boolean serializable;
    protected final JSONSchema schema;
    protected JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler;

    protected ObjectReaderBean(Class objectClass, Supplier<T> creator, String typeName, long features, JSONSchema schema, Function buildFunction) {
        if (typeName == null && objectClass != null) {
            typeName = TypeUtils.getTypeName(objectClass);
        }
        this.objectClass = objectClass;
        this.creator = creator;
        this.buildFunction = buildFunction;
        this.features = features;
        this.typeName = typeName;
        this.typeNameHash = typeName != null ? Fnv.hashCode64(typeName) : 0L;
        this.schema = schema;
        this.serializable = objectClass != null && Serializable.class.isAssignableFrom(objectClass);
    }

    @Override
    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    protected T processObjectInputSingleItemArray(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Type itemType;
        List list;
        String message = "expect {, but [, class " + this.typeName;
        if (fieldName != null) {
            message = message + ", parent fieldName " + fieldName;
        }
        String info = jsonReader.info(message);
        long featuresAll = jsonReader.features(features);
        if ((featuresAll & JSONReader.Feature.SupportSmartMatch.mask) != 0L && (list = jsonReader.readArray(itemType = fieldType == null ? this.objectClass : fieldType)).size() == 1) {
            return (T)list.get(0);
        }
        throw new JSONException(info);
    }

    protected void processExtra(JSONReader jsonReader, Object object) {
        String fieldName1;
        long hashCode64LCase;
        FieldReader fieldReader;
        String fieldName;
        if (this.extraFieldReader != null && object != null) {
            this.extraFieldReader.processExtra(jsonReader, object);
            return;
        }
        if ((jsonReader.features(this.features) & JSONReader.Feature.SupportSmartMatch.mask) != 0L && (fieldName = jsonReader.getFieldName()).startsWith("is") && (fieldReader = this.getFieldReaderLCase(hashCode64LCase = Fnv.hashCode64LCase(fieldName1 = fieldName.substring(2)))) != null && fieldReader.fieldClass == Boolean.class) {
            fieldReader.readFieldValue(jsonReader, object);
            return;
        }
        ExtraProcessor extraProcessor = jsonReader.getContext().getExtraProcessor();
        if (extraProcessor != null) {
            String fieldName2 = jsonReader.getFieldName();
            Type type = extraProcessor.getType(fieldName2);
            Object extraValue = jsonReader.read(type);
            extraProcessor.processExtra(object, fieldName2, extraValue);
            return;
        }
        jsonReader.skipValue();
    }

    @Override
    public void acceptExtra(Object object, String fieldName, Object fieldValue) {
        if (this.extraFieldReader == null || object == null) {
            return;
        }
        this.extraFieldReader.acceptExtra(object, fieldName, fieldValue);
    }

    public ObjectReader checkAutoType(JSONReader jsonReader, Class expectClass, long features) {
        if (jsonReader.nextIfMatch((byte)-110)) {
            boolean isSupportAutoType;
            ObjectReader autoTypeObjectReader;
            String typeName;
            long typeHash = jsonReader.readTypeHashCode();
            JSONReader.Context context = jsonReader.getContext();
            JSONReader.AutoTypeBeforeHandler autoTypeFilter = context.getContextAutoTypeBeforeHandler();
            if (autoTypeFilter != null) {
                Class<?> filterClass = autoTypeFilter.apply(typeHash, expectClass, features);
                if (filterClass == null) {
                    typeName = jsonReader.getString();
                    filterClass = autoTypeFilter.apply(typeName, expectClass, features);
                }
                if (filterClass != null) {
                    return context.getObjectReader(filterClass);
                }
            }
            if ((autoTypeObjectReader = context.getObjectReaderAutoType(typeHash)) == null) {
                typeName = jsonReader.getString();
                autoTypeObjectReader = context.getObjectReaderAutoType(typeName, expectClass, features);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException(jsonReader.info("auotype not support"));
            }
            if (typeHash == this.typeNameHash) {
                return this;
            }
            boolean bl = isSupportAutoType = ((context.getFeatures() | features) & JSONReader.Feature.SupportAutoType.mask) != 0L;
            if (!isSupportAutoType) {
                return null;
            }
            return autoTypeObjectReader;
        }
        return null;
    }

    protected void initDefaultValue(T object) {
    }

    public void readObject(JSONReader jsonReader, Object object, long features) {
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return;
        }
        boolean objectStart = jsonReader.nextIfMatch('{');
        if (!objectStart) {
            throw new JSONException(jsonReader.info());
        }
        while (!jsonReader.nextIfMatch('}')) {
            long hash = jsonReader.readFieldNameHashCode();
            FieldReader fieldReader = this.getFieldReader(hash);
            if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
            }
            if (fieldReader == null) {
                this.processExtra(jsonReader, object);
                continue;
            }
            fieldReader.readFieldValue(jsonReader, object);
        }
        jsonReader.nextIfMatch(',');
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.nextIfNullOrEmptyString()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        long featuresAll = jsonReader.features(this.getFeatures() | features);
        if (jsonReader.isArray()) {
            if ((featuresAll & JSONReader.Feature.SupportArrayToBean.mask) != 0L) {
                return this.readArrayMappingObject(jsonReader, fieldType, fieldName, features);
            }
            return this.processObjectInputSingleItemArray(jsonReader, fieldType, fieldName, featuresAll);
        }
        Object object = null;
        boolean objectStart = jsonReader.nextIfMatch('{');
        if (!objectStart) {
            char ch = jsonReader.current();
            if (ch == 't' || ch == 'f') {
                jsonReader.readBoolValue();
                return null;
            }
            if (ch != '\"' && ch != '\'' && ch != '}') {
                throw new JSONException(jsonReader.info());
            }
        }
        int i = 0;
        while (true) {
            long features3;
            if (jsonReader.nextIfMatch('}')) {
                if (object != null || (object = (Object)this.createInstance(jsonReader.getContext().getFeatures() | features)) == null || (featuresAll & JSONReader.Feature.InitStringFieldAsEmpty.mask) == 0L) break;
                this.initStringFieldAsEmpty(object);
                break;
            }
            JSONReader.Context context = jsonReader.getContext();
            long hash = jsonReader.readFieldNameHashCode();
            JSONReader.AutoTypeBeforeHandler autoTypeFilter = this.autoTypeBeforeHandler;
            if (autoTypeFilter == null) {
                autoTypeFilter = context.getContextAutoTypeBeforeHandler();
            }
            if (i == 0 && hash == this.getTypeKeyHash() && (((features3 = features | this.getFeatures() | context.getFeatures()) & JSONReader.Feature.SupportAutoType.mask) != 0L || autoTypeFilter != null)) {
                Class<?> filterClass;
                ObjectReader reader = null;
                long typeHash = jsonReader.readTypeHashCode();
                if (autoTypeFilter != null && (filterClass = autoTypeFilter.apply(typeHash, this.objectClass, features3)) == null && (filterClass = autoTypeFilter.apply(jsonReader.getString(), this.objectClass, features3)) != null) {
                    reader = context.getObjectReader(filterClass);
                }
                if (reader == null) {
                    reader = this.autoType(context, typeHash);
                }
                String typeName = null;
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass, features3)) == null) {
                    throw new JSONException(jsonReader.info("No suitable ObjectReader found for" + typeName));
                }
                if (reader != this) {
                    FieldReader fieldReader = reader.getFieldReader(hash);
                    if (fieldReader != null && typeName == null) {
                        typeName = jsonReader.getString();
                    }
                    object = reader.readObject(jsonReader, null, null, features | this.getFeatures());
                    if (fieldReader != null) {
                        fieldReader.accept(object, typeName);
                    }
                    return object;
                }
            } else {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (object == null) {
                    object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                }
                if (fieldReader == null) {
                    this.processExtra(jsonReader, object);
                } else {
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            object = buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    protected void initStringFieldAsEmpty(Object object) {
    }

    public JSONReader.AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public void setAutoTypeBeforeHandler(JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }
}

