/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterPretty;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.JSONWriterUTF16JDK8;
import com.alibaba.fastjson2.JSONWriterUTF16JDK8UF;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.JSONWriterUTF8JDK9;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.BeforeFilter;
import com.alibaba.fastjson2.filter.ContextNameFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderNoneDefaultConstructor;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.MultiType;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public interface JSON {
    public static final String VERSION = "2.0.28";

    public static Object parse(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            Object object;
            char ch = reader.current();
            if (reader.context.objectSupplier == null && (reader.context.features & JSONReader.Feature.UseNativeObject.mask) == 0L && (ch == '{' || ch == '[')) {
                if (ch == '{') {
                    JSONObject jsonObject = new JSONObject();
                    reader.read(jsonObject, 0L);
                    object = jsonObject;
                } else {
                    JSONArray array = new JSONArray();
                    reader.read(array);
                    object = array;
                }
                if (reader.resolveTasks != null) {
                    reader.handleResolveTasks(object);
                }
            } else {
                ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
                object = objectReader.readObject(reader, null, null, 0L);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, int offset, int length, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, offset, length);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, context);){
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(byte[] bytes, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(char[] chars, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(chars);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static JSONObject parseObject(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, int offset, int length, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, offset, length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(Reader input, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(input);){
            if (reader.isEnd()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream input, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8);){
            if (reader.isEnd()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(chars);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream in, Charset charset) {
        if (in == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(in, charset);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static <T> T parseObject(ByteBuffer buffer, Class<T> objectClass) {
        if (buffer == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(buffer, null);){
            ObjectReader objectReader = reader.getObjectReader(objectClass);
            Object object = objectReader.readObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static JSONObject parseObject(URL url) {
        JSONObject jSONObject;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONObject = JSON.parseObject(is, StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("JSON#parseObject cannot parse '" + url + "'", e);
                }
            }
            is.close();
        }
        return jSONObject;
    }

    public static JSONObject parseObject(byte[] bytes, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(char[] chars, int offset, int length, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(chars, offset, length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, Charset charset, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            reader.context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            if (reader.nextIfNull()) {
                T t = null;
                return t;
            }
            JSONReader.Context context = reader.context;
            reader.context.config(filter, features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, String format, Filter[] filters, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            if (reader.nextIfNull()) {
                T t = null;
                return t;
            }
            JSONReader.Context context = reader.context;
            context.setDateFormat(format);
            context.config(filters, features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            ObjectReader objectReader = reader.context.provider.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type ... types) {
        return JSON.parseObject(text, (Type)new MultiType(types));
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            context.config(features);
            Type type = typeReference.getType();
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            context.config(filter, features);
            Type type = typeReference.getType();
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            context.config(features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, int offset, int length, Class<T> clazz, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, offset, length);){
            JSONReader.Context context = reader.context;
            context.config(features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, context);){
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setDateFormat(format);
            }
            context.config(features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(filter, features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setDateFormat(format);
            }
            context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, int offset, int length, Type type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(chars, offset, length);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, Class<T> clazz) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(chars);){
            ObjectReader objectReader = reader.getObjectReader(clazz);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader reader = JSONReader.of(bytes);
        ObjectReader objectReader = reader.getObjectReader(type);
        Object object = objectReader.readObject(reader, type, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
            throw new JSONException(reader.info("input not end"));
        }
        return object;
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            ObjectReader objectReader = reader.getObjectReader(clazz);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] utf8Bytes, Class<T> clazz, Filter filter, JSONReader.Feature ... features) {
        if (utf8Bytes == null || utf8Bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(utf8Bytes);){
            JSONReader.Context context = reader.context;
            reader.context.config(filter, features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] utf8Bytes, Class<T> clazz, JSONReader.Context context) {
        if (utf8Bytes == null || utf8Bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(utf8Bytes, context);){
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] utf8Bytes, Type type, String format, Filter[] filters, JSONReader.Feature ... features) {
        if (utf8Bytes == null || utf8Bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(utf8Bytes);){
            JSONReader.Context context = reader.context;
            context.setDateFormat(format);
            context.config(filters, features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(clazz);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, Filter filter, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(filter, features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, String format, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setDateFormat(format);
            }
            context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(Reader input, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(input);){
            if (reader.isEnd()) {
                T t = null;
                return t;
            }
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8);){
            if (reader.isEnd()) {
                T t = null;
                return t;
            }
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Type type, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            T t = JSON.parseObject(is, type, features);
            return t;
        }
        catch (IOException e) {
            throw new JSONException("parseObject error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Class<T> objectClass, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            T t = JSON.parseObject(is, objectClass, features);
            return t;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse '" + url + "' to '" + objectClass + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Function<JSONObject, T> function, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            JSONObject object = JSON.parseObject(is, features);
            if (object == null) {
                T t = null;
                return t;
            }
            JSONObject jSONObject = function.apply(object);
            return (T)jSONObject;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse '" + url + "'", e);
        }
    }

    public static <T> T parseObject(InputStream input, Type type, String format, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setDateFormat(format);
            }
            context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Charset charset, Type type, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(input, charset);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset);){
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> void parseObject(InputStream input, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        JSON.parseObject(input, StandardCharsets.UTF_8, '\n', type, consumer, features);
    }

    public static <T> void parseObject(InputStream input, Charset charset, char delimiter, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        int cachedIndex = System.identityHashCode(Thread.currentThread()) & 3;
        byte[] bytes = JSONFactory.allocateByteArray(cachedIndex);
        int offset = 0;
        int start = 0;
        ObjectReader objectReader = null;
        try {
            int n;
            while ((n = input.read(bytes, offset, bytes.length - offset)) != -1) {
                int k = offset;
                offset += n;
                boolean dispose = false;
                while (k < offset) {
                    if (bytes[k] == delimiter) {
                        int end = k;
                        JSONReader jsonReader = JSONReader.of(bytes, start, end - start, charset);
                        jsonReader.context.config(features);
                        if (objectReader == null) {
                            objectReader = jsonReader.getObjectReader(type);
                        }
                        Object object = objectReader.readObject(jsonReader, type, null, 0L);
                        if (jsonReader.resolveTasks != null) {
                            jsonReader.handleResolveTasks(object);
                        }
                        if (jsonReader.ch != '\u001a' && (jsonReader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                            throw new JSONException(jsonReader.info("input not end"));
                        }
                        consumer.accept(object);
                        start = end + 1;
                        dispose = true;
                    }
                    ++k;
                }
                if (offset != bytes.length) continue;
                if (dispose) {
                    int len = bytes.length - start;
                    System.arraycopy(bytes, start, bytes, 0, len);
                    start = 0;
                    offset = len;
                    continue;
                }
                bytes = Arrays.copyOf(bytes, bytes.length + 8192);
            }
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse the 'InputStream' to '" + type + "'", e);
        }
        finally {
            JSONFactory.releaseByteArray(cachedIndex, bytes);
        }
    }

    public static <T> void parseObject(Reader input, char delimiter, Type type, Consumer<T> consumer) {
        int cachedIndex = System.identityHashCode(Thread.currentThread()) & 3;
        char[] chars = JSONFactory.allocateCharArray(cachedIndex);
        int offset = 0;
        int start = 0;
        ObjectReader objectReader = null;
        try {
            int n;
            while ((n = input.read(chars, offset, chars.length - offset)) != -1) {
                int k = offset;
                offset += n;
                boolean dispose = false;
                while (k < offset) {
                    if (chars[k] == delimiter) {
                        int end = k;
                        JSONReader jsonReader = JSONReader.of(chars, start, end - start);
                        if (objectReader == null) {
                            objectReader = jsonReader.getObjectReader(type);
                        }
                        consumer.accept(objectReader.readObject(jsonReader, type, null, 0L));
                        start = end + 1;
                        dispose = true;
                    }
                    ++k;
                }
                if (offset != chars.length) continue;
                if (dispose) {
                    int len = chars.length - start;
                    System.arraycopy(chars, start, chars, 0, len);
                    start = 0;
                    offset = len;
                    continue;
                }
                chars = Arrays.copyOf(chars, chars.length + 8192);
            }
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse the 'Reader' to '" + type + "'", e);
        }
        finally {
            JSONFactory.releaseCharArray(cachedIndex, chars);
        }
    }

    public static JSONArray parseArray(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(chars);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(URL url, JSONReader.Feature ... features) {
        JSONArray jSONArray;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONArray = JSON.parseArray(is, features);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("JSON#parseArray cannot parse '" + url + "' to '" + JSONArray.class + "'", e);
                }
            }
            is.close();
        }
        return jSONArray;
    }

    public static JSONArray parseArray(InputStream in, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(in, StandardCharsets.UTF_8);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            reader.context.config(features);
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type ... types) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            List list = reader.readList(types);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(char[] chars, Class<T> type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(chars);){
            reader.context.config(features);
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type[] types, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ArrayList array = new ArrayList(types.length);
        try (JSONReader reader = JSONReader.of(text);){
            if (reader.nextIfNull()) {
                List<T> list = null;
                return list;
            }
            reader.context.config(features);
            reader.startArray();
            for (Type itemType : types) {
                array.add(reader.read(itemType));
            }
            reader.endArray();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            ArrayList arrayList = array;
            return arrayList;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, int offset, int length, Charset charset, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset);){
            reader.context.config(features);
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (reader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static String toJSONString(Object object) {
        boolean pretty;
        JSONWriter.Context writeContext = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider);
        boolean bl = pretty = (writeContext.features & JSONWriter.Feature.PrettyFormat.mask) != 0L;
        JSONWriter jsonWriter = JDKUtils.JVM_VERSION == 8 ? (JDKUtils.FIELD_STRING_VALUE != null && !JDKUtils.ANDROID && !JDKUtils.OPENJ9 ? new JSONWriterUTF16JDK8UF(writeContext) : new JSONWriterUTF16JDK8(writeContext)) : ((writeContext.features & JSONWriter.Feature.OptimizedForAscii.mask) != 0L ? (JDKUtils.STRING_VALUE != null ? (JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF8 != null ? JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF8.apply(writeContext) : new JSONWriterUTF8JDK9(writeContext)) : new JSONWriterUTF8(writeContext)) : (JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF16 != null ? JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF16.apply(writeContext) : new JSONWriterUTF16(writeContext)));
        JSONWriter writer = pretty ? new JSONWriterPretty(jsonWriter) : jsonWriter;
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                if (valueClass == JSONObject.class) {
                    writer.write((JSONObject)object);
                } else {
                    JSONWriter.Context context = writer.context;
                    boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                    ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                    objectWriter.write(writer, object, null, null, 0L);
                }
            }
            String string = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
            }
        }
    }

    public static String toJSONString(Object object, JSONWriter.Context context) {
        JSONWriter writer = JSONWriter.of(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
            }
        }
    }

    public static String toJSONString(Object object, JSONWriter.Feature ... features) {
        boolean pretty;
        JSONWriter.Context writeContext = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        boolean bl = pretty = (writeContext.features & JSONWriter.Feature.PrettyFormat.mask) != 0L;
        JSONWriter jsonWriter = JDKUtils.JVM_VERSION == 8 ? (JDKUtils.FIELD_STRING_VALUE != null && !JDKUtils.ANDROID && !JDKUtils.OPENJ9 ? new JSONWriterUTF16JDK8UF(writeContext) : new JSONWriterUTF16JDK8(writeContext)) : ((writeContext.features & JSONWriter.Feature.OptimizedForAscii.mask) != 0L ? (JDKUtils.STRING_VALUE != null ? (JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF8 != null ? JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF8.apply(writeContext) : new JSONWriterUTF8JDK9(writeContext)) : new JSONWriterUTF8(writeContext)) : (JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF16 != null ? JSONFactory.INCUBATOR_VECTOR_WRITER_CREATOR_UTF16.apply(writeContext) : new JSONWriterUTF16(writeContext)));
        try (JSONWriter writer = pretty ? new JSONWriterPretty(jsonWriter) : jsonWriter;){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (writeContext.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = writeContext.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter filter, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (filter != null) {
                    writer.context.configFilter(filter);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static byte[] toJSONBytes(Object object) {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter ... filters) {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            if (filters != null && filters.length != 0) {
                writer.context.configFilter(filters);
            }
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static int writeTo(OutputStream out, Object object, JSONWriter.Feature ... features) {
        JSONWriter writer = JSONWriter.ofUTF8(features);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter writer = JSONWriter.ofUTF8(features);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException("JSON#writeTo cannot serialize '" + object + "' to 'OutputStream'", e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter writer = JSONWriter.ofUTF8(features);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException("JSON#writeTo cannot serialize '" + object + "' to 'OutputStream'", e);
            }
        }
    }

    public static boolean isValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(text);
        try {
            boolean bl;
            jsonReader.skipValue();
            boolean bl2 = bl = jsonReader.isEnd() && !jsonReader.comma;
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static boolean isValid(char[] chars) {
        if (chars == null || chars.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(chars);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes, offset, length, charset);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static Object toJSON(Object object) {
        return JSON.toJSON(object, new JSONWriter.Feature[0]);
    }

    public static Object toJSON(Object object, JSONWriter.Feature ... features) {
        String str;
        Class<?> valueClass;
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        JSONWriter.Context writeContext = JSONFactory.createWriteContext(features);
        ObjectWriter<?> objectWriter = writeContext.getObjectWriter(valueClass = object.getClass(), valueClass);
        if (objectWriter instanceof ObjectWriterAdapter && !writeContext.isEnabled(JSONWriter.Feature.ReferenceDetection)) {
            ObjectWriterAdapter objectWriterAdapter = (ObjectWriterAdapter)objectWriter;
            return objectWriterAdapter.toJSONObject(object);
        }
        try (JSONWriter writer = JSONWriter.of(writeContext);){
            objectWriter.write(writer, object, null, null, 0L);
            str = writer.toString();
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new JSONException("toJSONString error", ex);
        }
        return JSON.parse(str);
    }

    public static <T> T to(Class<T> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).to(clazz, new JSONReader.Feature[0]);
        }
        return TypeUtils.cast(object, clazz, JSONFactory.getDefaultObjectReaderProvider());
    }

    public static <T> T toJavaObject(Object object, Class<T> clazz) {
        return JSON.to(clazz, object);
    }

    public static void mixIn(Class<?> target, Class<?> mixinSource) {
        JSONFactory.defaultObjectWriterProvider.mixIn(target, mixinSource);
        JSONFactory.getDefaultObjectReaderProvider().mixIn(target, mixinSource);
    }

    public static ObjectReader<?> register(Type type, ObjectReader<?> objectReader) {
        return JSONFactory.getDefaultObjectReaderProvider().register(type, objectReader);
    }

    public static ObjectReader<?> registerIfAbsent(Type type, ObjectReader<?> objectReader) {
        return JSONFactory.getDefaultObjectReaderProvider().registerIfAbsent(type, objectReader);
    }

    public static boolean register(ObjectReaderModule objectReaderModule) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return provider.register(objectReaderModule);
    }

    public static void registerSeeAlsoSubType(Class subTypeClass) {
        JSON.registerSeeAlsoSubType(subTypeClass, null);
    }

    public static void registerSeeAlsoSubType(Class subTypeClass, String subTypeClassName) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        provider.registerSeeAlsoSubType(subTypeClass, subTypeClassName);
    }

    public static boolean register(ObjectWriterModule objectWriterModule) {
        return JSONFactory.getDefaultObjectWriterProvider().register(objectWriterModule);
    }

    public static ObjectWriter<?> register(Type type, ObjectWriter<?> objectWriter) {
        return JSONFactory.getDefaultObjectWriterProvider().register(type, objectWriter);
    }

    public static ObjectWriter<?> registerIfAbsent(Type type, ObjectWriter<?> objectWriter) {
        return JSONFactory.getDefaultObjectWriterProvider().registerIfAbsent(type, objectWriter);
    }

    public static void register(Class type, Filter filter) {
        boolean writerFilter;
        boolean bl = writerFilter = filter instanceof AfterFilter || filter instanceof BeforeFilter || filter instanceof ContextNameFilter || filter instanceof ContextValueFilter || filter instanceof LabelFilter || filter instanceof NameFilter || filter instanceof PropertyFilter || filter instanceof PropertyPreFilter || filter instanceof ValueFilter;
        if (writerFilter) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(type);
            objectWriter.setFilter(filter);
        }
    }

    public static void config(JSONReader.Feature ... features) {
        for (JSONReader.Feature feature : features) {
            if (feature == JSONReader.Feature.SupportAutoType) {
                throw new JSONException("not support config global autotype support");
            }
            JSONFactory.defaultReaderFeatures |= feature.mask;
        }
    }

    public static void config(JSONReader.Feature feature, boolean state) {
        if (feature == JSONReader.Feature.SupportAutoType && state) {
            throw new JSONException("not support config global autotype support");
        }
        JSONFactory.defaultReaderFeatures = state ? (JSONFactory.defaultReaderFeatures |= feature.mask) : (JSONFactory.defaultReaderFeatures &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isEnabled(JSONReader.Feature feature) {
        return (JSONFactory.defaultReaderFeatures & feature.mask) != 0L;
    }

    public static void config(JSONWriter.Feature ... features) {
        for (JSONWriter.Feature feature : features) {
            JSONFactory.defaultWriterFeatures |= feature.mask;
        }
    }

    public static void config(JSONWriter.Feature feature, boolean state) {
        JSONFactory.defaultWriterFeatures = state ? (JSONFactory.defaultWriterFeatures |= feature.mask) : (JSONFactory.defaultWriterFeatures &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isEnabled(JSONWriter.Feature feature) {
        return (JSONFactory.defaultWriterFeatures & feature.mask) != 0L;
    }

    public static <T> T copy(T object, JSONWriter.Feature ... features) {
        byte[] jsonbBytes;
        if (object == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        if (ObjectWriterProvider.isPrimitiveOrEnum(objectClass)) {
            return object;
        }
        boolean fieldBased = false;
        boolean beanToArray = false;
        long featuresValue = 0L;
        for (JSONWriter.Feature feature : features) {
            featuresValue |= feature.mask;
            if (feature == JSONWriter.Feature.FieldBased) {
                fieldBased = true;
                continue;
            }
            if (feature != JSONWriter.Feature.BeanToArray) continue;
            beanToArray = true;
        }
        ObjectWriter objectWriter = JSONFactory.defaultObjectWriterProvider.getObjectWriter(objectClass, objectClass, fieldBased);
        ObjectReader objectReader = JSONFactory.defaultObjectReaderProvider.getObjectReader(objectClass, fieldBased);
        if (objectWriter instanceof ObjectWriterAdapter && objectReader instanceof ObjectReaderBean) {
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            if (objectReader instanceof ObjectReaderNoneDefaultConstructor) {
                HashMap<String, Object> map = new HashMap<String, Object>(fieldWriters.size());
                for (FieldWriter fieldWriter : fieldWriters) {
                    Object fieldValue = fieldWriter.getFieldValue(object);
                    map.put(fieldWriter.fieldName, fieldValue);
                }
                return objectReader.createInstance(map, featuresValue);
            }
            Object instance = objectReader.createInstance(featuresValue);
            for (FieldWriter fieldWriter : fieldWriters) {
                FieldReader fieldReader = objectReader.getFieldReader(fieldWriter.fieldName);
                if (fieldReader == null) continue;
                Object fieldValue = fieldWriter.getFieldValue(object);
                Object fieldValueCopied = JSON.copy(fieldValue, new JSONWriter.Feature[0]);
                fieldReader.accept(instance, fieldValueCopied);
            }
            return instance;
        }
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.config(JSONWriter.Feature.WriteClassName);
            objectWriter.writeJSONB(writer, object, null, null, 0L);
            jsonbBytes = writer.getBytes();
        }
        try (JSONReader jsonReader = JSONReader.ofJSONB(jsonbBytes, JSONReader.Feature.SupportAutoType, JSONReader.Feature.SupportClassForName);){
            if (beanToArray) {
                jsonReader.context.config(JSONReader.Feature.SupportArrayToBean);
            }
            Object t = objectReader.readJSONBObject(jsonReader, null, null, featuresValue);
            return t;
        }
    }

    public static <T> T copyTo(Object object, Class<T> targetClass, JSONWriter.Feature ... features) {
        byte[] jsonbBytes;
        if (object == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        boolean fieldBased = false;
        boolean beanToArray = false;
        long featuresValue = 0L;
        for (JSONWriter.Feature feature : features) {
            featuresValue |= feature.mask;
            if (feature == JSONWriter.Feature.FieldBased) {
                fieldBased = true;
                continue;
            }
            if (feature != JSONWriter.Feature.BeanToArray) continue;
            beanToArray = true;
        }
        ObjectWriter objectWriter = JSONFactory.defaultObjectWriterProvider.getObjectWriter(objectClass, objectClass, fieldBased);
        ObjectReader objectReader = JSONFactory.defaultObjectReaderProvider.getObjectReader(targetClass, fieldBased);
        if (objectWriter instanceof ObjectWriterAdapter && objectReader instanceof ObjectReaderBean) {
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            if (objectReader instanceof ObjectReaderNoneDefaultConstructor) {
                HashMap<String, Object> map = new HashMap<String, Object>(fieldWriters.size());
                for (FieldWriter fieldWriter : fieldWriters) {
                    Object fieldValue = fieldWriter.getFieldValue(object);
                    map.put(fieldWriter.fieldName, fieldValue);
                }
                return objectReader.createInstance(map, featuresValue);
            }
            Object instance = objectReader.createInstance(featuresValue);
            for (FieldWriter fieldWriter : fieldWriters) {
                FieldReader fieldReader = objectReader.getFieldReader(fieldWriter.fieldName);
                if (fieldReader == null) continue;
                Object fieldValue = fieldWriter.getFieldValue(object);
                Object fieldValueCopied = fieldWriter.fieldClass == Date.class && fieldReader.fieldClass == String.class ? DateUtils.format((Date)fieldValue, fieldWriter.format) : (fieldWriter.fieldClass == LocalDate.class && fieldReader.fieldClass == String.class ? DateUtils.format((LocalDate)fieldValue, fieldWriter.format) : (fieldValue == null || fieldReader.supportAcceptType(fieldValue.getClass()) ? fieldValue : JSON.copy(fieldValue, new JSONWriter.Feature[0])));
                fieldReader.accept(instance, fieldValueCopied);
            }
            return instance;
        }
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.config(JSONWriter.Feature.WriteClassName);
            objectWriter.writeJSONB(writer, object, null, null, 0L);
            jsonbBytes = writer.getBytes();
        }
        try (JSONReader jsonReader = JSONReader.ofJSONB(jsonbBytes, JSONReader.Feature.SupportAutoType, JSONReader.Feature.SupportClassForName);){
            if (beanToArray) {
                jsonReader.context.config(JSONReader.Feature.SupportArrayToBean);
            }
            Object t = objectReader.readJSONBObject(jsonReader, null, null, 0L);
            return t;
        }
    }
}

