/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.support.csv.CSVWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.RyuFloat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;

final class CSVWriterUTF16
extends CSVWriter {
    static final char[] BYTES_TRUE = "true".toCharArray();
    static final char[] BYTES_FALSE = "false".toCharArray();
    static final char[] BYTES_LONG_MIN = "-9223372036854775808".toCharArray();
    final Writer out;
    final char[] chars;

    CSVWriterUTF16(Writer out, ZoneId zoneId, CSVWriter.Feature ... features) {
        super(zoneId, features);
        this.out = out;
        this.chars = new char[65536];
    }

    protected void writeDirect(char[] bytes, int off, int len) {
        try {
            this.out.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeComma() {
        if (this.off + 1 == this.chars.length) {
            this.flush();
        }
        this.chars[this.off++] = 44;
    }

    @Override
    protected void writeQuote() {
        if (this.off + 1 == this.chars.length) {
            this.flush();
        }
        this.chars[this.off++] = 34;
    }

    @Override
    public void writeLine() {
        if (this.off + 1 == this.chars.length) {
            this.flush();
        }
        this.chars[this.off++] = 10;
    }

    @Override
    public void writeBoolean(boolean booleanValue) {
        char[] valueBytes = booleanValue ? BYTES_TRUE : BYTES_FALSE;
        this.writeRaw(valueBytes);
    }

    @Override
    public void writeInt64(long longValue) {
        if (longValue == Long.MIN_VALUE) {
            this.writeRaw(BYTES_LONG_MIN);
            return;
        }
        int size = longValue < 0L ? IOUtils.stringSize(-longValue) + 1 : IOUtils.stringSize(longValue);
        int minCapacity = this.off + size;
        if (minCapacity - this.chars.length > 0) {
            this.flush();
        }
        IOUtils.getChars(longValue, this.off + size, this.chars);
        this.off += size;
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        if (this.off + 10 >= this.chars.length) {
            this.flush();
        }
        this.chars[this.off++] = (char)(year / 1000 + 48);
        this.chars[this.off++] = (char)(year / 100 % 10 + 48);
        this.chars[this.off++] = (char)(year / 10 % 10 + 48);
        this.chars[this.off++] = (char)(year % 10 + 48);
        this.chars[this.off++] = 45;
        this.chars[this.off++] = (char)(month / 10 + 48);
        this.chars[this.off++] = (char)(month % 10 + 48);
        this.chars[this.off++] = 45;
        this.chars[this.off++] = (char)(dayOfMonth / 10 + 48);
        this.chars[this.off++] = (char)(dayOfMonth % 10 + 48);
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        if (this.off + 19 >= this.chars.length) {
            this.flush();
        }
        this.chars[this.off++] = (char)(year / 1000 + 48);
        this.chars[this.off++] = (char)(year / 100 % 10 + 48);
        this.chars[this.off++] = (char)(year / 10 % 10 + 48);
        this.chars[this.off++] = (char)(year % 10 + 48);
        this.chars[this.off++] = 45;
        this.chars[this.off++] = (char)(month / 10 + 48);
        this.chars[this.off++] = (char)(month % 10 + 48);
        this.chars[this.off++] = 45;
        this.chars[this.off++] = (char)(dayOfMonth / 10 + 48);
        this.chars[this.off++] = (char)(dayOfMonth % 10 + 48);
        this.chars[this.off++] = 32;
        this.chars[this.off++] = (char)(hour / 10 + 48);
        this.chars[this.off++] = (char)(hour % 10 + 48);
        this.chars[this.off++] = 58;
        this.chars[this.off++] = (char)(minute / 10 + 48);
        this.chars[this.off++] = (char)(minute % 10 + 48);
        this.chars[this.off++] = 58;
        this.chars[this.off++] = (char)(second / 10 + 48);
        this.chars[this.off++] = (char)(second % 10 + 48);
    }

    @Override
    public void writeString(String str) {
        char ch;
        int i;
        if (str == null || str.isEmpty()) {
            return;
        }
        int len = str.length();
        int escapeCount = 0;
        boolean comma = false;
        if (str.charAt(0) == '\"') {
            for (i = 0; i < len; ++i) {
                ch = str.charAt(i);
                if (ch != '\"') continue;
                ++escapeCount;
            }
        } else {
            for (i = 0; i < len; ++i) {
                ch = str.charAt(i);
                if (ch == ',') {
                    comma = true;
                    continue;
                }
                if (ch != '\"') continue;
                ++escapeCount;
            }
            if (!comma) {
                escapeCount = 0;
            }
        }
        if (escapeCount == 0) {
            str.getChars(0, str.length(), this.chars, this.off);
            this.off += str.length();
            return;
        }
        if (this.off + 2 + str.length() + escapeCount >= this.chars.length) {
            this.flush();
        }
        this.chars[this.off++] = 34;
        for (i = 0; i < str.length(); ++i) {
            ch = str.charAt(i);
            if (ch == '\"') {
                this.chars[this.off++] = 34;
                this.chars[this.off++] = 34;
                continue;
            }
            this.chars[this.off++] = ch;
        }
        this.chars[this.off++] = 34;
    }

    @Override
    public void writeInt32(int intValue) {
        if (intValue == Integer.MIN_VALUE) {
            this.writeRaw("-2147483648");
            return;
        }
        int size = intValue < 0 ? IOUtils.stringSize(-intValue) + 1 : IOUtils.stringSize(intValue);
        int minCapacity = this.off + size;
        if (minCapacity - this.chars.length > 0) {
            this.flush();
        }
        IOUtils.getChars(intValue, this.off + size, this.chars);
        this.off += size;
    }

    @Override
    public void writeDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return;
        }
        int minCapacity = this.off + 24;
        if (minCapacity - this.chars.length > 0) {
            this.flush();
        }
        int size = RyuDouble.toString(value, this.chars, this.off);
        this.off += size;
    }

    @Override
    public void writeFloat(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return;
        }
        int minCapacity = this.off + 15;
        if (minCapacity - this.chars.length > 0) {
            this.flush();
        }
        int size = RyuFloat.toString(value, this.chars, this.off);
        this.off += size;
    }

    @Override
    public void flush() {
        try {
            this.out.write(this.chars, 0, this.off);
            this.off = 0;
            this.out.flush();
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeString(byte[] utf8) {
        if (utf8 == null || utf8.length == 0) {
            return;
        }
        String str = new String(utf8, 0, utf8.length, StandardCharsets.UTF_8);
        this.writeString(str);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            return;
        }
        int minCapacity = this.off + value.precision() + 2;
        if (minCapacity - this.chars.length > 0) {
            this.flush();
        }
        int size = IOUtils.getDecimalChars(value, this.chars, this.off);
        this.off += size;
    }

    @Override
    public void writeDecimal(long unscaledVal, int scale) {
        if (scale == 0) {
            this.writeInt64(unscaledVal);
            return;
        }
        if (unscaledVal == Long.MIN_VALUE || scale > 20) {
            this.writeDecimal(BigDecimal.valueOf(unscaledVal, scale));
            return;
        }
        int minCapacity = this.off + 24;
        if (minCapacity - this.chars.length > 0) {
            this.flush();
        }
        int size = IOUtils.getDecimalChars(unscaledVal, scale, this.chars, this.off);
        this.off += size;
    }

    void writeRaw(char[] chars) {
        if (chars.length + this.off < this.chars.length) {
            System.arraycopy(chars, 0, this.chars, this.off, chars.length);
            this.off += chars.length;
        } else {
            this.flush();
            if (chars.length >= this.chars.length) {
                this.writeDirect(chars, 0, chars.length);
            } else {
                System.arraycopy(chars, 0, this.chars, this.off, chars.length);
                this.off += chars.length;
            }
        }
    }

    @Override
    public void writeLocalDateTime(LocalDateTime ldt) {
        if (ldt == null) {
            return;
        }
        this.writeDateTime19(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        int nanoValue = ldt.getNano();
        if (nanoValue == 0) {
            return;
        }
        int value = nanoValue % 1000000 == 0 ? nanoValue / 1000000 + 1000 : (nanoValue % 1000 == 0 ? nanoValue / 1000 + 1000000 : nanoValue + 1000000000);
        int off = this.off;
        this.writeInt32(value);
        this.chars[off] = 46;
    }

    @Override
    protected void writeRaw(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        if (str.length() + this.off >= this.chars.length) {
            this.flush();
        }
        str.getChars(0, str.length(), this.chars, this.off);
        this.off += str.length();
    }

    @Override
    public void close() throws IOException {
        if (this.off > 0) {
            this.flush();
        }
        this.out.close();
    }

    public String toString() {
        if (this.out instanceof StringWriter) {
            this.flush();
            return this.out.toString();
        }
        return super.toString();
    }
}

