/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONValidException;
import com.alibaba.fastjson2.util.JDKUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import java.util.UUID;

final class JSONReaderUTF16
extends JSONReader {
    private final String str;
    private final char[] chars;
    private final int length;
    private final int end;
    private int nameBegin;
    private int nameEnd;
    private int nameLength;

    JSONReaderUTF16(JSONReader.Context ctx, byte[] bytes, int offset, int length) {
        super(ctx);
        this.str = null;
        this.chars = new char[length / 2];
        int j = 0;
        int bytesEnd = offset + length;
        int i = offset;
        while (i < bytesEnd) {
            byte c0 = bytes[i];
            byte c1 = bytes[i + 1];
            this.chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
            i += 2;
            ++j;
        }
        this.end = this.length = j;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, String str, char[] chars, int offset, int length) {
        super(ctx);
        this.str = str;
        this.chars = chars;
        this.offset = offset;
        this.length = length;
        this.end = offset + length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
    }

    @Override
    public boolean nextIfMatch(char ch) {
        if (this.ch != ch) {
            return false;
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
        return true;
    }

    @Override
    public void next() {
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        this.nameEscape = false;
        this.nameBegin = this.offset - 1;
        long hashCode = -3750763034362895579L;
        int i = 0;
        block8: while (true) {
            if (this.ch == '\\') {
                this.nameEscape = true;
                this.ch = this.chars[this.offset++];
                switch (this.ch) {
                    case 'u': {
                        char c1 = this.chars[this.offset++];
                        char c2 = this.chars[this.offset++];
                        char c3 = this.chars[this.offset++];
                        char c4 = this.chars[this.offset++];
                        this.ch = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[this.offset++];
                        char c2 = this.chars[this.offset++];
                        this.ch = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        this.ch = JSONReaderUTF16.char1(this.ch);
                    }
                }
                hashCode ^= (long)this.ch;
                hashCode *= 1099511628211L;
                this.next();
            } else {
                switch (this.ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case '\u001a': 
                    case ' ': 
                    case '!': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.nameLength = i;
                        this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                            this.next();
                        }
                        break block8;
                    }
                    default: {
                        hashCode ^= (long)this.ch;
                        hashCode *= 1099511628211L;
                        this.ch = (char)(this.offset >= this.end ? 26 : this.chars[this.offset++]);
                    }
                }
            }
            ++i;
        }
        return hashCode;
    }

    @Override
    public long readFieldNameHashCode() {
        char c;
        if (this.ch != '\"' && this.ch != '\'') {
            return -1L;
        }
        char quote = this.ch;
        this.stringValue = null;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i = 0;
        while (true) {
            if ((c = this.chars[offset]) == '\\') {
                this.nameEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                    }
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    if (offset < this.end) {
                        c = this.chars[offset];
                        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                            c = this.chars[++offset];
                        }
                    } else {
                        this.ch = (char)26;
                    }
                    if (c != ':') {
                        return -1L;
                    }
                    c = this.chars[++offset];
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    break;
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = c;
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        int c;
        if (this.ch != '\"') {
            return -1L;
        }
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i = 0;
        while (true) {
            if ((c = this.chars[offset]) == 92) {
                this.nameEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 117: {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 120: {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                    }
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            } else {
                if (c == 34) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    this.stringValue = null;
                    c = offset == this.end ? 26 : this.chars[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    if (c == 44) {
                        c = this.chars[++offset];
                        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                            c = this.chars[++offset];
                        }
                    }
                    break;
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        long hashCode = -3750763034362895579L;
        int offset = this.nameBegin;
        while (offset < this.end) {
            char c = this.chars[offset];
            if (c == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            ++offset;
            if (c == '_') continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            char c = this.chars[offset];
            if (c == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        char c;
        if (this.ch == '/') {
            this.skipLineComment();
        }
        if (this.ch != '\"' && this.ch != '\'') {
            return null;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (true) {
            if ((c = this.chars[offset]) == '\\') {
                this.nameEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = offset < this.end ? this.chars[offset] : (char)'\u001a';
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    if (c != ':') {
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = this.chars[++offset];
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    break;
                }
                ++offset;
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = c;
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
        }
        return this.getFieldName();
    }

    @Override
    public boolean skipName() {
        char c;
        if (this.ch != '\"') {
            throw new JSONException("not support unquoted name");
        }
        int offset = this.offset;
        while (true) {
            if ((c = this.chars[offset]) == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
                continue;
            }
            if (c == '\"') {
                c = this.chars[++offset];
                while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                    c = this.chars[++offset];
                }
                if (c != ':') {
                    throw new JSONException("syntax error, expect ',', but '" + c + "'");
                }
                c = this.chars[++offset];
                while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                    c = this.chars[++offset];
                }
                break;
            }
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = c;
        return true;
    }

    @Override
    public int readInt32Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.intValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("int overflow, value " + bigInteger);
                }
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = this.chars[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public Integer readInt32() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfMatch(',');
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = this.chars[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public long readInt64Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.longValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("long overflow, value " + bigInteger);
                }
            }
            return this.getInt64Value();
        }
        if (quote != '\u0000') {
            this.ch = this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = this.chars[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public Long readInt64() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfMatch(',');
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            return this.getInt64();
        }
        if (quote != '\u0000') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = this.chars[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    private void skipString() {
        block9: {
            char quote = this.ch;
            this.ch = this.chars[this.offset++];
            while (true) {
                if (this.ch == '\\') {
                    this.ch = this.chars[this.offset++];
                    if (this.ch == '\\' || this.ch == '\"') {
                        this.ch = this.chars[this.offset++];
                        continue;
                    }
                    this.ch = JSONReaderUTF16.char1(this.ch);
                    continue;
                }
                if (this.ch == quote) {
                    this.ch = this.offset < this.end ? this.chars[this.offset++] : (char)26;
                    break block9;
                }
                if (this.offset >= this.end) break;
                this.ch = this.chars[this.offset++];
            }
            this.ch = (char)26;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
            }
            ++this.offset;
        }
    }

    @Override
    public String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.chars, this.nameBegin, length);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.chars[offset]) == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = JSONReaderUTF16.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    private void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.chars[offset]) == '\\') {
                this.valueEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) break;
                ++offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.chars[offset]) == '\\') {
                    c = this.chars[++offset];
                    switch (c) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderUTF16.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i2] = c;
                ++offset;
                ++i2;
            }
            str = new String(chars);
        } else {
            str = new String(this.chars, this.offset, offset - this.offset);
        }
        int b = ++offset == this.end ? 26 : this.chars[offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.chars[++offset];
        }
        if (b == 44) {
            this.offset = offset + 1;
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int valueLength;
            boolean valueEscape;
            int start;
            int offset;
            char quote;
            block41: {
                char c;
                int i;
                quote = this.ch;
                start = offset = this.offset;
                valueEscape = false;
                boolean ascii = true;
                if (JDKUtils.JVM_VERSION > 8) {
                    i = 0;
                    while (true) {
                        if ((c = this.chars[offset]) == '\\') {
                            valueEscape = true;
                            c = this.chars[++offset];
                            switch (c) {
                                case 'u': {
                                    offset += 4;
                                    break;
                                }
                                case 'x': {
                                    offset += 2;
                                    break;
                                }
                            }
                            ++offset;
                        } else {
                            if (c == quote) {
                                valueLength = i;
                                break block41;
                            }
                            ++offset;
                        }
                        ++i;
                    }
                }
                i = 0;
                while (true) {
                    if ((c = this.chars[offset]) == '\\') {
                        valueEscape = true;
                        c = this.chars[++offset];
                        switch (c) {
                            case 'u': {
                                offset += 4;
                                break;
                            }
                            case 'x': {
                                offset += 2;
                                break;
                            }
                        }
                        ++offset;
                    } else {
                        if (c == quote) {
                            valueLength = i;
                            break;
                        }
                        ++offset;
                    }
                    ++i;
                }
            }
            if (valueEscape) {
                char[] chars = new char[valueLength];
                offset = start;
                int i = 0;
                while (true) {
                    char c;
                    if ((c = this.chars[offset]) == '\\') {
                        c = this.chars[++offset];
                        switch (c) {
                            case 'u': {
                                char c1 = this.chars[++offset];
                                char c2 = this.chars[++offset];
                                char c3 = this.chars[++offset];
                                char c4 = this.chars[++offset];
                                c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                                break;
                            }
                            case 'x': {
                                char c1 = this.chars[++offset];
                                char c2 = this.chars[++offset];
                                c = JSONReaderUTF16.char2(c1, c2);
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            default: {
                                c = JSONReaderUTF16.char1(c);
                                break;
                            }
                        }
                    } else if (c == quote) break;
                    chars[i] = c;
                    ++offset;
                    ++i;
                }
                str = new String(chars);
            } else {
                str = this.str != null && JDKUtils.JVM_VERSION > 8 ? this.str.substring(this.offset, offset) : new String(this.chars, this.offset, offset - this.offset);
            }
            if (offset + 1 == this.end) {
                this.offset = this.end;
                this.ch = (char)26;
                return str;
            }
            char b = this.chars[++offset];
            while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
                b = this.chars[++offset];
            }
            if (b == ',') {
                this.offset = offset + 1;
                this.ch = this.chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            } else {
                this.offset = offset + 1;
                this.ch = b;
            }
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException("TODO : " + this.ch);
    }

    @Override
    public byte[] readBinary() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void skipValue() {
        block0 : switch (this.ch) {
            case '[': {
                this.next();
                int i = 0;
                while (true) {
                    if (this.ch == ']') {
                        this.next();
                        break block0;
                    }
                    if (i != 0 && !this.comma) {
                        throw new JSONValidException("offset " + this.offset);
                    }
                    this.comma = false;
                    this.skipValue();
                    ++i;
                }
            }
            case '{': {
                this.next();
                while (true) {
                    if (this.ch == '}') {
                        this.next();
                        break block0;
                    }
                    this.skipName();
                    this.skipValue();
                }
            }
            case '\"': {
                this.skipString();
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'f': 
            case 'n': 
            case 't': {
                do {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        break block0;
                    }
                    this.ch = this.chars[this.offset++];
                    if (this.ch == '}' || this.ch == ']' || this.ch == '{' || this.ch == '[') break block0;
                } while (this.ch != ',');
                this.comma = true;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = this.chars[this.offset];
                }
                this.comma = true;
                ++this.offset;
                break;
            }
            default: {
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.length) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
            }
            ++this.offset;
        } else if (!this.comma && this.ch != '}' && this.ch != ']' && this.ch != '\u001a') {
            throw new JSONValidException("offset " + this.offset);
        }
    }

    @Override
    void skipLineComment() {
        while (true) {
            if (this.ch == '\n') {
                ++this.offset;
                if (this.offset >= this.length) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.length) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = this.chars[this.offset];
                }
                ++this.offset;
                break;
            }
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
    }

    @Override
    public void readNumber0() {
        int digit;
        int multmin;
        int limit;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfMatch(',');
                this.wasNull = true;
                return;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            limit = Integer.MIN_VALUE;
            multmin = -214748364;
            this.negative = true;
            this.ch = this.chars[this.offset++];
        } else {
            limit = -2147483647;
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                digit = this.ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin || this.mag3 < limit + digit) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = this.chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    digit = this.ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin || this.mag3 < limit + digit) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        if (intOverflow) {
            int numStart = this.negative ? start : start - 1;
            this.bigInt(this.chars, numStart, this.offset - 1);
        } else {
            this.mag3 = -this.mag3;
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = this.chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = this.chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 512) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (byte)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 'l') {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.chars[this.offset++] == 'r' && this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'e') {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.chars[this.offset++] == 'a' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 's' && this.chars[this.offset++] == 'e') {
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = this.chars[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
    }

    @Override
    public boolean readIfNull() {
        if (this.ch == 'n' && this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else {
            return false;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        return true;
    }

    @Override
    public void readNull() {
        if (this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else {
            throw new JSONException("json syntax error, not match null" + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
    }

    @Override
    public UUID readUUID() {
        if (this.ch == 'n') {
            this.readNull();
            return null;
        }
        if (this.ch != '\"') {
            throw new JSONException("syntax error, can not read uuid, position " + this.offset);
        }
        if (this.offset + 32 < this.chars.length && this.chars[this.offset + 32] == '\"') {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset);
            if ((msb1 | (msb2 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 4)) | (msb3 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 8)) | (msb4 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 12)) | (lsb1 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 16)) | (lsb2 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 20)) | (lsb3 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 24)) | (lsb4 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 28))) >= 0L) {
                this.offset += 33;
                this.ch = this.chars[this.offset++];
                if (this.ch == ',') {
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        } else if (this.offset + 36 < this.chars.length && this.chars[this.offset + 36] == '\"') {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1;
            char ch1 = this.chars[this.offset + 8];
            char ch2 = this.chars[this.offset + 13];
            char ch3 = this.chars[this.offset + 18];
            char ch4 = this.chars[this.offset + 23];
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-' && ((msb1 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset)) | (msb2 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 4)) | (msb3 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 9)) | (msb4 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 14)) | (lsb1 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 19)) | (lsb2 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 24)) | (lsb3 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 28)) | (lsb4 = JSONFactory.UUIDUtils.parse4Nibbles(this.chars, this.offset + 32))) >= 0L) {
                this.offset += 37;
                this.ch = this.chars[this.offset++];
                if (this.ch == ',') {
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        }
        String str = this.readString();
        return UUID.fromString(str);
    }

    @Override
    public int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input : " + this.ch);
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        while (i < this.end && this.chars[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    protected LocalDateTime readLocalDateTime16() {
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        if (c4 != '-' || c7 != '-' || c10 != 'T' && c10 != ' ' || c13 != ':') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        int second = 0;
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 17;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime17() {
        int s1;
        int s0;
        int i1;
        char i0;
        char h1;
        char h0;
        char d1;
        int d0;
        int m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        int c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        int c15 = this.chars[this.offset + 15];
        int c16 = this.chars[this.offset + 16];
        if (c4 == '-' && c7 == '-' && c10 == 'T' && c13 == 58 && c16 == 90) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else if (c4 == '-' && c6 == 45 && c8 == 32 && c11 == ':' && c14 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c12;
            i1 = c13;
            s0 = c15;
            s1 = c16;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 18;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime18() {
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        int d0;
        int m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        if (c4 == '-' && c6 == 45 && c9 == ' ' && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && c9 == ' ' && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 19;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime8() {
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        if (c2 != ':' || c5 != ':') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        this.offset += 9;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, second);
    }

    @Override
    public LocalDateTime readLocalDate8() {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        int c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        if (c4 == 45 && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 9;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate9() {
        int d1;
        int d0;
        int m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        if (c4 == '\u5e74' && c6 == 26376 && c8 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '\ub144' && c6 == 50900 && c8 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '-' && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == '-' && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 10;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate10() {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (this.ch != '\"') {
            throw new JSONException("localDate only support string input");
        }
        int c0 = this.chars[this.offset];
        int c1 = this.chars[this.offset + 1];
        int c2 = this.chars[this.offset + 2];
        int c3 = this.chars[this.offset + 3];
        int c4 = this.chars[this.offset + 4];
        int c5 = this.chars[this.offset + 5];
        int c6 = this.chars[this.offset + 6];
        int c7 = this.chars[this.offset + 7];
        int c8 = this.chars[this.offset + 8];
        int c9 = this.chars[this.offset + 9];
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c4 == 24180 && c6 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 45380 && c6 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 24180 && c7 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == 45380 && c7 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 11;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate11() {
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        if (c4 == '\u5e74' && c7 == '\u6708' && c10 == '\u65e5') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == '\ub144' && c7 == '\uc6d4' && c10 == '\uc77c') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 12;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected ZonedDateTime readZonedDateTimeX(int len) {
        ZoneId zoneId;
        int zoneIdBegin;
        int S8;
        char S7;
        char S6;
        char S5;
        char S4;
        char S3;
        char S2;
        char S1;
        char S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        char c20;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        char c18 = this.chars[this.offset + 18];
        int c19 = len == 19 ? 32 : this.chars[this.offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        int c28 = 48;
        int c29 = 0;
        switch (len) {
            case 19: {
                c20 = '\u0000';
                break;
            }
            case 20: {
                c20 = '\u0000';
                break;
            }
            case 21: {
                c20 = this.chars[this.offset + 20];
                break;
            }
            case 22: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                break;
            }
            case 23: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                break;
            }
            case 24: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                break;
            }
            case 25: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                break;
            }
            case 26: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                break;
            }
            case 27: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                break;
            }
            case 28: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                break;
            }
            case 29: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                c28 = this.chars[this.offset + 28];
                break;
            }
            default: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                c28 = this.chars[this.offset + 28];
                c29 = this.chars[this.offset + 29];
            }
        }
        boolean isTimeZone = false;
        if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 19;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 21 && c21 != '[' && c21 != '+' && c21 != '-' && c21 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 22 && c22 != '[' && c22 != '+' && c22 != '-' && c22 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == '|';
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == 'Z' && c17 == '[' && len == 22 && c21 == ']') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = '0';
            s1 = '0';
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 23 && c23 != '[' && c23 != '|' && c23 != '+' && c23 != '-' && c23 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 24 && c24 != '[' && c24 != '|' && c24 != '+' && c24 != '-' && c24 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 25 && c25 != '[' && c25 != '|' && c25 != '+' && c25 != '-' && c25 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 26 && c26 != '[' && c26 != '|' && c26 != '+' && c26 != '-' && c26 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 27 && c27 != '[' && c27 != '|' && c27 != '+' && c27 != '-' && c27 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 27;
            isTimeZone = c27 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 29 && c29 != 91 && c29 != 124 && c29 != 43 && c29 != 45 && c29 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == 124;
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':' && c19 == 46 && len == 23) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = false;
        } else {
            return null;
        }
        char first = this.chars[this.offset + zoneIdBegin];
        LocalDateTime ldt = JSONReaderUTF16.getLocalDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, (char)S8);
        if (isTimeZone) {
            String tzStr = new String(this.chars, this.offset + zoneIdBegin, len - zoneIdBegin);
            TimeZone timeZone = TimeZone.getTimeZone(tzStr);
            zoneId = timeZone.toZoneId();
        } else if (first == 'Z') {
            zoneId = UTC;
        } else {
            String zoneIdStr = first == '+' || first == '-' ? new String(this.chars, this.offset + zoneIdBegin, len - zoneIdBegin) : (first == ' ' ? new String(this.chars, this.offset + zoneIdBegin + 1, len - zoneIdBegin - 1) : (zoneIdBegin < len ? new String(this.chars, this.offset + zoneIdBegin + 1, len - zoneIdBegin - 2) : null));
            zoneId = this.getZoneId(ldt, zoneIdStr);
        }
        ZonedDateTime zdt = ldt.atZone(zoneId);
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return zdt;
    }

    @Override
    protected LocalDateTime readLocalDateTime19() {
        int millis;
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        char c18 = this.chars[this.offset + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 >= 48 && S0 <= 57 && S1 >= 48 && S1 <= 57 && S2 >= 48 && S2 <= 57) {
            millis = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, millis);
        this.offset += 20;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTimeX(int len) {
        char c20;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29) {
            throw new JSONException("illegal localDatetime string : " + this.readString());
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        char c18 = this.chars[this.offset + 18];
        char c19 = this.chars[this.offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = this.chars[this.offset + 20];
                break;
            }
            case 22: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                break;
            }
            case 23: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                break;
            }
            case 24: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                break;
            }
            case 25: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                break;
            }
            case 26: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                break;
            }
            case 27: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                break;
            }
            case 28: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                break;
            }
            default: {
                c20 = this.chars[this.offset + 20];
                c21 = this.chars[this.offset + 21];
                c22 = this.chars[this.offset + 22];
                c23 = this.chars[this.offset + 23];
                c24 = this.chars[this.offset + 24];
                c25 = this.chars[this.offset + 25];
                c26 = this.chars[this.offset + 26];
                c27 = this.chars[this.offset + 27];
                c28 = this.chars[this.offset + 28];
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        LocalDateTime ldt = JSONReaderUTF16.getLocalDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime10() {
        int millis;
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        int m1 = 48;
        int m2 = 48;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= 48 && m1 <= 57 && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 11;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    protected LocalTime readLocalTime11() {
        int millis;
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        int m2 = 48;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9' && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 12;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    protected LocalTime readLocalTime12() {
        int millis;
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9' && m2 >= '0' && m2 <= '9') {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 13;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    protected LocalTime readLocalTime18() {
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.chars[this.offset];
        char c1 = this.chars[this.offset + 1];
        char c2 = this.chars[this.offset + 2];
        char c3 = this.chars[this.offset + 3];
        char c4 = this.chars[this.offset + 4];
        char c5 = this.chars[this.offset + 5];
        char c6 = this.chars[this.offset + 6];
        char c7 = this.chars[this.offset + 7];
        char c8 = this.chars[this.offset + 8];
        char c9 = this.chars[this.offset + 9];
        char c10 = this.chars[this.offset + 10];
        char c11 = this.chars[this.offset + 11];
        char c12 = this.chars[this.offset + 12];
        char c13 = this.chars[this.offset + 13];
        char c14 = this.chars[this.offset + 14];
        char c15 = this.chars[this.offset + 15];
        char c16 = this.chars[this.offset + 16];
        char c17 = this.chars[this.offset + 17];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        char m3 = c12;
        char m4 = c13;
        char m5 = c14;
        char m6 = c15;
        char m7 = c16;
        char m8 = c17;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9' || m2 < '0' || m2 > '9' || m3 < '0' || m3 > '9' || m4 < '0' || m4 > '9' || m5 < '0' || m5 > '9' || m6 < '0' || m6 > '9' || m7 < '0' || m7 > '9' || m8 < '0' || m8 > '9') {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        this.offset += 19;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    @Override
    public String readPattern() {
        char c;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        int offset = this.offset;
        while ((c = this.chars[offset]) != '/' && ++offset < this.end) {
        }
        String str = new String(this.chars, this.offset, offset - this.offset);
        if (offset + 1 == this.end) {
            this.offset = this.end;
            this.ch = (char)26;
            return str;
        }
        char b = this.chars[++offset];
        while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
            b = this.chars[++offset];
        }
        if (b == ',') {
            this.offset = offset + 1;
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = b;
        }
        return str;
    }
}

