/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriterJSONB;
import com.alibaba.fastjson2.JSONWriterPretty;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.JSONWriterUTF16JDK8;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.JSONWriterUTF8JDK9;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public abstract class JSONWriter
implements Closeable {
    protected final Context context;
    protected final Charset charset;
    protected final boolean utf8;
    protected final boolean utf16;
    protected boolean startObject = false;
    protected int level;
    protected int off;
    protected Object rootObject;
    protected IdentityHashMap<Object, Path> refs;
    protected Path path;
    protected String lastReference;
    static int MAX_ARRAY_SIZE = 0x4000000;

    protected JSONWriter(Context context, Charset charset) {
        this.context = context;
        this.charset = charset;
        this.utf8 = charset == StandardCharsets.UTF_8;
        this.utf16 = charset == StandardCharsets.UTF_16;
    }

    public boolean isUTF8() {
        return this.utf8;
    }

    public boolean isUTF16() {
        return this.utf16;
    }

    public boolean isJSONB() {
        return false;
    }

    public boolean isIgnoreNoneSerializable() {
        return (this.context.features & Feature.IgnoreNoneSerializable.mask) != 0L;
    }

    public JSONB.SymbolTable getSymbolTable() {
        throw new UnsupportedOperationException();
    }

    public void config(Feature ... features) {
        this.context.config(features);
    }

    public void config(Feature feature, boolean state) {
        this.context.config(feature, state);
    }

    public Context getContext() {
        return this.context;
    }

    public int level() {
        return this.level;
    }

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
        if ((this.context.features & Feature.ReferenceDetection.mask) != 0L) {
            if (this.refs == null) {
                this.refs = new IdentityHashMap(8);
            }
            this.path = Path.ROOT;
            this.refs.putIfAbsent(rootObject, this.path);
        }
    }

    public String setPath(String name, Object object) {
        Path previous;
        if ((this.context.features & Feature.ReferenceDetection.mask) == 0L) {
            return null;
        }
        this.path = new Path(this.path, name);
        if (this.refs == null) {
            this.refs = new IdentityHashMap(8);
        }
        if ((previous = this.refs.get(object)) == null) {
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public String setPath(int index, Object object) {
        Path previous;
        if ((this.context.features & Feature.ReferenceDetection.mask) == 0L) {
            return null;
        }
        this.path = this.path == Path.ROOT ? (index == 0 ? Path.ROOT_0 : (index == 1 ? Path.ROOT_1 : new Path(Path.ROOT, index))) : new Path(this.path, index);
        if (this.refs == null) {
            this.refs = new IdentityHashMap(8);
        }
        if ((previous = this.refs.get(object)) == null) {
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public void popPath(Object object) {
        if (this.path == null) {
            return;
        }
        if ((this.context.features & Feature.ReferenceDetection.mask) == 0L) {
            return;
        }
        this.path = this.path.parent;
    }

    public boolean hasFilter() {
        return this.context.propertyPreFilter != null || this.context.propertyFilter != null || this.context.nameFilter != null || this.context.valueFilter != null;
    }

    public boolean isWriteNulls() {
        return (this.context.features & (Feature.WriteNulls.mask | Feature.NullAsDefaultValue.mask)) != 0L;
    }

    public boolean isNotWriteDefaultValue() {
        return (this.context.features & Feature.NotWriteDefaultValue.mask) != 0L;
    }

    public boolean isRefDetect() {
        return (this.context.features & Feature.ReferenceDetection.mask) != 0L;
    }

    public boolean isRefDetect(Object object) {
        return (this.context.features & Feature.ReferenceDetection.mask) != 0L && object != null && !ObjectWriterProvider.isNotReferenceDetect(object.getClass());
    }

    public boolean isBeanToArray() {
        return (this.context.features & Feature.BeanToArray.mask) != 0L;
    }

    public boolean isBeanToArray(long features) {
        return ((this.context.features | features) & Feature.BeanToArray.mask) != 0L;
    }

    public boolean isEnabled(Feature feature) {
        return (this.context.features & feature.mask) != 0L;
    }

    public boolean isEnabled(long feature) {
        return (this.context.features & feature) != 0L;
    }

    public long getFeatures() {
        return this.context.features;
    }

    public long getFeatures(long features) {
        return this.context.features | features;
    }

    public boolean isIgnoreErrorGetter() {
        return (this.context.features & Feature.IgnoreErrorGetter.mask) != 0L;
    }

    public boolean isWriteTypeInfo(Object object, Type fieldType) {
        Type rawType;
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType instanceof ParameterizedType && (rawType = ((ParameterizedType)fieldType).getRawType()) instanceof Class) {
            fieldClass = (Class)rawType;
        }
        if (objectClass == fieldClass) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object) {
        Class<?> objectClass;
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && object != null && ((objectClass = object.getClass()) == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object, Type fieldType, long features) {
        Type rawType;
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType instanceof ParameterizedType && (rawType = ((ParameterizedType)fieldType).getRawType()) instanceof Class) {
            fieldClass = (Class)rawType;
        }
        if (objectClass == fieldClass) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class ? fieldClass == null || fieldClass == Object.class || fieldClass == Map.class || fieldClass == AbstractMap.class : objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object, Class fieldClass, long features) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return false;
        }
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class ? fieldClass == null || fieldClass == Object.class || fieldClass == Map.class || fieldClass == AbstractMap.class : objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteMapTypeInfo(Object object, Class fieldClass, long features) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return false;
        }
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && objectClass == HashMap.class) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public boolean isWriteTypeInfo(Object object, long features) {
        Class<?> objectClass;
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && object != null && ((objectClass = object.getClass()) == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public ObjectWriter getObjectWriter(Class objectClass) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectWriter(objectClass, objectClass, fieldBased);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectWriter(objectType, objectClass, fieldBased);
    }

    public static JSONWriter of() {
        Context writeContext = JSONFactory.createWriteContext();
        return JDKUtils.JVM_VERSION == 8 ? new JSONWriterUTF16JDK8(writeContext) : new JSONWriterUTF16(writeContext);
    }

    public static JSONWriter of(Feature ... features) {
        Context writeContext = JSONFactory.createWriteContext(features);
        JSONWriterUTF16 jsonWriter = JDKUtils.JVM_VERSION == 8 ? new JSONWriterUTF16JDK8(writeContext) : new JSONWriterUTF16(writeContext);
        for (int i = 0; i < features.length; ++i) {
            if (features[i] != Feature.PrettyFormat) continue;
            return new JSONWriterPretty(jsonWriter);
        }
        return jsonWriter;
    }

    public static JSONWriter ofJSONB() {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider), null);
    }

    public static JSONWriter ofJSONB(Feature ... features) {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider, features), null);
    }

    public static JSONWriter ofJSONB(JSONB.SymbolTable symbolTable) {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider), symbolTable);
    }

    public static JSONWriter ofPretty() {
        return JSONWriter.ofPretty(JSONWriter.of());
    }

    public static JSONWriter ofPretty(JSONWriter writer) {
        return new JSONWriterPretty(writer);
    }

    public static JSONWriter ofUTF8() {
        if (JDKUtils.JVM_VERSION >= 9) {
            return new JSONWriterUTF8JDK9(JSONFactory.createWriteContext());
        }
        return new JSONWriterUTF8(JSONFactory.createWriteContext());
    }

    public static JSONWriter ofUTF8(Feature ... features) {
        boolean pretty;
        Context writeContext = JSONFactory.createWriteContext(features);
        JSONWriter jsonWriter = JDKUtils.JVM_VERSION >= 9 ? new JSONWriterUTF8JDK9(writeContext) : new JSONWriterUTF8(writeContext);
        boolean bl = pretty = (writeContext.features & Feature.PrettyFormat.mask) != 0L;
        if (pretty) {
            jsonWriter = new JSONWriterPretty(jsonWriter);
        }
        return jsonWriter;
    }

    public void writeBinary(byte[] bytes) {
        if (bytes == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt32(bytes[i]);
        }
        this.endArray();
    }

    public void writeBase64(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    protected abstract void write0(char var1);

    public abstract void writeRaw(String var1);

    public void writeRaw(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(byte b) {
        throw new UnsupportedOperationException();
    }

    public void writeNameRaw(byte[] bytes, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(char[] chars) {
        throw new UnsupportedOperationException();
    }

    public void writeNameRaw(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public void writeNameRaw(byte[] name, long nameHash) {
        throw new UnsupportedOperationException();
    }

    public void writeNameRaw(char[] chars) {
        throw new UnsupportedOperationException();
    }

    public void writeNameRaw(char[] bytes, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public void writeName(String name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeString(name);
    }

    public abstract void startObject();

    public abstract void endObject();

    public abstract void startArray();

    public void startArray(int size) {
        throw new UnsupportedOperationException();
    }

    public void startArray(Object array, int size) {
        throw new UnsupportedOperationException();
    }

    public abstract void endArray();

    public abstract void writeComma();

    public void writeColon() {
        this.write0(':');
    }

    public void writeInt16(short[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt16(value[i]);
        }
        this.endArray();
    }

    public void writeInt8(byte value) {
        this.writeInt32(value);
    }

    public void writeInt16(short value) {
        this.writeInt32(value);
    }

    public void writeInt32(int[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt32(value[i]);
        }
        this.endArray();
    }

    public abstract void writeInt32(int var1);

    public abstract void writeInt64(long var1);

    public void writeMillis(long i) {
        this.writeInt64(i);
    }

    public void writeInt64(long[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt64(value[i]);
        }
        this.endArray();
    }

    public abstract void writeFloat(float var1);

    public void writeFloat(float[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeFloat(value[i]);
        }
        this.endArray();
    }

    public abstract void writeDouble(double var1);

    public void writeDouble(double[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeDouble(value[i]);
        }
        this.endArray();
    }

    public void writeBool(boolean value) {
        if ((this.context.features & Feature.WriteBooleanAsNumber.mask) != 0L) {
            this.write0(value ? (char)'1' : '0');
        } else {
            this.writeRaw(value ? "true" : "false");
        }
    }

    public void writeBool(boolean[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeBool(value[i]);
        }
        this.endArray();
    }

    public void writeNull() {
        this.writeRaw("null");
    }

    public void writeStringNull() {
        String raw = (this.context.features & Feature.NullAsDefaultValue.mask) != 0L ? "" : "null";
        this.writeRaw(raw);
    }

    public void writeArrayNull() {
        String raw = (this.context.features & Feature.NullAsDefaultValue.mask) != 0L ? "[]" : "null";
        this.writeRaw(raw);
    }

    public void writeNumberNull() {
        if ((this.context.features & Feature.NullAsDefaultValue.mask) != 0L) {
            this.writeInt32(0);
        } else {
            this.writeNull();
        }
    }

    public void writeBooleanNull() {
        if ((this.context.features & Feature.NullAsDefaultValue.mask) != 0L) {
            this.writeBool(false);
        } else {
            this.writeNull();
        }
    }

    public abstract void writeDecimal(BigDecimal var1);

    public void writeDecimal(BigDecimal value, long features) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (((features |= this.context.features) & Feature.WriteBigDecimalAsPlain.mask) != 0L) {
            String str = value.toPlainString();
            this.writeRaw(str);
            return;
        }
        String str = value.toString();
        if ((features & Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW) < 0 || value.compareTo(JSONFactory.HIGH) > 0)) {
            this.write0('\"');
            this.writeRaw(str);
            this.write0('\"');
        } else {
            this.writeRaw(str);
        }
    }

    public void writeEnum(Enum e) {
        if (e == null) {
            this.writeNull();
            return;
        }
        if ((this.context.features & Feature.WriteEnumUsingToString.mask) != 0L) {
            this.writeString(e.toString());
        } else if ((this.context.features & Feature.WriteEnumsUsingName.mask) != 0L) {
            this.writeString(e.name());
        } else {
            this.writeInt32(e.ordinal());
        }
    }

    public void writeBigInt(BigInteger value) {
        this.writeBigInt(value, 0L);
    }

    public abstract void writeBigInt(BigInteger var1, long var2);

    public abstract void writeUUID(UUID var1);

    public void writeTypeName(String typeName) {
        throw new UnsupportedOperationException();
    }

    public boolean writeTypeName(byte[] typeName, long typeNameHash) {
        throw new UnsupportedOperationException();
    }

    public abstract void writeString(String var1);

    public void writeSymbol(String string) {
        this.writeString(string);
    }

    public void writeString(char ch) {
        this.write0('\"');
        this.write0(ch);
        this.write0('\"');
    }

    public void writeString(char[] str) {
        int i;
        if (str == null) {
            this.writeNull();
            return;
        }
        this.write0('\"');
        boolean special = false;
        for (i = 0; i < str.length; ++i) {
            if (str[i] != '\\' && str[i] != '\"') continue;
            special = true;
            break;
        }
        if (!special) {
            this.writeRaw(str);
        } else {
            for (i = 0; i < str.length; ++i) {
                char ch = str[i];
                if (ch == '\\' || ch == '\"') {
                    this.write0('\\');
                }
                this.write0(ch);
            }
        }
        this.write0('\"');
    }

    public void writeLocalDate(LocalDate date) {
        int year = date.getYear();
        int month = date.getMonthValue();
        int dayOfMonth = date.getDayOfMonth();
        int yearSize = IOUtils.stringSize(year);
        int len = 8 + yearSize;
        char[] chars = new char[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, len - 1, '0');
        IOUtils.getChars(year, yearSize + 1, chars);
        chars[yearSize + 1] = 45;
        IOUtils.getChars(month, yearSize + 4, chars);
        chars[yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, yearSize + 7, chars);
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    public void writeLocalDateTime(LocalDateTime dateTime) {
        int small;
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int dayOfMonth = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int nano = dateTime.getNano();
        int yearSize = IOUtils.stringSize(year);
        int len = 17 + yearSize;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        char[] chars = new char[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, len - 1, '0');
        IOUtils.getChars(year, yearSize + 1, chars);
        chars[yearSize + 1] = 45;
        IOUtils.getChars(month, yearSize + 4, chars);
        chars[yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, yearSize + 7, chars);
        chars[yearSize + 7] = 84;
        IOUtils.getChars(hour, yearSize + 10, chars);
        chars[yearSize + 10] = 58;
        IOUtils.getChars(minute, yearSize + 13, chars);
        chars[yearSize + 13] = 58;
        IOUtils.getChars(second, yearSize + 16, chars);
        if (small != 0) {
            chars[yearSize + 16] = 46;
            IOUtils.getChars(small, len - 1, chars);
        }
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    public void writeLocalTime(LocalTime time) {
        int small;
        int hour = time.getHour();
        int minute = time.getMinute();
        int second = time.getSecond();
        int nano = time.getNano();
        int len = 10;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        char[] chars = new char[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, chars.length - 1, '0');
        IOUtils.getChars(hour, 3, chars);
        chars[3] = 58;
        IOUtils.getChars(minute, 6, chars);
        chars[6] = 58;
        IOUtils.getChars(second, 9, chars);
        if (small != 0) {
            chars[9] = 46;
            IOUtils.getChars(small, len - 1, chars);
        }
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    public void writeZonedDateTime(ZonedDateTime dateTime) {
        int small;
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int dayOfMonth = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int nano = dateTime.getNano();
        String zoneId = dateTime.getZone().getId();
        int len = 17;
        if ("UTC".equals(zoneId)) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = 2 + zoneId.length();
        }
        len += zoneSize;
        int yearSize = IOUtils.stringSize(year);
        len += yearSize;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        char[] chars = new char[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, chars.length - 1, '0');
        IOUtils.getChars(year, yearSize + 1, chars);
        chars[yearSize + 1] = 45;
        IOUtils.getChars(month, yearSize + 4, chars);
        chars[yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, yearSize + 7, chars);
        chars[yearSize + 7] = 84;
        IOUtils.getChars(hour, yearSize + 10, chars);
        chars[yearSize + 10] = 58;
        IOUtils.getChars(minute, yearSize + 13, chars);
        chars[yearSize + 13] = 58;
        IOUtils.getChars(second, yearSize + 16, chars);
        if (small != 0) {
            chars[yearSize + 16] = 46;
            IOUtils.getChars(small, len - 1 - zoneSize, chars);
        }
        if (zoneSize == 1) {
            chars[len - 2] = 90;
        } else {
            chars[len - zoneSize - 1] = 91;
            zoneId.getChars(0, zoneId.length(), chars, len - zoneSize);
            chars[len - 2] = 93;
        }
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    public void writeInstant(Instant instant) {
        if (instant == null) {
            this.writeNull();
            return;
        }
        String str = DateTimeFormatter.ISO_INSTANT.format(instant);
        this.writeString(str);
    }

    public abstract void writeDateTime19(int var1, int var2, int var3, int var4, int var5, int var6);

    public void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds) {
        int millislen = millis == 0 ? 0 : (millis < 10 ? 4 : (millis % 100 == 0 ? 2 : (millis % 10 == 0 ? 3 : 4)));
        int zonelen = offsetSeconds == 0 ? 1 : 6;
        int offset = offsetSeconds / 3600;
        int len = 21 + millislen + zonelen;
        char[] chars = new char[len];
        chars[0] = 34;
        chars[1] = (char)(year / 1000 + 48);
        chars[2] = (char)(year / 100 % 10 + 48);
        chars[3] = (char)(year / 10 % 10 + 48);
        chars[4] = (char)(year % 10 + 48);
        chars[5] = 45;
        chars[6] = (char)(month / 10 + 48);
        chars[7] = (char)(month % 10 + 48);
        chars[8] = 45;
        chars[9] = (char)(dayOfMonth / 10 + 48);
        chars[10] = (char)(dayOfMonth % 10 + 48);
        chars[11] = 84;
        chars[12] = (char)(hour / 10 + 48);
        chars[13] = (char)(hour % 10 + 48);
        chars[14] = 58;
        chars[15] = (char)(minute / 10 + 48);
        chars[16] = (char)(minute % 10 + 48);
        chars[17] = 58;
        chars[18] = (char)(second / 10 + 48);
        chars[19] = (char)(second % 10 + 48);
        if (millislen > 0) {
            chars[20] = 46;
            Arrays.fill(chars, 21, 20 + millislen, '0');
            if (millis < 10) {
                IOUtils.getChars(millis, 20 + millislen, chars);
            } else if (millis % 100 == 0) {
                IOUtils.getChars(millis / 100, 20 + millislen, chars);
            } else if (millis % 10 == 0) {
                IOUtils.getChars(millis / 10, 20 + millislen, chars);
            } else {
                IOUtils.getChars(millis, 20 + millislen, chars);
            }
        }
        if (offsetSeconds == 0) {
            chars[20 + millislen] = 90;
        } else {
            int offsetAbs = Math.abs(offset);
            int offsetlen = IOUtils.stringSize(offsetAbs);
            chars[20 + millislen] = offset >= 0 ? 43 : 45;
            chars[20 + millislen + 1] = 48;
            IOUtils.getChars(offsetAbs, 20 + millislen + 3, chars);
            chars[20 + millislen + 3] = 58;
            chars[20 + millislen + 4] = 48;
            int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
            if (offsetMinutes < 0) {
                offsetMinutes = -offsetMinutes;
            }
            IOUtils.getChars(offsetMinutes, 20 + millislen + zonelen, chars);
        }
        chars[chars.length - 1] = 34;
        this.writeRaw(chars);
    }

    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        char[] chars = new char[]{(char)(year / 1000 + 48), (char)(year / 100 % 10 + 48), (char)(year / 10 % 10 + 48), (char)(year % 10 + 48), '-', (char)(month / 10 + 48), (char)(month % 10 + 48), '-', (char)(dayOfMonth / 10 + 48), (char)(dayOfMonth % 10 + 48)};
        this.writeString(chars);
    }

    public void writeTimeHHMMSS8(int hour, int minute, int second) {
        char[] chars = new char[]{(char)(hour / 10 + 48), (char)(hour % 10 + 48), ':', (char)(minute / 10 + 48), (char)(minute % 10 + 48), ':', (char)(second / 10 + 48), (char)(second % 10 + 48)};
        this.writeString(chars);
    }

    public void write(List array) {
        this.write0('[');
        boolean first = true;
        for (Object item : array) {
            if (!first) {
                this.write0(',');
            }
            this.writeAny(item);
            first = false;
        }
        this.write0(']');
    }

    public void write(Map map) {
        this.write0('{');
        boolean first = true;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            if (!first) {
                this.write0(',');
            }
            Map.Entry next = it.next();
            this.writeAny(next.getKey());
            this.write0(':');
            this.writeAny(next.getValue());
            first = false;
        }
        this.write0('}');
    }

    public void writeAny(Object value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        Class<?> valueClass = value.getClass();
        ObjectWriter objectWriter = this.context.provider.getObjectWriter(valueClass, valueClass);
        if (this.isJSONB()) {
            objectWriter.writeJSONB(this, value, null, null, 0L);
        } else {
            objectWriter.write(this, value, null, null, 0L);
        }
    }

    public abstract void writeReference(String var1);

    @Override
    public void close() {
    }

    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    public void flushTo(Writer to) {
        try {
            String json = this.toString();
            to.write(json);
        }
        catch (IOException e) {
            throw new JSONException("flushTo error", e);
        }
    }

    public int flushTo(OutputStream to) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static final class Path {
        public static final Path ROOT = new Path(null, "$");
        public static final Path ROOT_0 = new Path(ROOT, 0);
        public static final Path ROOT_1 = new Path(ROOT, 1);
        final Path parent;
        final String name;
        final int index;
        String fullPath;

        public Path(Path parent, String name) {
            this.parent = parent;
            this.name = name;
            this.index = -1;
        }

        public Path(Path parent, int index) {
            this.parent = parent;
            this.name = null;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return this.index == path.index && Objects.equals(this.parent, path.parent) && Objects.equals(this.name, path.name);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.name, this.index);
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            if (this.fullPath != null) {
                return this.fullPath;
            }
            buf = new byte[16];
            off = 0;
            level = 0;
            items = new Path[4];
            p = this;
            while (p != null) {
                if (items.length == level) {
                    items = Arrays.copyOf(items, items.length + 4);
                }
                items[level] = p;
                ++level;
                p = p.parent;
            }
            ascii = true;
            for (i = level - 1; i >= 0; --i) {
                block42: {
                    item = items[i];
                    name = item.name;
                    if (name == null) {
                        intValue = item.index;
                        intValueSize = IOUtils.stringSize(intValue);
                        while (off + intValueSize + 2 >= buf.length) {
                            newCapacity = buf.length + (buf.length >> 1);
                            buf = Arrays.copyOf(buf, newCapacity);
                        }
                        buf[off++] = 91;
                        IOUtils.getChars(intValue, off + intValueSize, buf);
                        off += intValueSize;
                        buf[off++] = 93;
                        continue;
                    }
                    if (off + 1 >= buf.length) {
                        newCapacity = buf.length + (buf.length >> 1);
                        buf = Arrays.copyOf(buf, newCapacity);
                    }
                    if (i != level - 1) {
                        buf[off++] = 46;
                    }
                    if (JDKUtils.JVM_VERSION != 8) break block42;
                    chars = JDKUtils.getCharArray(name);
                    block9: for (j = 0; j < chars.length; ++j) {
                        ch = chars[j];
                        switch (ch) {
                            case 33: 
                            case 34: 
                            case 35: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 96: 
                            case 126: {
                                if (off + 1 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = 92;
                                buf[off++] = (byte)ch;
                                continue block9;
                            }
                            default: {
                                if (ch >= 1 && ch <= 127) {
                                    if (off == buf.length) {
                                        newCapacity = buf.length + (buf.length >> 1);
                                        buf = Arrays.copyOf(buf, newCapacity);
                                    }
                                    buf[off++] = (byte)ch;
                                    continue block9;
                                }
                                if (ch < 55296 || ch >= 57344) ** GOTO lbl83
                                if (off + 2 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                ascii = false;
                                if (ch < 55296 || ch >= 56320) ** GOTO lbl70
                                if (name.length() - i < 2) {
                                    uc = -1;
                                } else {
                                    d = name.charAt(i + 1);
                                    if (d >= '\udc00' && d < '\ue000') {
                                        uc = (ch << 10) + d + -56613888;
                                    } else {
                                        buf[off++] = 63;
                                        continue block9;
lbl70:
                                        // 1 sources

                                        if (ch >= 56320 && ch < 57344) {
                                            buf[off++] = 63;
                                            continue block9;
                                        }
                                        uc = ch;
                                    }
                                }
                                if (uc < 0) {
                                    buf[off++] = 63;
                                    continue block9;
                                }
                                buf[off++] = (byte)(240 | uc >> 18);
                                buf[off++] = (byte)(128 | uc >> 12 & 63);
                                buf[off++] = (byte)(128 | uc >> 6 & 63);
                                buf[off++] = (byte)(128 | uc & 63);
                                ++i;
                                continue block9;
lbl83:
                                // 1 sources

                                if (ch > 2047) {
                                    if (off + 2 >= buf.length) {
                                        newCapacity = buf.length + (buf.length >> 1);
                                        buf = Arrays.copyOf(buf, newCapacity);
                                    }
                                    ascii = false;
                                    buf[off++] = (byte)(224 | ch >> 12 & 15);
                                    buf[off++] = (byte)(128 | ch >> 6 & 63);
                                    buf[off++] = (byte)(128 | ch >> 0 & 63);
                                    continue block9;
                                }
                                if (off + 1 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                ascii = false;
                                buf[off++] = (byte)(192 | ch >> 6 & 31);
                                buf[off++] = (byte)(128 | ch >> 0 & 63);
                            }
                        }
                    }
                    continue;
                }
                block10: for (j = 0; j < name.length(); ++j) {
                    ch = name.charAt(j);
                    switch (ch) {
                        case 33: 
                        case 34: 
                        case 35: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 96: 
                        case 126: {
                            if (off + 1 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            buf[off++] = 92;
                            buf[off++] = (byte)ch;
                            continue block10;
                        }
                        default: {
                            if (ch >= 1 && ch <= 127) {
                                if (off == buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = (byte)ch;
                                continue block10;
                            }
                            if (ch < 55296 || ch >= 57344) ** GOTO lbl146
                            if (off + 2 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            ascii = false;
                            if (ch < 55296 || ch >= 56320) ** GOTO lbl133
                            if (name.length() - i < 2) {
                                uc = -1;
                            } else {
                                d = name.charAt(i + 1);
                                if (d >= '\udc00' && d < '\ue000') {
                                    uc = (ch << 10) + d + -56613888;
                                } else {
                                    buf[off++] = 63;
                                    continue block10;
lbl133:
                                    // 1 sources

                                    if (ch >= 56320 && ch < 57344) {
                                        buf[off++] = 63;
                                        continue block10;
                                    }
                                    uc = ch;
                                }
                            }
                            if (uc < 0) {
                                buf[off++] = 63;
                                continue block10;
                            }
                            buf[off++] = (byte)(240 | uc >> 18);
                            buf[off++] = (byte)(128 | uc >> 12 & 63);
                            buf[off++] = (byte)(128 | uc >> 6 & 63);
                            buf[off++] = (byte)(128 | uc & 63);
                            ++i;
                            continue block10;
lbl146:
                            // 1 sources

                            if (ch > 2047) {
                                if (off + 2 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                ascii = false;
                                buf[off++] = (byte)(224 | ch >> 12 & 15);
                                buf[off++] = (byte)(128 | ch >> 6 & 63);
                                buf[off++] = (byte)(128 | ch >> 0 & 63);
                                continue block10;
                            }
                            if (off + 1 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            ascii = false;
                            buf[off++] = (byte)(192 | ch >> 6 & 31);
                            buf[off++] = (byte)(128 | ch >> 0 & 63);
                        }
                    }
                }
            }
            this.fullPath = new String(buf, 0, off, ascii != false ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8);
            return this.fullPath;
        }
    }

    public static enum Feature {
        FieldBased(1L),
        IgnoreNoneSerializable(2L),
        BeanToArray(4L),
        WriteNulls(8L),
        WriteMapNullValue(8L),
        BrowserCompatible(16L),
        NullAsDefaultValue(32L),
        WriteBooleanAsNumber(64L),
        WriteNonStringValueAsString(128L),
        WriteClassName(256L),
        NotWriteRootClassName(512L),
        NotWriteHashMapArrayListClassName(1024L),
        NotWriteDefaultValue(2048L),
        WriteEnumsUsingName(4096L),
        WriteEnumUsingToString(8192L),
        IgnoreErrorGetter(16384L),
        PrettyFormat(32768L),
        ReferenceDetection(65536L),
        WriteNameAsSymbol(131072L),
        WriteBigDecimalAsPlain(262144L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }

    public static class Context {
        static ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
        final ObjectWriterProvider provider;
        DateTimeFormatter dateFormatter;
        String dateFormat;
        boolean dateFormatMillis;
        boolean dateFormatISO8601;
        boolean dateFormatUnixTime;
        String numberFormat;
        long features;
        ZoneId zoneId;
        PropertyPreFilter propertyPreFilter;
        PropertyFilter propertyFilter;
        NameFilter nameFilter;
        ValueFilter valueFilter;

        public Context(ObjectWriterProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException("objectWriterProvider must not null");
            }
            this.provider = provider;
        }

        public Context(ObjectWriterProvider provider, Feature ... features) {
            if (provider == null) {
                throw new IllegalArgumentException("objectWriterProvider must not null");
            }
            this.provider = provider;
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public long getFeatures() {
            return this.features;
        }

        public boolean isEnabled(Feature feature) {
            return (this.features & feature.mask) != 0L;
        }

        public void config(Feature ... features) {
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public void config(Feature feature, boolean state) {
            this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        protected void configFilter(Filter ... filters) {
            for (Filter filter : filters) {
                if (filter instanceof NameFilter) {
                    this.setNameFilter((NameFilter)filter);
                    continue;
                }
                if (filter instanceof ValueFilter) {
                    this.setValueFilter((ValueFilter)filter);
                    continue;
                }
                if (filter instanceof PropertyFilter) {
                    this.setPropertyFilter((PropertyFilter)filter);
                    continue;
                }
                if (!(filter instanceof PropertyPreFilter)) continue;
                this.setPropertyPreFilter((PropertyPreFilter)filter);
            }
        }

        public <T> ObjectWriter<T> getObjectWriter(Class<T> objectType) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            ObjectWriter objectWriter = this.provider.getObjectWriter(objectType, objectType, fieldBased);
            return objectWriter;
        }

        public <T> ObjectWriter<T> getObjectWriter(Type objectType, Class<T> objectClass) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectWriter(objectType, objectClass, fieldBased);
        }

        public ObjectWriterProvider getProvider() {
            return this.provider;
        }

        public ZoneId getZoneId() {
            if (this.zoneId == null) {
                this.zoneId = DEFAULT_ZONE_ID;
            }
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public boolean isDateFormatMillis() {
            return this.dateFormatMillis;
        }

        public boolean isDateFormatUnixTime() {
            return this.dateFormatUnixTime;
        }

        public boolean isDateFormatISO8601() {
            return this.dateFormatISO8601;
        }

        public DateTimeFormatter getDateFormatter() {
            if (!(this.dateFormatter != null || this.dateFormat == null || this.dateFormatMillis || this.dateFormatISO8601 || this.dateFormatUnixTime)) {
                this.dateFormatter = DateTimeFormatter.ofPattern(this.dateFormat);
            }
            return this.dateFormatter;
        }

        public void setDateFormat(String dateFormat) {
            if (dateFormat == null || !dateFormat.equals(this.dateFormat)) {
                this.dateFormatter = null;
            }
            if (dateFormat != null && !dateFormat.isEmpty()) {
                switch (dateFormat) {
                    case "millis": {
                        this.dateFormatMillis = true;
                        break;
                    }
                    case "iso8601": {
                        this.dateFormatMillis = false;
                        this.dateFormatISO8601 = true;
                        break;
                    }
                    case "unixtime": {
                        this.dateFormatMillis = false;
                        this.dateFormatUnixTime = true;
                        break;
                    }
                    default: {
                        this.dateFormatMillis = false;
                    }
                }
            }
            this.dateFormat = dateFormat;
        }

        public PropertyPreFilter getPropertyPreFilter() {
            return this.propertyPreFilter;
        }

        public void setPropertyPreFilter(PropertyPreFilter propertyPreFilter) {
            this.propertyPreFilter = propertyPreFilter;
        }

        public NameFilter getNameFilter() {
            return this.nameFilter;
        }

        public void setNameFilter(NameFilter nameFilter) {
            this.nameFilter = nameFilter;
        }

        public ValueFilter getValueFilter() {
            return this.valueFilter;
        }

        public void setValueFilter(ValueFilter valueFilter) {
            this.valueFilter = valueFilter;
        }

        public PropertyFilter getPropertyFilter() {
            return this.propertyFilter;
        }

        public void setPropertyFilter(PropertyFilter propertyFilter) {
            this.propertyFilter = propertyFilter;
        }
    }
}

