/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.util.JDKUtils;
import java.util.Arrays;

final class JSONWriterUTF16JDK8
extends JSONWriterUTF16 {
    JSONWriterUTF16JDK8(JSONWriter.Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        char c1;
        char c0;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        char[] value = JDKUtils.getCharArray(str);
        int strlen = value.length;
        boolean special = false;
        int i = 0;
        while (i + 4 <= strlen) {
            c0 = value[i];
            c1 = value[i + 1];
            char c2 = value[i + 2];
            char c3 = value[i + 3];
            if (c0 == '\"' || c1 == '\"' || c2 == '\"' || c3 == '\"') {
                special = true;
                break;
            }
            if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\') {
                special = true;
                break;
            }
            if (c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ') {
                special = true;
                break;
            }
            i += 4;
        }
        if (!special && i + 2 <= strlen) {
            c0 = value[i];
            c1 = value[i + 1];
            if (c0 == '\"' || c1 == '\"' || c0 == '\\' || c1 == '\\' || c0 < ' ' || c1 < ' ') {
                special = true;
            } else {
                i += 2;
            }
        }
        if (!special && i + 1 == strlen) {
            c0 = value[i];
            boolean bl = special = c0 == '\"' || c0 == '\\' || c0 < ' ';
        }
        if (!special) {
            int minCapacity = this.off + strlen + 2;
            if (minCapacity - this.chars.length > 0) {
                int oldCapacity = this.chars.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                if (newCapacity - MAX_ARRAY_SIZE > 0) {
                    throw new OutOfMemoryError();
                }
                this.chars = Arrays.copyOf(this.chars, newCapacity);
            }
            this.chars[this.off++] = 34;
            System.arraycopy(value, 0, this.chars, this.off, value.length);
            this.off += strlen;
            this.chars[this.off++] = 34;
            return;
        }
        this.ensureCapacity(this.off + strlen * 2 + 2);
        this.chars[this.off++] = 34;
        block9: for (i = 0; i < strlen; ++i) {
            char ch = value[i];
            switch (ch) {
                case '\"': 
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block9;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block9;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block9;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block9;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block9;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block9;
                }
                default: {
                    this.chars[this.off++] = ch;
                }
            }
        }
        this.chars[this.off++] = 34;
    }
}

