/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigInteger;

final class FieldReaderBigIntegerField<T>
extends FieldReaderObjectField<T> {
    FieldReaderBigIntegerField(String fieldName, Class fieldType, int ordinal, String format, BigInteger defaultValue, Field field) {
        super(fieldName, (Type)fieldType, fieldType, ordinal, 0L, format, defaultValue, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        BigInteger fieldValue = jsonReader.readBigInteger();
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, int value) {
        try {
            this.field.set(object, BigInteger.valueOf(value));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, long value) {
        try {
            this.field.set(object, BigInteger.valueOf(value));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        try {
            this.field.set(object, TypeUtils.toBigInteger(value));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

