/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectMethod;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

final class FieldReaderDateMethod<T>
extends FieldReaderObjectMethod<T> {
    DateTimeFormatter formatter;
    ObjectReaderImplDate dateReader;

    FieldReaderDateMethod(String fieldName, Class fieldClass, int ordinal, long features, String format, Locale locale, Method method) {
        super(fieldName, fieldClass, fieldClass, ordinal, features, format, locale, null, method);
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplDate.INSTANCE : new ObjectReaderImplDate(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public void accept(T object, Object value) {
        try {
            if (value instanceof String) {
                String str = (String)value;
                if (this.format != null) {
                    DateTimeFormatter formatter = this.getFormatter(null);
                    LocalDateTime ldt = this.format.indexOf("HH") == -1 ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                    ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
                    long millis = zdt.toInstant().toEpochMilli();
                    value = new Date(millis);
                }
            }
            this.method.invoke(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Date fieldValue;
        long millis;
        if (jsonReader.isInt()) {
            millis = jsonReader.readInt64Value();
            fieldValue = new Date(millis);
        } else if (jsonReader.isNull()) {
            jsonReader.readNull();
            fieldValue = null;
        } else if (this.format != null) {
            Locale locale = jsonReader.getContext().getLocale();
            DateTimeFormatter formatter = this.getFormatter(locale);
            String str = jsonReader.readString();
            LocalDateTime ldt = this.format.indexOf("HH") == -1 ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
            ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
            long millis2 = zdt.toInstant().toEpochMilli();
            fieldValue = new Date(millis2);
        } else {
            millis = jsonReader.readMillisFromString();
            fieldValue = new Date(millis);
        }
        try {
            this.method.invoke(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    private DateTimeFormatter getFormatter(Locale locale) {
        if (this.formatter != null && locale == null) {
            return this.formatter;
        }
        String format = this.format.replaceAll("aa", "a");
        if (locale != null && locale != Locale.getDefault()) {
            return DateTimeFormatter.ofPattern(format, locale);
        }
        if (this.locale != null) {
            this.formatter = DateTimeFormatter.ofPattern(format, this.locale);
            return this.formatter;
        }
        this.formatter = DateTimeFormatter.ofPattern(format);
        return this.formatter;
    }
}

