/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;

public final class ObjectReaderImplInstant
extends DateTimeCodec
implements ObjectReader {
    public static final ObjectReaderImplInstant INSTANCE = new ObjectReaderImplInstant(null, null);

    public static ObjectReaderImplInstant of(String format, Locale locale) {
        if (format == null) {
            return INSTANCE;
        }
        return new ObjectReaderImplInstant(format, locale);
    }

    ObjectReaderImplInstant(String format, Locale locale) {
        super(format, locale);
    }

    public Object createInstance(Map map, long features) {
        Number nano = (Number)map.get("nano");
        Number epochSecond = (Number)map.get("epochSecond");
        if (nano != null && epochSecond != null) {
            return Instant.ofEpochSecond(epochSecond.longValue(), nano.longValue());
        }
        if (epochSecond != null) {
            return Instant.ofEpochSecond(epochSecond.longValue());
        }
        Number epochMilli = (Number)map.get("epochMilli");
        if (epochMilli != null) {
            return Instant.ofEpochMilli(epochMilli.longValue());
        }
        throw new JSONException("can not create instant.");
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        return jsonReader.readInstant();
    }

    public Object readObject(JSONReader jsonReader, long features) {
        DateTimeFormatter formatter;
        if (jsonReader.isString() && this.format != null && (formatter = this.getDateFormatter(jsonReader.getLocale())) != null) {
            String str = jsonReader.readString();
            LocalDateTime ldt = this.format.indexOf("HH") == -1 ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
            ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
            return zdt.toInstant();
        }
        return jsonReader.readInstant();
    }
}

