/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class ObjectReaderImplMapTyped
implements ObjectReader {
    final Class mapType;
    final Class instanceType;
    final Type keyType;
    final Type valueType;
    final Class valueClass;
    final long features;
    final Function builder;
    ObjectReader valueObjectReader = null;
    ObjectReader keyObjectReader = null;

    public ObjectReaderImplMapTyped(Class mapType, Class instanceType, Type keyType, Type valueType, long features, Function builder) {
        this.mapType = mapType;
        this.instanceType = instanceType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.valueClass = TypeUtils.getClass(valueType);
        this.features = features;
        this.builder = builder;
    }

    public Object createInstance(Map input, long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Map object = (Map)this.createInstance();
        for (Map.Entry entry : input.entrySet()) {
            String fieldName = entry.getKey().toString();
            Object fieldValue = entry.getValue();
            Object value = fieldValue;
            Class<?> valueClass = value.getClass();
            Function typeConvert = provider.getTypeConvert(valueClass, this.valueType);
            if (typeConvert != null) {
                value = typeConvert.apply(value);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                if (this.valueObjectReader == null) {
                    this.valueObjectReader = provider.getObjectReader(this.valueType);
                }
                value = this.valueObjectReader.createInstance(map, features);
            } else if (value instanceof Collection) {
                if (this.valueObjectReader == null) {
                    this.valueObjectReader = provider.getObjectReader(this.valueType);
                }
                value = this.valueObjectReader.createInstance((Collection)value);
            } else {
                throw new JSONException("can not convert from " + valueClass + " to " + this.valueType);
            }
            object.put(fieldName, value);
        }
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }

    public Object createInstance(long features) {
        if (this.instanceType != null && !this.instanceType.isInterface()) {
            try {
                return this.instanceType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create map error");
            }
        }
        return new HashMap();
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        byte firstType;
        ObjectReader objectReader = null;
        Function builder = this.builder;
        if (jsonReader.getType() == -110 && (objectReader = jsonReader.checkAutoType(this.mapType, 0L, this.features | features)) != null && objectReader != this) {
            builder = objectReader.getBuildFunction();
            if (!(objectReader instanceof ObjectReaderImplMap) && !(objectReader instanceof ObjectReaderImplMapTyped)) {
                return objectReader.readJSONBObject(jsonReader, features);
            }
        }
        if ((firstType = jsonReader.getType()) == -81) {
            jsonReader.next();
            return null;
        }
        if (firstType == -90) {
            jsonReader.next();
        }
        Map object = objectReader != null ? (Map)objectReader.createInstance(jsonReader.getContext().getFeatures() | features) : (this.instanceType == HashMap.class ? new HashMap() : (Map)this.createInstance());
        int i = 0;
        while (true) {
            String reference;
            Object name;
            byte type;
            if ((type = jsonReader.getType()) == -91) break;
            if (this.keyType == String.class || jsonReader.isString()) {
                name = jsonReader.readFieldName();
            } else if (jsonReader.isReference()) {
                reference = jsonReader.readReference();
                name = new ReferenceKey(i);
                jsonReader.addResolveTask(object, name, JSONPath.of(reference));
            } else {
                if (this.keyObjectReader == null && this.keyType != null) {
                    this.keyObjectReader = jsonReader.getObjectReader(this.keyType);
                }
                name = this.keyObjectReader == null ? jsonReader.readAny() : this.keyObjectReader.readJSONBObject(jsonReader, features);
            }
            if (jsonReader.isReference()) {
                reference = jsonReader.readReference();
                if ("..".equals(reference)) {
                    object.put(name, object);
                } else {
                    jsonReader.addResolveTask(object, name, JSONPath.of(reference));
                    if (!(object instanceof ConcurrentMap)) {
                        object.put(name, null);
                    }
                }
            } else if (jsonReader.nextIfNull()) {
                object.put(name, null);
            } else {
                Object value;
                if (this.valueType == Object.class) {
                    value = jsonReader.readAny();
                } else {
                    ObjectReader autoTypeValueReader = jsonReader.checkAutoType(this.valueClass, 0L, features);
                    if (autoTypeValueReader != null) {
                        value = autoTypeValueReader.readJSONBObject(jsonReader, features);
                    } else {
                        if (this.valueObjectReader == null) {
                            this.valueObjectReader = jsonReader.getObjectReader(this.valueType);
                        }
                        value = this.valueObjectReader.readJSONBObject(jsonReader, features);
                    }
                }
                object.put(name, value);
            }
            ++i;
        }
        jsonReader.next();
        if (builder != null) {
            return builder.apply(object);
        }
        return object;
    }

    public Object readObject(JSONReader jsonReader, long features) {
        HashMap object;
        boolean match = jsonReader.nextIfMatch('{');
        if (!match) {
            throw new JSONException("expect '{', but '['");
        }
        Map<String, Object> map = object = this.instanceType == HashMap.class ? new HashMap() : (Map)this.createInstance(jsonReader.getContext().getFeatures() | features);
        while (!jsonReader.nextIfMatch('}')) {
            String name = jsonReader.readFieldName();
            if (this.valueObjectReader == null) {
                this.valueObjectReader = jsonReader.getObjectReader(this.valueType);
            }
            Object value = this.valueObjectReader.readObject(jsonReader, 0L);
            object.put(name, value);
        }
        jsonReader.nextIfMatch(',');
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }
}

