/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.function.ObjBoolConsumer;
import com.alibaba.fastjson2.function.ObjByteConsumer;
import com.alibaba.fastjson2.function.ObjCharConsumer;
import com.alibaba.fastjson2.function.ObjFloatConsumer;
import com.alibaba.fastjson2.function.ObjShortConsumer;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderBoolValFunc;
import com.alibaba.fastjson2.reader.FieldReaderCharValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderListFuncImpl;
import com.alibaba.fastjson2.reader.FieldReaderObjectFunc2;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;

public class ObjectReaders {
    public static <T> ObjectReader<T> of(Supplier<T> defaultCreator, FieldReader ... fieldReaders) {
        return ObjectReaderCreator.INSTANCE.createObjectReader(null, defaultCreator, fieldReaders);
    }

    public static <T> ObjectReader<T> ofReflect(Class<T> objectType) {
        return ObjectReaderCreator.INSTANCE.createObjectReader(objectType);
    }

    public static <T> ObjectReader<T> of(Class<T> objectType) {
        return ObjectReaderCreator.INSTANCE.createObjectReader(objectType);
    }

    public static <T> ObjectReader<T> createObjectReader(Function<Map<Long, Object>, T> creator, FieldReader ... fieldReaders) {
        return ObjectReaderCreator.INSTANCE.createObjectReaderNoneDefaultConstrutor(null, creator, fieldReaders);
    }

    public static FieldReader fieldReader(String fieldName, Class fieldType) {
        return ObjectReaderCreator.INSTANCE.createFieldReader(null, fieldName, (Type)fieldType, fieldType, (Method)null);
    }

    public static <T> FieldReader fieldReaderBool(String fieldName, ObjBoolConsumer<T> function) {
        return new FieldReaderBoolValFunc<T>(fieldName, 0, null, function);
    }

    public static <T> FieldReader fieldReaderByte(String fieldName, ObjByteConsumer<T> function) {
        return new FieldReaderInt8ValueFunc<T>(fieldName, 0, null, function);
    }

    public static <T> FieldReader fieldReaderShort(String fieldName, ObjShortConsumer<T> function) {
        return new FieldReaderInt16ValueFunc<T>(fieldName, 0, null, function);
    }

    public static <T> FieldReader fieldReaderInt(String fieldName, ObjIntConsumer<T> function) {
        return new FieldReaderInt32ValueFunc<T>(fieldName, 0, null, function);
    }

    public static <T> FieldReader fieldReaderLong(String fieldName, ObjLongConsumer<T> function) {
        return new FieldReaderInt64ValueFunc<T>(fieldName, 0, null, function);
    }

    public static <T> FieldReader fieldReaderChar(String fieldName, ObjCharConsumer<T> function) {
        return new FieldReaderCharValueFunc<T>(fieldName, 0, null, null, null, function);
    }

    public static <T> FieldReader fieldReaderFloat(String fieldName, ObjFloatConsumer<T> function) {
        return new FieldReaderFloatValueFunc<T>(fieldName, 0, null, function);
    }

    public static <T> FieldReader fieldReaderDouble(String fieldName, ObjDoubleConsumer<T> function) {
        return new FieldReaderDoubleValueFunc<T>(fieldName, 0, null, function);
    }

    public static <T, V> FieldReader fieldReader(String fieldName, Class<V> fieldClass, BiConsumer<T, V> function) {
        return ObjectReaderCreator.INSTANCE.createFieldReader(fieldName, fieldClass, fieldClass, null, function);
    }

    public static <T, U> FieldReader fieldReader(String fieldName, Type fieldType, BiConsumer<T, U> consumer, ObjectReader<U> fieldObjectReader) {
        return new FieldReaderObjectFunc2<T, U>(fieldObjectReader, consumer, fieldType, fieldName);
    }

    public static <T, V> FieldReader fieldReaderList(String fieldName, Type itemType, Supplier<List<V>> listCreator, BiConsumer<T, List<V>> function, ObjectReader<V> itemObjectReader) {
        return new FieldReaderListFuncImpl<T, V>(listCreator, itemObjectReader, function, itemType, fieldName);
    }
}

