/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

final class FieldReaderDateField<T>
extends FieldReaderObjectField<T> {
    private ObjectReaderImplDate dateReader;
    DateTimeFormatter formatter;
    final Locale locale;
    final boolean useSimpleFormatter;

    FieldReaderDateField(String fieldName, Class fieldType, int ordinal, long features, String format, Locale locale, Date defaultValue, Field field) {
        super(fieldName, (Type)fieldType, fieldType, ordinal, features, format, defaultValue, field);
        this.locale = locale;
        this.useSimpleFormatter = "yyyyMMddHHmmssSSSZ".equals(format);
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplDate.INSTANCE : new ObjectReaderImplDate(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Date fieldValue;
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            this.getObjectReader(jsonReader);
            if (this.dateReader.formatUnixTime) {
                millis *= 1000L;
            }
            fieldValue = new Date(millis);
        } else if (jsonReader.isNull()) {
            jsonReader.readNull();
            fieldValue = null;
        } else if (this.format != null) {
            this.getObjectReader(jsonReader);
            if (this.dateReader.useSimpleFormatter) {
                fieldValue = (Date)this.dateReader.readObject(jsonReader, this.features);
            } else {
                String str = jsonReader.readString();
                Locale locale = jsonReader.getContext().getLocale();
                DateTimeFormatter formatter = this.getFormatter(locale);
                LocalDateTime ldt = this.format.indexOf("HH") == -1 ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
                long millis = zdt.toInstant().toEpochMilli();
                fieldValue = new Date(millis);
            }
        } else {
            long millis = jsonReader.readMillisFromString();
            fieldValue = new Date(millis);
        }
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        if (value instanceof String) {
            JSONReader jsonReader = JSONReader.of(JSON.toJSONString(value));
            value = this.getObjectReader(jsonReader).readObject(jsonReader);
        } else if (value instanceof Integer) {
            long millis = ((Integer)value).intValue();
            if (this.dateReader.formatUnixTime) {
                millis *= 1000L;
            }
            value = new Date(millis);
        }
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    private DateTimeFormatter getFormatter(Locale locale) {
        if (this.formatter != null && locale == null) {
            return this.formatter;
        }
        String format = this.format.replaceAll("aa", "a");
        if (locale != null && locale != Locale.getDefault()) {
            return DateTimeFormatter.ofPattern(format, locale);
        }
        if (this.locale != null) {
            this.formatter = DateTimeFormatter.ofPattern(format, this.locale);
            return this.formatter;
        }
        this.formatter = DateTimeFormatter.ofPattern(format);
        return this.formatter;
    }
}

