/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;

final class FieldReaderStringFunc<T, V>
extends FieldReaderImpl<T> {
    final Method method;
    final BiConsumer<T, V> function;
    final String format;
    final boolean trim;

    FieldReaderStringFunc(String fieldName, Class<V> fieldClass, int ordinal, long features, String format, Object defaultValue, Method method, BiConsumer<T, V> function) {
        super(fieldName, fieldClass, fieldClass, ordinal, features, format, defaultValue);
        this.method = method;
        this.function = function;
        this.format = format;
        this.trim = "trim".equals(format);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void accept(T object, Object value) {
        String fieldValue = (String)value;
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        this.function.accept(object, fieldValue);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        String fieldValue = jsonReader.readString();
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        this.function.accept(object, fieldValue);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readString();
    }
}

