/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReader2<T>
extends ObjectReaderBean<T> {
    final long features;
    final Supplier<T> defaultCreator;
    final Function buildFunction;
    private final FieldReader first;
    private final FieldReader second;
    private final long firstHashCode;
    private final long secondHashCode;
    private final long firstHashCodeLCase;
    private final long secondHashCodeLCase;

    public ObjectReader2(Class objectClass, long features, Supplier<T> defaultCreator, Function buildFunction, FieldReader first, FieldReader second) {
        super(objectClass, null);
        this.features = features;
        this.defaultCreator = defaultCreator;
        this.buildFunction = buildFunction;
        this.first = first;
        this.second = second;
        String fieldName0 = first.getFieldName();
        this.firstHashCode = Fnv.hashCode64(fieldName0);
        this.firstHashCodeLCase = Fnv.hashCode64LCase(fieldName0);
        String fieldName1 = second.getFieldName();
        this.secondHashCode = Fnv.hashCode64(fieldName1);
        this.secondHashCodeLCase = Fnv.hashCode64LCase(fieldName1);
        if (first.isUnwrapped()) {
            this.extraFieldReader = first;
        }
        if (second.isUnwrapped()) {
            this.extraFieldReader = second;
        }
        this.hasDefaultValue = first.getDefaultValue() != null || second.getDefaultValue() != null;
    }

    @Override
    protected void initDefaultValue(T object) {
        this.first.setDefault(object);
        this.second.setDefault(object);
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T createInstance(long features) {
        return this.defaultCreator.get();
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, long features) {
        Object object;
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, features);
        }
        if (jsonReader.isArray()) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt != 2) {
                throw new JSONException("not support input entryCount " + entryCnt);
            }
            T object2 = this.defaultCreator.get();
            if (this.hasDefaultValue) {
                this.initDefaultValue(object2);
            }
            this.first.readFieldValue(jsonReader, object2);
            this.second.readFieldValue(jsonReader, object2);
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            throw new JSONException("expect object, but " + JSONB.typeName(jsonReader.getType()));
        }
        if (this.defaultCreator != null) {
            object = this.defaultCreator.get();
        } else if (JDKUtils.UNSAFE_SUPPORT && ((features | jsonReader.getContext().getFeatures()) & JSONReader.Feature.FieldBased.mask) != 0L) {
            try {
                object = UnsafeUtils.UNSAFE.allocateInstance(this.objectClass);
            }
            catch (InstantiationException e) {
                throw new JSONException("create instance error", e);
            }
        } else {
            object = null;
        }
        if (object != null && this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == 0L) continue;
            if (hashCode == this.firstHashCode) {
                this.first.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.secondHashCode) {
                this.second.readFieldValueJSONB(jsonReader, object);
                continue;
            }
            if (jsonReader.isSupportSmartMatch(features | this.features)) {
                long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                if (nameHashCodeLCase == this.firstHashCodeLCase) {
                    this.first.readFieldValueJSONB(jsonReader, object);
                    continue;
                }
                if (nameHashCodeLCase == this.secondHashCodeLCase) {
                    this.second.readFieldValueJSONB(jsonReader, object);
                    continue;
                }
            }
            this.processExtra(jsonReader, object);
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader) {
        return this.readObject(jsonReader, this.features);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public T readObject(JSONReader jsonReader, long features) {
        block15: {
            block14: {
                if (jsonReader.isJSONB()) {
                    return this.readJSONBObject(jsonReader, features);
                }
                if (jsonReader.nextIfNull()) {
                    jsonReader.nextIfMatch(',');
                    return null;
                }
                if (!jsonReader.isArray() || !jsonReader.isSupportBeanArray(this.features | features)) break block14;
                jsonReader.next();
                object = this.defaultCreator.get();
                if (this.hasDefaultValue) {
                    this.initDefaultValue(object);
                }
                this.first.readFieldValue(jsonReader, object);
                this.second.readFieldValue(jsonReader, object);
                if (jsonReader.current() != ']') {
                    throw new JSONException("array to bean end error, " + jsonReader.current());
                }
                jsonReader.next();
                break block15;
            }
            jsonReader.nextIfMatch('{');
            object = this.defaultCreator.get();
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            i = 0;
            while (!jsonReader.nextIfMatch('}')) {
                block17: {
                    block19: {
                        block18: {
                            block16: {
                                hashCode = jsonReader.readFieldNameHashCode();
                                if (i != 0 || hashCode != ObjectReader2.HASH_TYPE) break block16;
                                typeHash = jsonReader.readTypeHashCode();
                                context = jsonReader.getContext();
                                autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                                if ((autoTypeObjectReader != null || (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) != null) && autoTypeObjectReader != this) {
                                    object = autoTypeObjectReader.readObject(jsonReader, features);
                                    break;
                                }
                                break block17;
                            }
                            if (hashCode != this.firstHashCode) break block18;
                            this.first.readFieldValue(jsonReader, object);
                            break block17;
                        }
                        if (hashCode != this.secondHashCode) break block19;
                        this.second.readFieldValue(jsonReader, object);
                        break block17;
                    }
                    if (!jsonReader.isSupportSmartMatch(features | this.features)) ** GOTO lbl-1000
                    nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    if (nameHashCodeLCase == this.firstHashCodeLCase) {
                        this.first.readFieldValue(jsonReader, object);
                    } else if (nameHashCodeLCase == this.secondHashCodeLCase) {
                        this.second.readFieldValue(jsonReader, object);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.processExtra(jsonReader, object);
                    }
                }
                ++i;
            }
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            try {
                return (T)this.buildFunction.apply(object);
            }
            catch (IllegalStateException e) {
                throw new JSONException("build object error", e);
            }
        }
        return object;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.firstHashCode) {
            return this.first;
        }
        if (hashCode == this.secondHashCode) {
            return this.second;
        }
        return null;
    }
}

