/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

class ObjectReaderImplZonedDateTime
extends DateTimeCodec
implements ObjectReader {
    static final ObjectReaderImplZonedDateTime INSTANCE = new ObjectReaderImplZonedDateTime(null, null);

    public static ObjectReaderImplZonedDateTime of(String format, Locale locale) {
        if (format == null) {
            return INSTANCE;
        }
        return new ObjectReaderImplZonedDateTime(format, locale);
    }

    public ObjectReaderImplZonedDateTime(String format, Locale locale) {
        super(format, locale);
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        return jsonReader.readZonedDateTime();
    }

    public Object readObject(JSONReader jsonReader, long features) {
        DateTimeFormatter formatter;
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return ZonedDateTime.ofInstant(instant, jsonReader.getContext().getZoneId());
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.isString() && (formatter = this.getDateFormatter(jsonReader.getLocale())) != null) {
            String str = jsonReader.readString();
            LocalDateTime ldt = this.format.indexOf("HH") == -1 ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
            return ldt.atZone(jsonReader.getZoneId());
        }
        return jsonReader.readZonedDateTime();
    }
}

