/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.Field;

final class FieldWriterDoubleValField<T>
extends FieldWriterImpl<T> {
    final Field field;

    FieldWriterDoubleValField(String name, int ordinal, Field field) {
        super(name, ordinal, 0L, null, Double.TYPE, Double.TYPE);
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.getFieldValueDouble(object);
    }

    public double getFieldValueDouble(T object) {
        try {
            return this.field.getDouble(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        double value = this.getFieldValueDouble(object);
        this.writeDouble(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        double value = this.getFieldValueDouble(object);
        jsonWriter.writeDouble(value);
    }
}

