/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapString;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JSONObject1O;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObjectReaderImplMap
implements ObjectReader {
    static Function UNSAFE_OBJECT_CREATOR;
    static final Class CLASS_SINGLETON_MAP;
    static final Class CLASS_EMPTY_MAP;
    static final Class CLASS_EMPTY_SORTED_MAP;
    static final Class CLASS_EMPTY_NAVIGABLE_MAP;
    static final Class CLASS_UNMODIFIABLE_MAP;
    static final Class CLASS_UNMODIFIABLE_SORTED_MAP;
    static final Class CLASS_UNMODIFIABLE_NAVIGABLE_MAP;
    public static ObjectReaderImplMap INSTANCE;
    public static ObjectReaderImplMap INSTANCE_OBJECT;
    final Type fieldType;
    final Class mapType;
    final Class instanceType;
    final long features;
    final Function builder;
    volatile boolean instanceError;

    public static ObjectReader of(Type fieldType, Class mapType, long features) {
        String instanceTypeName;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Function<Map, Map> builder = null;
        Class<Object> instanceType = mapType;
        if ("".equals(instanceType.getSimpleName())) {
            instanceType = mapType.getSuperclass();
            if (fieldType == null) {
                fieldType = mapType.getGenericSuperclass();
            }
        }
        if (mapType == Map.class || mapType == AbstractMap.class || mapType == CLASS_SINGLETON_MAP) {
            instanceType = HashMap.class;
        } else if (mapType == CLASS_UNMODIFIABLE_MAP) {
            instanceType = LinkedHashMap.class;
        } else if (mapType == SortedMap.class || mapType == CLASS_UNMODIFIABLE_SORTED_MAP || mapType == CLASS_UNMODIFIABLE_NAVIGABLE_MAP) {
            instanceType = TreeMap.class;
        } else if (mapType == ConcurrentMap.class) {
            instanceType = ConcurrentHashMap.class;
        } else if (mapType == ConcurrentNavigableMap.class) {
            instanceType = ConcurrentSkipListMap.class;
        } else {
            switch (mapType.getTypeName()) {
                case "com.google.common.collect.ImmutableMap": 
                case "com.google.common.collect.RegularImmutableMap": {
                    instanceType = HashMap.class;
                    builder = GuavaSupport.immutableMapConverter();
                    break;
                }
                case "com.google.common.collect.SingletonImmutableBiMap": {
                    instanceType = HashMap.class;
                    builder = GuavaSupport.singletonBiMapConverter();
                    break;
                }
                case "java.util.Collections$SynchronizedMap": {
                    instanceType = HashMap.class;
                    builder = Collections::synchronizedMap;
                    break;
                }
                case "java.util.Collections$SynchronizedNavigableMap": {
                    instanceType = TreeMap.class;
                    builder = Collections::synchronizedNavigableMap;
                    break;
                }
                case "java.util.Collections$SynchronizedSortedMap": {
                    instanceType = TreeMap.class;
                    builder = Collections::synchronizedSortedMap;
                    break;
                }
            }
        }
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 2 && !"org.springframework.util.LinkedMultiValueMap".equals(instanceType.getName())) {
            Type keyType = actualTypeArguments[0];
            Type valueType = actualTypeArguments[1];
            if (keyType == String.class && valueType == String.class && builder == null) {
                return new ObjectReaderImplMapString(mapType, instanceType, features);
            }
            return new ObjectReaderImplMapTyped(mapType, instanceType, keyType, valueType, 0L, builder);
        }
        if (fieldType == null && features == 0L) {
            if (mapType == HashMap.class && instanceType == HashMap.class) {
                return INSTANCE;
            }
            if (mapType == JSONObject.class && instanceType == JSONObject.class) {
                return INSTANCE_OBJECT;
            }
        }
        switch (instanceTypeName = instanceType.getName()) {
            case "com.alibaba.fastjson.JSONObject": {
                builder = ObjectReaderImplMap.createObjectSupplier(instanceType);
                instanceType = HashMap.class;
                break;
            }
            case "com.google.common.collect.RegularImmutableMap": {
                builder = GuavaSupport.immutableMapConverter();
                instanceType = HashMap.class;
                break;
            }
            case "com.google.common.collect.SingletonImmutableBiMap": {
                builder = GuavaSupport.singletonBiMapConverter();
                instanceType = HashMap.class;
                break;
            }
            case "com.google.common.collect.ArrayListMultimap": {
                builder = GuavaSupport.createConvertFunction(instanceType);
                instanceType = HashMap.class;
                break;
            }
            default: {
                if (instanceType == JSONObject1O.class) {
                    Class objectClass = TypeUtils.loadClass("com.alibaba.fastjson.JSONObject");
                    builder = ObjectReaderImplMap.createObjectSupplier(objectClass);
                    instanceType = LinkedHashMap.class;
                    break;
                }
                if (mapType == CLASS_UNMODIFIABLE_MAP) {
                    builder = Collections::unmodifiableMap;
                    break;
                }
                if (mapType == CLASS_UNMODIFIABLE_SORTED_MAP) {
                    builder = Collections::unmodifiableSortedMap;
                    break;
                }
                if (mapType == CLASS_UNMODIFIABLE_NAVIGABLE_MAP) {
                    builder = Collections::unmodifiableNavigableMap;
                    break;
                }
                if (mapType != CLASS_SINGLETON_MAP) break;
                builder = map -> {
                    Map.Entry entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                };
            }
        }
        return new ObjectReaderImplMap(fieldType, mapType, instanceType, features, builder);
    }

    ObjectReaderImplMap(Type fieldType, Class mapType, Class instanceType, long features, Function builder) {
        this.fieldType = fieldType;
        this.mapType = mapType;
        this.instanceType = instanceType;
        this.features = features;
        this.builder = builder;
    }

    public Class getObjectClass() {
        return this.mapType;
    }

    @Override
    public Function getBuildFunction() {
        return this.builder;
    }

    public Object createInstance(long features) {
        if (this.instanceType == HashMap.class) {
            return new HashMap();
        }
        if (this.instanceType == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (this.instanceType == JSONObject.class) {
            return new JSONObject();
        }
        if (this.instanceType == CLASS_EMPTY_MAP) {
            return Collections.emptyMap();
        }
        if (this.instanceType == CLASS_EMPTY_SORTED_MAP) {
            return Collections.emptySortedMap();
        }
        if (this.instanceType == CLASS_EMPTY_NAVIGABLE_MAP) {
            return Collections.emptyNavigableMap();
        }
        if (JDKUtils.UNSAFE_SUPPORT) {
            String instanceTypeName;
            switch (instanceTypeName = this.instanceType.getName()) {
                case "com.ali.com.google.common.collect.EmptyImmutableBiMap": {
                    return ((Supplier<Object>)() -> {
                        try {
                            return UnsafeUtils.UNSAFE.allocateInstance(this.instanceType);
                        }
                        catch (InstantiationException e) {
                            throw new JSONException("create map error : " + this.instanceType);
                        }
                    }).get();
                }
                case "java.util.ImmutableCollections$Map1": {
                    return new HashMap();
                }
                case "java.util.ImmutableCollections$MapN": {
                    return new LinkedHashMap();
                }
            }
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create map error : " + this.instanceType);
        }
    }

    public Object createInstance(Map map, long features) {
        if (this.mapType.isInstance(map)) {
            return map;
        }
        if (this.mapType == JSONObject.class) {
            return new JSONObject(map);
        }
        Map instance = (Map)this.createInstance(features);
        instance.putAll(map);
        if (this.builder != null) {
            return this.builder.apply(instance);
        }
        return instance;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName1, long features) {
        ObjectReader objectReader = jsonReader.checkAutoType(this.mapType, 0L, this.features | features);
        if (objectReader != null && objectReader != this) {
            return objectReader.readJSONBObject(jsonReader, fieldType, fieldName1, features);
        }
        if (jsonReader.nextIfNull()) {
            return null;
        }
        boolean emptyObject = false;
        jsonReader.nextIfMatch((byte)-90);
        Supplier<Map> objectSupplier = jsonReader.getContext().getObjectSupplier();
        Map<String, Object> map = null;
        if (this.mapType == null && objectSupplier != null) {
            map = objectSupplier.get();
        } else if (this.instanceType == HashMap.class) {
            map = new HashMap();
        } else if (this.instanceType == LinkedHashMap.class) {
            map = new LinkedHashMap();
        } else if (this.instanceType == JSONObject.class) {
            map = new JSONObject();
        } else if (this.instanceType == CLASS_EMPTY_MAP) {
            map = Collections.EMPTY_MAP;
        } else {
            JSONException error;
            block43: {
                error = null;
                if (!this.instanceError) {
                    try {
                        map = (Map)this.instanceType.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        this.instanceError = true;
                        error = new JSONException(jsonReader.info("create map error " + this.instanceType));
                    }
                }
                if (this.instanceError && Map.class.isAssignableFrom(this.instanceType.getSuperclass())) {
                    try {
                        map = (Map)this.instanceType.getSuperclass().newInstance();
                        error = null;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        if (error != null) break block43;
                        error = new JSONException(jsonReader.info("create map error " + this.instanceType));
                    }
                }
            }
            if (error != null) {
                throw error;
            }
        }
        if (!emptyObject) {
            int i = 0;
            while (true) {
                String reference;
                Object fieldName;
                byte type;
                if ((type = jsonReader.getType()) == -91) {
                    jsonReader.next();
                    break;
                }
                if (type >= 73 && type <= 127) {
                    fieldName = jsonReader.readFieldName();
                } else if (jsonReader.nextIfMatch((byte)-109)) {
                    reference = jsonReader.readString();
                    fieldName = new ReferenceKey(i);
                    jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference));
                } else {
                    fieldName = jsonReader.readAny();
                }
                if (jsonReader.isReference()) {
                    reference = jsonReader.readReference();
                    if ("..".equals(reference)) {
                        map.put((String)fieldName, map);
                    } else {
                        jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference));
                        map.put((String)fieldName, null);
                    }
                } else {
                    Object value;
                    type = jsonReader.getType();
                    if (type >= 73 && type <= 125) {
                        value = jsonReader.readString();
                    } else if (type == -110) {
                        ObjectReader autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, this.features | features);
                        value = autoTypeObjectReader.readJSONBObject(jsonReader, null, fieldName, features);
                    } else if (type == -79) {
                        value = Boolean.TRUE;
                        jsonReader.next();
                    } else if (type == -80) {
                        value = Boolean.FALSE;
                        jsonReader.next();
                    } else if (type == -109) {
                        String reference2 = jsonReader.readReference();
                        if ("..".equals(reference2)) {
                            value = map;
                        } else {
                            value = null;
                            jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference2));
                        }
                    } else {
                        value = type == -90 ? jsonReader.readObject() : (type >= -108 && type <= -92 ? jsonReader.readArray() : jsonReader.readAny());
                    }
                    map.put((String)fieldName, value);
                }
                ++i;
            }
        }
        if (this.builder != null) {
            return this.builder.apply(map);
        }
        return map;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        JSONReader.Context context = jsonReader.getContext();
        Supplier<Map> objectSupplier = jsonReader.getContext().getObjectSupplier();
        Map object = objectSupplier != null && (this.mapType == null || this.mapType == JSONObject.class || "com.alibaba.fastjson.JSONObject".equals(this.mapType.getName())) ? objectSupplier.get() : (Map)this.createInstance(context.getFeatures() | features);
        jsonReader.read(object, features);
        jsonReader.nextIfMatch(',');
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }

    static Function createObjectSupplier(Class objectClass) {
        Constructor constructor;
        if (JDKUtils.UNSAFE_SUPPORT) {
            if (UNSAFE_OBJECT_CREATOR != null) {
                return UNSAFE_OBJECT_CREATOR;
            }
            UNSAFE_OBJECT_CREATOR = new ObjectCreatorUF(objectClass);
            return UNSAFE_OBJECT_CREATOR;
        }
        try {
            constructor = objectClass.getConstructor(Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new JSONException("create JSONObject1 error");
        }
        return arg -> {
            try {
                return constructor.newInstance(arg);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("create JSONObject1 error");
            }
        };
    }

    static {
        CLASS_SINGLETON_MAP = Collections.singletonMap(1, 1).getClass();
        CLASS_EMPTY_MAP = Collections.EMPTY_MAP.getClass();
        CLASS_EMPTY_SORTED_MAP = Collections.emptySortedMap().getClass();
        CLASS_EMPTY_NAVIGABLE_MAP = Collections.emptyNavigableMap().getClass();
        CLASS_UNMODIFIABLE_MAP = Collections.unmodifiableMap(Collections.emptyMap()).getClass();
        CLASS_UNMODIFIABLE_SORTED_MAP = Collections.unmodifiableSortedMap(Collections.emptySortedMap()).getClass();
        CLASS_UNMODIFIABLE_NAVIGABLE_MAP = Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()).getClass();
        INSTANCE = new ObjectReaderImplMap(null, HashMap.class, HashMap.class, 0L, null);
        INSTANCE_OBJECT = new ObjectReaderImplMap(null, JSONObject.class, JSONObject.class, 0L, null);
    }

    static class ObjectCreatorUF
    implements Function {
        final Class objectClass;
        final Field map;
        final long mapOffset;

        ObjectCreatorUF(Class objectClass) {
            this.objectClass = objectClass;
            try {
                this.map = objectClass.getDeclaredField("map");
            }
            catch (NoSuchFieldException e) {
                throw new JSONException("field map not found", e);
            }
            this.mapOffset = UnsafeUtils.UNSAFE.objectFieldOffset(this.map);
        }

        public Object apply(Object map) {
            Object object;
            if (map == null) {
                map = new HashMap();
            }
            try {
                object = UnsafeUtils.UNSAFE.allocateInstance(this.objectClass);
                UnsafeUtils.UNSAFE.putObject(object, this.mapOffset, map);
            }
            catch (InstantiationException e) {
                throw new JSONException("create " + this.objectClass.getName() + " error", e);
            }
            return object;
        }
    }
}

