/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class FieldWriterEnum
extends FieldWriter {
    final byte[][] valueNameCacheUTF8;
    final char[][] valueNameCacheUTF16;
    final byte[][] utf8ValueCache;
    final char[][] utf16ValueCache;
    final Class enumType;
    final Enum[] enumConstants;
    final long[] hashCodes;
    final long[] hashCodesSymbolCache;

    protected FieldWriterEnum(String name, int ordinal, long features, String format, String label, Type fieldType, Class<? extends Enum> enumClass, Field field, Method method) {
        super(name, ordinal, features, format, label, fieldType, enumClass, field, method);
        this.enumType = enumClass;
        this.enumConstants = enumClass.getEnumConstants();
        this.hashCodes = new long[this.enumConstants.length];
        this.hashCodesSymbolCache = new long[this.enumConstants.length];
        for (int i = 0; i < this.enumConstants.length; ++i) {
            this.hashCodes[i] = Fnv.hashCode64(this.enumConstants[i].name());
        }
        this.valueNameCacheUTF8 = new byte[this.enumConstants.length][];
        this.valueNameCacheUTF16 = new char[this.enumConstants.length][];
        this.utf8ValueCache = new byte[this.enumConstants.length][];
        this.utf16ValueCache = new char[this.enumConstants.length][];
    }

    @Override
    public final void writeEnumJSONB(JSONWriter jsonWriter, Enum e) {
        int symbol;
        if (e == null) {
            return;
        }
        long features = this.features | jsonWriter.getFeatures();
        boolean usingOrdinal = (features & (JSONWriter.Feature.WriteEnumUsingToString.mask | JSONWriter.Feature.WriteEnumsUsingName.mask)) == 0L;
        boolean usingToString = (features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L;
        int ordinal = e.ordinal();
        SymbolTable symbolTable = jsonWriter.symbolTable;
        if (symbolTable != null && usingOrdinal && !usingToString) {
            int enumSymbol;
            int symbolTableIdentity = System.identityHashCode(symbolTable);
            long enumNameCache = this.hashCodesSymbolCache[ordinal];
            if (enumNameCache == 0L) {
                enumSymbol = symbolTable.getOrdinalByHashCode(this.hashCodes[ordinal]);
                this.hashCodesSymbolCache[ordinal] = (long)enumSymbol << 32 | (long)symbolTableIdentity;
            } else {
                int identity = (int)enumNameCache;
                if (identity == symbolTableIdentity) {
                    enumSymbol = (int)(enumNameCache >> 32);
                } else {
                    enumSymbol = symbolTable.getOrdinalByHashCode(this.hashCodes[ordinal]);
                    this.hashCodesSymbolCache[ordinal] = (long)enumSymbol << 32 | (long)symbolTableIdentity;
                }
            }
            int namingOrdinal = enumSymbol;
            if (namingOrdinal >= 0) {
                int symbol2;
                if (this.nameSymbolCache == 0L) {
                    symbol2 = symbolTable.getOrdinalByHashCode(this.hashCode);
                    if (symbol2 != -1) {
                        this.nameSymbolCache = (long)symbol2 << 32 | (long)symbolTableIdentity;
                    }
                } else {
                    int identity = (int)this.nameSymbolCache;
                    if (identity == symbolTableIdentity) {
                        symbol2 = (int)(this.nameSymbolCache >> 32);
                    } else {
                        symbol2 = symbolTable.getOrdinalByHashCode(this.hashCode);
                        this.nameSymbolCache = (long)symbol2 << 32 | (long)symbolTableIdentity;
                    }
                }
                if (symbol2 != -1) {
                    jsonWriter.writeSymbol(-symbol2);
                } else {
                    if (this.nameJSONB == null) {
                        this.nameJSONB = JSONB.toBytes(this.fieldName);
                    }
                    jsonWriter.writeNameRaw(this.nameJSONB, this.hashCode);
                }
                jsonWriter.writeRaw((byte)121);
                jsonWriter.writeInt32(-namingOrdinal);
                return;
            }
        }
        if (usingToString) {
            if (symbolTable != null) {
                int symbolTableIdentity = System.identityHashCode(symbolTable);
                if (this.nameSymbolCache == 0L) {
                    symbol = symbolTable.getOrdinalByHashCode(this.hashCode);
                    this.nameSymbolCache = (long)symbol << 32 | (long)symbolTableIdentity;
                } else {
                    int identity = (int)this.nameSymbolCache;
                    if (identity == symbolTableIdentity) {
                        symbol = (int)(this.nameSymbolCache >> 32);
                    } else {
                        symbol = symbolTable.getOrdinalByHashCode(this.hashCode);
                        this.nameSymbolCache = (long)symbol << 32 | (long)symbolTableIdentity;
                    }
                }
            } else {
                symbol = -1;
            }
            if (symbol != -1) {
                jsonWriter.writeSymbol(-symbol);
            } else {
                if (this.nameJSONB == null) {
                    this.nameJSONB = JSONB.toBytes(this.fieldName);
                }
                jsonWriter.writeNameRaw(this.nameJSONB, this.hashCode);
            }
            jsonWriter.writeString(e.toString());
            return;
        }
        if (usingOrdinal) {
            if (symbolTable != null) {
                int symbolTableIdentity = System.identityHashCode(symbolTable);
                if (this.nameSymbolCache == 0L) {
                    symbol = symbolTable.getOrdinalByHashCode(this.hashCode);
                    this.nameSymbolCache = (long)symbol << 32 | (long)symbolTableIdentity;
                } else {
                    int identity = (int)this.nameSymbolCache;
                    if (identity == symbolTableIdentity) {
                        symbol = (int)(this.nameSymbolCache >> 32);
                    } else {
                        symbol = symbolTable.getOrdinalByHashCode(this.hashCode);
                        this.nameSymbolCache = (long)symbol << 32 | (long)symbolTableIdentity;
                    }
                }
            } else {
                symbol = -1;
            }
            if (symbol != -1) {
                jsonWriter.writeSymbol(-symbol);
            } else {
                if (this.nameJSONB == null) {
                    this.nameJSONB = JSONB.toBytes(this.fieldName);
                }
                jsonWriter.writeNameRaw(this.nameJSONB, this.hashCode);
            }
            jsonWriter.writeInt32(ordinal);
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(e.name());
    }

    @Override
    public final void writeEnum(JSONWriter jsonWriter, Enum e) {
        long features = this.features | jsonWriter.getFeatures();
        if ((features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(e.toString());
            return;
        }
        if (jsonWriter.jsonb) {
            this.writeEnumJSONB(jsonWriter, e);
            return;
        }
        boolean usingOrdinal = (features & JSONWriter.Feature.WriteEnumUsingOrdinal.mask) != 0L;
        boolean utf8 = jsonWriter.utf8;
        boolean utf16 = utf8 ? false : jsonWriter.utf16;
        int ordinal = e.ordinal();
        if (usingOrdinal) {
            if (utf8) {
                byte[] bytes = this.utf8ValueCache[ordinal];
                if (bytes == null) {
                    int size = IOUtils.stringSize(ordinal);
                    byte[] original = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + size);
                    bytes = Arrays.copyOf(original, original.length);
                    IOUtils.getChars(ordinal, bytes.length, bytes);
                    this.utf8ValueCache[ordinal] = bytes;
                }
                jsonWriter.writeNameRaw(bytes);
                return;
            }
            if (utf16) {
                char[] bytes = this.utf16ValueCache[ordinal];
                if (bytes == null) {
                    int size = IOUtils.stringSize(ordinal);
                    char[] original = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + size);
                    bytes = Arrays.copyOf(original, original.length);
                    IOUtils.getChars(ordinal, bytes.length, bytes);
                    this.utf16ValueCache[ordinal] = bytes;
                }
                jsonWriter.writeNameRaw(bytes);
                return;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt32(ordinal);
            return;
        }
        if (utf8) {
            byte[] bytes = this.valueNameCacheUTF8[ordinal];
            if (bytes == null) {
                byte[] nameUft8Bytes = this.enumConstants[ordinal].name().getBytes(StandardCharsets.UTF_8);
                bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + nameUft8Bytes.length + 2);
                bytes[this.nameWithColonUTF8.length] = 34;
                int index = this.nameWithColonUTF8.length + 1;
                for (byte b : nameUft8Bytes) {
                    bytes[index++] = b;
                }
                bytes[bytes.length - 1] = 34;
                this.valueNameCacheUTF8[ordinal] = bytes;
            }
            jsonWriter.writeNameRaw(bytes);
            return;
        }
        if (utf16) {
            char[] chars = this.valueNameCacheUTF16[ordinal];
            if (chars == null) {
                String name = this.enumConstants[ordinal].name();
                chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + name.length() + 2);
                chars[this.nameWithColonUTF16.length] = 34;
                name.getChars(0, name.length(), chars, this.nameWithColonUTF16.length + 1);
                chars[chars.length - 1] = 34;
                this.valueNameCacheUTF16[ordinal] = chars;
            }
            jsonWriter.writeNameRaw(chars);
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(e.toString());
    }

    public final void writeValue(JSONWriter jsonWriter, Object object) {
        Enum value = (Enum)this.getFieldValue(object);
        jsonWriter.writeEnum(value);
    }

    public boolean write(JSONWriter jsonWriter, Object object) {
        Enum value = (Enum)this.getFieldValue(object);
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNull();
                return true;
            }
            return false;
        }
        if (jsonWriter.jsonb) {
            this.writeEnumJSONB(jsonWriter, value);
        } else {
            this.writeEnum(jsonWriter, value);
        }
        return true;
    }
}

