/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONWriterUTF8
extends JSONWriter {
    static final byte[] REF_PREF = "{\"$ref\":".getBytes(StandardCharsets.ISO_8859_1);
    final JSONFactory.CacheItem cacheItem;
    protected byte[] bytes;

    JSONWriterUTF8(JSONWriter.Context ctx) {
        super(ctx, null, false, StandardCharsets.UTF_8);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        this.bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (this.bytes == null) {
            this.bytes = new byte[8192];
        }
    }

    @Override
    public final void writeReference(String path) {
        this.lastReference = path;
        this.writeRaw(REF_PREF);
        this.writeString(path);
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 125;
    }

    @Override
    public final void writeBase64(byte[] bytes) {
        int i;
        int charsLen = (bytes.length - 1) / 3 + 1 << 2;
        this.ensureCapacity(this.off + charsLen + 2);
        this.bytes[this.off++] = (byte)this.quote;
        int eLen = bytes.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 18 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 12 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i & 0x3F];
        }
        int left = bytes.length - eLen;
        if (left > 0) {
            i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytes.length - 1] & 0xFF) << 2 : 0);
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >> 12];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            this.bytes[this.off++] = left == 2 ? (int)JSONFactory.CA[i & 0x3F] : 61;
            this.bytes[this.off++] = 61;
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeHex(byte[] bytes) {
        if (bytes == null) {
            this.writeNull();
            return;
        }
        int charsLen = bytes.length * 2 + 3;
        this.ensureCapacity(this.off + charsLen + 2);
        this.bytes[this.off++] = 120;
        this.bytes[this.off++] = 39;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int a = b & 0xFF;
            int b0 = a >> 4;
            int b1 = a & 0xF;
            this.bytes[this.off++] = (byte)(b0 + (b0 < 10 ? 48 : 55));
            this.bytes[this.off++] = (byte)(b1 + (b1 < 10 ? 48 : 55));
        }
        this.bytes[this.off++] = 39;
    }

    @Override
    public final void close() {
        if (this.bytes.length > 0x100000) {
            return;
        }
        JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, this.bytes);
    }

    @Override
    public final int size() {
        return this.off;
    }

    @Override
    public final byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.off);
    }

    @Override
    public final byte[] getBytes(Charset charset) {
        if (charset == StandardCharsets.UTF_8) {
            return Arrays.copyOf(this.bytes, this.off);
        }
        String str = this.toString();
        return str.getBytes(charset);
    }

    @Override
    public final int flushTo(OutputStream to) throws IOException {
        int len = this.off;
        to.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }

    @Override
    protected final void write0(char c) {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = (byte)c;
    }

    @Override
    public final void writeColon() {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 58;
    }

    @Override
    public final void startObject() {
        ++this.level;
        this.startObject = true;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 123;
    }

    @Override
    public final void endObject() {
        --this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 125;
        this.startObject = false;
    }

    @Override
    public final void writeComma() {
        this.startObject = false;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 44;
    }

    @Override
    public final void startArray() {
        ++this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 91;
    }

    @Override
    public final void endArray() {
        --this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 93;
    }

    @Override
    public void writeString(String str) {
        char c3;
        char c2;
        char c1;
        char c0;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        char[] chars = JDKUtils.getCharArray(str);
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int minCapacity = this.off + chars.length * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += chars.length * 3;
        }
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        int i = 0;
        while (i + 8 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            char c4 = chars[i + 4];
            char c5 = chars[i + 5];
            char c6 = chars[i + 6];
            char c7 = chars[i + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || c4 > '\u007f' || c5 > '\u007f' || c6 > '\u007f' || c7 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')' || c4 == '<' || c4 == '>' || c4 == '(' || c4 == ')' || c5 == '<' || c5 == '>' || c5 == '(' || c5 == ')' || c6 == '<' || c6 == '>' || c6 == '(' || c6 == ')' || c7 == '<' || c7 == '>' || c7 == '(' || c7 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.bytes[this.off + 4] = (byte)c4;
            this.bytes[this.off + 5] = (byte)c5;
            this.bytes[this.off + 6] = (byte)c6;
            this.bytes[this.off + 7] = (byte)c7;
            this.off += 8;
            i += 8;
        }
        while (i + 4 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.off += 4;
            i += 4;
        }
        if (i + 2 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            if (c0 != this.quote && c1 != this.quote && c0 != '\\' && c1 != '\\' && c0 >= ' ' && c1 >= ' ' && c0 <= '\u007f' && c1 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')' && c1 != '<' && c1 != '>' && c1 != '(' && c1 != ')')) {
                this.bytes[this.off] = (byte)c0;
                this.bytes[this.off + 1] = (byte)c1;
                this.off += 2;
                i += 2;
            }
        }
        if (i + 1 == chars.length && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')')) {
            this.bytes[this.off++] = (byte)c0;
            this.bytes[this.off++] = (byte)this.quote;
            return;
        }
        int rest = chars.length - i;
        minCapacity = this.off + rest * 6 + 2;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (i < chars.length) {
            this.writeStringEscapedRest(chars, chars.length, browserSecure, escapeNoneAscii, i);
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    protected void writeStringLatin1(byte[] value) {
        int minCapacity;
        byte c3;
        byte c2;
        byte c1;
        byte c0;
        if (value == null) {
            this.writeStringNull();
            return;
        }
        boolean escape = false;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        int valueOffset = 0;
        while (valueOffset + 8 <= value.length) {
            c0 = value[valueOffset];
            c1 = value[valueOffset + 1];
            c2 = value[valueOffset + 2];
            c3 = value[valueOffset + 3];
            byte c4 = value[valueOffset + 4];
            byte c5 = value[valueOffset + 5];
            byte c6 = value[valueOffset + 6];
            byte c7 = value[valueOffset + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c4 == 92 || c5 == 92 || c6 == 92 || c7 == 92 || c0 < 32 || c1 < 32 || c2 < 32 || c3 < 32 || c4 < 32 || c5 < 32 || c6 < 32 || c7 < 32 || browserSecure && (c0 == 60 || c0 == 62 || c0 == 40 || c0 == 41 || c1 == 60 || c1 == 62 || c1 == 40 || c1 == 41 || c2 == 60 || c2 == 62 || c2 == 40 || c2 == 41 || c3 == 60 || c3 == 62 || c3 == 40 || c3 == 41 || c4 == 60 || c4 == 62 || c4 == 40 || c4 == 41 || c5 == 60 || c5 == 62 || c5 == 40 || c5 == 41 || c6 == 60 || c6 == 62 || c6 == 40 || c6 == 41 || c7 == 60 || c7 == 62 || c7 == 40 || c7 == 41)) {
                escape = true;
                break;
            }
            valueOffset += 8;
        }
        if (!escape) {
            while (valueOffset + 4 <= value.length) {
                c0 = value[valueOffset];
                c1 = value[valueOffset + 1];
                c2 = value[valueOffset + 2];
                c3 = value[valueOffset + 3];
                if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c0 < 32 || c1 < 32 || c2 < 32 || c3 < 32 || browserSecure && (c0 == 60 || c0 == 62 || c0 == 40 || c0 == 41 || c1 == 60 || c1 == 62 || c1 == 40 || c1 == 41 || c2 == 60 || c2 == 62 || c2 == 40 || c2 == 41 || c3 == 60 || c3 == 62 || c3 == 40 || c3 == 41)) {
                    escape = true;
                    break;
                }
                valueOffset += 4;
            }
        }
        if (!escape && valueOffset + 2 <= value.length) {
            c0 = value[valueOffset];
            c1 = value[valueOffset + 1];
            if (c0 == this.quote || c1 == this.quote || c0 == 92 || c1 == 92 || c0 < 32 || c1 < 32 || browserSecure && (c0 == 60 || c0 == 62 || c0 == 40 || c0 == 41 || c1 == 60 || c1 == 62 || c1 == 40 || c1 == 41)) {
                escape = true;
            } else {
                valueOffset += 2;
            }
        }
        if (!escape && valueOffset + 1 == value.length) {
            c0 = value[valueOffset];
            escape = c0 == this.quote || c0 == 92 || c0 < 32 || browserSecure && (c0 == 60 || c0 == 62 || c0 == 40 || c0 == 41);
        }
        if ((minCapacity = this.off + (escape ? value.length * 4 : value.length) + 2) - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (!escape) {
            this.bytes[this.off++] = (byte)this.quote;
            System.arraycopy(value, 0, this.bytes, this.off, value.length);
            this.off += value.length;
            this.bytes[this.off++] = (byte)this.quote;
            return;
        }
        this.writeStringEscaped(value);
    }

    @Override
    public final void writeString(char[] chars) {
        char c3;
        char c2;
        char c1;
        char c0;
        if (chars == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int minCapacity = this.off + chars.length * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += chars.length * 3;
        }
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        int i = 0;
        while (i + 8 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            char c4 = chars[i + 4];
            char c5 = chars[i + 5];
            char c6 = chars[i + 6];
            char c7 = chars[i + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || c4 > '\u007f' || c5 > '\u007f' || c6 > '\u007f' || c7 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')' || c4 == '<' || c4 == '>' || c4 == '(' || c4 == ')' || c5 == '<' || c5 == '>' || c5 == '(' || c5 == ')' || c6 == '<' || c6 == '>' || c6 == '(' || c6 == ')' || c7 == '<' || c7 == '>' || c7 == '(' || c7 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.bytes[this.off + 4] = (byte)c4;
            this.bytes[this.off + 5] = (byte)c5;
            this.bytes[this.off + 6] = (byte)c6;
            this.bytes[this.off + 7] = (byte)c7;
            this.off += 8;
            i += 8;
        }
        while (i + 4 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.off += 4;
            i += 4;
        }
        if (i + 2 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            if (c0 != this.quote && c1 != this.quote && c0 != '\\' && c1 != '\\' && c0 >= ' ' && c1 >= ' ' && c0 <= '\u007f' && c1 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')' && c1 != '<' && c1 != '>' && c1 != '(' && c1 != ')')) {
                this.bytes[this.off] = (byte)c0;
                this.bytes[this.off + 1] = (byte)c1;
                this.off += 2;
                i += 2;
            }
        }
        if (i + 1 == chars.length && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')')) {
            this.bytes[this.off++] = (byte)c0;
            this.bytes[this.off++] = (byte)this.quote;
            return;
        }
        int rest = chars.length - i;
        minCapacity = this.off + rest * 6 + 2;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (i < chars.length) {
            this.writeStringEscapedRest(chars, chars.length, browserSecure, escapeNoneAscii, i);
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeString(char[] chars, int stroff, int strlen) {
        char c3;
        char c2;
        char c1;
        char c0;
        if (chars == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        int end = stroff + strlen;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int minCapacity = this.off + strlen * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += strlen * 3;
        }
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        int i = stroff;
        while (i + 8 <= end) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            char c4 = chars[i + 4];
            char c5 = chars[i + 5];
            char c6 = chars[i + 6];
            char c7 = chars[i + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || c4 > '\u007f' || c5 > '\u007f' || c6 > '\u007f' || c7 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')' || c4 == '<' || c4 == '>' || c4 == '(' || c4 == ')' || c5 == '<' || c5 == '>' || c5 == '(' || c5 == ')' || c6 == '<' || c6 == '>' || c6 == '(' || c6 == ')' || c7 == '<' || c7 == '>' || c7 == '(' || c7 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.bytes[this.off + 4] = (byte)c4;
            this.bytes[this.off + 5] = (byte)c5;
            this.bytes[this.off + 6] = (byte)c6;
            this.bytes[this.off + 7] = (byte)c7;
            this.off += 8;
            i += 8;
        }
        while (i + 4 <= end) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')' || c1 == '<' || c1 == '>' || c1 == '(' || c1 == ')' || c2 == '<' || c2 == '>' || c2 == '(' || c2 == ')' || c3 == '<' || c3 == '>' || c3 == '(' || c3 == ')')) break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.off += 4;
            i += 4;
        }
        if (i + 2 <= end) {
            c0 = chars[i];
            c1 = chars[i + 1];
            if (c0 != this.quote && c1 != this.quote && c0 != '\\' && c1 != '\\' && c0 >= ' ' && c1 >= ' ' && c0 <= '\u007f' && c1 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')' && c1 != '<' && c1 != '>' && c1 != '(' && c1 != ')')) {
                this.bytes[this.off] = (byte)c0;
                this.bytes[this.off + 1] = (byte)c1;
                this.off += 2;
                i += 2;
            }
        }
        if (i + 1 == end && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')')) {
            this.bytes[this.off++] = (byte)c0;
            this.bytes[this.off++] = (byte)this.quote;
            return;
        }
        int rest = end - i;
        minCapacity = this.off + rest * 6 + 2;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (i < end) {
            this.writeStringEscapedRest(chars, end, browserSecure, escapeNoneAscii, i);
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    protected final void writeStringEscaped(byte[] value) {
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        this.bytes[this.off++] = (byte)this.quote;
        block13: for (int i = 0; i < value.length; ++i) {
            byte ch = value[i];
            switch (ch) {
                case 92: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 92;
                    continue block13;
                }
                case 10: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 110;
                    continue block13;
                }
                case 13: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 114;
                    continue block13;
                }
                case 12: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 102;
                    continue block13;
                }
                case 8: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 98;
                    continue block13;
                }
                case 9: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 116;
                    continue block13;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = (byte)(48 + ch);
                    continue block13;
                }
                case 11: 
                case 14: 
                case 15: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = (byte)(97 + (ch - 10));
                    continue block13;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 49;
                    this.bytes[this.off++] = (byte)(48 + (ch - 16));
                    continue block13;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 49;
                    this.bytes[this.off++] = (byte)(97 + (ch - 26));
                    continue block13;
                }
                case 40: 
                case 41: 
                case 60: 
                case 62: {
                    if (browserSecure) {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = 117;
                        this.bytes[this.off++] = (byte)DIGITS[ch >>> 12 & 0xF];
                        this.bytes[this.off++] = (byte)DIGITS[ch >>> 8 & 0xF];
                        this.bytes[this.off++] = (byte)DIGITS[ch >>> 4 & 0xF];
                        this.bytes[this.off++] = (byte)DIGITS[ch & 0xF];
                        continue block13;
                    }
                    this.bytes[this.off++] = ch;
                    continue block13;
                }
                default: {
                    if (ch == this.quote) {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = (byte)this.quote;
                        continue block13;
                    }
                    if (ch < 0) {
                        int c = ch & 0xFF;
                        this.bytes[this.off++] = (byte)(0xC0 | c >> 6);
                        this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
                        continue block13;
                    }
                    this.bytes[this.off++] = ch;
                }
            }
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void writeStringEscapedRest(char[] chars, int end, boolean browserSecure, boolean escapeNoneAscii, int i) {
        while (i < end) {
            block23: {
                block25: {
                    block26: {
                        block28: {
                            block27: {
                                block24: {
                                    block22: {
                                        ch = chars[i];
                                        if (ch < '\u0000' || ch > '\u007f') break block22;
                                        switch (ch) {
                                            case 92: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 92;
                                                break;
                                            }
                                            case 10: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 110;
                                                break;
                                            }
                                            case 13: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 114;
                                                break;
                                            }
                                            case 12: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 102;
                                                break;
                                            }
                                            case 8: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 98;
                                                break;
                                            }
                                            case 9: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 116;
                                                break;
                                            }
                                            case 0: 
                                            case 1: 
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: 
                                            case 7: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(48 + ch);
                                                break;
                                            }
                                            case 11: 
                                            case 14: 
                                            case 15: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 10));
                                                break;
                                            }
                                            case 16: 
                                            case 17: 
                                            case 18: 
                                            case 19: 
                                            case 20: 
                                            case 21: 
                                            case 22: 
                                            case 23: 
                                            case 24: 
                                            case 25: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(48 + (ch - 16));
                                                break;
                                            }
                                            case 26: 
                                            case 27: 
                                            case 28: 
                                            case 29: 
                                            case 30: 
                                            case 31: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 26));
                                                break;
                                            }
                                            case 40: 
                                            case 41: 
                                            case 60: 
                                            case 62: {
                                                if (browserSecure) {
                                                    this.bytes[this.off++] = 92;
                                                    this.bytes[this.off++] = 117;
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 12 & 15];
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 8 & 15];
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 4 & 15];
                                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch & 15];
                                                    break;
                                                }
                                                this.bytes[this.off++] = (byte)ch;
                                                break;
                                            }
                                            default: {
                                                if (ch == this.quote) {
                                                    this.bytes[this.off++] = 92;
                                                    this.bytes[this.off++] = (byte)this.quote;
                                                    break;
                                                }
                                                this.bytes[this.off++] = (byte)ch;
                                                break;
                                            }
                                        }
                                        break block23;
                                    }
                                    if (!escapeNoneAscii) break block24;
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 12 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 8 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 4 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch & 15];
                                    break block23;
                                }
                                if (ch < '\ud800' || ch >= '\ue000') break block25;
                                if (ch < '\ud800' || ch >= '\udc00') break block26;
                                if (chars.length - i >= 2) break block27;
                                uc = '\uffffffff';
                                ** GOTO lbl108
                            }
                            d = chars[i + 1];
                            if (d < '\udc00' || d >= '\ue000') break block28;
                            uc = (ch << 10) + d + -56613888;
                            ** GOTO lbl108
                        }
                        this.bytes[this.off++] = 63;
                        break block23;
                    }
                    if (ch >= '\udc00' && ch < '\ue000') {
                        this.bytes[this.off++] = 63;
                    } else {
                        uc = ch;
lbl108:
                        // 3 sources

                        if (uc < '\u0000') {
                            this.bytes[this.off++] = 63;
                        } else {
                            this.bytes[this.off++] = (byte)(240 | uc >> 18);
                            this.bytes[this.off++] = (byte)(128 | uc >> 12 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc >> 6 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc & 63);
                            ++i;
                        }
                    }
                    break block23;
                }
                if (ch > '\u07ff') {
                    this.bytes[this.off++] = (byte)(224 | ch >> 12 & 15);
                    this.bytes[this.off++] = (byte)(128 | ch >> 6 & 63);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                } else {
                    this.bytes[this.off++] = (byte)(192 | ch >> 6 & 31);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final void writeString(char[] chars, int offset, int len, boolean quoted) {
        escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        minCapacity = this.off + chars.length * 3 + 2;
        if (escapeNoneAscii) {
            minCapacity += len * 3;
        }
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (quoted) {
            this.bytes[this.off++] = (byte)this.quote;
        }
        i = 0;
        while (i + 8 <= len) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            c4 = chars[i + 4];
            c5 = chars[i + 5];
            c6 = chars[i + 6];
            c7 = chars[i + 7];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || c4 > '\u007f' || c5 > '\u007f' || c6 > '\u007f' || c7 > '\u007f') break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.bytes[this.off + 4] = (byte)c4;
            this.bytes[this.off + 5] = (byte)c5;
            this.bytes[this.off + 6] = (byte)c6;
            this.bytes[this.off + 7] = (byte)c7;
            this.off += 8;
            i += 8;
        }
        while (i + 4 <= len) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f') break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.off += 4;
            i += 4;
        }
        if (i + 2 <= len) {
            c0 = chars[i];
            c1 = chars[i + 1];
            if (c0 != this.quote && c1 != this.quote && c0 != '\\' && c1 != '\\' && c0 >= ' ' && c1 >= ' ' && c0 <= '\u007f' && c1 <= '\u007f') {
                this.bytes[this.off] = (byte)c0;
                this.bytes[this.off + 1] = (byte)c1;
                this.off += 2;
                i += 2;
            }
        }
        if (i + 1 == len && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f') {
            this.bytes[this.off++] = (byte)c0;
            if (quoted) {
                this.bytes[this.off++] = (byte)this.quote;
            }
            return;
        }
        while (i < len) {
            block31: {
                block33: {
                    block34: {
                        block36: {
                            block35: {
                                block32: {
                                    block30: {
                                        ch = chars[i];
                                        if (ch < '\u0000' || ch > '\u007f') break block30;
                                        switch (ch) {
                                            case 92: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 92;
                                                break;
                                            }
                                            case 10: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 110;
                                                break;
                                            }
                                            case 13: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 114;
                                                break;
                                            }
                                            case 12: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 102;
                                                break;
                                            }
                                            case 8: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 98;
                                                break;
                                            }
                                            case 9: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 116;
                                                break;
                                            }
                                            case 0: 
                                            case 1: 
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: 
                                            case 7: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(48 + ch);
                                                break;
                                            }
                                            case 11: 
                                            case 14: 
                                            case 15: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 10));
                                                break;
                                            }
                                            case 16: 
                                            case 17: 
                                            case 18: 
                                            case 19: 
                                            case 20: 
                                            case 21: 
                                            case 22: 
                                            case 23: 
                                            case 24: 
                                            case 25: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(48 + (ch - 16));
                                                break;
                                            }
                                            case 26: 
                                            case 27: 
                                            case 28: 
                                            case 29: 
                                            case 30: 
                                            case 31: {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = 117;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 48;
                                                this.bytes[this.off++] = 49;
                                                this.bytes[this.off++] = (byte)(97 + (ch - 26));
                                                break;
                                            }
                                            default: {
                                                if (ch == this.quote) {
                                                    this.bytes[this.off++] = 92;
                                                    this.bytes[this.off++] = (byte)this.quote;
                                                    break;
                                                }
                                                this.bytes[this.off++] = (byte)ch;
                                                break;
                                            }
                                        }
                                        break block31;
                                    }
                                    if (!escapeNoneAscii) break block32;
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 12 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 8 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch >>> 4 & 15];
                                    this.bytes[this.off++] = (byte)JSONWriterUTF8.DIGITS[ch & 15];
                                    break block31;
                                }
                                if (ch < '\ud800' || ch >= '\ue000') break block33;
                                if (ch < '\ud800' || ch >= '\udc00') break block34;
                                if (chars.length - i >= 2) break block35;
                                uc = '\uffffffff';
                                ** GOTO lbl153
                            }
                            d = chars[i + 1];
                            if (d < '\udc00' || d >= '\ue000') break block36;
                            uc = (ch << 10) + d + -56613888;
                            ** GOTO lbl153
                        }
                        this.bytes[this.off++] = 63;
                        break block31;
                    }
                    if (ch >= '\udc00' && ch < '\ue000') {
                        this.bytes[this.off++] = 63;
                    } else {
                        uc = ch;
lbl153:
                        // 3 sources

                        if (uc < '\u0000') {
                            this.bytes[this.off++] = 63;
                        } else {
                            this.bytes[this.off++] = (byte)(240 | uc >> 18);
                            this.bytes[this.off++] = (byte)(128 | uc >> 12 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc >> 6 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc & 63);
                            ++i;
                        }
                    }
                    break block31;
                }
                if (ch > '\u07ff') {
                    this.bytes[this.off++] = (byte)(224 | ch >> 12 & 15);
                    this.bytes[this.off++] = (byte)(128 | ch >> 6 & 63);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                } else {
                    this.bytes[this.off++] = (byte)(192 | ch >> 6 & 31);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                }
            }
            ++i;
        }
        if (quoted) {
            this.bytes[this.off++] = (byte)this.quote;
        }
    }

    @Override
    public final void writeChar(char ch) {
        int minCapacity = this.off + 8;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        if (ch >= '\u0000' && ch <= '\u007f') {
            switch (ch) {
                case '\\': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 92;
                    break;
                }
                case '\n': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 110;
                    break;
                }
                case '\r': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 114;
                    break;
                }
                case '\f': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 102;
                    break;
                }
                case '\b': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 98;
                    break;
                }
                case '\t': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 116;
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = (byte)(48 + ch);
                    break;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = (byte)(97 + (ch - 10));
                    break;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 49;
                    this.bytes[this.off++] = (byte)(48 + (ch - 16));
                    break;
                }
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 117;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 48;
                    this.bytes[this.off++] = 49;
                    this.bytes[this.off++] = (byte)(97 + (ch - 26));
                    break;
                }
                default: {
                    if (ch == this.quote) {
                        this.bytes[this.off++] = 92;
                        this.bytes[this.off++] = (byte)this.quote;
                        break;
                    }
                    this.bytes[this.off++] = (byte)ch;
                    break;
                }
            }
        } else {
            if (ch >= '\ud800' && ch < '\ue000') {
                throw new JSONException("illegal char " + ch);
            }
            if (ch > '\u07ff') {
                this.bytes[this.off++] = (byte)(0xE0 | ch >> 12 & 0xF);
                this.bytes[this.off++] = (byte)(0x80 | ch >> 6 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | ch >> 0 & 0x3F);
            } else {
                this.bytes[this.off++] = (byte)(0xC0 | ch >> 6 & 0x1F);
                this.bytes[this.off++] = (byte)(0x80 | ch >> 0 & 0x3F);
            }
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long hi = value.getMostSignificantBits();
        long lo = value.getLeastSignificantBits();
        int hi1 = (int)(hi >> 32);
        int hi2 = (int)hi;
        int lo1 = (int)(lo >> 32);
        int lo2 = (int)lo;
        int minCapacity = this.off + 38;
        if (minCapacity > this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = 34;
        int v = hi1 >> 24 & 0xFF;
        char l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = hi1 >> 16 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = hi1 >> 8 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = hi1 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        this.bytes[this.off++] = 45;
        v = hi2 >> 24 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = hi2 >> 16 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        this.bytes[this.off++] = 45;
        v = hi2 >> 8 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = hi2 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        this.bytes[this.off++] = 45;
        v = lo1 >> 24 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = lo1 >> 16 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        this.bytes[this.off++] = 45;
        v = lo1 >> 8 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = lo1 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = lo2 >> 24 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = lo2 >> 16 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = lo2 >> 8 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        v = lo2 & 0xFF;
        l = JSONFactory.UUID_LOOKUP[v];
        this.bytes[this.off++] = (byte)(l >> 8);
        this.bytes[this.off++] = (byte)l;
        this.bytes[this.off++] = 34;
    }

    @Override
    public final void writeRaw(String str) {
        char[] chars = JDKUtils.getCharArray(str);
        int minCapacity = this.off + chars.length * 3;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.bytes[this.off++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.bytes[this.off++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.bytes[this.off++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.bytes[this.off++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.bytes[this.off++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    @Override
    public final void writeRaw(byte[] bytes) {
        int minCapacity = this.off + bytes.length;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public final void writeNameRaw(byte[] bytes) {
        int minCapacity = this.off + bytes.length + (this.startObject ? 0 : 1);
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.bytes[this.off++] = 44;
        }
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public final void writeRaw(char ch) {
        if (ch > '\u0080') {
            throw new JSONException("not support " + ch);
        }
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = (byte)ch;
    }

    @Override
    public final void writeRaw(char c0, char c1) {
        if (c0 > '\u0080') {
            throw new JSONException("not support " + c0);
        }
        if (c1 > '\u0080') {
            throw new JSONException("not support " + c1);
        }
        if (this.off + 1 >= this.bytes.length) {
            this.ensureCapacity(this.off + 2);
        }
        this.bytes[this.off++] = (byte)c0;
        this.bytes[this.off++] = (byte)c1;
    }

    @Override
    public final void writeNameRaw(byte[] bytes, int off, int len) {
        int minCapacity = this.off + len + (this.startObject ? 0 : 1);
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.bytes[this.off++] = 44;
        }
        System.arraycopy(bytes, off, this.bytes, this.off, len);
        this.off += len;
    }

    final void ensureCapacity(int minCapacity) {
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
    }

    @Override
    public final void writeInt32(int[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L;
        int minCapacity = this.off + 2 + values.length * (writeAsString ? 23 : 21);
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = 91;
        if (writeAsString) {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.bytes[this.off++] = 44;
                }
                int v = values[i];
                this.bytes[this.off++] = 34;
                this.off = IOUtils.writeInt32(this.bytes, this.off, v);
                this.bytes[this.off++] = 34;
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.bytes[this.off++] = 44;
                }
                int v = values[i];
                this.off = IOUtils.writeInt32(this.bytes, this.off, v);
            }
        }
        this.bytes[this.off++] = 93;
    }

    @Override
    public final void writeInt32(int i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 13;
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        if (writeAsString) {
            this.bytes[this.off++] = 34;
            this.off = IOUtils.writeInt32(this.bytes, this.off, i);
            this.bytes[this.off++] = 34;
        } else {
            this.off = IOUtils.writeInt32(this.bytes, this.off, i);
        }
    }

    @Override
    public final void writeInt64(long[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean browserCompatible = (this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L;
        boolean noneStringAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L;
        boolean writeAsString = noneStringAsString || browserCompatible;
        int minCapacity = this.off + 2 + values.length * (writeAsString ? 23 : 21);
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = 91;
        if (writeAsString) {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.bytes[this.off++] = 44;
                }
                long v = values[i];
                if (!noneStringAsString && browserCompatible && v <= 0x1FFFFFFFFFFFFFL && v >= -9007199254740991L) {
                    this.off = IOUtils.writeInt64(this.bytes, this.off, v);
                    continue;
                }
                this.bytes[this.off++] = 34;
                this.off = IOUtils.writeInt64(this.bytes, this.off, v);
                this.bytes[this.off++] = 34;
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.bytes[this.off++] = 44;
                }
                long v = values[i];
                this.off = IOUtils.writeInt64(this.bytes, this.off, v);
            }
        }
        this.bytes[this.off++] = 93;
    }

    @Override
    public final void writeInt64(long i) {
        boolean writeAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L || (this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (i > 0x1FFFFFFFFFFFFFL || i < -9007199254740991L);
        int minCapacity = this.off + 23;
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        if (writeAsString) {
            this.bytes[this.off++] = 34;
            this.off = IOUtils.writeInt64(this.bytes, this.off, i);
            this.bytes[this.off++] = 34;
        } else {
            this.off = IOUtils.writeInt64(this.bytes, this.off, i);
        }
    }

    @Override
    public final void writeFloat(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            this.writeNull();
            return;
        }
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 15;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
        int len = RyuDouble.toString(value, this.bytes, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
    }

    @Override
    public final void writeDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.writeNull();
            return;
        }
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 24;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        if (minCapacity > this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
        int len = RyuDouble.toString(value, this.bytes, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.bytes[this.off++] = 34;
        }
    }

    @Override
    public final void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 16);
        this.bytes[this.off++] = (byte)this.quote;
        IOUtils.write4(year, this.bytes, this.off);
        IOUtils.write2(month, this.bytes, this.off + 4);
        IOUtils.write2(dayOfMonth, this.bytes, this.off + 6);
        IOUtils.write2(hour, this.bytes, this.off + 8);
        IOUtils.write2(minute, this.bytes, this.off + 10);
        IOUtils.write2(second, this.bytes, this.off + 12);
        this.off += 14;
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 21);
        this.bytes[this.off++] = (byte)this.quote;
        IOUtils.write4(year, this.bytes, this.off);
        this.off += 4;
        this.bytes[this.off++] = 45;
        IOUtils.write2(month, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 45;
        IOUtils.write2(dayOfMonth, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 32;
        IOUtils.write2(hour, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        IOUtils.write2(minute, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        IOUtils.write2(second, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeLocalDate(LocalDate date) {
        int minCapacity;
        if (date == null) {
            this.writeNull();
            return;
        }
        if (this.context.dateFormat != null) {
            if (this.context.dateFormatUnixTime) {
                LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.MIN);
                long millis = dateTime.atZone(this.context.getZoneId()).toInstant().toEpochMilli();
                this.writeInt64(millis / 1000L);
                return;
            }
            if (this.context.dateFormatMillis) {
                LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.MIN);
                long millis = dateTime.atZone(this.context.getZoneId()).toInstant().toEpochMilli();
                this.writeInt64(millis);
                return;
            }
            DateTimeFormatter formatter = this.context.getDateFormatter();
            if (formatter != null) {
                String str = this.context.isDateFormatHasHour() ? formatter.format(LocalDateTime.of(date, LocalTime.MIN)) : formatter.format(date);
                this.writeString(str);
                return;
            }
        }
        if ((minCapacity = this.off + 18) > this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        this.writeLocalDate0(date);
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeLocalDateTime(LocalDateTime dateTime) {
        int minCapacity = this.off + 38;
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        this.writeLocalDate0(dateTime.toLocalDate());
        this.bytes[this.off++] = 32;
        this.writeLocalTime0(dateTime.toLocalTime());
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        int minCapacity = this.off + 10;
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        IOUtils.write4(year, this.bytes, this.off);
        this.off += 4;
        IOUtils.write2(month, this.bytes, this.off);
        this.off += 2;
        IOUtils.write2(dayOfMonth, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        int minCapacity = this.off + 12;
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        IOUtils.write4(year, this.bytes, this.off);
        this.off += 4;
        this.bytes[this.off + 5] = 45;
        IOUtils.write2(month, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off + 8] = 45;
        IOUtils.write2(dayOfMonth, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeTimeHHMMSS8(int hour, int minute, int second) {
        int minCapacity = this.off + 10;
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        IOUtils.write2(hour, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        IOUtils.write2(minute, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        IOUtils.write2(second, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeLocalTime(LocalTime time) {
        int minCapacity = this.off + 20;
        if (minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        this.writeLocalTime0(time);
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeZonedDateTime(ZonedDateTime dateTime) {
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        ZoneId zone = dateTime.getZone();
        String zoneId = zone.getId();
        char firstZoneChar = '\u0000';
        if (ZoneOffset.UTC == zone || zoneId.length() <= 3 && ("UTC".equals(zoneId) || "Z".equals(zoneId))) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneId.length() != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneId.length() : 2 + zoneId.length();
        }
        int minCapacity = this.off + zoneSize + 38;
        if (minCapacity > this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        this.writeLocalDate0(dateTime.toLocalDate());
        this.bytes[this.off++] = 84;
        this.writeLocalTime0(dateTime.toLocalTime());
        if (zoneSize == 1) {
            this.bytes[this.off++] = 90;
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getBytes(0, zoneId.length(), this.bytes, this.off);
            this.off += zoneId.length();
        } else {
            this.bytes[this.off++] = 91;
            zoneId.getBytes(0, zoneId.length(), this.bytes, this.off);
            this.off += zoneId.length();
            this.bytes[this.off++] = 93;
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeOffsetDateTime(OffsetDateTime dateTime) {
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        ZoneOffset offset = dateTime.getOffset();
        String zoneId = offset.getId();
        char firstZoneChar = '\u0000';
        if (ZoneOffset.UTC == offset || zoneId.length() <= 3 && ("UTC".equals(zoneId) || "Z".equals(zoneId))) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneId.length() != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneId.length() : 2 + zoneId.length();
        }
        int minCapacity = this.off + zoneSize + 38;
        if (minCapacity > this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        LocalDateTime ldt = dateTime.toLocalDateTime();
        this.writeLocalDate0(ldt.toLocalDate());
        this.bytes[this.off++] = 84;
        this.writeLocalTime0(ldt.toLocalTime());
        if (zoneSize == 1) {
            this.bytes[this.off++] = 90;
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getBytes(0, zoneId.length(), this.bytes, this.off);
            this.off += zoneId.length();
        } else {
            this.bytes[this.off++] = 91;
            zoneId.getBytes(0, zoneId.length(), this.bytes, this.off);
            this.off += zoneId.length();
            this.bytes[this.off++] = 93;
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    final void writeLocalDate0(LocalDate localDate) {
        int year = localDate.getYear();
        if (year >= 0 && year < 10000) {
            IOUtils.write4(year, this.bytes, this.off);
            this.off += 4;
        } else {
            int yearSize = year > 0 ? IOUtils.stringSize(year) : IOUtils.stringSize(-year) + 1;
            IOUtils.getChars(year, this.off + yearSize, this.bytes);
            this.off += yearSize;
        }
        this.bytes[this.off++] = 45;
        int month = localDate.getMonthValue();
        IOUtils.write2(month, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 45;
        int dayOfMonth = localDate.getDayOfMonth();
        IOUtils.write2(dayOfMonth, this.bytes, this.off);
        this.off += 2;
    }

    final void writeLocalTime0(LocalTime time) {
        int hour = time.getHour();
        IOUtils.write2(hour, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        int minute = time.getMinute();
        IOUtils.write2(minute, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        int second = time.getSecond();
        IOUtils.write2(second, this.bytes, this.off);
        this.off += 2;
        int nano = time.getNano();
        if (nano != 0) {
            int div = nano / 1000;
            int div2 = div / 1000;
            int rem1 = nano - div * 1000;
            this.bytes[this.off++] = 46;
            if (rem1 != 0) {
                IOUtils.write3(div2, this.bytes, this.off);
                IOUtils.write3(div - div2 * 1000, this.bytes, this.off + 3);
                IOUtils.write3(rem1, this.bytes, this.off + 6);
                this.off += 9;
            } else {
                int rem2 = div - div2 * 1000;
                if (rem2 != 0) {
                    IOUtils.write3(div2, this.bytes, this.off);
                    IOUtils.write3(rem2, this.bytes, this.off + 3);
                    this.off += 6;
                } else {
                    IOUtils.write3(div2, this.bytes, this.off);
                    this.off += 3;
                }
            }
        }
    }

    @Override
    public final void writeBigInt(BigInteger value, long features) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        String str = value.toString(10);
        if (((this.context.features | features) & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW_BIGINT) < 0 || value.compareTo(JSONFactory.HIGH_BIGINT) > 0)) {
            this.writeString(str);
            return;
        }
        int strlen = str.length();
        int minCapacity = this.off + strlen;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        str.getBytes(0, strlen, this.bytes, this.off);
        this.off += strlen;
    }

    @Override
    public final void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        int zonelen = timeZone ? (offsetSeconds == 0 ? 1 : 6) : 0;
        int minCapacity = this.off + 25 + zonelen;
        if (this.off + minCapacity >= this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        IOUtils.write4(year, this.bytes, this.off);
        this.off += 4;
        this.bytes[this.off++] = 45;
        IOUtils.write2(month, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 45;
        IOUtils.write2(dayOfMonth, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = (byte)(timeZone ? 84 : 32);
        IOUtils.write2(hour, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        IOUtils.write2(minute, this.bytes, this.off);
        this.off += 2;
        this.bytes[this.off++] = 58;
        IOUtils.write2(second, this.bytes, this.off);
        this.off += 2;
        if (millis > 0) {
            this.bytes[this.off++] = 46;
            int div = millis / 10;
            int div2 = div / 10;
            int rem1 = millis - div * 10;
            if (rem1 != 0) {
                IOUtils.write3(millis, this.bytes, this.off);
                this.off += 3;
            } else {
                int rem2 = div - div2 * 10;
                if (rem2 != 0) {
                    IOUtils.write2(div, this.bytes, this.off);
                    this.off += 2;
                } else {
                    this.bytes[this.off++] = (byte)(div2 + 48);
                }
            }
        }
        if (timeZone) {
            int offset = offsetSeconds / 3600;
            if (offsetSeconds == 0) {
                this.bytes[this.off++] = 90;
            } else {
                int offsetAbs = Math.abs(offset);
                this.bytes[this.off++] = offset >= 0 ? 43 : 45;
                IOUtils.write2(offsetAbs, this.bytes, this.off);
                this.off += 2;
                this.bytes[this.off++] = 58;
                int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.write2(offsetMinutes, this.bytes, this.off);
                this.off += 2;
            }
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeDecimal(BigDecimal value, long features, DecimalFormat format) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (format != null) {
            String str = format.format(value);
            this.writeRaw(str);
            return;
        }
        int precision = value.precision();
        boolean browserCompatible = ((features |= this.context.features) & JSONWriter.Feature.BrowserCompatible.mask) != 0L && precision >= 16 && (value.compareTo(JSONFactory.LOW) < 0 || value.compareTo(JSONFactory.HIGH) > 0);
        int minCapacity = this.off + precision + 4;
        if (minCapacity > this.bytes.length) {
            this.ensureCapacity(minCapacity);
        }
        if (browserCompatible) {
            this.bytes[this.off++] = 34;
        }
        if ((features & JSONWriter.Feature.WriteBigDecimalAsPlain.mask) != 0L) {
            long unscaleValue;
            if (precision < 19 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L && (unscaleValue = UnsafeUtils.getLong(value, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET)) != Long.MIN_VALUE) {
                int scale = value.scale();
                this.off += IOUtils.getDecimalChars(unscaleValue, scale, this.bytes, this.off);
            } else {
                String str = value.toPlainString();
                str.getBytes(0, str.length(), this.bytes, this.off);
                this.off += str.length();
            }
        } else {
            String str = value.toString();
            int strlen = str.length();
            str.getBytes(0, strlen, this.bytes, this.off);
            this.off += strlen;
        }
        if (browserCompatible) {
            this.bytes[this.off++] = 34;
        }
    }

    @Override
    public final void writeNameRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void writeNameRaw(char[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void write(JSONObject map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 123;
        boolean first = true;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next;
            Object value;
            if (!first) {
                if (this.off == this.bytes.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.bytes[this.off++] = 44;
            }
            if ((value = (next = it.next()).getValue()) == null && (this.context.features & JSONWriter.Feature.WriteMapNullValue.mask) == 0L) continue;
            first = false;
            this.writeString((String)next.getKey());
            if (this.off == this.bytes.length) {
                this.ensureCapacity(this.off + 1);
            }
            this.bytes[this.off++] = 58;
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 125;
    }

    @Override
    public final void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 91;
        boolean first = true;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            if (!first) {
                if (this.off == this.bytes.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.bytes[this.off++] = 44;
            }
            first = false;
            Object value = array.get(i);
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = 93;
    }

    public final String toString() {
        return new String(this.bytes, 0, this.off, StandardCharsets.UTF_8);
    }

    @Override
    public final int flushTo(OutputStream out, Charset charset) throws IOException {
        if (charset != null && charset != StandardCharsets.UTF_8) {
            throw new JSONException("UnsupportedOperation");
        }
        if (this.off == 0) {
            return 0;
        }
        int len = this.off;
        out.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }
}

