/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;

public class IOUtils {
    public static final byte[] digits;
    public static final byte[] DigitTens;
    public static final byte[] DigitOnes;
    static final int[] sizeTable;
    static final char[] CA;
    static final int[] IA;
    private static final int[] DIGITS;
    private static final byte MINUS = 45;
    private static final byte[] MIN_INT;
    private static final byte[] MIN_LONG;

    public static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static void getChars(int i, int index, byte[] buf) {
        int r;
        int q;
        int p = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--p] = DigitOnes[r];
            buf[--p] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--p] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--p] = sign;
        }
    }

    public static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int p = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--p] = (char)DigitOnes[r];
            buf[--p] = (char)DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--p] = (char)digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--p] = sign;
        }
    }

    public static void getChars(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = (char)DigitOnes[r];
            buf[--charPos] = (char)DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = (char)DigitOnes[r];
            buf[--charPos] = (char)DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = (char)digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static int getDecimalChars(long unscaledVal, int scale, byte[] buf, int off) {
        int start = off;
        boolean negative = unscaledVal < 0L;
        int size = IOUtils.stringSize(Math.abs(unscaledVal));
        if (scale == 0) {
            if (unscaledVal < 0L) {
                ++size;
            }
            IOUtils.getChars(unscaledVal, off + size, buf);
            return size;
        }
        int insertionPoint = size - scale;
        if (insertionPoint == 0) {
            if (negative) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
        } else if (insertionPoint < 0) {
            if (negative) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            for (int i = 0; i < -insertionPoint; ++i) {
                buf[off++] = 48;
            }
        } else if (negative) {
            buf[off++] = 45;
        }
        IOUtils.getChars(Math.abs(unscaledVal), off + size, buf);
        off += size;
        if (insertionPoint > 0) {
            int insertPointOff = off - scale;
            System.arraycopy(buf, insertPointOff, buf, insertPointOff + 1, scale);
            buf[insertPointOff] = 46;
            ++off;
        }
        return off - start;
    }

    public static int getDecimalChars(long unscaledVal, int scale, char[] buf, int off) {
        int start = off;
        boolean negative = unscaledVal < 0L;
        int size = IOUtils.stringSize(Math.abs(unscaledVal));
        if (scale == 0) {
            if (unscaledVal < 0L) {
                ++size;
            }
            IOUtils.getChars(unscaledVal, off + size, buf);
            return size;
        }
        int insertionPoint = size - scale;
        if (insertionPoint == 0) {
            if (negative) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
        } else if (insertionPoint < 0) {
            if (negative) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            for (int i = 0; i < -insertionPoint; ++i) {
                buf[off++] = 48;
            }
        } else if (negative) {
            buf[off++] = 45;
        }
        IOUtils.getChars(Math.abs(unscaledVal), off + size, buf);
        off += size;
        if (insertionPoint > 0) {
            int insertPointOff = off - scale;
            System.arraycopy(buf, insertPointOff, buf, insertPointOff + 1, scale);
            buf[insertPointOff] = 46;
            ++off;
        }
        return off - start;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeUTF8(byte[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        while (offset < sl) {
            byte b1;
            byte b0 = src[offset++];
            if ((b1 = src[offset++]) == 0 && b0 >= 0) {
                dst[dp++] = b0;
                continue;
            }
            int c = (b0 & 0xFF) << 0 | (b1 & 0xFF) << 8;
            if (c < 2048) {
                dst[dp++] = (byte)(0xC0 | c >> 6);
                dst[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= 55296 && c < 57344) {
                int uc;
                int ip = offset - 1;
                if (c >= 55296 && c < 56320) {
                    if (sl - ip < 2) {
                        uc = -1;
                    } else {
                        b0 = src[ip + 1];
                        b1 = src[ip + 2];
                        char d = (char)((b0 & 0xFF) << 0 | (b1 & 0xFF) << 8);
                        if (d < '\udc00' || d >= '\ue000') return -1;
                        offset += 2;
                        uc = (c << 10) + d + -56613888;
                    }
                } else {
                    if (c >= 56320 && c < 57344) {
                        return -1;
                    }
                    uc = c;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp++] = (byte)(0xF0 | uc >> 18);
                dst[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc & 0x3F);
                continue;
            }
            dst[dp++] = (byte)(0xE0 | c >> 12);
            dst[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp++] = (byte)(0x80 | c & 0x3F);
        }
        return dp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int encodeUTF8(char[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        int dlASCII = dp + Math.min(len, dst.length);
        while (dp < dlASCII && src[offset] < '\u0080') {
            dst[dp++] = (byte)src[offset++];
        }
        while (true) {
            int c;
            block12: {
                int uc;
                block11: {
                    block13: {
                        if (offset >= sl) {
                            return dp;
                        }
                        if ((c = src[offset++]) < 128) {
                            dst[dp++] = (byte)c;
                            continue;
                        }
                        if (c < 2048) {
                            dst[dp++] = (byte)(0xC0 | c >> 6);
                            dst[dp++] = (byte)(0x80 | c & 0x3F);
                            continue;
                        }
                        if (c < 55296 || c >= 57344) break block12;
                        int ip = offset - 1;
                        if (c < 55296 || c >= 56320) break block13;
                        if (sl - ip < 2) {
                            uc = -1;
                            break block11;
                        } else {
                            char d = src[ip + 1];
                            if (d >= '\udc00' && d < '\ue000') {
                                uc = (c << 10) + d + -56613888;
                                break block11;
                            } else {
                                dst[dp++] = 63;
                                continue;
                            }
                        }
                    }
                    if (c >= 56320 && c < 57344) {
                        dst[dp++] = 63;
                        continue;
                    }
                    uc = c;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp++] = (byte)(0xF0 | uc >> 18);
                dst[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc & 0x3F);
                ++offset;
                continue;
            }
            dst[dp++] = (byte)(0xE0 | c >> 12);
            dst[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp++] = (byte)(0x80 | c & 0x3F);
        }
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char[] chars, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = chars[i];
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(byte[] chars, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = (char)chars[i];
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int decodeUTF8(byte[] src, int off, int len, byte[] dst) {
        int sl = off + len;
        int dp = 0;
        while (off < sl) {
            byte b1;
            byte b0;
            if ((b0 = src[off++]) >= 0) {
                dst[dp++] = b0;
                dst[dp++] = 0;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b1 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 6 ^ b1 ^ 0xF80);
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    continue;
                }
                dst[dp++] = b0;
                dst[dp++] = 0;
                break;
            }
            if (b0 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b1 = src[off++];
                    byte b2 = src[off++];
                    if (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    continue;
                }
                return -1;
            }
            if (b0 >> 3 == -2) {
                if (off + 2 < sl) {
                    byte b2 = src[off++];
                    byte b3 = src[off++];
                    byte b4 = src[off++];
                    int uc = b0 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    char c = (char)((uc >>> 10) + 55232);
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    c = (char)((uc & 0x3FF) + 56320);
                    dst[dp++] = (byte)c;
                    dst[dp++] = (byte)(c >> 8);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static int decodeUTF8(byte[] src, int off, int len, char[] dst) {
        int sl = off + len;
        int dp = 0;
        int dlASCII = Math.min(len, dst.length);
        while (dp < dlASCII && src[off] >= 0) {
            dst[dp++] = (char)src[off++];
        }
        while (off < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = src[off++]) >= 0) {
                dst[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b2 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    dst[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b2 = src[off++];
                    b3 = src[off++];
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (off + 2 < sl) {
                    b2 = src[off++];
                    b3 = src[off++];
                    byte b4 = src[off++];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    dst[dp++] = (char)((uc >>> 10) + 55232);
                    dst[dp++] = (char)((uc & 0x3FF) + 56320);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static byte[] decodeBase64(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == '=' ? (s.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static long lines(File file) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            long l = IOUtils.lines(in);
            return l;
        }
    }

    public static long lines(InputStream in) throws Exception {
        int len;
        long lines = 0L;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf, 0, buf.length)) != -1) {
            for (int i = 0; i < len; ++i) {
                byte b = buf[i];
                if (b != 10) continue;
                ++lines;
            }
        }
        return lines;
    }

    public static void write4(int value, byte[] buf, int pos) {
        if (value > 9999) {
            throw new IllegalArgumentException("Only 4 digits numbers are supported. Provided: " + value);
        }
        int q = value / 1000;
        int v = DIGITS[value - q * 1000];
        buf[pos] = (byte)(q + 48);
        buf[pos + 1] = (byte)(v >> 16);
        buf[pos + 2] = (byte)(v >> 8);
        buf[pos + 3] = (byte)v;
    }

    public static void write4(int value, char[] buf, int pos) {
        if (value > 9999) {
            throw new IllegalArgumentException("Only 4 digits numbers are supported. Provided: " + value);
        }
        int q = value / 1000;
        int v = DIGITS[value - q * 1000];
        buf[pos] = (char)(q + 48);
        buf[pos + 1] = (char)(v >> 16);
        buf[pos + 2] = (char)(v >> 8);
        buf[pos + 3] = (char)v;
    }

    public static void write3(int number, byte[] buf, int pos) {
        int v = DIGITS[number];
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    public static void write3(int number, char[] buf, int pos) {
        int v = DIGITS[number];
        buf[pos] = (char)(v >> 16);
        buf[pos + 1] = (char)(v >> 8);
        buf[pos + 2] = (char)v;
    }

    public static void write2(int number, byte[] buf, int pos) {
        int v = DIGITS[number];
        buf[pos] = (byte)(v >> 8);
        buf[pos + 1] = (byte)v;
    }

    public static void write2(int number, char[] buf, int pos) {
        int v = DIGITS[number];
        buf[pos] = (char)(v >> 8);
        buf[pos + 1] = (char)v;
    }

    public static int writeInt64(byte[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                for (int x = 0; x < MIN_LONG.length; ++x) {
                    buf[pos + x] = MIN_LONG[x];
                }
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        long q1 = i / 1000L;
        if (q1 == 0L) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[(int)i], pos);
            return pos;
        }
        int r1 = (int)(i - q1 * 1000L);
        long q2 = q1 / 1000L;
        if (q2 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[(int)q1];
            int off = IOUtils.writeFirstBuf(buf, v2, pos);
            IOUtils.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        if (q3 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[(int)q2];
            pos += IOUtils.writeFirstBuf(buf, v3, pos);
            IOUtils.writeBuf(buf, v2, pos);
            IOUtils.writeBuf(buf, v1, pos + 3);
            return pos + 6;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        if (q4 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[(int)q3];
            pos += IOUtils.writeFirstBuf(buf, v4, pos);
            IOUtils.writeBuf(buf, v3, pos);
            IOUtils.writeBuf(buf, v2, pos + 3);
            IOUtils.writeBuf(buf, v1, pos + 6);
            return pos + 9;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        if (q5 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[r4];
            int v5 = DIGITS[q4];
            pos += IOUtils.writeFirstBuf(buf, v5, pos);
            IOUtils.writeBuf(buf, v4, pos);
            IOUtils.writeBuf(buf, v3, pos + 3);
            IOUtils.writeBuf(buf, v2, pos + 6);
            IOUtils.writeBuf(buf, v1, pos + 9);
            return pos + 12;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        int v3 = DIGITS[r3];
        int v4 = DIGITS[r4];
        int v5 = DIGITS[r5];
        if (q6 == 0) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[q5], pos);
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos++] = (byte)(q6 + 48);
            IOUtils.writeBuf(buf, DIGITS[r6], pos);
            pos += 3;
        }
        IOUtils.writeBuf(buf, v5, pos);
        IOUtils.writeBuf(buf, v4, pos + 3);
        IOUtils.writeBuf(buf, v3, pos + 6);
        IOUtils.writeBuf(buf, v2, pos + 9);
        IOUtils.writeBuf(buf, v1, pos + 12);
        return pos + 15;
    }

    public static int writeInt64(char[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                for (int x = 0; x < MIN_LONG.length; ++x) {
                    buf[pos + x] = (char)MIN_LONG[x];
                }
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        long q1 = i / 1000L;
        if (q1 == 0L) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[(int)i], pos);
            return pos;
        }
        int r1 = (int)(i - q1 * 1000L);
        long q2 = q1 / 1000L;
        if (q2 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[(int)q1];
            int off = IOUtils.writeFirstBuf(buf, v2, pos);
            IOUtils.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        if (q3 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[(int)q2];
            pos += IOUtils.writeFirstBuf(buf, v3, pos);
            IOUtils.writeBuf(buf, v2, pos);
            IOUtils.writeBuf(buf, v1, pos + 3);
            return pos + 6;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        if (q4 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[(int)q3];
            pos += IOUtils.writeFirstBuf(buf, v4, pos);
            IOUtils.writeBuf(buf, v3, pos);
            IOUtils.writeBuf(buf, v2, pos + 3);
            IOUtils.writeBuf(buf, v1, pos + 6);
            return pos + 9;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        if (q5 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[r4];
            int v5 = DIGITS[q4];
            pos += IOUtils.writeFirstBuf(buf, v5, pos);
            IOUtils.writeBuf(buf, v4, pos);
            IOUtils.writeBuf(buf, v3, pos + 3);
            IOUtils.writeBuf(buf, v2, pos + 6);
            IOUtils.writeBuf(buf, v1, pos + 9);
            return pos + 12;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        int v3 = DIGITS[r3];
        int v4 = DIGITS[r4];
        int v5 = DIGITS[r5];
        if (q6 == 0) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[q5], pos);
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos++] = (char)(q6 + 48);
            IOUtils.writeBuf(buf, DIGITS[r6], pos);
            pos += 3;
        }
        IOUtils.writeBuf(buf, v5, pos);
        IOUtils.writeBuf(buf, v4, pos + 3);
        IOUtils.writeBuf(buf, v3, pos + 6);
        IOUtils.writeBuf(buf, v2, pos + 9);
        IOUtils.writeBuf(buf, v1, pos + 12);
        return pos + 15;
    }

    public static int writeInt32(byte[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                for (int x = 0; x < MIN_INT.length; ++x) {
                    buf[pos + x] = MIN_INT[x];
                }
                return pos + MIN_INT.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        int q1 = i / 1000;
        if (q1 == 0) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[i], pos);
            return pos;
        }
        int r1 = i - q1 * 1000;
        int q2 = q1 / 1000;
        if (q2 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[q1];
            int off = IOUtils.writeFirstBuf(buf, v2, pos);
            IOUtils.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        if (q3 == 0) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[q2], pos);
        } else {
            int r3 = q2 - q3 * 1000;
            buf[pos++] = (byte)(q3 + 48);
            IOUtils.writeBuf(buf, DIGITS[r3], pos);
            pos += 3;
        }
        IOUtils.writeBuf(buf, v2, pos);
        IOUtils.writeBuf(buf, v1, pos + 3);
        return pos + 6;
    }

    public static int writeInt32(char[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                for (int x = 0; x < MIN_INT.length; ++x) {
                    buf[pos + x] = (char)MIN_INT[x];
                }
                return pos + MIN_INT.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        int q1 = i / 1000;
        if (q1 == 0) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[i], pos);
            return pos;
        }
        int r1 = i - q1 * 1000;
        int q2 = q1 / 1000;
        if (q2 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[q1];
            int off = IOUtils.writeFirstBuf(buf, v2, pos);
            IOUtils.writeBuf(buf, v1, pos + off);
            return pos + 3 + off;
        }
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        if (q3 == 0) {
            pos += IOUtils.writeFirstBuf(buf, DIGITS[q2], pos);
        } else {
            int r3 = q2 - q3 * 1000;
            buf[pos++] = (char)(q3 + 48);
            IOUtils.writeBuf(buf, DIGITS[r3], pos);
            pos += 3;
        }
        IOUtils.writeBuf(buf, v2, pos);
        IOUtils.writeBuf(buf, v1, pos + 3);
        return pos + 6;
    }

    private static int writeFirstBuf(byte[] buf, int v, int pos) {
        int start = v >> 24;
        if (start == 0) {
            buf[pos++] = (byte)(v >> 16);
            buf[pos++] = (byte)(v >> 8);
        } else if (start == 1) {
            buf[pos++] = (byte)(v >> 8);
        }
        buf[pos] = (byte)v;
        return 3 - start;
    }

    private static int writeFirstBuf(char[] buf, int v, int pos) {
        int start = v >> 24;
        if (start == 0) {
            buf[pos++] = (char)(v >> 16);
            buf[pos++] = (char)(v >> 8);
        } else if (start == 1) {
            buf[pos++] = (char)(v >> 8);
        }
        buf[pos] = (char)v;
        return 3 - start;
    }

    private static void writeBuf(byte[] buf, int v, int pos) {
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    private static void writeBuf(char[] buf, int v, int pos) {
        buf[pos] = (char)(v >> 16);
        buf[pos + 1] = (char)(v >> 8);
        buf[pos + 2] = (char)v;
    }

    static {
        int i;
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
        DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        DIGITS = new int[1000];
        MIN_INT = "-2147483648".getBytes();
        MIN_LONG = "-9223372036854775808".getBytes();
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            IOUtils.IA[IOUtils.CA[i]] = i;
        }
        IOUtils.IA[61] = 0;
        for (i = 0; i < DIGITS.length; ++i) {
            IOUtils.DIGITS[i] = (i < 10 ? 0x2000000 : (i < 100 ? 0x1000000 : 0)) + (i / 100 + 48 << 16) + (i / 10 % 10 + 48 << 8) + i % 10 + 48;
        }
    }
}

