/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.time.DateTimeException;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.NameCacheEntry;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONReaderUTF16
extends JSONReader {
    protected final String str;
    protected final char[] chars;
    protected final int length;
    protected final int start;
    protected final int end;
    private int nameBegin;
    private int nameEnd;
    private int nameLength;
    private int referenceBegin;
    private Closeable input;
    private int cacheIndex = -1;

    JSONReaderUTF16(JSONReader.Context ctx, byte[] bytes, int offset, int length) {
        super(ctx, false);
        this.str = null;
        this.chars = new char[length / 2];
        int j = 0;
        int bytesEnd = offset + length;
        int i = offset;
        while (i < bytesEnd) {
            byte c0 = bytes[i];
            byte c1 = bytes[i + 1];
            this.chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
            i += 2;
            ++j;
        }
        this.start = offset;
        this.end = this.length = j;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + offset);
        }
    }

    @Override
    public final byte[] readHex() {
        if (this.ch == 'x') {
            this.next();
        }
        int ch = this.ch;
        int offset = this.offset;
        char[] chars = this.chars;
        int quote = ch;
        if (quote != 39 && quote != 34) {
            throw new JSONException("illegal state. " + (char)ch);
        }
        int start = offset++;
        while ((ch = chars[offset++]) >= 48 && ch <= 57 || ch >= 65 && ch <= 70) {
        }
        if (ch != quote) {
            throw new JSONException("illegal state. " + (char)ch);
        }
        ch = chars[offset++];
        int len = offset - start - 2;
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 != 0) {
            throw new JSONException("illegal state. " + len);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < bytes.length; ++i) {
            char c0 = chars[start + i * 2];
            char c1 = chars[start + i * 2 + 1];
            int b0 = c0 - (c0 <= '9' ? 48 : 55);
            int b1 = c1 - (c1 <= '9' ? 48 : 55);
            bytes[i] = (byte)(b0 << 4 | b1);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = 26;
                continue;
            }
            ch = chars[offset++];
        }
        if (ch != 44 || offset >= this.end) {
            this.offset = offset;
            this.ch = ch;
            return bytes;
        }
        this.comma = true;
        ch = chars[offset];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return bytes;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = (char)ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
        return bytes;
    }

    @Override
    public final boolean isReference() {
        char[] chars = this.chars;
        char ch = this.ch;
        int offset = this.offset;
        if (ch != '{') {
            return false;
        }
        if (offset == this.end) {
            return false;
        }
        ch = chars[offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                return false;
            }
            ch = chars[offset];
        }
        char quote = ch;
        if (quote != '\"' && quote != '\'' || this.offset + 5 >= this.end) {
            return false;
        }
        if (chars[offset + 1] != '$' || chars[offset + 2] != 'r' || chars[offset + 3] != 'e' || chars[offset + 4] != 'f' || chars[offset + 5] != quote || offset + 6 >= this.end) {
            return false;
        }
        ch = chars[offset += 6];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                return false;
            }
            ch = chars[offset];
        }
        if (ch != ':' || offset + 1 >= this.end) {
            return false;
        }
        ch = chars[++offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                return false;
            }
            ch = chars[offset];
        }
        if (ch != quote) {
            return false;
        }
        this.referenceBegin = offset;
        return true;
    }

    @Override
    public final String readReference() {
        if (this.referenceBegin == this.end) {
            return null;
        }
        this.offset = this.referenceBegin;
        this.ch = this.chars[this.offset++];
        String reference = this.readString();
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return reference;
            }
            this.ch = this.chars[this.offset];
        }
        if (this.ch != '}') {
            throw new JSONException("illegal reference : " + reference);
        }
        this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = this.chars[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return reference;
    }

    JSONReaderUTF16(JSONReader.Context ctx, Reader input) {
        super(ctx, false);
        this.input = input;
        this.cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[this.cacheIndex];
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(cacheItem, null);
        if (chars == null) {
            chars = new char[8192];
        }
        int off = 0;
        try {
            int n;
            while ((n = input.read(chars, off, chars.length - off)) != -1) {
                if ((off += n) != chars.length) continue;
                int oldCapacity = chars.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                chars = Arrays.copyOf(chars, newCapacity);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.str = null;
        this.chars = chars;
        this.offset = 0;
        this.length = off;
        this.start = 0;
        this.end = this.length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + this.offset);
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, String str, int offset, int length) {
        super(ctx, false);
        this.cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[this.cacheIndex];
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(cacheItem, null);
        if (chars == null || chars.length < length) {
            chars = new char[Math.max(length, 8192)];
        }
        str.getChars(offset, length, chars, 0);
        this.str = str;
        this.chars = chars;
        this.offset = 0;
        this.length = length;
        this.start = 0;
        this.end = this.length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/' && this.offset < this.chars.length && this.chars[this.offset] == '/') {
            this.skipLineComment();
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, String str, char[] chars, int offset, int length) {
        super(ctx, false);
        this.str = str;
        this.chars = chars;
        this.offset = offset;
        this.length = length;
        this.start = offset;
        this.end = offset + length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/' && this.offset < this.chars.length && this.chars[this.offset] == '/') {
            this.skipLineComment();
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, InputStream input) {
        super(ctx, false);
        char[] chars;
        this.input = input;
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(cacheItem, null);
        if (bytes == null) {
            bytes = new byte[ctx.bufferSize];
        }
        try {
            int n;
            int off = 0;
            while ((n = input.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + ctx.bufferSize);
            }
            if (off % 2 == 1) {
                throw new JSONException("illegal input utf16 bytes, length " + off);
            }
            chars = new char[off / 2];
            int i = 0;
            int j = 0;
            while (i < off) {
                byte c0 = bytes[i];
                byte c1 = bytes[i + 1];
                chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                i += 2;
                ++j;
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        finally {
            JSONFactory.BYTES_UPDATER.lazySet(cacheItem, bytes);
        }
        int length = chars.length;
        this.str = null;
        this.chars = chars;
        this.offset = 0;
        this.length = length;
        this.start = 0;
        this.end = length;
        if (this.end == 0) {
            this.ch = (char)26;
            return;
        }
        int offset = 0;
        char ch = chars[offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= length) {
                this.ch = (char)26;
                return;
            }
            ch = chars[offset];
        }
        this.ch = ch;
        ++this.offset;
        if (ch == '\ufffe' || ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + ch + ", offset " + offset);
        }
    }

    @Override
    public final boolean nextIfMatch(char m) {
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = '\u001a';
                continue;
            }
            ch = chars[offset++];
        }
        if (ch != m) {
            return false;
        }
        boolean bl = this.comma = m == ',';
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = chars[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfComma() {
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        if (ch != ',') {
            return false;
        }
        this.comma = true;
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = chars[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfArrayStart() {
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        if (ch != '[') {
            return false;
        }
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = chars[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfArrayEnd() {
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        if (ch == '}' || ch == '\u001a') {
            throw new JSONException(this.info());
        }
        if (ch != ']') {
            return false;
        }
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = chars[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = chars[offset];
        }
        if (ch == ',') {
            this.comma = true;
            ch = chars[++offset];
            while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                if (++offset >= this.end) {
                    this.offset = offset;
                    this.ch = (char)26;
                    return true;
                }
                ch = chars[offset];
            }
        }
        this.offset = offset + 1;
        this.ch = ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfNullOrEmptyString() {
        int ch;
        char first = this.ch;
        int end = this.end;
        int offset = this.offset;
        char[] chars = this.chars;
        if (first == 'n' && offset + 2 < end && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
            offset += 3;
        } else if ((first == '\"' || first == '\'') && offset < end && chars[offset] == first) {
            ++offset;
        } else {
            return false;
        }
        int n = ch = offset == end ? 26 : chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                this.ch = (char)26;
                this.offset = offset;
                return true;
            }
            ch = chars[offset];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = ++offset >= end ? 26 : chars[offset];
        }
        if (offset >= end) {
            this.ch = (char)26;
            this.offset = offset;
            return true;
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                this.ch = (char)26;
                return true;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2) {
        if (this.ch != c0) {
            return false;
        }
        int offset2 = this.offset + 2;
        if (offset2 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2) {
            return false;
        }
        if (offset2 == this.end) {
            this.offset = offset2;
            this.ch = (char)26;
            return true;
        }
        int offset = offset2;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset2) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        if (this.ch != c0) {
            return false;
        }
        int offset3 = this.offset + 3;
        if (offset3 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2 || this.chars[this.offset + 2] != c3) {
            return false;
        }
        if (offset3 == this.end) {
            this.offset = offset3;
            this.ch = (char)26;
            return true;
        }
        int offset = offset3;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset3 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        if (this.ch != c0) {
            return false;
        }
        int offset4 = this.offset + 4;
        if (offset4 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2 || this.chars[this.offset + 2] != c3 || this.chars[this.offset + 3] != c4) {
            return false;
        }
        if (offset4 == this.end) {
            this.offset = offset4;
            this.ch = (char)26;
            return true;
        }
        int offset = offset4;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset4 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        if (this.ch != c0) {
            return false;
        }
        int offset5 = this.offset + 5;
        if (offset5 > this.end || this.chars[this.offset] != c1 || this.chars[this.offset + 1] != c2 || this.chars[this.offset + 2] != c3 || this.chars[this.offset + 3] != c4 || this.chars[this.offset + 4] != c5) {
            return false;
        }
        if (offset5 == this.end) {
            this.offset = offset5;
            this.ch = (char)26;
            return true;
        }
        int offset = offset5;
        int ch = this.chars[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.chars[offset];
        }
        if (offset == offset5 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final boolean nextIfSet() {
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 83 && offset + 1 < this.end && chars[offset] == 'e' && chars[offset + 1] == 't') {
            if ((offset += 2) >= this.end) {
                ch = 26;
            } else {
                ch = chars[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (offset == this.end) {
                        ch = 26;
                        break;
                    }
                    ch = chars[offset++];
                }
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextIfInfinity() {
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 73 && offset + 6 < this.end && chars[offset] == 'n' && chars[offset + 1] == 'f' && chars[offset + 2] == 'i' && chars[offset + 3] == 'n' && chars[offset + 4] == 'i' && chars[offset + 5] == 't' && chars[offset + 6] == 'y') {
            if ((offset += 7) >= this.end) {
                ch = 26;
            } else {
                ch = chars[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (offset == this.end) {
                        ch = 26;
                        break;
                    }
                    ch = chars[offset++];
                }
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextIfObjectStart() {
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        if (ch != '{') {
            return false;
        }
        this.comma = false;
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = chars[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfObjectEnd() {
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        if (ch != '}') {
            return false;
        }
        this.comma = false;
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = chars[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public final void next() {
        int offset = this.offset;
        if (offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        char[] chars = this.chars;
        char ch = chars[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return;
            }
            ch = chars[offset];
        }
        this.offset = offset + 1;
        this.ch = ch;
        while (this.ch == '/' && this.offset < chars.length && chars[this.offset] == '/') {
            this.skipLineComment();
        }
    }

    @Override
    public final long readFieldNameHashCodeUnquote() {
        long hashCode;
        this.nameEscape = false;
        this.nameBegin = this.offset - 1;
        char first = this.ch;
        long nameValue = 0L;
        int i = 0;
        block26: while (this.offset <= this.end) {
            switch (this.ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\u001a': 
                case ' ': 
                case '!': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    this.nameLength = i;
                    this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        this.next();
                    }
                    break block26;
                }
                default: {
                    if (this.ch == '\\') {
                        this.nameEscape = true;
                        this.ch = this.chars[this.offset++];
                        switch (this.ch) {
                            case 'u': {
                                char c1 = this.chars[this.offset++];
                                char c2 = this.chars[this.offset++];
                                char c3 = this.chars[this.offset++];
                                char c4 = this.chars[this.offset++];
                                this.ch = JSONReaderUTF16.char4(c1, c2, c3, c4);
                                break;
                            }
                            case 'x': {
                                char c1 = this.chars[this.offset++];
                                char c2 = this.chars[this.offset++];
                                this.ch = JSONReaderUTF16.char2(c1, c2);
                                break;
                            }
                            case '\"': 
                            case '*': 
                            case '+': 
                            case '-': 
                            case '.': 
                            case '/': 
                            case ':': 
                            case '<': 
                            case '=': 
                            case '>': 
                            case '@': 
                            case '\\': {
                                break;
                            }
                            default: {
                                this.ch = this.char1(this.ch);
                            }
                        }
                    }
                    if (this.ch > '\u00ff' || i >= 8 || i == 0 && this.ch == '\u0000') {
                        nameValue = 0L;
                        this.ch = first;
                        this.offset = this.nameBegin + 1;
                        break block26;
                    }
                    byte c = (byte)this.ch;
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    this.ch = (char)(this.offset >= this.end ? 26 : this.chars[this.offset++]);
                    ++i;
                    continue block26;
                }
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            block28: while (true) {
                if (this.ch == '\\') {
                    this.nameEscape = true;
                    this.ch = this.chars[this.offset++];
                    switch (this.ch) {
                        case 'u': {
                            char c1 = this.chars[this.offset++];
                            char c2 = this.chars[this.offset++];
                            char c3 = this.chars[this.offset++];
                            char c4 = this.chars[this.offset++];
                            this.ch = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[this.offset++];
                            char c2 = this.chars[this.offset++];
                            this.ch = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '@': 
                        case '\\': {
                            break;
                        }
                        default: {
                            this.ch = this.char1(this.ch);
                        }
                    }
                    hashCode ^= (long)this.ch;
                    hashCode *= 1099511628211L;
                    this.next();
                } else {
                    switch (this.ch) {
                        case '\b': 
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case '\u001a': 
                        case ' ': 
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '[': 
                        case ']': 
                        case '{': 
                        case '}': {
                            this.nameLength = i2;
                            this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                                this.next();
                            }
                            break block28;
                        }
                        default: {
                            hashCode ^= (long)this.ch;
                            hashCode *= 1099511628211L;
                            this.ch = (char)(this.offset >= this.end ? 26 : this.chars[this.offset++]);
                        }
                    }
                }
                ++i2;
            }
        }
        if (this.ch == ':') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        return hashCode;
    }

    @Override
    public final long readFieldNameHashCode() {
        char c;
        long hashCode;
        char[] chars = this.chars;
        if (this.ch != '\"' && this.ch != '\'') {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF16.isFirstIdentifier(this.ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            String errorMsg = this.ch == '[' && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + this.ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + this.ch;
            throw new JSONException(this.info(errorMsg));
        }
        char quote = this.ch;
        this.stringValue = null;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (offset + 9 < this.end) {
            char c0 = chars[offset];
            char c1 = chars[offset + 1];
            char c2 = chars[offset + 2];
            char c3 = chars[offset + 3];
            char c4 = chars[offset + 4];
            char c5 = chars[offset + 5];
            char c6 = chars[offset + 6];
            char c7 = chars[offset + 7];
            char c8 = chars[offset + 8];
            if (c0 != quote) {
                if (c1 == quote && c0 != '\u0000' && c0 != '\\' && c0 <= '\u00ff') {
                    nameValue = (byte)c0;
                    this.nameLength = 1;
                    this.nameEnd = offset + 1;
                    offset += 2;
                } else if (c2 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff') {
                    nameValue = ((byte)c1 << 8) + c0;
                    this.nameLength = 2;
                    this.nameEnd = offset + 2;
                    offset += 3;
                } else if (c3 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff') {
                    nameValue = ((byte)c2 << 16) + (c1 << 8) + c0;
                    this.nameLength = 3;
                    this.nameEnd = offset + 3;
                    offset += 4;
                } else if (c4 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff') {
                    nameValue = ((byte)c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                    this.nameLength = 4;
                    this.nameEnd = offset + 4;
                    offset += 5;
                } else if (c5 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff') {
                    nameValue = ((long)((byte)c4) << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    this.nameLength = 5;
                    this.nameEnd = offset + 5;
                    offset += 6;
                } else if (c6 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff') {
                    nameValue = ((long)((byte)c5) << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    this.nameLength = 6;
                    this.nameEnd = offset + 6;
                    offset += 7;
                } else if (c7 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c6 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff' && c6 <= '\u00ff') {
                    nameValue = ((long)((byte)c6) << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    this.nameLength = 7;
                    this.nameEnd = offset + 7;
                    offset += 8;
                } else if (c8 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c6 != '\\' && c7 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff' && c6 <= '\u00ff' && c7 <= '\u00ff') {
                    nameValue = ((long)((byte)c7) << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    this.nameLength = 8;
                    this.nameEnd = offset + 8;
                    offset += 9;
                }
            }
        }
        if (nameValue == 0L) {
            int i = 0;
            while (offset < this.end) {
                char c2 = chars[offset];
                if (c2 == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c2 == '\\') {
                    this.nameEscape = true;
                    c2 = chars[++offset];
                    switch (c2) {
                        case 'u': {
                            char c1 = chars[++offset];
                            char c22 = chars[++offset];
                            char c3 = chars[++offset];
                            char c4 = chars[++offset];
                            c2 = JSONReaderUTF16.char4(c1, c22, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = chars[++offset];
                            char c22 = chars[++offset];
                            c2 = JSONReaderUTF16.char2(c1, c22);
                            break;
                        }
                        default: {
                            c2 = this.char1(c2);
                        }
                    }
                }
                if (c2 > '\u00ff' || i >= 8 || i == 0 && c2 == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c2;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c2 << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c2 << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c2 << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c2) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c2) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c2) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c2) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                char c3;
                if ((c3 = chars[offset]) == '\\') {
                    this.nameEscape = true;
                    c3 = chars[++offset];
                    switch (c3) {
                        case 'u': {
                            char c1 = chars[++offset];
                            char c2 = chars[++offset];
                            char c32 = chars[++offset];
                            char c4 = chars[++offset];
                            c3 = JSONReaderUTF16.char4(c1, c2, c32, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = chars[++offset];
                            char c2 = chars[++offset];
                            c3 = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        default: {
                            c3 = this.char1(c3);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                } else {
                    if (c3 == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        if (offset < this.end) {
            c = chars[offset];
            while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                c = chars[++offset];
            }
        } else {
            c = '\u001a';
        }
        if (c != ':') {
            throw new JSONException(this.info("expect ':', but " + c));
        }
        c = ++offset == this.end ? (char)'\u001a' : chars[offset];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = c;
        return hashCode;
    }

    @Override
    public final long readValueHashCode() {
        long hashCode;
        if (this.ch != '\"' && this.ch != '\'') {
            return -1L;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        int i = 0;
        while (offset < this.end) {
            char c = this.chars[offset];
            if (c == quote) {
                if (i == 0) {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                this.nameLength = i;
                this.nameEnd = offset++;
                break;
            }
            if (c == '\\') {
                this.nameEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = this.char1(c);
                    }
                }
            }
            if (c > '\u00ff' || i >= 8 || i == 0 && c == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)c;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++offset;
            ++i;
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.chars[offset]) == '\\') {
                    this.nameEscape = true;
                    c = this.chars[++offset];
                    switch (c) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                } else {
                    if (c == '\"') {
                        this.nameLength = i2;
                        this.nameEnd = offset++;
                        this.stringValue = null;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i2;
            }
        }
        int c = offset == this.end ? 26 : this.chars[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = this.chars[++offset];
        }
        this.comma = c == 44;
        if (this.comma) {
            c = ++offset == this.end ? 26 : this.chars[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = this.chars[++offset];
            }
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public final long getNameHashCodeLCase() {
        int offset;
        long nameValue = 0L;
        int i = 0;
        for (offset = this.nameBegin; offset < this.end; ++offset) {
            char c1;
            char c = this.chars[offset];
            if (c == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if (c > '\u00ff' || i >= 8 || i == 0 && c == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            if ((c == '_' || c == '-' || c == ' ') && (c1 = this.chars[offset + 1]) != '\"' && c1 != '\'' && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)c;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        while (offset < this.end) {
            char c1;
            char c = this.chars[offset];
            if (c == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if ((c == '_' || c == '-' || c == ' ') && (c1 = this.chars[++offset]) != '\"' && c1 != '\'' && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public final String getFieldName() {
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            char c = this.chars[offset];
            if (c == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        return new String(chars);
    }

    @Override
    public final String readFieldName() {
        if (this.ch != '\"' && this.ch != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF16.isFirstIdentifier(this.ch)) {
                return this.readFieldNameUnquote();
            }
            return null;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (offset < this.end) {
            char c = this.chars[offset];
            if (c == '\\') {
                this.nameEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = offset < this.end ? this.chars[offset] : (char)'\u001a';
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    if (c != ':') {
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = ++offset == this.end ? (char)'\u001a' : this.chars[offset];
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.chars[++offset];
                    }
                    this.offset = offset + 1;
                    this.ch = c;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        if (this.nameEnd < this.nameBegin) {
            throw new JSONException("syntax error : " + offset);
        }
        if (!this.nameEscape) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            switch (this.nameLength) {
                case 1: {
                    return TypeUtils.toString(this.chars[this.nameBegin]);
                }
                case 2: {
                    return TypeUtils.toString(this.chars[this.nameBegin], this.chars[this.nameBegin + 1]);
                }
                case 3: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2) break;
                    nameValue0 = (c2 << 16) + (c1 << 8) + c0;
                    break;
                }
                case 4: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3) break;
                    nameValue0 = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                    break;
                }
                case 5: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4) break;
                    nameValue0 = ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 6: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5) break;
                    nameValue0 = ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 7: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6) break;
                    nameValue0 = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 8: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7) break;
                    nameValue0 = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 9: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8) break;
                    nameValue0 = c0;
                    nameValue1 = ((long)c8 << 56) + ((long)c7 << 48) + ((long)c6 << 40) + ((long)c5 << 32) + ((long)c4 << 24) + ((long)c3 << 16) + ((long)c2 << 8) + (long)c1;
                    break;
                }
                case 10: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9) break;
                    nameValue0 = c1 << 8 + c0;
                    nameValue1 = ((long)c9 << 56) + ((long)c8 << 48) + ((long)c7 << 40) + ((long)c6 << 32) + ((long)c5 << 24) + ((long)c4 << 16) + ((long)c3 << 8) + (long)c2;
                    break;
                }
                case 11: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10) break;
                    nameValue0 = c2 << 16 + (c1 << 8) + c0;
                    nameValue1 = ((long)c10 << 56) + ((long)c9 << 48) + ((long)c8 << 40) + ((long)c7 << 32) + ((long)c6 << 24) + ((long)c5 << 16) + ((long)c4 << 8) + (long)c3;
                    break;
                }
                case 12: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11) break;
                    nameValue0 = c3 << 24 + (c2 << 16) + (c1 << 8) + c0;
                    nameValue1 = ((long)c11 << 56) + ((long)c10 << 48) + ((long)c9 << 40) + ((long)c8 << 32) + ((long)c7 << 24) + ((long)c6 << 16) + ((long)c5 << 8) + (long)c4;
                    break;
                }
                case 13: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12) break;
                    nameValue0 = ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c12 << 56) + ((long)c11 << 48) + ((long)c10 << 40) + ((long)c9 << 32) + ((long)c8 << 24) + ((long)c7 << 16) + ((long)c6 << 8) + (long)c5;
                    break;
                }
                case 14: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    char c13 = this.chars[this.nameBegin + 13];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13) break;
                    nameValue0 = ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c13 << 56) + ((long)c12 << 48) + ((long)c11 << 40) + ((long)c10 << 32) + ((long)c9 << 24) + ((long)c8 << 16) + ((long)c7 << 8) + (long)c6;
                    break;
                }
                case 15: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    char c13 = this.chars[this.nameBegin + 13];
                    char c14 = this.chars[this.nameBegin + 14];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13 || (c14 & 0xFF) != c14) break;
                    nameValue0 = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c14 << 56) + ((long)c13 << 48) + ((long)c12 << 40) + ((long)c11 << 32) + ((long)c10 << 24) + ((long)c9 << 16) + ((long)c8 << 8) + (long)c7;
                    break;
                }
                case 16: {
                    char c0 = this.chars[this.nameBegin];
                    char c1 = this.chars[this.nameBegin + 1];
                    char c2 = this.chars[this.nameBegin + 2];
                    char c3 = this.chars[this.nameBegin + 3];
                    char c4 = this.chars[this.nameBegin + 4];
                    char c5 = this.chars[this.nameBegin + 5];
                    char c6 = this.chars[this.nameBegin + 6];
                    char c7 = this.chars[this.nameBegin + 7];
                    char c8 = this.chars[this.nameBegin + 8];
                    char c9 = this.chars[this.nameBegin + 9];
                    char c10 = this.chars[this.nameBegin + 10];
                    char c11 = this.chars[this.nameBegin + 11];
                    char c12 = this.chars[this.nameBegin + 12];
                    char c13 = this.chars[this.nameBegin + 13];
                    char c14 = this.chars[this.nameBegin + 14];
                    char c15 = this.chars[this.nameBegin + 15];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13 || (c14 & 0xFF) != c14 || (c15 & 0xFF) != c15) break;
                    nameValue0 = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c15 << 56) + ((long)c14 << 48) + ((long)c13 << 40) + ((long)c12 << 32) + ((long)c11 << 24) + ((long)c10 << 16) + ((long)c9 << 8) + (long)c8;
                    break;
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    int indexMask = (int)nameValue1 & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        String name = this.str != null ? this.str.substring(this.nameBegin, this.nameEnd) : new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)nameValue0 & JSONFactory.NAME_CACHE.length - 1;
                    NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        String name = this.str != null ? this.str.substring(this.nameBegin, this.nameEnd) : new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
                        JSONFactory.NAME_CACHE[indexMask] = new NameCacheEntry(name, nameValue0);
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        return entry.name;
                    }
                }
            }
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
        }
        return this.getFieldName();
    }

    @Override
    public final boolean skipName() {
        char ch = this.ch;
        if (ch != '\"' && ch != '\'') {
            throw new JSONException(this.info("not support unquoted name"));
        }
        char quote = ch;
        int offset = this.offset;
        char[] chars = this.chars;
        while (true) {
            if ((ch = chars[offset]) == '\\') {
                ch = chars[++offset];
                switch (ch) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
                continue;
            }
            if (ch == quote) {
                ch = chars[++offset];
                while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                    ch = chars[++offset];
                }
                if (ch != ':') {
                    throw new JSONException("syntax error, expect ',', but '" + ch + "'");
                }
                ch = chars[++offset];
                while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                    ch = chars[++offset];
                }
                break;
            }
            ++offset;
        }
        this.ch = ch;
        this.offset = ++offset;
        return true;
    }

    @Override
    public final int readInt32Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        char[] chars = this.chars;
        int intValue = 0;
        char quote = '\u0000';
        if (firstChar == '\"' || firstChar == '\'') {
            quote = this.ch;
            this.ch = chars[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                if (bigInteger.bitLength() <= 31) {
                    return bigInteger.intValue();
                }
                throw new JSONException("long overflow, value " + bigInteger);
            }
            if (this.valueType == 5 && (this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                throw new JSONException(this.info("int value not support input null"));
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : chars[this.offset++]);
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : chars[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = chars[this.offset++];
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public final Integer readInt32() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.chars[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = this.chars[this.offset++];
                    }
                    this.nextIfComma();
                }
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = this.chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public final long readInt64Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        char[] chars = this.chars;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = chars[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                if (bigInteger.bitLength() <= 63) {
                    return bigInteger.longValue();
                }
                throw new JSONException("long overflow, value " + bigInteger);
            }
            return this.getInt64Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : chars[this.offset++]);
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : chars[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = chars[this.offset++];
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public final Long readInt64() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfComma();
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.chars[this.offset++];
        } else if (this.ch == '+') {
            this.ch = this.chars[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            return this.getInt64();
        }
        if (quote != '\u0000') {
            this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = this.chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public final double readDoubleValue() {
        long intValue10;
        this.wasNull = false;
        boolean value = false;
        double doubleValue = 0.0;
        char[] chars = this.chars;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : chars[this.offset++];
                this.nextIfComma();
                this.wasNull = true;
                return 0.0;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = chars[this.offset++];
        } else {
            this.negative = false;
            if (this.ch == '+') {
                this.ch = chars[this.offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = chars[this.offset++];
        }
        this.scale = 0;
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(this.ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = chars[this.offset++];
            }
        }
        int expValue = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            this.ch = chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (chars[this.offset++] == 'u' && chars[this.offset++] == 'l' && chars[this.offset++] == 'l') {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (chars[this.offset++] == 'r' && chars[this.offset++] == 'u' && chars[this.offset++] == 'e') {
                    value = true;
                    doubleValue = 1.0;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (chars[this.offset++] == 'a' && chars[this.offset++] == 'l' && chars[this.offset++] == 's' && chars[this.offset++] == 'e') {
                    doubleValue = 0.0;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = chars[this.offset++];
                    }
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        String str = null;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                str = this.readString();
            }
            this.ch = this.offset >= this.end ? (char)26 : chars[this.offset++];
        }
        if (!value) {
            if (!overflow) {
                if (longValue == 0L) {
                    if (this.scale == 1) {
                        doubleValue = 0.0;
                        value = true;
                    }
                } else {
                    int scale = this.scale - expValue;
                    double v = longValue;
                    if (scale == 0) {
                        doubleValue = v;
                        if (this.negative) {
                            doubleValue = -doubleValue;
                        }
                        value = true;
                    } else if ((long)v == longValue) {
                        if (0 < scale && scale < JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = v / JSONFactory.DOUBLE_10_POW[scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        } else if (0 > scale && scale > -JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = v * JSONFactory.DOUBLE_10_POW[-scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        }
                    }
                    if (!value && scale > -128 && scale < 128) {
                        doubleValue = TypeUtils.doubleValue(this.negative ? -1 : 1, longValue, scale);
                        value = true;
                    }
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        doubleValue = Double.parseDouble(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    doubleValue = TypeUtils.parseDouble(chars, start - 1, len);
                }
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : chars[this.offset++];
            }
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = chars[this.offset++];
                }
            }
        }
        return doubleValue;
    }

    @Override
    public final float readFloatValue() {
        long intValue10;
        this.wasNull = false;
        boolean value = false;
        float floatValue = 0.0f;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfComma();
                this.wasNull = true;
                return 0.0f;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = this.chars[this.offset++];
        } else {
            this.negative = false;
            if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        this.scale = 0;
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = this.chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(this.ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        int expValue = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            this.ch = this.chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = this.chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 'l') {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.chars[this.offset++] == 'r' && this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'e') {
                    value = true;
                    floatValue = 1.0f;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.chars[this.offset++] == 'a' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 's' && this.chars[this.offset++] == 'e') {
                    floatValue = 0.0f;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        String str = null;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                overflow = true;
                --this.offset;
                this.ch = quote;
                str = this.readString();
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (!value) {
            if (!overflow) {
                int scale = this.scale - expValue;
                float v = longValue;
                if (scale == 0) {
                    floatValue = longValue;
                    if (this.negative) {
                        floatValue = -floatValue;
                    }
                    value = true;
                } else if ((long)v == longValue) {
                    if (0 < scale && scale < JSONFactory.FLOAT_10_POW.length) {
                        floatValue = v / JSONFactory.FLOAT_10_POW[scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    } else if (0 > scale && scale > -JSONFactory.FLOAT_10_POW.length) {
                        floatValue = v * JSONFactory.FLOAT_10_POW[-scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    }
                }
                if (!value && scale > -128 && scale < 128) {
                    floatValue = TypeUtils.floatValue(this.negative ? -1 : 1, longValue, scale);
                    value = true;
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        floatValue = Float.parseFloat(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    floatValue = TypeUtils.parseFloat(this.chars, start - 1, len);
                }
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            }
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = this.chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
        return floatValue;
    }

    private void skipString() {
        char ch;
        char[] chars;
        int offset;
        block11: {
            char quote = this.ch;
            offset = this.offset;
            chars = this.chars;
            ch = chars[offset++];
            while (true) {
                if (ch == '\\') {
                    if (offset >= this.end) {
                        throw new JSONException(this.info("illegal string, end"));
                    }
                    if ((ch = chars[offset++]) == '\\' || ch == '\"') {
                        ch = chars[offset++];
                        continue;
                    }
                    if (ch == 'u') {
                        offset += 4;
                        ch = chars[offset++];
                        continue;
                    }
                    ch = this.char1(ch);
                    continue;
                }
                if (ch == quote) {
                    ch = offset < this.end ? chars[offset++] : (char)'\u001a';
                    break block11;
                }
                if (offset >= this.end) break;
                ch = chars[offset++];
            }
            ch = '\u001a';
        }
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = chars[offset++];
        }
        this.comma = ch == ',';
        if (this.comma) {
            if (offset >= this.end) {
                this.ch = (char)26;
                this.offset = offset;
                return;
            }
            ch = chars[offset];
            while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                if (++offset >= this.end) {
                    this.ch = (char)26;
                    this.offset = offset;
                    return;
                }
                ch = chars[offset];
            }
            ++offset;
        }
        this.ch = ch;
        this.offset = offset;
    }

    @Override
    public final String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.chars, this.nameBegin, length);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.chars[offset]) == '\\') {
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        char c3 = this.chars[++offset];
                        char c4 = this.chars[++offset];
                        c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.chars[++offset];
                        char c2 = this.chars[++offset];
                        c = JSONReaderUTF16.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    protected final void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.chars[offset]) == '\\') {
                this.valueEscape = true;
                c = this.chars[++offset];
                switch (c) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) break;
                ++offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.chars[offset]) == '\\') {
                    c = this.chars[++offset];
                    switch (c) {
                        case 'u': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            char c3 = this.chars[++offset];
                            char c4 = this.chars[++offset];
                            c = JSONReaderUTF16.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.chars[++offset];
                            char c2 = this.chars[++offset];
                            c = JSONReaderUTF16.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i2] = c;
                ++offset;
                ++i2;
            }
            str = new String(chars);
        } else {
            str = new String(this.chars, this.offset, offset - this.offset);
        }
        int b = ++offset == this.end ? 26 : this.chars[offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.chars[++offset];
        }
        this.comma = b == 44;
        if (this.comma) {
            this.offset = offset + 1;
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int offset;
            block51: {
                int valueLength;
                char quote = this.ch;
                int start = offset = this.offset;
                boolean valueEscape = false;
                int i = 0;
                char c0 = '\u0000';
                char c1 = '\u0000';
                char c2 = '\u0000';
                char c3 = '\u0000';
                boolean quoted = false;
                int upperBound = offset + (this.end - offset & 0xFFFFFFFC);
                while (offset < upperBound) {
                    c0 = this.chars[offset];
                    c1 = this.chars[offset + 1];
                    c2 = this.chars[offset + 2];
                    c3 = this.chars[offset + 3];
                    if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\') break;
                    if (c0 == quote || c1 == quote || c2 == quote || c3 == quote) {
                        quoted = true;
                        break;
                    }
                    offset += 4;
                    i += 4;
                }
                if (quoted) {
                    if (c0 != quote) {
                        if (c1 == quote) {
                            ++offset;
                            ++i;
                        } else if (c2 == quote) {
                            offset += 2;
                            i += 2;
                        } else if (c3 == quote) {
                            offset += 3;
                            i += 3;
                        }
                    }
                    valueLength = i;
                } else {
                    while (true) {
                        if (offset >= this.end) {
                            throw new JSONException(this.info("invalid escape character EOI"));
                        }
                        char c = this.chars[offset];
                        if (c == '\\') {
                            valueEscape = true;
                            c = this.chars[++offset];
                            switch (c) {
                                case 'u': {
                                    offset += 4;
                                    break;
                                }
                                case 'x': {
                                    offset += 2;
                                    break;
                                }
                            }
                            ++offset;
                        } else {
                            if (c == quote) {
                                valueLength = i;
                                break;
                            }
                            ++offset;
                        }
                        ++i;
                    }
                }
                if (valueEscape) {
                    char[] chars = new char[valueLength];
                    offset = start;
                    int i2 = 0;
                    while (true) {
                        char c;
                        if ((c = this.chars[offset]) == '\\') {
                            c = this.chars[++offset];
                            switch (c) {
                                case 'u': {
                                    char c12 = this.chars[++offset];
                                    char c22 = this.chars[++offset];
                                    char c32 = this.chars[++offset];
                                    char c4 = this.chars[++offset];
                                    c = JSONReaderUTF16.char4(c12, c22, c32, c4);
                                    break;
                                }
                                case 'x': {
                                    char c12 = this.chars[++offset];
                                    char c22 = this.chars[++offset];
                                    c = JSONReaderUTF16.char2(c12, c22);
                                    break;
                                }
                                case '\"': 
                                case '\\': {
                                    break;
                                }
                                case 'b': {
                                    c = '\b';
                                    break;
                                }
                                case 't': {
                                    c = '\t';
                                    break;
                                }
                                case 'n': {
                                    c = '\n';
                                    break;
                                }
                                case 'f': {
                                    c = '\f';
                                    break;
                                }
                                case 'r': {
                                    c = '\r';
                                    break;
                                }
                                default: {
                                    c = this.char1(c);
                                    break;
                                }
                            }
                        } else if (c == quote) break;
                        chars[i2] = c;
                        ++offset;
                        ++i2;
                    }
                    str = new String(chars);
                } else {
                    int strlen = offset - this.offset;
                    str = strlen == 1 && (c0 = this.chars[this.offset]) < '\u0080' ? TypeUtils.toString(c0) : (strlen == 2 && (c0 = this.chars[this.offset]) < '\u0080' && (c1 = this.chars[this.offset + 1]) < '\u0080' ? TypeUtils.toString(c0, c1) : (this.str != null ? this.str.substring(this.offset, offset) : new String(this.chars, this.offset, offset - this.offset)));
                }
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str = str.trim();
                }
                if (++offset != this.end) {
                    int e = this.chars[offset++];
                    while (e <= 32 && (1L << e & 0x100003700L) != 0L) {
                        if (offset != this.end) {
                            e = this.chars[offset++];
                            continue;
                        }
                        break block51;
                    }
                    this.comma = e == 44;
                    if (this.comma) {
                        if (offset == this.end) {
                            e = 26;
                        } else {
                            e = this.chars[offset++];
                            while (e <= 32 && (1L << e & 0x100003700L) != 0L) {
                                if (offset == this.end) {
                                    e = 26;
                                    break;
                                }
                                e = this.chars[offset++];
                            }
                        }
                    }
                    this.ch = e;
                    this.offset = offset;
                    return str;
                }
            }
            this.ch = (char)26;
            this.comma = false;
            this.offset = offset;
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException(this.info("illegal input : " + this.ch));
    }

    @Override
    public final void skipValue() {
        char[] chars = this.chars;
        block0 : switch (this.ch) {
            case '[': {
                this.next();
                int i = 0;
                while (true) {
                    if (this.ch == ']') {
                        this.next();
                        break block0;
                    }
                    if (i != 0 && !this.comma) {
                        throw new JSONException(this.info("illegal value"));
                    }
                    this.comma = false;
                    this.skipValue();
                    ++i;
                }
            }
            case '{': {
                this.next();
                while (true) {
                    if (this.ch == '}') {
                        this.comma = false;
                        this.next();
                        break block0;
                    }
                    this.skipName();
                    this.skipValue();
                }
            }
            case '\"': {
                this.skipString();
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean sign;
                boolean bl = sign = this.ch == '-' || this.ch == '+';
                if (sign) {
                    if (this.offset < this.end) {
                        this.ch = chars[this.offset++];
                    } else {
                        throw new JSONException("illegal number, offset " + this.offset);
                    }
                }
                boolean dot = this.ch == '.';
                boolean num = false;
                if (!dot && this.ch >= '0' && this.ch <= '9') {
                    num = true;
                    do {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            return;
                        }
                        this.ch = chars[this.offset++];
                    } while (this.ch >= '0' && this.ch <= '9');
                }
                boolean small = false;
                if (this.ch == '.') {
                    small = true;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = chars[this.offset++];
                    if (this.ch >= '0' && this.ch <= '9') {
                        do {
                            if (this.offset >= this.end) {
                                this.ch = (char)26;
                                return;
                            }
                            this.ch = chars[this.offset++];
                        } while (this.ch >= '0' && this.ch <= '9');
                    }
                }
                if (!num && !small) {
                    throw new JSONException("illegal number, offset " + this.offset + ", char " + this.ch);
                }
                if (this.ch == 'e' || this.ch == 'E') {
                    this.ch = chars[this.offset++];
                    boolean eSign = false;
                    if (this.ch == '+' || this.ch == '-') {
                        eSign = true;
                        if (this.offset < this.end) {
                            this.ch = chars[this.offset++];
                        } else {
                            throw new JSONException("illegal number, offset " + this.offset);
                        }
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        do {
                            if (this.offset >= this.end) {
                                this.ch = (char)26;
                                return;
                            }
                            this.ch = chars[this.offset++];
                        } while (this.ch >= '0' && this.ch <= '9');
                    } else if (eSign) {
                        throw new JSONException("illegal number, offset " + this.offset + ", char " + this.ch);
                    }
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = chars[this.offset++];
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch == '}' || this.ch == ']') {
                    return;
                }
                if (this.ch == ',') {
                    this.comma = true;
                    if (this.offset >= this.end) {
                        throw new JSONException("illegal number, offset " + this.offset);
                    }
                    this.ch = chars[this.offset];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        ++this.offset;
                        if (this.offset >= this.end) {
                            throw new JSONException("illegal number, offset " + this.offset);
                        }
                        this.ch = chars[this.offset];
                    }
                    ++this.offset;
                    return;
                }
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
            case 't': {
                if (this.offset + 3 > this.end) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                if (chars[this.offset] != 'r' || chars[this.offset + 1] != 'u' || chars[this.offset + 2] != 'e') {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.offset += 3;
                if (this.offset < this.end) {
                    this.ch = chars[this.offset++];
                } else {
                    this.ch = (char)26;
                    return;
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = chars[this.offset++];
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch != '}' && this.ch != ']') break;
                return;
            }
            case 'f': {
                if (this.offset + 4 > this.end) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                if (chars[this.offset] != 'a' || chars[this.offset + 1] != 'l' || chars[this.offset + 2] != 's' || chars[this.offset + 3] != 'e') {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.offset += 4;
                if (this.offset < this.end) {
                    this.ch = chars[this.offset++];
                } else {
                    this.ch = (char)26;
                    return;
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = chars[this.offset++];
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch != '}' && this.ch != ']') break;
                return;
            }
            case 'n': {
                if (this.offset + 3 > this.end) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                if (chars[this.offset] != 'u' || chars[this.offset + 1] != 'l' || chars[this.offset + 2] != 'l') {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.offset += 3;
                if (this.offset < this.end) {
                    this.ch = chars[this.offset++];
                } else {
                    this.ch = (char)26;
                    return;
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = chars[this.offset++];
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch != '}' && this.ch != ']') break;
                return;
            }
            case 'S': {
                if (this.nextIfSet()) {
                    this.skipValue();
                    break;
                }
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
            default: {
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.length) {
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
            this.ch = chars[this.offset];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.length) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.ch = chars[this.offset];
            }
            ++this.offset;
        } else if (!this.comma && this.ch != '}' && this.ch != ']' && this.ch != '\u001a') {
            throw new JSONException(this.info("illegal ch " + this.ch));
        }
    }

    @Override
    public final void skipLineComment() {
        while (true) {
            if (this.ch == '\n') {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.chars[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = this.chars[this.offset];
                }
                ++this.offset;
                break;
            }
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
    }

    @Override
    public final void readNumber0() {
        int digit;
        int multmin;
        int limit;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        int firstOffset = this.offset;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.chars[this.offset++];
                this.nextIfComma();
                this.wasNull = true;
                return;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            limit = Integer.MIN_VALUE;
            multmin = -214748364;
            this.negative = true;
            this.ch = this.chars[this.offset++];
        } else {
            if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            limit = -2147483647;
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                digit = this.ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin || this.mag3 < limit + digit) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.chars[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = this.chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    digit = this.ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin || this.mag3 < limit + digit) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? this.offset - 2 - numStart : this.offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                this.stringValue = new String(this.chars, numStart, this.offset - 1 - numStart);
            } else {
                this.bigInt(this.chars, numStart, this.offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = this.chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = this.chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = this.chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = this.chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 'l') {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.chars[this.offset++] == 'r' && this.chars[this.offset++] == 'u' && this.chars[this.offset++] == 'e') {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.chars[this.offset++] == 'a' && this.chars[this.offset++] == 'l' && this.chars[this.offset++] == 's' && this.chars[this.offset++] == 'e') {
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.chars[this.offset++];
                    }
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                this.offset = firstOffset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = this.chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.chars[this.offset++];
                }
            }
        }
    }

    @Override
    public final boolean readIfNull() {
        if (this.ch == 'n' && this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else {
            return false;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        return true;
    }

    @Override
    public final Date readNullOrNewDate() {
        Date date = null;
        if (this.offset + 2 < this.end && this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else if (this.offset + 1 < this.end && this.chars[this.offset] == 'e' && this.chars[this.offset + 1] == 'w') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 2];
            this.offset += 3;
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            if (this.offset + 4 < this.end && this.ch == 'D' && this.chars[this.offset] == 'a' && this.chars[this.offset + 1] == 't' && this.chars[this.offset + 2] == 'e') {
                this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
                this.offset += 4;
            } else {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            if (this.ch != '(' || this.offset >= this.end) {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
            long millis = this.readInt64Value();
            if (this.ch != ')') {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            date = new Date(millis);
        } else {
            throw new JSONException("json syntax error, not match null or new Date" + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : this.chars[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
        return date;
    }

    @Override
    public final boolean isArray() {
        return this.ch == '[';
    }

    @Override
    public final boolean isNull() {
        return this.ch == 'n' && this.offset < this.end && this.chars[this.offset] == 'u';
    }

    @Override
    public final boolean nextIfNull() {
        if (this.ch == 'n' && this.offset + 2 < this.end && this.chars[this.offset] == 'u') {
            this.readNull();
            return true;
        }
        return false;
    }

    @Override
    public final void readNull() {
        if (this.chars[this.offset] == 'u' && this.chars[this.offset + 1] == 'l' && this.chars[this.offset + 2] == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.chars[this.offset + 3];
            this.offset += 4;
        } else {
            throw new JSONException("json syntax error, not match null, offset " + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = this.offset >= this.end ? (char)26 : this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        }
    }

    @Override
    public final BigDecimal readBigDecimal() {
        long intValue10;
        char[] chars = this.chars;
        boolean value = false;
        BigDecimal decimal = null;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = chars[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : chars[this.offset++];
                this.nextIfComma();
                return null;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = chars[this.offset++];
        } else {
            this.negative = false;
            if (this.ch == '+') {
                this.ch = chars[this.offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = chars[this.offset++];
        }
        this.scale = 0;
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = chars[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(this.ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = chars[this.offset++];
            }
        }
        int expValue = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            this.ch = chars[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = chars[this.offset++];
            } else if (this.ch == '+') {
                this.ch = chars[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = chars[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (chars[this.offset++] == 'u' && chars[this.offset++] == 'l' && chars[this.offset++] == 'l') {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = chars[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (chars[this.offset++] == 'r' && chars[this.offset++] == 'u' && chars[this.offset++] == 'e') {
                    value = true;
                    decimal = BigDecimal.ONE;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = chars[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (chars[this.offset++] == 'a' && chars[this.offset++] == 'l' && chars[this.offset++] == 's' && chars[this.offset++] == 'e') {
                    decimal = BigDecimal.ZERO;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = chars[this.offset++];
                    }
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                JSONObject jsonObject = new JSONObject();
                this.readObject((Object)jsonObject, 0L);
                decimal = this.decimal(jsonObject);
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                String str = this.readString();
                try {
                    return TypeUtils.toBigDecimal(str);
                }
                catch (NumberFormatException e) {
                    throw new JSONException(this.info(e.getMessage()), e);
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : chars[this.offset++];
        }
        if (!value) {
            if (expValue == 0 && !overflow && longValue != 0L) {
                decimal = BigDecimal.valueOf(this.negative ? -longValue : longValue, this.scale);
                value = true;
            }
            if (!value) {
                decimal = TypeUtils.parseBigDecimal(chars, start - 1, len);
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : chars[this.offset++];
            }
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = chars[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = chars[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = chars[this.offset++];
                }
            }
        }
        return decimal;
    }

    @Override
    public final UUID readUUID() {
        char ch = this.ch;
        if (ch == 'n') {
            this.readNull();
            return null;
        }
        if (ch != '\"' && ch != '\'') {
            throw new JSONException(this.info("syntax error, can not read uuid"));
        }
        char quote = ch;
        int offset = this.offset;
        char[] chars = this.chars;
        if (offset + 36 < chars.length && chars[offset + 36] == quote) {
            char ch1 = chars[offset + 8];
            char ch2 = chars[offset + 13];
            char ch3 = chars[offset + 18];
            char ch4 = chars[offset + 23];
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-') {
                int i;
                int i2;
                long hi = 0L;
                for (i2 = 0; i2 < 8; ++i2) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i2] - 48];
                }
                for (i2 = 9; i2 < 13; ++i2) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i2] - 48];
                }
                for (i2 = 14; i2 < 18; ++i2) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i2] - 48];
                }
                long lo = 0L;
                for (i = 19; i < 23; ++i) {
                    lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
                }
                for (i = 24; i < 36; ++i) {
                    lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
                }
                UUID uuid = new UUID(hi, lo);
                ch = (offset += 37) == this.end ? (char)'\u001a' : chars[offset++];
                while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                    if (offset >= this.end) {
                        ch = '\u001a';
                        continue;
                    }
                    ch = chars[offset++];
                }
                this.offset = offset;
                this.comma = ch == ',';
                if (this.comma) {
                    this.next();
                } else {
                    this.ch = ch;
                }
                return uuid;
            }
        } else if (offset + 32 < chars.length && chars[offset + 32] == quote) {
            long hi = 0L;
            for (int i = 0; i < 16; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            long lo = 0L;
            for (int i = 16; i < 32; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            UUID uuid = new UUID(hi, lo);
            ch = (offset += 33) == this.end ? (char)'\u001a' : chars[offset++];
            while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    ch = '\u001a';
                    continue;
                }
                ch = chars[offset++];
            }
            this.offset = offset;
            this.comma = ch == ',';
            if (this.comma) {
                this.next();
            } else {
                this.ch = ch;
            }
            return uuid;
        }
        String str = this.readString();
        return UUID.fromString(str);
    }

    @Override
    public final int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        char[] chars = this.chars;
        int i8 = i + 8;
        if (i8 < this.end && i8 < chars.length && chars[i] != quote && chars[i + 1] != quote && chars[i + 2] != quote && chars[i + 3] != quote && chars[i + 4] != quote && chars[i + 5] != quote && chars[i + 6] != quote && chars[i + 7] != quote) {
            i += 8;
            len += 8;
        }
        while (i < this.end && chars[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    protected final LocalDateTime readLocalDateTime14() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime14(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 15;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime12() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime12(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime16() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime16(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 17;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime17() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime17(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 18;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime18() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime18(this.chars, this.offset);
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime5() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime5(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 6;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime8() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    public final LocalDate readLocalDate8() {
        LocalDate ldt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate8(this.chars, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate9() {
        LocalDate ldt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate9(this.chars, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate10() {
        LocalDate ldt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate10(this.chars, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate11() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        LocalDate ldt = DateUtils.parseLocalDate11(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate() {
        char[] chars = this.chars;
        if ((this.ch == '\"' || this.ch == '\'') && (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601)) {
            char quote = this.ch;
            int c10 = this.offset + 10;
            if (c10 < chars.length && c10 < this.end && chars[this.offset + 4] == '-' && chars[this.offset + 7] == '-' && chars[this.offset + 10] == quote) {
                LocalDate ldt;
                char y0 = chars[this.offset];
                char y1 = chars[this.offset + 1];
                char y2 = chars[this.offset + 2];
                char y3 = chars[this.offset + 3];
                char m0 = chars[this.offset + 5];
                char m1 = chars[this.offset + 6];
                char d0 = chars[this.offset + 8];
                char d1 = chars[this.offset + 9];
                if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
                    return super.readLocalDate();
                }
                int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
                if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
                    return super.readLocalDate();
                }
                int month = (m0 - 48) * 10 + (m1 - 48);
                if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
                    return super.readLocalDate();
                }
                int dom = (d0 - 48) * 10 + (d1 - 48);
                try {
                    ldt = year == 0 && month == 0 && dom == 0 ? null : LocalDate.of(year, month, dom);
                }
                catch (DateTimeException ex) {
                    throw new JSONException(this.info("read date error"), ex);
                }
                this.offset += 11;
                this.next();
                this.comma = this.ch == ',';
                if (this.comma) {
                    this.next();
                }
                return ldt;
            }
        }
        return super.readLocalDate();
    }

    @Override
    protected final ZonedDateTime readZonedDateTimeX(int len) {
        ZonedDateTime zdt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        if (len == 30 && this.chars[this.offset + 29] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime29(this.chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else if (len == 29 && this.chars[this.offset + 28] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime28(this.chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else if (len == 28 && this.chars[this.offset + 27] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime27(this.chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else if (len == 27 && this.chars[this.offset + 26] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime26(this.chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else {
            zdt = DateUtils.parseZonedDateTime(this.chars, this.offset, len, this.context.zoneId);
        }
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return zdt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime19() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime19(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime20() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime20(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 21;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final long readMillis19() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            throw new JSONException("date only support string input");
        }
        if (this.offset + 18 >= this.end) {
            this.wasNull = true;
            return 0L;
        }
        long millis = DateUtils.parseMillis19(this.chars, this.offset, this.context.zoneId);
        if (this.chars[this.offset + 19] != quote) {
            throw new JSONException(this.info("illegal date input"));
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return millis;
    }

    @Override
    protected final LocalDateTime readLocalDateTimeX(int len) {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTimeX(this.chars, this.offset, len);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime10() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime10(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime11() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime11(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime12() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime12(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime18() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime18(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    public final String readPattern() {
        char c;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        int offset = this.offset;
        while ((c = this.chars[offset]) != '/' && ++offset < this.end) {
        }
        String str = new String(this.chars, this.offset, offset - this.offset);
        if (offset + 1 == this.end) {
            this.offset = this.end;
            this.ch = (char)26;
            return str;
        }
        char b = this.chars[++offset];
        while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
            b = this.chars[++offset];
        }
        this.comma = b == ',';
        if (this.comma) {
            this.offset = offset + 1;
            this.ch = this.chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.chars[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = b;
        }
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean readBoolValue() {
        boolean val;
        this.wasNull = false;
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 116 && offset + 2 < chars.length && chars[offset] == 'r' && chars[offset + 1] == 'u' && chars[offset + 2] == 'e') {
            offset += 3;
            val = true;
        } else if (ch == 102 && offset + 3 < chars.length && chars[offset] == 'a' && chars[offset + 1] == 'l' && chars[offset + 2] == 's' && chars[offset + 3] == 'e') {
            offset += 4;
            val = false;
        } else {
            if (ch == 45 || ch >= 48 && ch <= 57) {
                this.readNumber();
                if (this.valueType != 1) return false;
                if ((this.context.features & JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue.mask) != 0L) {
                    if (this.mag0 != 0) return true;
                    if (this.mag1 != 0) return true;
                    if (this.mag2 != 0) return true;
                    if (this.mag3 == 0) return false;
                    return true;
                }
                if (this.mag0 != 0) return false;
                if (this.mag1 != 0) return false;
                if (this.mag2 != 0) return false;
                if (this.mag3 != 1) return false;
                return true;
            }
            if (ch == 110 && offset + 2 < chars.length && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("boolean value not support input null"));
                }
                this.wasNull = true;
                offset += 3;
                val = false;
            } else {
                if (ch != 34) throw new JSONException("syntax error : " + (char)ch);
                if (offset + 1 < chars.length && chars[offset + 1] == '\"') {
                    char c0 = chars[offset];
                    offset += 2;
                    if (c0 == '0' || c0 == 'N') {
                        val = false;
                    } else {
                        if (c0 != '1') {
                            if (c0 != 'Y') throw new JSONException("can not convert to boolean : " + c0);
                        }
                        val = true;
                    }
                } else {
                    String str = this.readString();
                    if ("true".equalsIgnoreCase(str)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(str)) {
                        return false;
                    }
                    if (!str.isEmpty()) {
                        if (!"null".equalsIgnoreCase(str)) throw new JSONException("can not convert to boolean : " + str);
                    }
                    this.wasNull = true;
                    return false;
                }
            }
        }
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = 26;
                continue;
            }
            ch = chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    ch = 26;
                    continue;
                }
                ch = chars[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return val;
    }

    @Override
    public final String info(String message) {
        int line = 1;
        int column = 1;
        int i = 0;
        while (i < this.offset & i < this.end) {
            if (this.chars[i] == '\n') {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        StringBuilder buf = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            buf.append(message).append(", ");
        }
        buf.append("offset ").append(this.offset).append(", character ").append(this.ch).append(", line ").append(line).append(", column ").append(column).append(", fastjson-version ").append("2.0.33").append(line > 1 ? (char)'\n' : ' ');
        int MAX_OUTPUT_LENGTH = 65535;
        buf.append(this.chars, this.start, this.length < 65535 ? this.length : 65535);
        return buf.toString();
    }

    @Override
    public final void close() {
        if (this.cacheIndex != -1) {
            JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[this.cacheIndex];
            JSONFactory.CHARS_UPDATER.lazySet(cacheItem, this.chars);
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

