/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathMulti;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONPathSegmentIndex;
import com.alibaba.fastjson2.JSONPathSegmentName;
import com.alibaba.fastjson2.JSONPathSingle;
import com.alibaba.fastjson2.JSONPathSingleIndex;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTwoSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.Fnv;
import java.util.ArrayList;
import java.util.List;

class JSONPathParser {
    final String path;
    final JSONReader jsonReader;
    boolean dollar;
    boolean lax;
    boolean strict;
    int segmentIndex;
    JSONPathSegment first;
    JSONPathSegment second;
    List<JSONPathSegment> segments;
    boolean negative;

    public JSONPathParser(String str) {
        this.path = str;
        this.jsonReader = JSONReader.of(this.path, JSONPath.PARSE_CONTEXT);
        if (this.jsonReader.ch == 'l' && this.jsonReader.nextIfMatchIdent('l', 'a', 'x')) {
            this.lax = true;
        } else if (this.jsonReader.ch == 's' && this.jsonReader.nextIfMatchIdent('s', 't', 'r', 'i', 'c', 't')) {
            this.strict = true;
        }
        if (this.jsonReader.ch == '-') {
            this.jsonReader.next();
            this.negative = true;
        }
        if (this.jsonReader.ch == '$') {
            this.jsonReader.next();
            this.dollar = true;
        }
    }

    JSONPath parse() {
        if (this.dollar && this.jsonReader.ch == '\u001a') {
            if (this.negative) {
                throw new JSONException("not support '-'");
            }
            return JSONPath.RootPath.INSTANCE;
        }
        while (this.jsonReader.ch != '\u001a') {
            JSONPathSegment segment;
            char ch = this.jsonReader.ch;
            if (ch == '.') {
                this.jsonReader.next();
                segment = this.parseProperty();
            } else if (this.jsonReader.ch == '[') {
                segment = this.parseArrayAccess();
            } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_') {
                segment = this.parseProperty();
            } else {
                if (ch == '?') {
                    throw new JSONException("not support filter '?'");
                }
                if (ch == '@') {
                    this.jsonReader.next();
                    segment = JSONPathSegment.SelfSegment.INSTANCE;
                } else {
                    throw new JSONException("not support " + ch);
                }
            }
            if (this.segmentIndex == 0) {
                this.first = segment;
            } else if (this.segmentIndex == 1) {
                this.second = segment;
            } else if (this.segmentIndex == 2) {
                this.segments = new ArrayList<JSONPathSegment>();
                this.segments.add(this.first);
                this.segments.add(this.second);
                this.segments.add(segment);
            } else {
                this.segments.add(segment);
            }
            ++this.segmentIndex;
        }
        if (this.negative) {
            throw new JSONException("not support '-'");
        }
        if (this.segmentIndex == 1) {
            if (this.first instanceof JSONPathSegmentName) {
                return new JSONPathSingleName(this.path, (JSONPathSegmentName)this.first);
            }
            if (this.first instanceof JSONPathSegmentIndex) {
                JSONPathSegmentIndex firstIndex = (JSONPathSegmentIndex)this.first;
                if (firstIndex.index >= 0) {
                    return new JSONPathSingleIndex(this.path, firstIndex);
                }
            }
            return new JSONPathSingle(this.first, this.path);
        }
        if (this.segmentIndex == 2) {
            return new JSONPathTwoSegment(this.path, this.first, this.second);
        }
        return new JSONPathMulti(this.path, this.segments);
    }

    private JSONPathSegment parseArrayAccess() {
        JSONPathSegment segment;
        this.jsonReader.next();
        switch (this.jsonReader.ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int index = this.jsonReader.readInt32Value();
                if (this.jsonReader.ch == ':') {
                    throw new JSONException("not support range index ':'");
                }
                if (this.jsonReader.isNumber()) {
                    throw new JSONException("not support");
                }
                segment = JSONPathSegmentIndex.of(index);
                break;
            }
            case '*': {
                throw new JSONException("not support *");
            }
            case ':': {
                throw new JSONException("not support range index ':'");
            }
            case '\"': 
            case '\'': {
                String name = this.jsonReader.readString();
                if (this.jsonReader.current() == ']') {
                    segment = new JSONPathSegmentName(name, Fnv.hashCode64(name));
                    break;
                }
                if (this.jsonReader.isString()) {
                    throw new JSONException("not support multi name");
                }
                throw new JSONException("TODO : " + this.jsonReader.current());
            }
            default: {
                throw new JSONException("TODO : " + this.jsonReader.current());
            }
        }
        if (!this.jsonReader.nextIfArrayEnd()) {
            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
        }
        return segment;
    }

    private JSONPathSegment parseProperty() {
        if (this.jsonReader.ch == '*') {
            throw new JSONException("not support *");
        }
        if (this.jsonReader.ch == '.') {
            throw new JSONException("not support jsonpath ..");
        }
        long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
        String name = this.jsonReader.getFieldName();
        if (this.jsonReader.ch == '(') {
            throw new JSONException("not support jsonpath function");
        }
        JSONPathSegmentName segment = new JSONPathSegmentName(name, hashCode);
        return segment;
    }
}

