/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.function.Supplier;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.reflect.Type;

public class ObjectReader2<T>
extends ObjectReaderAdapter<T> {
    protected final FieldReader fieldReader0;
    protected final FieldReader fieldReader1;
    protected final long hashCode0;
    protected final long hashCode1;
    protected final long hashCode0LCase;
    protected final long hashCode1LCase;
    protected ObjectReader objectReader0;
    protected ObjectReader objectReader1;

    public ObjectReader2(Class objectClass, long features, Supplier<T> creator, Function buildFunction, FieldReader first, FieldReader second) {
        this(objectClass, null, null, features, creator, buildFunction, first, second);
    }

    public ObjectReader2(Class objectClass, String typeKey, String typeName, long features, Supplier<T> creator, Function buildFunction, FieldReader ... fieldReaders) {
        super(objectClass, typeKey, typeName, features, creator, buildFunction, fieldReaders);
        this.fieldReader0 = fieldReaders[0];
        this.fieldReader1 = fieldReaders[1];
        this.hashCode0 = this.fieldReader0.fieldNameHash;
        this.hashCode0LCase = this.fieldReader0.fieldNameHashLCase;
        this.hashCode1 = this.fieldReader1.fieldNameHash;
        this.hashCode1LCase = this.fieldReader1.fieldNameHashLCase;
        this.hasDefaultValue = this.fieldReader0.defaultValue != null || this.fieldReader1.defaultValue != null;
    }

    @Override
    protected void initDefaultValue(T object) {
        this.fieldReader0.acceptDefaultValue(object);
        this.fieldReader1.acceptDefaultValue(object);
    }

    @Override
    public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        ObjectReader autoTypeReader;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((autoTypeReader = this.checkAutoType(jsonReader, this.objectClass, this.features | features)) != null && autoTypeReader != this && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        Object object = this.creator.get();
        int entryCnt = jsonReader.startArray();
        if (entryCnt > 0) {
            this.fieldReader0.readFieldValue(jsonReader, object);
            if (entryCnt > 1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                for (int i = 2; i < entryCnt; ++i) {
                    jsonReader.skipValue();
                }
            }
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object object;
        ObjectReader autoTypeReader;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features)) != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.isArray()) {
            int entryCnt;
            Object object2 = this.creator.get();
            if (this.hasDefaultValue) {
                this.initDefaultValue(object2);
            }
            if ((entryCnt = jsonReader.startArray()) > 0) {
                this.fieldReader0.readFieldValue(jsonReader, object2);
                if (entryCnt > 1) {
                    this.fieldReader1.readFieldValue(jsonReader, object2);
                    for (int i = 2; i < entryCnt; ++i) {
                        jsonReader.skipValue();
                    }
                }
            }
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
        }
        if (this.creator != null) {
            object = this.creator.get();
        } else if (((features | jsonReader.context.getFeatures()) & JSONReader.Feature.FieldBased.mask) != 0L) {
            try {
                object = JDKUtils.UNSAFE.allocateInstance(this.objectClass);
            }
            catch (InstantiationException e) {
                throw new JSONException(jsonReader.info("create instance error"), e);
            }
        } else {
            object = null;
        }
        if (object != null && this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        if (object != null && jsonReader.isInitStringFieldAsEmpty()) {
            this.initStringFieldAsEmpty(object);
        }
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == 0L) continue;
            if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode1) {
                this.fieldReader1.readFieldValueJSONB(jsonReader, object);
                continue;
            }
            if (jsonReader.isSupportSmartMatch(features | this.features)) {
                long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                if (nameHashCodeLCase == this.hashCode0LCase) {
                    this.fieldReader0.readFieldValueJSONB(jsonReader, object);
                    continue;
                }
                if (nameHashCodeLCase == this.hashCode1LCase) {
                    this.fieldReader1.readFieldValueJSONB(jsonReader, object);
                    continue;
                }
            }
            this.processExtra(jsonReader, object);
        }
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader) {
        return this.readObject(jsonReader, null, null, this.features);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.jsonb) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfComma();
            return null;
        }
        featuresAll = jsonReader.features(this.features | features);
        if (jsonReader.isArray()) {
            if ((featuresAll & JSONReader.Feature.SupportArrayToBean.mask) != 0L) {
                jsonReader.next();
                object = this.creator.get();
                if (this.hasDefaultValue) {
                    this.initDefaultValue(object);
                }
                this.fieldReader0.readFieldValue(jsonReader, object);
                this.fieldReader1.readFieldValue(jsonReader, object);
                if (jsonReader.current() != ']') {
                    throw new JSONException(jsonReader.info("array to bean end error"));
                }
                jsonReader.next();
                return object;
            }
            return this.processObjectInputSingleItemArray(jsonReader, fieldType, fieldName, featuresAll);
        }
        jsonReader.nextIfObjectStart();
        object /* !! */  = this.creator.get();
        if (this.hasDefaultValue) {
            this.initDefaultValue(object /* !! */ );
        }
        if (object /* !! */  != null && (featuresAll & JSONReader.Feature.InitStringFieldAsEmpty.mask) != 0L) {
            this.initStringFieldAsEmpty(object /* !! */ );
        }
        i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            block19: {
                block21: {
                    block20: {
                        block18: {
                            hashCode = jsonReader.readFieldNameHashCode();
                            if (i != 0 || hashCode != ObjectReader2.HASH_TYPE) break block18;
                            context = jsonReader.context;
                            typeHash = jsonReader.readTypeHashCode();
                            autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                            if ((autoTypeObjectReader != null || (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) != null) && autoTypeObjectReader != this) {
                                object /* !! */  = autoTypeObjectReader.readObject(jsonReader, fieldType, fieldName, features);
                                break;
                            }
                            break block19;
                        }
                        if (hashCode != this.hashCode0) break block20;
                        this.fieldReader0.readFieldValue(jsonReader, object /* !! */ );
                        break block19;
                    }
                    if (hashCode != this.hashCode1) break block21;
                    this.fieldReader1.readFieldValue(jsonReader, object /* !! */ );
                    break block19;
                }
                if (!jsonReader.isSupportSmartMatch(features | this.features)) ** GOTO lbl-1000
                nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                if (nameHashCodeLCase == this.hashCode0LCase) {
                    this.fieldReader0.readFieldValue(jsonReader, object /* !! */ );
                } else if (nameHashCodeLCase == this.hashCode1LCase) {
                    this.fieldReader1.readFieldValue(jsonReader, object /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    this.processExtra(jsonReader, object /* !! */ );
                }
            }
            ++i;
        }
        jsonReader.nextIfComma();
        if (this.buildFunction != null) {
            try {
                object /* !! */  = this.buildFunction.apply(object /* !! */ );
            }
            catch (IllegalStateException e) {
                throw new JSONException(jsonReader.info("build object error"), e);
            }
        }
        return object /* !! */ ;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.hashCode0) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1) {
            return this.fieldReader1;
        }
        return null;
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        if (hashCode == this.hashCode0LCase) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1LCase) {
            return this.fieldReader1;
        }
        return null;
    }
}

