/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.function.Supplier;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapString;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JSONObject1O;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ObjectReaderImplMap
implements ObjectReader {
    static final Class CLASS_SINGLETON_MAP = Collections.singletonMap(1, 1).getClass();
    static final Class CLASS_EMPTY_MAP = Collections.EMPTY_MAP.getClass();
    static final Class CLASS_UNMODIFIABLE_MAP = Collections.unmodifiableMap(Collections.emptyMap()).getClass();
    public static ObjectReaderImplMap INSTANCE = new ObjectReaderImplMap(null, HashMap.class, HashMap.class, 0L, null);
    public static ObjectReaderImplMap INSTANCE_OBJECT = new ObjectReaderImplMap(null, JSONObject.class, JSONObject.class, 0L, null);
    final Type fieldType;
    final Class mapType;
    final long mapTypeHash;
    final Class instanceType;
    final long features;
    final Function builder;
    Object mapSingleton;
    volatile boolean instanceError;

    public static ObjectReader of(Type fieldType, Class mapType, long features) {
        String instanceTypeName;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Function<Map, Map> builder = null;
        Class<Object> instanceType = mapType;
        if ("".equals(instanceType.getSimpleName())) {
            instanceType = mapType.getSuperclass();
            if (fieldType == null) {
                fieldType = mapType.getGenericSuperclass();
            }
        }
        if (mapType == Map.class || mapType == AbstractMap.class || mapType == CLASS_SINGLETON_MAP) {
            instanceType = HashMap.class;
        } else if (mapType == CLASS_UNMODIFIABLE_MAP) {
            instanceType = LinkedHashMap.class;
        } else if (mapType == ConcurrentMap.class) {
            instanceType = ConcurrentHashMap.class;
        } else if (mapType == ConcurrentNavigableMap.class) {
            instanceType = ConcurrentSkipListMap.class;
        } else {
            switch (TypeUtils.getTypeName(mapType)) {
                case "java.util.Collections$SynchronizedMap": {
                    instanceType = HashMap.class;
                    builder = Collections::synchronizedMap;
                    break;
                }
                case "java.util.Collections$SynchronizedSortedMap": {
                    instanceType = TreeMap.class;
                    builder = Collections::synchronizedSortedMap;
                    break;
                }
            }
        }
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 2 && !"org.springframework.util.LinkedMultiValueMap".equals(instanceType.getName())) {
            Type keyType = actualTypeArguments[0];
            Type valueType = actualTypeArguments[1];
            if (keyType == String.class && valueType == String.class && builder == null) {
                return new ObjectReaderImplMapString(mapType, instanceType, features);
            }
            return new ObjectReaderImplMapTyped(mapType, instanceType, keyType, valueType, 0L, builder);
        }
        if (fieldType == null && features == 0L) {
            if (mapType == HashMap.class && instanceType == HashMap.class) {
                return INSTANCE;
            }
            if (mapType == JSONObject.class && instanceType == JSONObject.class) {
                return INSTANCE_OBJECT;
            }
        }
        if ((instanceTypeName = instanceType.getName()).equals("com.alibaba.fastjson.JSONObject")) {
            builder = ObjectReaderImplMap.createObjectSupplier(instanceType);
            instanceType = HashMap.class;
        } else {
            if (instanceTypeName.equals("java.util.Collections$EmptyMap")) {
                return new ObjectReaderImplMap(instanceType, features, Collections.EMPTY_MAP);
            }
            if (instanceTypeName.equals("kotlin.collections.EmptyMap")) {
                Object mapSingleton;
                try {
                    Field field = instanceType.getField("INSTANCE");
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    mapSingleton = field.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException("Failed to get singleton of " + instanceType, e);
                }
                return new ObjectReaderImplMap(instanceType, features, mapSingleton);
            }
            if (instanceType == JSONObject1O.class) {
                Class objectClass = TypeUtils.CLASS_JSON_OBJECT_1x;
                builder = ObjectReaderImplMap.createObjectSupplier(objectClass);
                instanceType = LinkedHashMap.class;
            } else if (mapType == CLASS_UNMODIFIABLE_MAP) {
                builder = Collections::unmodifiableMap;
            } else if (mapType == CLASS_SINGLETON_MAP) {
                builder = map -> {
                    Map.Entry entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                };
            }
        }
        return new ObjectReaderImplMap(fieldType, mapType, instanceType, features, builder);
    }

    ObjectReaderImplMap(Class mapClass, long features, Object mapSingleton) {
        this(mapClass, mapClass, mapClass, features, null);
        this.mapSingleton = mapSingleton;
    }

    ObjectReaderImplMap(Type fieldType, Class mapType, Class instanceType, long features, Function builder) {
        this.fieldType = fieldType;
        this.mapType = mapType;
        this.mapTypeHash = Fnv.hashCode64(TypeUtils.getTypeName(mapType));
        this.instanceType = instanceType;
        this.features = features;
        this.builder = builder;
    }

    public Class getObjectClass() {
        return this.mapType;
    }

    @Override
    public Function getBuildFunction() {
        return this.builder;
    }

    public Object createInstance(long features) {
        String instanceTypeName;
        if (this.instanceType == HashMap.class) {
            return new HashMap();
        }
        if (this.instanceType == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (this.instanceType == JSONObject.class) {
            return new JSONObject();
        }
        if (this.mapSingleton != null) {
            return this.mapSingleton;
        }
        switch (instanceTypeName = this.instanceType.getName()) {
            case "java.util.ImmutableCollections$Map1": {
                return new HashMap();
            }
            case "java.util.ImmutableCollections$MapN": {
                return new LinkedHashMap();
            }
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create map error : " + this.instanceType);
        }
    }

    public Object createInstance(Map map, long features) {
        if (this.mapType.isInstance(map)) {
            return map;
        }
        if (this.mapType == JSONObject.class) {
            return new JSONObject(map);
        }
        Map instance = (Map)this.createInstance(features);
        instance.putAll(map);
        if (this.builder != null) {
            return this.builder.apply(instance);
        }
        return instance;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName1, long features) {
        ObjectReader objectReader = jsonReader.checkAutoType(this.mapType, this.mapTypeHash, this.features | features);
        if (objectReader != null && objectReader != this) {
            return objectReader.readJSONBObject(jsonReader, fieldType, fieldName1, features);
        }
        if (jsonReader.nextIfNull()) {
            return null;
        }
        boolean emptyObject = false;
        jsonReader.nextIfMatch((byte)-90);
        Supplier<Map> objectSupplier = jsonReader.context.getObjectSupplier();
        Map<String, Object> map = null;
        if (this.mapType == null && objectSupplier != null) {
            map = objectSupplier.get();
        } else if (this.instanceType == HashMap.class) {
            map = new HashMap();
        } else if (this.instanceType == LinkedHashMap.class) {
            map = new LinkedHashMap();
        } else if (this.instanceType == JSONObject.class) {
            map = new JSONObject();
        } else if (this.instanceType == CLASS_EMPTY_MAP) {
            map = Collections.EMPTY_MAP;
        } else {
            JSONException error;
            block43: {
                error = null;
                if (!this.instanceError) {
                    try {
                        map = (Map)this.instanceType.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        this.instanceError = true;
                        error = new JSONException(jsonReader.info("create map error " + this.instanceType));
                    }
                }
                if (this.instanceError && Map.class.isAssignableFrom(this.instanceType.getSuperclass())) {
                    try {
                        map = (Map)this.instanceType.getSuperclass().newInstance();
                        error = null;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        if (error != null) break block43;
                        error = new JSONException(jsonReader.info("create map error " + this.instanceType));
                    }
                }
            }
            if (error != null) {
                throw error;
            }
        }
        if (!emptyObject) {
            int i = 0;
            while (true) {
                String reference;
                Object fieldName;
                byte type;
                if ((type = jsonReader.getType()) == -91) {
                    jsonReader.next();
                    break;
                }
                if (type >= 73) {
                    fieldName = jsonReader.readFieldName();
                } else if (jsonReader.nextIfMatch((byte)-109)) {
                    reference = jsonReader.readString();
                    fieldName = new ReferenceKey(i);
                    jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference));
                } else {
                    fieldName = jsonReader.readAny();
                }
                if (jsonReader.isReference()) {
                    reference = jsonReader.readReference();
                    if ("..".equals(reference)) {
                        map.put((String)fieldName, map);
                    } else {
                        jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference));
                        map.put((String)fieldName, null);
                    }
                } else {
                    Object value;
                    type = jsonReader.getType();
                    if (type >= 73 && type <= 125) {
                        value = jsonReader.readString();
                    } else if (type == -110) {
                        ObjectReader autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, this.features | features);
                        value = autoTypeObjectReader != null ? autoTypeObjectReader.readJSONBObject(jsonReader, null, fieldName, features) : jsonReader.readAny();
                    } else if (type == -79) {
                        value = Boolean.TRUE;
                        jsonReader.next();
                    } else if (type == -80) {
                        value = Boolean.FALSE;
                        jsonReader.next();
                    } else if (type == -109) {
                        String reference2 = jsonReader.readReference();
                        if ("..".equals(reference2)) {
                            value = map;
                        } else {
                            value = null;
                            jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference2));
                        }
                    } else {
                        value = type == -90 ? jsonReader.readObject() : (type >= -108 && type <= -92 ? jsonReader.readArray() : jsonReader.readAny());
                    }
                    map.put((String)fieldName, value);
                }
                ++i;
            }
        }
        if (this.builder != null) {
            return this.builder.apply(map);
        }
        return map;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.jsonb) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        JSONReader.Context context = jsonReader.context;
        Supplier<Map> objectSupplier = jsonReader.context.getObjectSupplier();
        Map object = objectSupplier != null && (this.mapType == null || this.mapType == JSONObject.class || "com.alibaba.fastjson.JSONObject".equals(this.mapType.getName())) ? objectSupplier.get() : (Map)this.createInstance(context.getFeatures() | features);
        jsonReader.read(object, features);
        jsonReader.nextIfComma();
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }

    static Function createObjectSupplier(Class objectClass) {
        Constructor constructor;
        try {
            constructor = objectClass.getConstructor(Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new JSONException("create JSONObject1 error");
        }
        return arg -> {
            try {
                return constructor.newInstance(arg);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("create JSONObject1 error");
            }
        };
    }
}

