/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.ByteOrder;
import javax.sql.DataSource;
import javax.sql.RowSet;
import sun.misc.Unsafe;

public class JDKUtils {
    public static final long FIELD_DECIMAL_INT_COMPACT_OFFSET;
    public static final boolean BIG_ENDIAN;
    public static final Unsafe UNSAFE;
    public static final long ARRAY_BYTE_BASE_OFFSET;

    public static boolean isSQLDataSourceOrRowSet(Class<?> type) {
        return DataSource.class.isAssignableFrom(type) || RowSet.class.isAssignableFrom(type);
    }

    public static char[] getCharArray(String str) {
        return str.toCharArray();
    }

    static {
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        Unsafe unsafe = null;
        try {
            unsafe = Unsafe.getUnsafe();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (unsafe == null) {
            try {
                Field theUnsafeField = null;
                for (Field field : Unsafe.class.getDeclaredFields()) {
                    String fieldName = field.getName();
                    if (!fieldName.equals("theUnsafe") && !fieldName.equals("THE_ONE")) continue;
                    theUnsafeField = field;
                    break;
                }
                if (theUnsafeField != null) {
                    theUnsafeField.setAccessible(true);
                    unsafe = (Unsafe)theUnsafeField.get(null);
                }
            }
            catch (Throwable theUnsafeField) {
                // empty catch block
            }
        }
        UNSAFE = unsafe;
        int arrayByteBaseOffset = -1;
        if (unsafe != null) {
            arrayByteBaseOffset = unsafe.arrayBaseOffset(byte[].class);
        }
        ARRAY_BYTE_BASE_OFFSET = arrayByteBaseOffset;
        long fieldOffset = -1L;
        try {
            Field field = BigDecimal.class.getDeclaredField("intCompact");
            fieldOffset = UNSAFE.objectFieldOffset(field);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FIELD_DECIMAL_INT_COMPACT_OFFSET = fieldOffset;
    }
}

