/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

abstract class JSONPathFilter
extends JSONPathSegment
implements JSONPathSegment.EvalSegment {
    private boolean and = true;

    JSONPathFilter() {
    }

    public boolean isAnd() {
        return this.and;
    }

    public JSONPathFilter setAnd(boolean and) {
        this.and = and;
        return this;
    }

    abstract boolean apply(JSONPath.Context var1, Object var2);

    static final class NameIntInSegment
    extends NameFilter {
        private final long[] values;
        private final boolean not;

        public NameIntInSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function expr, long[] values, boolean not) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, expr);
            this.values = values;
            this.not = not;
        }

        @Override
        protected boolean applyNull() {
            return this.not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                long fieldValueLong = ((Number)fieldValue).longValue();
                for (long value : this.values) {
                    if (value != fieldValueLong) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof Float || fieldValue instanceof Double) {
                double fieldValueDouble = ((Number)fieldValue).doubleValue();
                for (long value : this.values) {
                    if ((double)value != fieldValueDouble) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)fieldValue;
                long longValue = decimal.longValue();
                for (long value : this.values) {
                    if (value != longValue || decimal.compareTo(BigDecimal.valueOf(value)) != 0) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigInteger) {
                BigInteger bigiInt = (BigInteger)fieldValue;
                long longValue = bigiInt.longValue();
                for (long value : this.values) {
                    if (value != longValue || !bigiInt.equals(BigInteger.valueOf(value))) continue;
                    return !this.not;
                }
                return this.not;
            }
            return this.not;
        }
    }

    static final class NameLongContainsSegment
    extends NameFilter {
        private final long[] values;
        private final boolean not;

        public NameLongContainsSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, long[] values, boolean not) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, null);
            this.values = values;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Collection) {
                Collection collection = (Collection)fieldValue;
                boolean containsAll = true;
                for (long value : this.values) {
                    boolean containsItem = false;
                    for (Object item : collection) {
                        BigInteger bigiInt;
                        BigDecimal decimal;
                        long longValue;
                        long longItem;
                        if ((item instanceof Byte || item instanceof Short || item instanceof Integer || item instanceof Long) && (longItem = ((Number)item).longValue()) == value) {
                            containsItem = true;
                            break;
                        }
                        if (item instanceof Float && (float)value == ((Float)item).floatValue()) {
                            containsItem = true;
                            break;
                        }
                        if (item instanceof Double && (double)value == (Double)item) {
                            containsItem = true;
                            break;
                        }
                        if (item instanceof BigDecimal && value == (longValue = (decimal = (BigDecimal)item).longValue()) && decimal.compareTo(BigDecimal.valueOf(value)) == 0) {
                            containsItem = true;
                            break;
                        }
                        if (!(item instanceof BigInteger) || value != (longValue = (bigiInt = (BigInteger)item).longValue()) || !bigiInt.equals(BigInteger.valueOf(value))) continue;
                        containsItem = true;
                        break;
                    }
                    if (containsItem) continue;
                    containsAll = false;
                    break;
                }
                if (containsAll) {
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static final class NameIntBetweenSegment
    extends NameFilter {
        private final long begin;
        private final long end;
        private final boolean not;

        public NameIntBetweenSegment(String fieldName, long fieldNameNameHash, long begin, long end, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.begin = begin;
            this.end = end;
            this.not = not;
        }

        @Override
        protected boolean applyNull() {
            return this.not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                long fieldValueLong = ((Number)fieldValue).longValue();
                if (fieldValueLong >= this.begin && fieldValueLong <= this.end) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof Float || fieldValue instanceof Double) {
                double fieldValueDouble = ((Number)fieldValue).doubleValue();
                if (fieldValueDouble >= (double)this.begin && fieldValueDouble <= (double)this.end) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)fieldValue;
                int cmpBegin = decimal.compareTo(BigDecimal.valueOf(this.begin));
                int cmpEnd = decimal.compareTo(BigDecimal.valueOf(this.end));
                if (cmpBegin >= 0 && cmpEnd <= 0) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigInteger) {
                BigInteger bigInt = (BigInteger)fieldValue;
                int cmpBegin = bigInt.compareTo(BigInteger.valueOf(this.begin));
                int cmpEnd = bigInt.compareTo(BigInteger.valueOf(this.end));
                if (cmpBegin >= 0 && cmpEnd <= 0) {
                    return !this.not;
                }
                return this.not;
            }
            return this.not;
        }
    }

    static final class NameExistsFilter
    extends JSONPathFilter {
        final String name;
        final long nameHashCode;

        public NameExistsFilter(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray array = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!(item instanceof Map) || !((Map)item).containsKey(this.name)) continue;
                    array.add(item);
                }
                context.value = array;
                return;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                Object value = map.get(this.name);
                context.value = value != null ? object : null;
                return;
            }
            if (object instanceof JSONPath.Sequence) {
                List list = ((JSONPath.Sequence)object).values;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!(item instanceof Map) || !((Map)item).containsKey(this.name)) continue;
                    array.add(item);
                }
                context.value = context.next != null ? new JSONPath.Sequence(array) : array;
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        public String toString() {
            return '?' + this.name;
        }

        @Override
        public boolean apply(JSONPath.Context context, Object object) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NameMatchFilter
    extends NameFilter {
        final String startsWithValue;
        final String endsWithValue;
        final String[] containsValues;
        final int minLength;
        final boolean not;

        public NameMatchFilter(String fieldName, long fieldNameNameHash, String startsWithValue, String endsWithValue, String[] containsValues, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.startsWithValue = startsWithValue;
            this.endsWithValue = endsWithValue;
            this.containsValues = containsValues;
            this.not = not;
            int len = 0;
            if (startsWithValue != null) {
                len += startsWithValue.length();
            }
            if (endsWithValue != null) {
                len += endsWithValue.length();
            }
            if (containsValues != null) {
                for (String item : containsValues) {
                    len += item.length();
                }
            }
            this.minLength = len;
        }

        @Override
        boolean apply(Object arg) {
            if (!(arg instanceof String)) {
                return false;
            }
            String fieldValue = (String)arg;
            if (fieldValue.length() < this.minLength) {
                return this.not;
            }
            int start = 0;
            if (this.startsWithValue != null) {
                if (!fieldValue.startsWith(this.startsWithValue)) {
                    return this.not;
                }
                start += this.startsWithValue.length();
            }
            if (this.containsValues != null) {
                for (String containsValue : this.containsValues) {
                    int index = fieldValue.indexOf(containsValue, start);
                    if (index == -1) {
                        return this.not;
                    }
                    start = index + containsValue.length();
                }
            }
            if (this.endsWithValue != null && !fieldValue.endsWith(this.endsWithValue)) {
                return this.not;
            }
            return !this.not;
        }
    }

    static final class NameStringContainsSegment
    extends NameFilter {
        private final String[] values;
        private final boolean not;

        public NameStringContainsSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, String[] values, boolean not) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, null);
            this.values = values;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Collection) {
                Collection collection = (Collection)fieldValue;
                boolean containsAll = true;
                for (String value : this.values) {
                    if (collection.contains(value)) continue;
                    containsAll = false;
                    break;
                }
                if (containsAll) {
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static final class NameStringInSegment
    extends NameFilter {
        private final String[] values;
        private final boolean not;

        public NameStringInSegment(String fieldName, long fieldNameNameHash, String[] values, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.values = values;
            this.not = not;
        }

        @Override
        protected boolean applyNull() {
            return this.not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            for (String value : this.values) {
                if (value == fieldValue) {
                    return !this.not;
                }
                if (value == null || !value.equals(fieldValue)) continue;
                return !this.not;
            }
            return this.not;
        }
    }

    static final class NameObjectOpSegment
    extends NameFilter {
        final Operator operator;
        final JSONObject object;

        public NameObjectOpSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function function, Operator operator, JSONObject object) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, function);
            this.operator = operator;
            this.object = object;
        }

        @Override
        boolean apply(Object fieldValue) {
            if (Objects.requireNonNull(this.operator) == Operator.EQ) {
                return this.object.equals(fieldValue);
            }
            throw new JSONException("not support operator : " + (Object)((Object)this.operator));
        }
    }

    static final class NameArrayOpSegment
    extends NameFilter {
        final Operator operator;
        final JSONArray array;

        public NameArrayOpSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function function, Operator operator, JSONArray array) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, function);
            this.operator = operator;
            this.array = array;
        }

        @Override
        boolean apply(Object fieldValue) {
            if (Objects.requireNonNull(this.operator) == Operator.EQ) {
                return this.array.equals(fieldValue);
            }
            throw new JSONException("not support operator : " + (Object)((Object)this.operator));
        }
    }

    static final class NameStringOpSegment
    extends NameFilter {
        final Operator operator;
        final String value;

        public NameStringOpSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function expr, Operator operator, String value) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, expr);
            this.operator = operator;
            this.value = value;
        }

        @Override
        protected boolean applyNull() {
            return this.operator == Operator.NE;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (!(fieldValue instanceof String)) {
                return false;
            }
            int cmp = ((String)fieldValue).compareTo(this.value);
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static abstract class NameFilter
    extends JSONPathFilter {
        final String fieldName;
        final long fieldNameNameHash;
        final String[] fieldName2;
        final long[] fieldNameNameHash2;
        final Function function;

        public NameFilter(String fieldName, long fieldNameNameHash) {
            this.fieldName = fieldName;
            this.fieldNameNameHash = fieldNameNameHash;
            this.fieldName2 = null;
            this.fieldNameNameHash2 = null;
            this.function = null;
        }

        public NameFilter(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function function) {
            this.fieldName = fieldName;
            this.fieldNameNameHash = fieldNameNameHash;
            this.fieldName2 = fieldName2;
            this.fieldNameNameHash2 = fieldNameNameHash2;
            this.function = function;
        }

        abstract boolean apply(Object var1);

        @Override
        public final void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
            }
            this.eval(context);
        }

        @Override
        public boolean remove(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                for (int i = list.size() - 1; i >= 0; --i) {
                    Object item = list.get(i);
                    if (!this.apply(context, item)) continue;
                    list.remove(i);
                }
                return true;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public final void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                JSONArray array = new JSONArray(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!this.apply(context, item)) continue;
                    array.add(item);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] list = (Object[])object;
                JSONArray array = new JSONArray(list.length);
                for (Object item : list) {
                    if (!this.apply(context, item)) continue;
                    array.add(item);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            if (object instanceof JSONPath.Sequence) {
                JSONPath.Sequence sequence = (JSONPath.Sequence)object;
                JSONArray array = new JSONArray();
                for (Object value : sequence.values) {
                    if (value instanceof Collection) {
                        for (Object valueItem : (Collection)value) {
                            if (!this.apply(context, valueItem)) continue;
                            array.add(valueItem);
                        }
                        continue;
                    }
                    if (!this.apply(context, value)) continue;
                    array.add(value);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            if (this.apply(context, object)) {
                context.value = object;
                context.eval = true;
            }
        }

        protected boolean applyNull() {
            return false;
        }

        @Override
        public final boolean apply(JSONPath.Context context, Object object) {
            if (object == null) {
                return false;
            }
            JSONWriter.Context writerContext = context.path.getWriterContext();
            if (object instanceof Map) {
                Object fieldValue;
                Object object2 = fieldValue = this.fieldName == null ? object : ((Map)object).get(this.fieldName);
                if (fieldValue == null) {
                    return this.applyNull();
                }
                if (this.fieldName2 != null) {
                    for (int i = 0; i < this.fieldName2.length; ++i) {
                        String name = this.fieldName2[i];
                        if (fieldValue instanceof Map) {
                            fieldValue = ((Map)fieldValue).get(name);
                        } else {
                            ObjectWriter<?> objectWriter2 = writerContext.getObjectWriter(fieldValue.getClass());
                            if (objectWriter2 instanceof ObjectWriterAdapter) {
                                FieldWriter fieldWriter2 = objectWriter2.getFieldWriter(this.fieldNameNameHash2[i]);
                                if (fieldWriter2 == null) {
                                    return false;
                                }
                                fieldValue = fieldWriter2.getFieldValue(fieldValue);
                            } else {
                                return false;
                            }
                        }
                        if (fieldValue != null) continue;
                        return this instanceof NameIsNull;
                    }
                }
                if (this.function != null) {
                    fieldValue = this.function.apply(fieldValue);
                }
                return this.apply(fieldValue);
            }
            ObjectWriter<?> objectWriter = writerContext.getObjectWriter(object.getClass());
            if (objectWriter instanceof ObjectWriterAdapter) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.fieldNameNameHash);
                Object fieldValue = fieldWriter.getFieldValue(object);
                if (fieldValue == null) {
                    return false;
                }
                if (this.fieldName2 != null) {
                    for (int i = 0; i < this.fieldName2.length; ++i) {
                        String name = this.fieldName2[i];
                        if (fieldValue instanceof Map) {
                            fieldValue = ((Map)fieldValue).get(name);
                        } else {
                            ObjectWriter<?> objectWriter2 = writerContext.getObjectWriter(fieldValue.getClass());
                            if (objectWriter2 instanceof ObjectWriterAdapter) {
                                FieldWriter fieldWriter2 = objectWriter2.getFieldWriter(this.fieldNameNameHash2[i]);
                                if (fieldWriter2 == null) {
                                    return false;
                                }
                                fieldValue = fieldWriter2.getFieldValue(fieldValue);
                            } else {
                                return false;
                            }
                        }
                        if (fieldValue != null) continue;
                        return false;
                    }
                }
                if (this.function != null) {
                    fieldValue = this.function.apply(fieldValue);
                }
                return this.apply(fieldValue);
            }
            if (this.function != null) {
                Object fieldValue = this.function.apply(object);
                return this.apply(fieldValue);
            }
            if (this.fieldName == null) {
                return this.apply(object);
            }
            return false;
        }
    }

    static final class GroupFilter
    extends JSONPathSegment
    implements JSONPathSegment.EvalSegment {
        final List<JSONPathFilter> filters;

        public GroupFilter(List<JSONPathFilter> filters) {
            this.filters = filters;
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
            }
            this.eval(context);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void eval(JSONPath.Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            List<Object> orderedFilters = new ArrayList();
            if (this.filters != null) {
                orderedFilters = this.filters.stream().sorted(Comparator.comparing(JSONPathFilter::isAnd)).collect(Collectors.toList());
            }
            if (object instanceof List) {
                void var6_9;
                List list = (List)object;
                JSONArray array = new JSONArray(list.size());
                boolean bl = false;
                while (var6_9 < list.size()) {
                    Object item = list.get((int)var6_9);
                    boolean match = false;
                    for (JSONPathFilter jSONPathFilter : orderedFilters) {
                        boolean and;
                        match = and = jSONPathFilter.isAnd();
                        boolean result = jSONPathFilter.apply(context, item);
                        if (and) {
                            if (result) continue;
                            match = false;
                            break;
                        }
                        if (!result) continue;
                        match = true;
                        break;
                    }
                    if (match) {
                        array.add(item);
                    }
                    ++var6_9;
                }
                context.value = array;
                context.eval = true;
                return;
            }
            boolean match = false;
            for (JSONPathFilter jSONPathFilter : orderedFilters) {
                boolean and;
                match = and = jSONPathFilter.isAnd();
                boolean result = jSONPathFilter.apply(context, object);
                if (and) {
                    if (result) continue;
                    match = false;
                    break;
                }
                if (!result) continue;
                match = true;
                break;
            }
            if (match) {
                context.value = object;
            }
            context.eval = true;
        }
    }

    static final class EndsWithSegment
    extends NameFilter {
        final String prefix;

        public EndsWithSegment(String fieldName, long fieldNameNameHash, String prefix) {
            super(fieldName, fieldNameNameHash);
            this.prefix = prefix;
        }

        @Override
        boolean apply(Object fieldValue) {
            String propertyValue = fieldValue.toString();
            return propertyValue != null && propertyValue.endsWith(this.prefix);
        }
    }

    static final class StartsWithSegment
    extends NameFilter {
        final String prefix;

        public StartsWithSegment(String fieldName, long fieldNameNameHash, String prefix) {
            super(fieldName, fieldNameNameHash);
            this.prefix = prefix;
        }

        @Override
        boolean apply(Object fieldValue) {
            String propertyValue = fieldValue.toString();
            return propertyValue != null && propertyValue.startsWith(this.prefix);
        }
    }

    static final class NameRLikeSegment
    extends NameFilter {
        final Pattern pattern;
        final boolean not;

        public NameRLikeSegment(String fieldName, long fieldNameNameHash, Pattern pattern, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.pattern = pattern;
            this.not = not;
        }

        @Override
        boolean apply(Object fieldValue) {
            String strPropertyValue = fieldValue.toString();
            Matcher m = this.pattern.matcher(strPropertyValue);
            boolean match = m.matches();
            if (this.not) {
                match = !match;
            }
            return match;
        }
    }

    static final class NameDecimalOpSegment
    extends NameFilter {
        final Operator operator;
        final BigDecimal value;

        public NameDecimalOpSegment(String name, long nameHashCode, Operator operator, BigDecimal value) {
            super(name, nameHashCode);
            this.operator = operator;
            this.value = value;
        }

        @Override
        protected boolean applyNull() {
            return this.operator == Operator.NE;
        }

        @Override
        public boolean apply(Object fieldValue) {
            BigDecimal fieldValueDecimal;
            if (fieldValue == null) {
                return false;
            }
            if (fieldValue instanceof Boolean) {
                fieldValueDecimal = (Boolean)fieldValue != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                fieldValueDecimal = BigDecimal.valueOf(((Number)fieldValue).longValue());
            } else if (fieldValue instanceof BigDecimal) {
                fieldValueDecimal = (BigDecimal)fieldValue;
            } else if (fieldValue instanceof BigInteger) {
                fieldValueDecimal = new BigDecimal((BigInteger)fieldValue);
            } else {
                throw new UnsupportedOperationException();
            }
            int cmp = fieldValueDecimal.compareTo(this.value);
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static final class NameIntOpSegment
    extends NameFilter {
        final Operator operator;
        final long value;

        public NameIntOpSegment(String name, long nameHashCode, String[] fieldName2, long[] fieldNameNameHash2, Function expr, Operator operator, long value) {
            super(name, nameHashCode, fieldName2, fieldNameNameHash2, expr);
            this.operator = operator;
            this.value = value;
        }

        @Override
        protected boolean applyNull() {
            return this.operator == Operator.NE;
        }

        @Override
        public boolean apply(Object fieldValue) {
            int cmp;
            boolean objInt;
            boolean bl = objInt = fieldValue instanceof Boolean || fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long;
            if (objInt) {
                long fieldValueInt = fieldValue instanceof Boolean ? ((Boolean)fieldValue != false ? 1L : 0L) : ((Number)fieldValue).longValue();
                switch (this.operator) {
                    case LT: {
                        return fieldValueInt < this.value;
                    }
                    case LE: {
                        return fieldValueInt <= this.value;
                    }
                    case EQ: {
                        return fieldValueInt == this.value;
                    }
                    case NE: {
                        return fieldValueInt != this.value;
                    }
                    case GT: {
                        return fieldValueInt > this.value;
                    }
                    case GE: {
                        return fieldValueInt >= this.value;
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (fieldValue instanceof BigDecimal) {
                cmp = ((BigDecimal)fieldValue).compareTo(BigDecimal.valueOf(this.value));
            } else if (fieldValue instanceof BigInteger) {
                cmp = ((BigInteger)fieldValue).compareTo(BigInteger.valueOf(this.value));
            } else if (fieldValue instanceof Float) {
                cmp = ((Float)fieldValue).compareTo(Float.valueOf(this.value));
            } else if (fieldValue instanceof Double) {
                cmp = ((Double)fieldValue).compareTo(Double.valueOf(this.value));
            } else if (fieldValue instanceof String) {
                String fieldValueStr = (String)fieldValue;
                if (IOUtils.isNumber(fieldValueStr)) {
                    try {
                        cmp = Long.compare(Long.parseLong(fieldValueStr), this.value);
                    }
                    catch (Exception ignored) {
                        cmp = fieldValueStr.compareTo(Long.toString(this.value));
                    }
                } else {
                    cmp = fieldValueStr.compareTo(Long.toString(this.value));
                }
            } else {
                throw new UnsupportedOperationException();
            }
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(JSONPath.Context context, Object value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!this.apply(context, item)) continue;
                    list.set(i, value);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation ");
        }

        @Override
        public void setCallback(JSONPath.Context context, BiFunction callback) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    Object value;
                    Object item = list.get(i);
                    if (!this.apply(context, item) || (value = callback.apply(list, item)) == item) continue;
                    list.set(i, value);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation ");
        }

        public String toString() {
            return "[?(" + (this.fieldName2 == null ? "@" : this.fieldName2) + '.' + this.fieldName + ' ' + (Object)((Object)this.operator) + ' ' + this.value + ")]";
        }
    }

    static final class NameIsNull
    extends NameFilter {
        public NameIsNull(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function function) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, function);
        }

        @Override
        protected boolean applyNull() {
            return true;
        }

        @Override
        boolean apply(Object fieldValue) {
            if (this.function != null) {
                fieldValue = this.function.apply(fieldValue);
            }
            return fieldValue == null;
        }
    }

    static enum Operator {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE,
        LIKE,
        NOT_LIKE,
        RLIKE,
        NOT_RLIKE,
        IN,
        NOT_IN,
        BETWEEN,
        NOT_BETWEEN,
        AND,
        OR,
        REG_MATCH,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        NOT_CONTAINS;


        public String toString() {
            switch (this) {
                case EQ: {
                    return "==";
                }
                case NE: {
                    return "!=";
                }
                case GT: {
                    return ">";
                }
                case GE: {
                    return ">=";
                }
                case LT: {
                    return "<";
                }
                case LE: {
                    return "<=";
                }
                case LIKE: {
                    return "like";
                }
                case NOT_LIKE: {
                    return "not like";
                }
                case RLIKE: {
                    return "rlike";
                }
                case NOT_RLIKE: {
                    return "not rlike";
                }
                case BETWEEN: {
                    return "between";
                }
                case NOT_BETWEEN: {
                    return "not between";
                }
                case AND: {
                    return "and";
                }
                case OR: {
                    return "or";
                }
                case STARTS_WITH: {
                    return "starts with";
                }
                case ENDS_WITH: {
                    return "ends with";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOT_CONTAINS: {
                    return "not contains";
                }
            }
            return this.name();
        }
    }
}

