/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalTime;

public class IOUtils {
    static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    public static final int[] DIGITS_K = new int[1000];
    private static final byte[] MIN_INT_BYTES = "-2147483648".getBytes();
    private static final char[] MIN_INT_CHARS = "-2147483648".toCharArray();
    private static final byte[] MIN_LONG = "-9223372036854775808".getBytes();

    public static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static void getChars(int i, int index, byte[] buf) {
        int r;
        int q;
        int p = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--p] = DigitOnes[r];
            buf[--p] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--p] = DIGITS[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--p] = sign;
        }
    }

    public static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int p = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--p] = (char)DigitOnes[r];
            buf[--p] = (char)DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--p] = (char)DIGITS[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--p] = sign;
        }
    }

    public static void getChars(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = DIGITS[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = (char)DigitOnes[r];
            buf[--charPos] = (char)DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = (char)DigitOnes[r];
            buf[--charPos] = (char)DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = (char)DIGITS[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static int writeDecimal(byte[] buf, int off, long unscaledVal, int scale) {
        if (unscaledVal < 0L) {
            buf[off++] = 45;
            unscaledVal = -unscaledVal;
        }
        if (scale == 0) {
            return IOUtils.writeInt64(buf, off, unscaledVal);
        }
        int insertionPoint = IOUtils.stringSize(unscaledVal) - scale;
        if (insertionPoint == 0) {
            buf[off] = 48;
            buf[off + 1] = 46;
            off += 2;
        } else if (insertionPoint < 0) {
            buf[off] = 48;
            buf[off + 1] = 46;
            off += 2;
            for (int i = 0; i < -insertionPoint; ++i) {
                buf[off++] = 48;
            }
        }
        off = IOUtils.writeInt64(buf, off, unscaledVal);
        if (insertionPoint > 0) {
            int insertPointOff = off - scale;
            System.arraycopy(buf, insertPointOff, buf, insertPointOff + 1, scale);
            buf[insertPointOff] = 46;
            ++off;
        }
        return off;
    }

    public static int writeDecimal(char[] buf, int off, long unscaledVal, int scale) {
        if (unscaledVal < 0L) {
            buf[off++] = 45;
            unscaledVal = -unscaledVal;
        }
        if (scale == 0) {
            return IOUtils.writeInt64(buf, off, unscaledVal);
        }
        int insertionPoint = IOUtils.stringSize(unscaledVal) - scale;
        if (insertionPoint == 0) {
            buf[off] = 48;
            buf[off + 1] = 46;
            off += 2;
        } else if (insertionPoint < 0) {
            buf[off] = 48;
            buf[off + 1] = 46;
            off += 2;
            for (int i = 0; i < -insertionPoint; ++i) {
                buf[off++] = 48;
            }
        }
        off = IOUtils.writeInt64(buf, off, unscaledVal);
        if (insertionPoint > 0) {
            int insertPointOff = off - scale;
            System.arraycopy(buf, insertPointOff, buf, insertPointOff + 1, scale);
            buf[insertPointOff] = 46;
            ++off;
        }
        return off;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeUTF8(byte[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        while (offset < sl) {
            byte b0 = src[offset];
            byte b1 = src[offset + 1];
            offset += 2;
            if (b1 == 0 && b0 >= 0) {
                dst[dp++] = b0;
                continue;
            }
            char c = (char)(b0 & 0xFF | (b1 & 0xFF) << 8);
            if (c < '\u0800') {
                dst[dp] = (byte)(0xC0 | c >> 6);
                dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                dp += 2;
                continue;
            }
            if (c >= '\ud800' && c < '\ue000') {
                int uc;
                int ip = offset - 1;
                if (c >= '\udc00') return -1;
                if (sl - ip < 2) {
                    uc = -1;
                } else {
                    b0 = src[ip + 1];
                    b1 = src[ip + 2];
                    char d = (char)(b0 & 0xFF | (b1 & 0xFF) << 8);
                    if (d < '\udc00' || d >= '\ue000') return -1;
                    offset += 2;
                    uc = (c << 10) + d + -56613888;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp] = (byte)(0xF0 | uc >> 18);
                dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
                dp += 4;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
        return dp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int encodeUTF8(char[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        int dlASCII = dp + Math.min(len, dst.length);
        while (dp < dlASCII && src[offset] < '\u0080') {
            dst[dp++] = (byte)src[offset++];
        }
        while (true) {
            char c;
            block11: {
                int uc;
                block10: {
                    block12: {
                        if (offset >= sl) {
                            return dp;
                        }
                        if ((c = src[offset++]) < '\u0080') {
                            dst[dp++] = (byte)c;
                            continue;
                        }
                        if (c < '\u0800') {
                            dst[dp] = (byte)(0xC0 | c >> 6);
                            dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                            dp += 2;
                            continue;
                        }
                        if (c < '\ud800' || c >= '\ue000') break block11;
                        int ip = offset - 1;
                        if (c >= '\udc00') break block12;
                        if (sl - ip < 2) {
                            uc = -1;
                            break block10;
                        } else {
                            char d = src[ip + 1];
                            if (d >= '\udc00' && d < '\ue000') {
                                uc = (c << 10) + d + -56613888;
                                break block10;
                            } else {
                                dst[dp++] = 63;
                                continue;
                            }
                        }
                    }
                    dst[dp++] = 63;
                    continue;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp] = (byte)(0xF0 | uc >> 18);
                dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
                dp += 4;
                ++offset;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char[] chars, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = chars[i];
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(byte[] chars, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = (char)chars[i];
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int decodeUTF8(byte[] src, int off, int len, byte[] dst) {
        int sl = off + len;
        int dp = 0;
        while (off < sl) {
            byte b1;
            byte b0;
            if ((b0 = src[off++]) >= 0) {
                dst[dp] = b0;
                dst[dp + 1] = 0;
                dp += 2;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b1 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 6 ^ b1 ^ 0xF80);
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                dst[dp] = b0;
                dst[dp + 1] = 0;
                dp += 2;
                break;
            }
            if (b0 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b1 = src[off];
                    byte b2 = src[off + 1];
                    off += 2;
                    if (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            if (b0 >> 3 == -2) {
                if (off + 2 < sl) {
                    byte b2 = src[off];
                    byte b3 = src[off + 1];
                    byte b4 = src[off + 2];
                    off += 3;
                    int uc = b0 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    char c = (char)((uc >>> 10) + 55232);
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    c = (char)((uc & 0x3FF) + 56320);
                    dst[dp += 2] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static int decodeUTF8(byte[] src, int off, int len, char[] dst) {
        int sl = off + len;
        int dp = 0;
        int dlASCII = Math.min(len, dst.length);
        while (dp < dlASCII && src[off] >= 0) {
            dst[dp++] = (char)src[off++];
        }
        while (off < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = src[off++]) >= 0) {
                dst[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b2 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    dst[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b2 = src[off];
                    b3 = src[off + 1];
                    off += 2;
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (off + 2 < sl) {
                    b2 = src[off];
                    b3 = src[off + 1];
                    byte b4 = src[off + 2];
                    off += 3;
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    dst[dp] = (char)((uc >>> 10) + 55232);
                    dst[dp + 1] = (char)((uc & 0x3FF) + 56320);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static long lines(File file) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            long l = IOUtils.lines(in);
            return l;
        }
    }

    public static long lines(InputStream in) throws Exception {
        int len;
        long lines = 0L;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf, 0, buf.length)) != -1) {
            for (int i = 0; i < len; ++i) {
                byte b = buf[i];
                if (b != 10) continue;
                ++lines;
            }
        }
        return lines;
    }

    public static int writeLocalDate(byte[] bytes, int off, int year, int month, int dayOfMonth) {
        if (year >= 1000 && year < 10000) {
            int y0;
            int yyy;
            if (year < 3000) {
                if (year < 2000) {
                    yyy = year - 1000;
                    y0 = 49;
                } else {
                    yyy = year - 2000;
                    y0 = 50;
                }
            } else {
                int q = year / 1000;
                yyy = year - q * 1000;
                y0 = (byte)(q + 48);
            }
            bytes[off] = y0;
            int v = DIGITS_K[yyy];
            bytes[off + 1] = (byte)(v >> 16);
            bytes[off + 2] = (byte)(v >> 8);
            bytes[off + 3] = (byte)v;
            off += 4;
        } else {
            if (year > 9999) {
                bytes[off++] = 43;
            }
            off = IOUtils.writeInt32(bytes, off, year);
        }
        bytes[off] = 45;
        int v = DIGITS_K[month];
        bytes[off + 1] = (byte)(v >> 8);
        bytes[off + 2] = (byte)v;
        bytes[off + 3] = 45;
        v = DIGITS_K[dayOfMonth];
        bytes[off + 4] = (byte)(v >> 8);
        bytes[off + 5] = (byte)v;
        return off += 6;
    }

    public static int writeLocalDate(char[] chars, int off, int year, int month, int dayOfMonth) {
        if (year >= 1000 && year < 10000) {
            int y0;
            int yyy;
            if (year < 3000) {
                if (year < 2000) {
                    yyy = year - 1000;
                    y0 = 49;
                } else {
                    yyy = year - 2000;
                    y0 = 50;
                }
            } else {
                int q = year / 1000;
                yyy = year - q * 1000;
                y0 = (char)(q + 48);
            }
            chars[off] = y0;
            int v = DIGITS_K[yyy];
            chars[off + 1] = (char)(v >> 16);
            chars[off + 2] = (char)(v >> 8);
            chars[off + 3] = (char)v;
            off += 4;
        } else {
            if (year > 9999) {
                chars[off++] = 43;
            }
            off = IOUtils.writeInt32(chars, off, year);
        }
        chars[off] = 45;
        int v = DIGITS_K[month];
        chars[off + 1] = (char)(v >> 8);
        chars[off + 2] = (char)v;
        chars[off + 3] = 45;
        v = DIGITS_K[dayOfMonth];
        chars[off + 4] = (char)(v >> 8);
        chars[off + 5] = (char)v;
        return off += 6;
    }

    public static int writeLocalTime(byte[] bytes, int off, LocalTime time) {
        int v = DIGITS_K[time.getHour()];
        bytes[off] = (byte)(v >> 8);
        bytes[off + 1] = (byte)v;
        bytes[off + 2] = 58;
        v = DIGITS_K[time.getMinute()];
        bytes[off + 3] = (byte)(v >> 8);
        bytes[off + 4] = (byte)v;
        bytes[off + 5] = 58;
        v = DIGITS_K[time.getSecond()];
        bytes[off + 6] = (byte)(v >> 8);
        bytes[off + 7] = (byte)v;
        off += 8;
        int nano = time.getNano();
        if (nano != 0) {
            int div = nano / 1000;
            int div2 = div / 1000;
            int rem1 = nano - div * 1000;
            bytes[off] = 46;
            v = DIGITS_K[div2];
            bytes[off + 1] = (byte)(v >> 16);
            bytes[off + 2] = (byte)(v >> 8);
            bytes[off + 3] = (byte)v;
            off += 4;
            if (rem1 == 0) {
                int rem2 = div - div2 * 1000;
                if (rem2 == 0) {
                    return off;
                }
                v = DIGITS_K[rem2];
            } else {
                v = DIGITS_K[div - div2 * 1000];
            }
            bytes[off] = (byte)(v >> 16);
            bytes[off + 1] = (byte)(v >> 8);
            bytes[off + 2] = (byte)v;
            off += 3;
            if (rem1 == 0) {
                return off;
            }
            v = DIGITS_K[rem1];
            bytes[off] = (byte)(v >> 16);
            bytes[off + 1] = (byte)(v >> 8);
            bytes[off + 2] = (byte)v;
            off += 3;
        }
        return off;
    }

    public static int writeLocalTime(char[] bytes, int off, LocalTime time) {
        int v = DIGITS_K[time.getHour()];
        bytes[off] = (char)(v >> 8);
        bytes[off + 1] = (char)v;
        bytes[off + 2] = 58;
        v = DIGITS_K[time.getMinute()];
        bytes[off + 3] = (char)(v >> 8);
        bytes[off + 4] = (char)v;
        bytes[off + 5] = 58;
        v = DIGITS_K[time.getSecond()];
        bytes[off + 6] = (char)(v >> 8);
        bytes[off + 7] = (char)v;
        off += 8;
        int nano = time.getNano();
        if (nano != 0) {
            int div = nano / 1000;
            int div2 = div / 1000;
            int rem1 = nano - div * 1000;
            bytes[off] = 46;
            v = DIGITS_K[div2];
            bytes[off + 1] = (char)(v >> 16);
            bytes[off + 2] = (char)(v >> 8);
            bytes[off + 3] = (char)v;
            off += 4;
            if (rem1 == 0) {
                int rem2 = div - div2 * 1000;
                if (rem2 == 0) {
                    return off;
                }
                v = DIGITS_K[rem2];
            } else {
                v = DIGITS_K[div - div2 * 1000];
            }
            bytes[off] = (char)(v >> 16);
            bytes[off + 1] = (char)(v >> 8);
            bytes[off + 2] = (char)v;
            off += 3;
            if (rem1 == 0) {
                return off;
            }
            v = DIGITS_K[rem1];
            bytes[off] = (char)(v >> 16);
            bytes[off + 1] = (char)(v >> 8);
            bytes[off + 2] = (char)v;
            off += 3;
        }
        return off;
    }

    public static int writeInt64(byte[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG, 0, buf, pos, MIN_LONG.length);
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000L) {
            int v = DIGITS_K[(int)i];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v >> 16);
                buf[pos + 1] = (byte)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 8);
            }
            buf[pos++] = (byte)v;
            return pos;
        }
        long q1 = i / 1000L;
        int r1 = (int)(i - q1 * 1000L);
        int v1 = DIGITS_K[r1];
        if (i < 1000000L) {
            int v2 = DIGITS_K[(int)q1];
            int start = v2 >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v2 >> 16);
                buf[pos + 1] = (byte)(v2 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v2 >> 8);
            }
            buf[pos] = (byte)v2;
            buf[pos + 1] = (byte)(v1 >> 16);
            buf[pos + 2] = (byte)(v1 >> 8);
            buf[pos + 3] = (byte)v1;
            return pos + 4;
        }
        long q2 = q1 / 1000L;
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        int v2 = DIGITS_K[r2];
        if (q3 == 0L) {
            int v3 = DIGITS_K[(int)q2];
            int start = v3 >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v3 >> 16);
                buf[pos + 1] = (byte)(v3 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v3 >> 8);
            }
            buf[pos] = (byte)v3;
            buf[pos + 1] = (byte)(v2 >> 16);
            buf[pos + 2] = (byte)(v2 >> 8);
            buf[pos + 3] = (byte)v2;
            buf[pos + 4] = (byte)(v1 >> 16);
            buf[pos + 5] = (byte)(v1 >> 8);
            buf[pos + 6] = (byte)v1;
            return pos + 7;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        int v3 = DIGITS_K[r3];
        if (q4 == 0) {
            int v4 = DIGITS_K[(int)q3];
            int start = v4 >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v4 >> 16);
                buf[pos + 1] = (byte)(v4 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v4 >> 8);
            }
            buf[pos] = (byte)v4;
            buf[pos + 1] = (byte)(v3 >> 16);
            buf[pos + 2] = (byte)(v3 >> 8);
            buf[pos + 3] = (byte)v3;
            buf[pos + 4] = (byte)(v2 >> 16);
            buf[pos + 5] = (byte)(v2 >> 8);
            buf[pos + 6] = (byte)v2;
            buf[pos + 7] = (byte)(v1 >> 16);
            buf[pos + 8] = (byte)(v1 >> 8);
            buf[pos + 9] = (byte)v1;
            return pos + 10;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        int v4 = DIGITS_K[r4];
        if (q5 == 0) {
            int v5 = DIGITS_K[q4];
            int start = v5 >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v5 >> 16);
                buf[pos + 1] = (byte)(v5 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v5 >> 8);
            }
            buf[pos] = (byte)v5;
            buf[pos + 1] = (byte)(v4 >> 16);
            buf[pos + 2] = (byte)(v4 >> 8);
            buf[pos + 3] = (byte)v4;
            buf[pos + 4] = (byte)(v3 >> 16);
            buf[pos + 5] = (byte)(v3 >> 8);
            buf[pos + 6] = (byte)v3;
            buf[pos + 7] = (byte)(v2 >> 16);
            buf[pos + 8] = (byte)(v2 >> 8);
            buf[pos + 9] = (byte)v2;
            buf[pos + 10] = (byte)(v1 >> 16);
            buf[pos + 11] = (byte)(v1 >> 8);
            buf[pos + 12] = (byte)v1;
            return pos + 13;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v5 = DIGITS_K[r5];
        if (q6 == 0) {
            int v = DIGITS_K[q5];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v >> 16);
                buf[pos + 1] = (byte)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 8);
            }
            buf[pos++] = (byte)v;
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos] = (byte)(q6 + 48);
            int v = DIGITS_K[r6];
            buf[pos + 1] = (byte)(v >> 16);
            buf[pos + 2] = (byte)(v >> 8);
            buf[pos + 3] = (byte)v;
            pos += 4;
        }
        buf[pos] = (byte)(v5 >> 16);
        buf[pos + 1] = (byte)(v5 >> 8);
        buf[pos + 2] = (byte)v5;
        buf[pos + 3] = (byte)(v4 >> 16);
        buf[pos + 4] = (byte)(v4 >> 8);
        buf[pos + 5] = (byte)v4;
        buf[pos + 6] = (byte)(v3 >> 16);
        buf[pos + 7] = (byte)(v3 >> 8);
        buf[pos + 8] = (byte)v3;
        buf[pos + 9] = (byte)(v2 >> 16);
        buf[pos + 10] = (byte)(v2 >> 8);
        buf[pos + 11] = (byte)v2;
        buf[pos + 12] = (byte)(v1 >> 16);
        buf[pos + 13] = (byte)(v1 >> 8);
        buf[pos + 14] = (byte)v1;
        return pos + 15;
    }

    public static int writeInt64(char[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                for (int x = 0; x < MIN_LONG.length; ++x) {
                    buf[pos + x] = (char)MIN_LONG[x];
                }
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000L) {
            int v = DIGITS_K[(int)i];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (char)(v >> 16);
                buf[pos + 1] = (char)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 8);
            }
            buf[pos++] = (char)v;
            return pos;
        }
        long q1 = i / 1000L;
        int r1 = (int)(i - q1 * 1000L);
        int v1 = DIGITS_K[r1];
        if (i < 1000000L) {
            int v2 = DIGITS_K[(int)q1];
            int start = v2 >> 24;
            if (start == 0) {
                buf[pos] = (char)(v2 >> 16);
                buf[pos + 1] = (char)(v2 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v2 >> 8);
            }
            buf[pos] = (char)v2;
            buf[pos + 1] = (char)(v1 >> 16);
            buf[pos + 2] = (char)(v1 >> 8);
            buf[pos + 3] = (char)v1;
            return pos + 4;
        }
        long q2 = q1 / 1000L;
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        int v2 = DIGITS_K[r2];
        if (q3 == 0L) {
            int v3 = DIGITS_K[(int)q2];
            int start = v3 >> 24;
            if (start == 0) {
                buf[pos] = (char)(v3 >> 16);
                buf[pos + 1] = (char)(v3 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v3 >> 8);
            }
            buf[pos] = (char)v3;
            buf[pos + 1] = (char)(v2 >> 16);
            buf[pos + 2] = (char)(v2 >> 8);
            buf[pos + 3] = (char)v2;
            buf[pos + 4] = (char)(v1 >> 16);
            buf[pos + 5] = (char)(v1 >> 8);
            buf[pos + 6] = (char)v1;
            return pos + 7;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        int v3 = DIGITS_K[r3];
        if (q4 == 0) {
            int v4 = DIGITS_K[(int)q3];
            int start = v4 >> 24;
            if (start == 0) {
                buf[pos] = (char)(v4 >> 16);
                buf[pos + 1] = (char)(v4 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v4 >> 8);
            }
            buf[pos] = (char)v4;
            buf[pos + 1] = (char)(v3 >> 16);
            buf[pos + 2] = (char)(v3 >> 8);
            buf[pos + 3] = (char)v3;
            buf[pos + 4] = (char)(v2 >> 16);
            buf[pos + 5] = (char)(v2 >> 8);
            buf[pos + 6] = (char)v2;
            buf[pos + 7] = (char)(v1 >> 16);
            buf[pos + 8] = (char)(v1 >> 8);
            buf[pos + 9] = (char)v1;
            return pos + 10;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        int v4 = DIGITS_K[r4];
        if (q5 == 0) {
            int v5 = DIGITS_K[q4];
            int start = v5 >> 24;
            if (start == 0) {
                buf[pos] = (char)(v5 >> 16);
                buf[pos + 1] = (char)(v5 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v5 >> 8);
            }
            buf[pos] = (char)v5;
            buf[pos + 1] = (char)(v4 >> 16);
            buf[pos + 2] = (char)(v4 >> 8);
            buf[pos + 3] = (char)v4;
            buf[pos + 4] = (char)(v3 >> 16);
            buf[pos + 5] = (char)(v3 >> 8);
            buf[pos + 6] = (char)v3;
            buf[pos + 7] = (char)(v2 >> 16);
            buf[pos + 8] = (char)(v2 >> 8);
            buf[pos + 9] = (char)v2;
            buf[pos + 10] = (char)(v1 >> 16);
            buf[pos + 11] = (char)(v1 >> 8);
            buf[pos + 12] = (char)v1;
            return pos + 13;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v5 = DIGITS_K[r5];
        if (q6 == 0) {
            int v = DIGITS_K[q5];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (char)(v >> 16);
                buf[pos + 1] = (char)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 8);
            }
            buf[pos++] = (char)v;
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos] = (char)(q6 + 48);
            int v = DIGITS_K[r6];
            buf[pos + 1] = (char)(v >> 16);
            buf[pos + 2] = (char)(v >> 8);
            buf[pos + 3] = (char)v;
            pos += 4;
        }
        buf[pos] = (char)(v5 >> 16);
        buf[pos + 1] = (char)(v5 >> 8);
        buf[pos + 2] = (char)v5;
        buf[pos + 3] = (char)(v4 >> 16);
        buf[pos + 4] = (char)(v4 >> 8);
        buf[pos + 5] = (char)v4;
        buf[pos + 6] = (char)(v3 >> 16);
        buf[pos + 7] = (char)(v3 >> 8);
        buf[pos + 8] = (char)v3;
        buf[pos + 9] = (char)(v2 >> 16);
        buf[pos + 10] = (char)(v2 >> 8);
        buf[pos + 11] = (char)v2;
        buf[pos + 12] = (char)(v1 >> 16);
        buf[pos + 13] = (char)(v1 >> 8);
        buf[pos + 14] = (char)v1;
        return pos + 15;
    }

    public static int writeInt32(byte[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_BYTES, 0, buf, pos, MIN_INT_BYTES.length);
                return pos + MIN_INT_BYTES.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000) {
            int v = DIGITS_K[i];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v >> 16);
                buf[pos + 1] = (byte)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 8);
            }
            buf[pos] = (byte)v;
            return pos + 1;
        }
        int q1 = i / 1000;
        int r1 = i - q1 * 1000;
        int v1 = DIGITS_K[r1];
        if (i < 1000000) {
            int v2 = DIGITS_K[q1];
            int start = v2 >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v2 >> 16);
                buf[pos + 1] = (byte)(v2 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v2 >> 8);
            }
            buf[pos] = (byte)v2;
            buf[pos + 1] = (byte)(v1 >> 16);
            buf[pos + 2] = (byte)(v1 >> 8);
            buf[pos + 3] = (byte)v1;
            return pos + 4;
        }
        int q2 = q1 / 1000;
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        int v2 = DIGITS_K[r2];
        if (q3 == 0) {
            int v = DIGITS_K[q2];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (byte)(v >> 16);
                buf[pos + 1] = (byte)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 8);
            }
            buf[pos++] = (byte)v;
        } else {
            int r3 = q2 - q3 * 1000;
            buf[pos] = (byte)(q3 + 48);
            int v = DIGITS_K[r3];
            buf[pos + 1] = (byte)(v >> 16);
            buf[pos + 2] = (byte)(v >> 8);
            buf[pos + 3] = (byte)v;
            pos += 4;
        }
        buf[pos] = (byte)(v2 >> 16);
        buf[pos + 1] = (byte)(v2 >> 8);
        buf[pos + 2] = (byte)v2;
        buf[pos + 3] = (byte)(v1 >> 16);
        buf[pos + 4] = (byte)(v1 >> 8);
        buf[pos + 5] = (byte)v1;
        return pos + 6;
    }

    public static int writeInt32(char[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_CHARS, 0, buf, pos, MIN_INT_CHARS.length);
                return pos + MIN_INT_CHARS.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000) {
            int v = DIGITS_K[i];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (char)(v >> 16);
                buf[pos + 1] = (char)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 8);
            }
            buf[pos] = (char)v;
            return pos + 1;
        }
        int q1 = i / 1000;
        int r1 = i - q1 * 1000;
        int v1 = DIGITS_K[r1];
        if (i < 1000000) {
            int v2 = DIGITS_K[q1];
            int start = v2 >> 24;
            if (start == 0) {
                buf[pos] = (char)(v2 >> 16);
                buf[pos + 1] = (char)(v2 >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v2 >> 8);
            }
            buf[pos] = (char)v2;
            buf[pos + 1] = (char)(v1 >> 16);
            buf[pos + 2] = (char)(v1 >> 8);
            buf[pos + 3] = (char)v1;
            return pos + 4;
        }
        int q2 = q1 / 1000;
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        int v2 = DIGITS_K[r2];
        if (q3 == 0) {
            int v = DIGITS_K[q2];
            int start = v >> 24;
            if (start == 0) {
                buf[pos] = (char)(v >> 16);
                buf[pos + 1] = (char)(v >> 8);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 8);
            }
            buf[pos++] = (char)v;
        } else {
            int r3 = q2 - q3 * 1000;
            buf[pos] = (char)(q3 + 48);
            int v = DIGITS_K[r3];
            buf[pos + 1] = (char)(v >> 16);
            buf[pos + 2] = (char)(v >> 8);
            buf[pos + 3] = (char)v;
            pos += 4;
        }
        buf[pos] = (char)(v2 >> 16);
        buf[pos + 1] = (char)(v2 >> 8);
        buf[pos + 2] = (char)v2;
        buf[pos + 3] = (char)(v1 >> 16);
        buf[pos + 4] = (char)(v1 >> 8);
        buf[pos + 5] = (char)v1;
        return pos + 6;
    }

    static {
        for (int i = 0; i < DIGITS_K.length; ++i) {
            IOUtils.DIGITS_K[i] = (i < 10 ? 0x2000000 : (i < 100 ? 0x1000000 : 0)) + (i / 100 + 48 << 16) + (i / 10 % 10 + 48 << 8) + i % 10 + 48;
        }
    }
}

