/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public final class ObjectReaderImplListInt64
implements ObjectReader {
    final Class listType;
    final Class instanceType;
    final long instanceTypeHash;

    public ObjectReaderImplListInt64(Class listType, Class instanceType) {
        this.listType = listType;
        this.instanceType = instanceType;
        this.instanceTypeHash = Fnv.hashCode64(TypeUtils.getTypeName(instanceType));
    }

    public Object createInstance(long features) {
        if (this.instanceType == ArrayList.class) {
            return new ArrayList();
        }
        if (this.instanceType == LinkedList.class) {
            return new LinkedList();
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create list error, type " + this.instanceType);
        }
    }

    public Object createInstance(Collection collection) {
        Collection list = (Collection)this.createInstance(0L);
        for (Object item : collection) {
            list.add(TypeUtils.toLong(item));
        }
        return list;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Function buildFunction;
        if (jsonReader.nextIfNull()) {
            return null;
        }
        Class listType = this.listType;
        ObjectReader objectReader = jsonReader.checkAutoType(listType, this.instanceTypeHash, features);
        if (objectReader != null) {
            listType = objectReader.getObjectClass();
        }
        Collection<Object> list = listType == ArrayList.class ? new ArrayList() : (listType == JSONArray.class ? new JSONArray() : (listType != null && listType != this.listType ? (Collection)objectReader.createInstance(features) : (Collection)this.createInstance(jsonReader.context.getFeatures() | features)));
        int entryCnt = jsonReader.startArray();
        for (int i = 0; i < entryCnt; ++i) {
            list.add(jsonReader.readInt64());
        }
        if (objectReader != null && (buildFunction = objectReader.getBuildFunction()) != null) {
            list = (Collection)buildFunction.apply(list);
        }
        return list;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.jsonb) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.isString()) {
            Collection list = (Collection)this.createInstance(jsonReader.context.getFeatures() | features);
            String str = jsonReader.readString();
            if (str.indexOf(44) != -1) {
                String[] items;
                for (String item : items = str.split(",")) {
                    list.add(Long.parseLong(item));
                }
            } else {
                list.add(Long.parseLong(str));
            }
            jsonReader.nextIfComma();
            return list;
        }
        boolean set = jsonReader.nextIfSet();
        if (jsonReader.current() != '[') {
            throw new JSONException(jsonReader.info("format error"));
        }
        jsonReader.next();
        Collection list = set && this.instanceType == Collection.class ? new LinkedHashSet() : (Collection)this.createInstance(jsonReader.context.getFeatures() | features);
        while (true) {
            if (jsonReader.isEnd()) {
                throw new JSONException(jsonReader.info("illegal input error"));
            }
            if (jsonReader.nextIfArrayEnd()) break;
            list.add(jsonReader.readInt64());
        }
        jsonReader.nextIfComma();
        return list;
    }
}

