/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.time;

import com.alibaba.fastjson2.time.LocalDateTime;
import java.util.Arrays;

public final class LocalTime {
    private static final LocalTime[] HOURS = new LocalTime[24];
    public static final LocalTime MIN;
    public static final LocalTime MIDNIGHT;
    public final byte hour;
    public final byte minute;
    public final byte second;
    public final int nano;

    private LocalTime(int hour, int minute, int second, int nano) {
        this.hour = (byte)hour;
        this.minute = (byte)minute;
        this.second = (byte)second;
        this.nano = nano;
    }

    public static LocalTime of(int hour, int minute, int second) {
        return new LocalTime(hour, minute, second, 0);
    }

    public static LocalTime of(int hour, int minute, int second, int nano) {
        return new LocalTime(hour, minute, second, nano);
    }

    public static LocalTime ofNanoOfDay(long nanoOfDay) {
        long NANOS_PER_HOUR = 3600000000000L;
        long NANOS_PER_MINUTE = 60000000000L;
        long NANOS_PER_SECOND = 1000000000L;
        LocalDateTime.checkSecondOfDay(nanoOfDay);
        int hours = (int)(nanoOfDay / 3600000000000L);
        int minutes = (int)((nanoOfDay -= (long)hours * 3600000000000L) / 60000000000L);
        int seconds = (int)((nanoOfDay -= (long)minutes * 60000000000L) / 1000000000L);
        return LocalTime.create(hours, minutes, seconds, (int)(nanoOfDay -= (long)seconds * 1000000000L));
    }

    private static LocalTime create(int hour, int minute, int second, int nanoOfSecond) {
        if ((minute | second | nanoOfSecond) == 0) {
            return HOURS[hour];
        }
        return new LocalTime(hour, minute, second, nanoOfSecond);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTime localTime = (LocalTime)o;
        return this.hour == localTime.hour && this.minute == localTime.minute && this.second == localTime.second && this.nano == localTime.nano;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.hour, this.minute, this.second, this.nano});
    }

    static {
        for (int i = 0; i < HOURS.length; ++i) {
            LocalTime.HOURS[i] = new LocalTime(i, 0, 0, 0);
        }
        MIDNIGHT = HOURS[0];
        MIN = HOURS[0];
    }
}

