/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.time;

import com.alibaba.fastjson2.time.DateTimeFormatter;
import com.alibaba.fastjson2.time.Instant;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.util.DateUtils;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public final class ZonedDateTime {
    public final LocalDateTime dateTime;
    public final int offsetSeconds;
    public final ZoneId zone;

    private ZonedDateTime(LocalDateTime dateTime, int offsetSeconds, ZoneId zone) {
        this.dateTime = dateTime;
        this.offsetSeconds = offsetSeconds;
        this.zone = zone;
    }

    public static ZonedDateTime ofInstant(Instant instant, ZoneId zone) {
        return ZonedDateTime.create(instant.epochSecond, instant.nanos, zone);
    }

    public static ZonedDateTime of(LocalDateTime localDateTime, ZoneId zone) {
        return ZonedDateTime.ofLocal(localDateTime, zone);
    }

    public static ZonedDateTime of(LocalDate localDate, LocalTime localTime, ZoneId zone) {
        return ZonedDateTime.ofLocal(LocalDateTime.of(localDate, localTime), zone);
    }

    public static ZonedDateTime now(ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(System.currentTimeMillis());
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    public ZonedDateTime minusNanos(long nanos) {
        Calendar calendar = Calendar.getInstance(this.zone.timeZone);
        calendar.set(this.dateTime.date.year, this.dateTime.date.monthValue - 1, this.dateTime.date.dayOfMonth, this.dateTime.time.hour, this.dateTime.time.minute, this.dateTime.time.second);
        long nano = (long)this.dateTime.time.nano + nanos;
        calendar.set(14, (int)nano / 1000000);
        long millis = calendar.getTimeInMillis();
        Instant instant = Instant.of(new Date(millis));
        return ZonedDateTime.ofInstant(instant, this.zone);
    }

    public ZonedDateTime plusDays(long days) {
        Calendar calendar = Calendar.getInstance(this.zone.timeZone);
        calendar.set(this.dateTime.date.year, this.dateTime.date.monthValue - 1, this.dateTime.date.dayOfMonth + (int)days, this.dateTime.time.hour, this.dateTime.time.minute, this.dateTime.time.second);
        calendar.set(14, this.dateTime.time.nano / 1000000);
        long millis = calendar.getTimeInMillis();
        Instant instant = Instant.of(new Date(millis));
        return ZonedDateTime.ofInstant(instant, this.zone);
    }

    public static ZonedDateTime ofLocal(LocalDateTime ldt, ZoneId zone) {
        Instant instant = ldt.toInstant(zone);
        int offset = zone.getOffsetTotalSeconds(instant);
        return new ZonedDateTime(ldt, offset, zone);
    }

    private static ZonedDateTime create(long epochSecond, int nanoOfSecond, ZoneId zone) {
        Instant instant = Instant.ofEpochSecond(epochSecond, nanoOfSecond);
        int offset = zone.getOffsetTotalSeconds(instant);
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(epochSecond, nanoOfSecond, offset);
        return new ZonedDateTime(ldt, offset, zone);
    }

    public Instant toInstant() {
        long seconds = this.toEpochMilli() / 1000L;
        return Instant.ofEpochSecond(seconds, this.dateTime.time.nano);
    }

    public long toEpochSecond() {
        return this.toEpochMilli() / 1000L;
    }

    public long toEpochMilli() {
        LocalDate date = this.dateTime.date;
        LocalTime time = this.dateTime.time;
        if (this.zone == ZoneId.SHANGHAI_ZONE_ID || this.zone.id.equals("Asia/Shanghai")) {
            long SECONDS_1991_09_15_02;
            long utcSeconds = DateUtils.utcSeconds(date.year, date.monthValue, date.dayOfMonth, time.hour, time.minute, time.second);
            int zoneOffsetTotalSeconds = utcSeconds >= (SECONDS_1991_09_15_02 = 684900000L) ? 28800 : DateUtils.getShanghaiZoneOffsetTotalSeconds(utcSeconds);
            return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L + (long)(time.nano / 1000000);
        }
        Calendar calendar = Calendar.getInstance(this.zone.timeZone);
        calendar.set(date.year, date.monthValue - 1, date.dayOfMonth, time.hour, time.minute, time.second);
        calendar.set(14, time.nano / 1000000);
        return calendar.getTimeInMillis();
    }

    public String format(DateTimeFormatter formatter) {
        return formatter.format(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZonedDateTime that = (ZonedDateTime)o;
        return this.dateTime == that.dateTime || this.dateTime != null && this.dateTime.equals(that.dateTime) && this.offsetSeconds == that.offsetSeconds && this.zone == that.zone || this.zone != null && this.zone.equals(that.zone);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.dateTime, this.offsetSeconds, this.zone});
    }
}

