/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.ObjDoubleConsumer;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;

final class FieldReaderDoubleValueFunc<T>
extends FieldReader<T> {
    final ObjDoubleConsumer<T> function;

    public FieldReaderDoubleValueFunc(String fieldName, int ordinal, Double defaultValue, Method method, ObjDoubleConsumer<T> function) {
        super(fieldName, Double.TYPE, Double.TYPE, ordinal, 0L, null, null, defaultValue, method, null);
        this.function = function;
    }

    @Override
    public void accept(T object, double value) {
        this.function.accept(object, value);
    }

    @Override
    public void accept(T object, Object value) {
        double doubleValue = TypeUtils.toDoubleValue(value);
        this.function.accept(object, doubleValue);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        double value = jsonReader.readDoubleValue();
        this.function.accept(object, value);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readDoubleValue();
    }
}

