/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import sun.misc.Unsafe;

public class JDKUtils {
    public static final Unsafe UNSAFE;
    public static final long ARRAY_BYTE_BASE_OFFSET;
    public static final long ARRAY_CHAR_BASE_OFFSET;
    public static final int JVM_VERSION;
    public static final Byte LATIN1;
    public static final Byte UTF16;
    public static final Field FIELD_STRING_VALUE;
    public static final long FIELD_STRING_VALUE_OFFSET;
    public static volatile boolean FIELD_STRING_VALUE_ERROR;
    public static final long FIELD_DECIMAL_INT_COMPACT_OFFSET;
    public static final Field FIELD_STRING_CODER;
    public static final long FIELD_STRING_CODER_OFFSET;
    public static volatile boolean FIELD_STRING_CODER_ERROR;
    static final Class<?> CLASS_SQL_DATASOURCE;
    static final Class<?> CLASS_SQL_ROW_SET;
    public static final boolean HAS_SQL;
    public static final boolean ANDROID;
    public static final boolean GRAAL;
    public static final boolean OPENJ9;
    public static final Class CLASS_TRANSIENT;
    public static final boolean BIG_ENDIAN;
    public static final boolean UNSAFE_SUPPORT = true;
    public static final boolean VECTOR_SUPPORT;
    public static final int VECTOR_BIT_LENGTH;
    public static final BiFunction<char[], Boolean, String> STRING_CREATOR_JDK8;
    public static final BiFunction<byte[], Byte, String> STRING_CREATOR_JDK11;
    public static final ToIntFunction<String> STRING_CODER;
    public static final Function<String, byte[]> STRING_VALUE;
    public static final MethodHandle METHOD_HANDLE_HAS_NEGATIVE;
    public static final Predicate<byte[]> PREDICATE_IS_ASCII;
    static final MethodHandles.Lookup IMPL_LOOKUP;
    static volatile MethodHandle CONSTRUCTOR_LOOKUP;
    static volatile boolean CONSTRUCTOR_LOOKUP_ERROR;
    static volatile Throwable initErrorLast;
    static volatile Throwable reflectErrorLast;
    static final AtomicInteger reflectErrorCount;

    public static boolean isSQLDataSourceOrRowSet(Class<?> type) {
        return CLASS_SQL_DATASOURCE != null && CLASS_SQL_DATASOURCE.isAssignableFrom(type) || CLASS_SQL_ROW_SET != null && CLASS_SQL_ROW_SET.isAssignableFrom(type);
    }

    public static void setReflectErrorLast(Throwable error) {
        reflectErrorCount.incrementAndGet();
        reflectErrorLast = error;
    }

    public static char[] getCharArray(String str) {
        if (!FIELD_STRING_VALUE_ERROR) {
            try {
                return (char[])UNSAFE.getObject(str, FIELD_STRING_VALUE_OFFSET);
            }
            catch (Exception ignored) {
                FIELD_STRING_VALUE_ERROR = true;
            }
        }
        return str.toCharArray();
    }

    public static MethodHandles.Lookup trustedLookup(Class objectClass) {
        if (!CONSTRUCTOR_LOOKUP_ERROR) {
            try {
                int TRUSTED = -1;
                MethodHandle constructor = CONSTRUCTOR_LOOKUP;
                if (JVM_VERSION < 15) {
                    if (constructor == null) {
                        CONSTRUCTOR_LOOKUP = constructor = IMPL_LOOKUP.findConstructor(MethodHandles.Lookup.class, MethodType.methodType(Void.TYPE, Class.class, Integer.TYPE));
                    }
                    int FULL_ACCESS_MASK = 31;
                    return constructor.invoke(objectClass, OPENJ9 ? FULL_ACCESS_MASK : TRUSTED);
                }
                if (constructor == null) {
                    CONSTRUCTOR_LOOKUP = constructor = IMPL_LOOKUP.findConstructor(MethodHandles.Lookup.class, MethodType.methodType(Void.TYPE, Class.class, Class.class, Integer.TYPE));
                }
                return constructor.invoke(objectClass, null, TRUSTED);
            }
            catch (Throwable ignored) {
                CONSTRUCTOR_LOOKUP_ERROR = true;
            }
        }
        return IMPL_LOOKUP.in(objectClass);
    }

    static {
        CallSite callSite;
        LATIN1 = 0;
        UTF16 = 1;
        reflectErrorCount = new AtomicInteger();
        Unsafe unsafe = null;
        long offset = -1L;
        long charOffset = -1L;
        try {
            Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            unsafe = (Unsafe)theUnsafeField.get(null);
            offset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
            charOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET;
        }
        catch (Throwable theUnsafeField) {
            // empty catch block
        }
        UNSAFE = unsafe;
        ARRAY_BYTE_BASE_OFFSET = offset;
        ARRAY_CHAR_BASE_OFFSET = charOffset;
        int jvmVersion = -1;
        boolean openj9 = false;
        boolean android = false;
        boolean graal = false;
        try {
            String javaSpecVer;
            String jmvName = System.getProperty("java.vm.name");
            openj9 = jmvName.contains("OpenJ9");
            android = jmvName.equals("Dalvik");
            boolean bl = graal = System.getProperty("org.graalvm.nativeimage.imagecode") != null;
            if (openj9 || android || graal) {
                FIELD_STRING_VALUE_ERROR = true;
            }
            if ((javaSpecVer = System.getProperty("java.specification.version")).startsWith("1.")) {
                javaSpecVer = javaSpecVer.substring(2);
            }
            if (javaSpecVer.indexOf(46) == -1) {
                jvmVersion = Integer.parseInt(javaSpecVer);
            }
        }
        catch (Throwable e) {
            initErrorLast = e;
        }
        OPENJ9 = openj9;
        ANDROID = android;
        GRAAL = graal;
        boolean hasJavaSql = true;
        Class<?> dataSourceClass = null;
        Class<?> rowSetClass = null;
        try {
            dataSourceClass = Class.forName("javax.sql.DataSource");
            rowSetClass = Class.forName("javax.sql.RowSet");
        }
        catch (Throwable ignored) {
            hasJavaSql = false;
        }
        CLASS_SQL_DATASOURCE = dataSourceClass;
        CLASS_SQL_ROW_SET = rowSetClass;
        HAS_SQL = hasJavaSql;
        Class<?> transientClass = null;
        if (!android) {
            try {
                transientClass = Class.forName("java.beans.Transient");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        CLASS_TRANSIENT = transientClass;
        JVM_VERSION = jvmVersion;
        if (JVM_VERSION == 8) {
            Field field = null;
            long fieldOffset = -1L;
            try {
                field = String.class.getDeclaredField("value");
                field.setAccessible(true);
                fieldOffset = UNSAFE.objectFieldOffset(field);
            }
            catch (Exception ignored) {
                FIELD_STRING_VALUE_ERROR = true;
            }
            FIELD_STRING_VALUE = field;
            FIELD_STRING_VALUE_OFFSET = fieldOffset;
            FIELD_STRING_CODER = null;
            FIELD_STRING_CODER_OFFSET = -1L;
            FIELD_STRING_CODER_ERROR = true;
        } else {
            Field fieldValue = null;
            long fieldValueOffset = -1L;
            try {
                fieldValue = String.class.getDeclaredField("value");
                fieldValueOffset = UNSAFE.objectFieldOffset(fieldValue);
            }
            catch (Exception ignored) {
                FIELD_STRING_VALUE_ERROR = true;
            }
            FIELD_STRING_VALUE_OFFSET = fieldValueOffset;
            FIELD_STRING_VALUE = fieldValue;
            Field fieldCode = null;
            long fieldCodeOffset = -1L;
            try {
                fieldCode = String.class.getDeclaredField("coder");
                fieldCodeOffset = UNSAFE.objectFieldOffset(fieldCode);
            }
            catch (Exception ignored) {
                FIELD_STRING_CODER_ERROR = true;
            }
            FIELD_STRING_CODER_OFFSET = fieldCodeOffset;
            FIELD_STRING_CODER = fieldCode;
        }
        long fieldOffset = -1L;
        try {
            Field field = BigDecimal.class.getDeclaredField("intCompact");
            fieldOffset = UNSAFE.objectFieldOffset(field);
        }
        catch (Throwable field) {
            // empty catch block
        }
        FIELD_DECIMAL_INT_COMPACT_OFFSET = fieldOffset;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        BiFunction stringCreatorJDK8 = null;
        BiFunction stringCreatorJDK11 = null;
        ToIntFunction stringCoder = null;
        Function stringValue = null;
        MethodHandles.Lookup trustedLookup = null;
        try {
            Class<MethodHandles.Lookup> lookupClass = MethodHandles.Lookup.class;
            Field implLookup = lookupClass.getDeclaredField("IMPL_LOOKUP");
            long fieldOffset2 = UNSAFE.staticFieldOffset(implLookup);
            trustedLookup = (MethodHandles.Lookup)UNSAFE.getObject(lookupClass, fieldOffset2);
        }
        catch (Throwable lookupClass) {
            // empty catch block
        }
        if (trustedLookup == null) {
            trustedLookup = MethodHandles.lookup();
        }
        IMPL_LOOKUP = trustedLookup;
        int vector_bit_length = -1;
        boolean vector_support = false;
        try {
            if (JVM_VERSION >= 11) {
                Class<?> factorClass = Class.forName("java.lang.management.ManagementFactory");
                Class<?> runtimeMXBeanClass = Class.forName("java.lang.management.RuntimeMXBean");
                Method getRuntimeMXBean = factorClass.getMethod("getRuntimeMXBean", new Class[0]);
                Object runtimeMXBean = getRuntimeMXBean.invoke(null, new Object[0]);
                Method getInputArguments = runtimeMXBeanClass.getMethod("getInputArguments", new Class[0]);
                List inputArguments = (List)getInputArguments.invoke(runtimeMXBean, new Object[0]);
                vector_support = inputArguments.contains("--add-modules=jdk.incubator.vector");
                if (vector_support) {
                    Class<?> byteVectorClass = Class.forName("jdk.incubator.vector.ByteVector");
                    Class<?> vectorSpeciesClass = Class.forName("jdk.incubator.vector.VectorSpecies");
                    Field speciesMax = byteVectorClass.getField("SPECIES_MAX");
                    Object species = speciesMax.get(null);
                    Method lengthMethod = vectorSpeciesClass.getMethod("length", new Class[0]);
                    int length = (Integer)lengthMethod.invoke(species, new Object[0]);
                    vector_bit_length = length * 8;
                }
            }
        }
        catch (Throwable e) {
            initErrorLast = e;
        }
        VECTOR_SUPPORT = vector_support;
        VECTOR_BIT_LENGTH = vector_bit_length;
        Predicate isAscii = null;
        MethodHandle handle = null;
        Class classStringCoding = null;
        if (JVM_VERSION >= 17) {
            try {
                classStringCoding = String.class;
                handle = trustedLookup.findStatic(String.class, "isASCII", MethodType.methodType(Boolean.TYPE, byte[].class));
            }
            catch (Throwable e) {
                initErrorLast = e;
            }
        }
        if (handle == null && JVM_VERSION >= 11) {
            try {
                classStringCoding = Class.forName("java.lang.StringCoding");
                handle = trustedLookup.findStatic(classStringCoding, "isASCII", MethodType.methodType(Boolean.TYPE, byte[].class));
            }
            catch (Throwable e) {
                initErrorLast = e;
            }
        }
        if (handle != null) {
            try {
                MethodHandles.Lookup lookup = JDKUtils.trustedLookup(classStringCoding);
                callSite = LambdaMetafactory.metafactory(lookup, "test", MethodType.methodType(Predicate.class), MethodType.methodType(Boolean.TYPE, Object.class), handle, MethodType.methodType(Boolean.TYPE, byte[].class));
                isAscii = callSite.getTarget().invokeExact();
            }
            catch (Throwable e) {
                initErrorLast = e;
            }
        }
        PREDICATE_IS_ASCII = isAscii;
        MethodHandle handle2 = null;
        if (JVM_VERSION >= 11) {
            try {
                Class<?> classStringCoding2 = Class.forName("java.lang.StringCoding");
                handle2 = trustedLookup.findStatic(classStringCoding2, "hasNegatives", MethodType.methodType(Boolean.TYPE, byte[].class, Integer.TYPE, Integer.TYPE));
            }
            catch (Throwable e) {
                initErrorLast = e;
            }
        }
        METHOD_HANDLE_HAS_NEGATIVE = handle2;
        Boolean compact_strings = null;
        try {
            if (JVM_VERSION == 8) {
                MethodHandles.Lookup lookup = JDKUtils.trustedLookup(String.class);
                MethodHandle handle3 = lookup.findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class, Boolean.TYPE));
                CallSite callSite2 = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(BiFunction.class), MethodType.methodType(Object.class, Object.class, Object.class), handle3, MethodType.methodType(String.class, char[].class, Boolean.TYPE));
                stringCreatorJDK8 = callSite2.getTarget().invokeExact();
            }
            boolean lookupLambda = false;
            if (JVM_VERSION > 8 && !android) {
                try {
                    Field compact_strings_field = String.class.getDeclaredField("COMPACT_STRINGS");
                    long fieldOffset3 = UNSAFE.staticFieldOffset(compact_strings_field);
                    compact_strings = UNSAFE.getBoolean(String.class, fieldOffset3);
                }
                catch (Throwable e) {
                    initErrorLast = e;
                }
                boolean bl = lookupLambda = compact_strings != null && compact_strings != false;
            }
            if (lookupLambda) {
                MethodHandles.Lookup lookup = trustedLookup.in(String.class);
                MethodHandle handle4 = lookup.findConstructor(String.class, MethodType.methodType(Void.TYPE, byte[].class, Byte.TYPE));
                callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(BiFunction.class), MethodType.methodType(Object.class, Object.class, Object.class), handle4, MethodType.methodType(String.class, byte[].class, Byte.class));
                stringCreatorJDK11 = callSite.getTarget().invokeExact();
                MethodHandle coder = lookup.findSpecial(String.class, "coder", MethodType.methodType(Byte.TYPE), String.class);
                CallSite applyAsInt = LambdaMetafactory.metafactory(lookup, "applyAsInt", MethodType.methodType(ToIntFunction.class), MethodType.methodType(Integer.TYPE, Object.class), coder, MethodType.methodType(Byte.TYPE, String.class));
                stringCoder = applyAsInt.getTarget().invokeExact();
                MethodHandle value = lookup.findSpecial(String.class, "value", MethodType.methodType(byte[].class), String.class);
                CallSite apply = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), value, MethodType.methodType(byte[].class, String.class));
                stringValue = apply.getTarget().invokeExact();
            }
        }
        catch (Throwable e) {
            initErrorLast = e;
        }
        if (stringCoder == null) {
            stringCoder = str -> 1;
        }
        STRING_CREATOR_JDK8 = stringCreatorJDK8;
        STRING_CREATOR_JDK11 = stringCreatorJDK11;
        STRING_CODER = stringCoder;
        STRING_VALUE = stringValue;
    }
}

