/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterPretty;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;

public interface JSON {
    public static final String VERSION = "2.0.4";

    public static Object parse(String text) {
        if (text == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static Object parse(String text, JSONReader.Feature ... features) {
        if (text == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static JSONObject parseObject(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONObject jSONObject = JSONObject.READER.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, JSONReader.Feature ... features) {
        if (text == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            JSONObject jSONObject = (JSONObject)objectReader.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream input, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8);){
            reader.getContext().config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            JSONObject jSONObject = (JSONObject)objectReader.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            JSONObject jSONObject = (JSONObject)objectReader.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream in, Charset charset) {
        if (in == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(in, charset);){
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            JSONObject jSONObject = (JSONObject)objectReader.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static JSONObject parseObject(URL url) {
        JSONObject jSONObject;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONObject = JSON.parseObject(is, StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("parseObject error", e);
                }
            }
            is.close();
        }
        return jSONObject;
    }

    public static JSONObject parseObject(byte[] bytes, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            JSONObject jSONObject = (JSONObject)objectReader.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            JSONObject jSONObject = (JSONObject)objectReader.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, Charset charset, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            JSONObject jSONObject = (JSONObject)objectReader.readObject(reader, 0L);
            return jSONObject;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (text == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Filter filter, JSONReader.Feature ... features) {
        if (text == null) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            reader.context.config(filter, features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            ObjectReader objectReader = reader.context.provider.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(String text, TypeReference typeReference, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            context.config(features);
            Type type = typeReference.getType();
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            context.config(features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setUtilDateFormat(format);
            }
            context.config(features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setUtilDateFormat(format);
            }
            context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader reader = JSONReader.of(bytes);
        ObjectReader objectReader = reader.getObjectReader(type);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            ObjectReader objectReader = reader.getObjectReader(clazz);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, String format, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setUtilDateFormat(format);
            }
            context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Type type, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Type type, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            T t = JSON.parseObject(is, type, features);
            return t;
        }
        catch (IOException e) {
            throw new JSONException("parseObject error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Function<JSONObject, T> function, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            JSONObject object = JSON.parseObject(is, features);
            if (object == null) {
                T t = null;
                return t;
            }
            JSONObject jSONObject = function.apply(object);
            return (T)jSONObject;
        }
        catch (IOException e) {
            throw new JSONException("parseObject error", e);
        }
    }

    public static <T> T parseObject(InputStream input, Type type, String format, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8);){
            JSONReader.Context context = reader.context;
            if (format != null && !format.isEmpty()) {
                context.setUtilDateFormat(format);
            }
            context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Charset charset, Type type, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(input, charset);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset);){
            ObjectReader objectReader = reader.getObjectReader(type);
            Object t = objectReader.readObject(reader, 0L);
            return t;
        }
    }

    public static <T> void parseObject(InputStream input, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        JSON.parseObject(input, StandardCharsets.UTF_8, '\n', type, consumer, features);
    }

    public static <T> void parseObject(InputStream input, Charset charset, char delimiter, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        AtomicReferenceFieldUpdater<JSONFactory.Cache, byte[]> byteUpdater;
        int identityHashCode = System.identityHashCode(Thread.currentThread());
        switch (identityHashCode & 3) {
            case 0: {
                byteUpdater = JSONFactory.BYTES0_UPDATER;
                break;
            }
            case 1: {
                byteUpdater = JSONFactory.BYTES1_UPDATER;
                break;
            }
            case 2: {
                byteUpdater = JSONFactory.BYTES2_UPDATER;
                break;
            }
            default: {
                byteUpdater = JSONFactory.BYTES3_UPDATER;
            }
        }
        byte[] bytes = byteUpdater.getAndSet(JSONFactory.CACHE, null);
        if (bytes == null) {
            bytes = new byte[8192];
        }
        int limit = 0;
        int start = 0;
        ObjectReader objectReader = null;
        try {
            int n;
            while ((n = input.read(bytes, limit, bytes.length - limit)) != -1) {
                for (int i = 0; i < n; ++i) {
                    int j = limit + i;
                    if (bytes[j] != delimiter) continue;
                    int end = j;
                    JSONReader jsonReader = JSONReader.of(bytes, start, end - start, charset);
                    jsonReader.context.config(features);
                    if (objectReader == null) {
                        objectReader = jsonReader.getObjectReader(type);
                    }
                    consumer.accept(objectReader.readObject(jsonReader));
                    start = end + 1;
                }
                if ((limit += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + 8192);
            }
        }
        catch (IOException e) {
            throw new JSONException("Interruption in reading", e);
        }
    }

    public static <T> void parseObject(Reader input, char delimiter, Type type, Consumer<T> consumer) {
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(JSONFactory.CACHE, null);
        if (chars == null) {
            chars = new char[8192];
        }
        int limit = 0;
        int start = 0;
        ObjectReader objectReader = null;
        try {
            int n;
            while ((n = input.read(chars, limit, chars.length - limit)) != -1) {
                for (int i = 0; i < n; ++i) {
                    int j = limit + i;
                    if (chars[j] != delimiter) continue;
                    int end = j;
                    JSONReader jsonReader = JSONReader.of(chars, start, end - start);
                    if (objectReader == null) {
                        objectReader = jsonReader.getObjectReader(type);
                    }
                    consumer.accept(objectReader.readObject(jsonReader));
                    start = end + 1;
                }
                if ((limit += n) != chars.length) continue;
                chars = Arrays.copyOf(chars, chars.length + 8192);
            }
        }
        catch (IOException e) {
            throw new JSONException("Interruption in reading", e);
        }
    }

    public static JSONArray parseArray(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONArray.class));
            JSONArray jSONArray = (JSONArray)objectReader.readObject(reader, 0L);
            return jSONArray;
        }
    }

    public static JSONArray parseArray(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONArray.class));
            JSONArray jSONArray = (JSONArray)objectReader.readObject(reader, 0L);
            return jSONArray;
        }
    }

    public static JSONArray parseArray(URL url, JSONReader.Feature ... features) {
        JSONArray jSONArray;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONArray = JSON.parseArray(is, features);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("parseArray error", e);
                }
            }
            is.close();
        }
        return jSONArray;
    }

    public static JSONArray parseArray(InputStream in, JSONReader.Feature ... features) {
        try (JSONReader reader = JSONReader.of(in, StandardCharsets.UTF_8);){
            reader.context.config(features);
            ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONArray.class));
            JSONArray jSONArray = (JSONArray)objectReader.readObject(reader, 0L);
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            List list = (List)reader.read(paramType);
            return list;
        }
    }

    public static <T> List<T> parseArray(String text, Type[] types, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ArrayList array = new ArrayList(types.length);
        try (JSONReader reader = JSONReader.of(text);){
            reader.context.config(features);
            reader.startArray();
            for (Type itemType : types) {
                array.add(reader.read(itemType));
            }
            reader.endArray();
            ArrayList arrayList = array;
            return arrayList;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        try (JSONReader reader = JSONReader.of(bytes);){
            reader.context.config(features);
            List list = (List)reader.read(paramType);
            return list;
        }
    }

    public static String toJSONString(Object object) {
        JSONWriter writer = JSONWriter.of();
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NullPointerException | NumberFormatException ex) {
                throw new JSONException("toJSONString error", ex);
            }
        }
    }

    public static String toJSONString(Object object, JSONWriter.Feature ... features) {
        JSONWriter.Context writeContext = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        boolean pretty = (writeContext.features & JSONWriter.Feature.PrettyFormat.mask) != 0L;
        JSONWriterUTF16 jsonWriter = new JSONWriterUTF16(writeContext);
        try (JSONWriter writer = pretty ? new JSONWriterPretty(jsonWriter) : jsonWriter;){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (writeContext.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = writeContext.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter filter, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (filter != null) {
                    writer.context.configFilter(filter);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static byte[] toJSONBytes(Object object) {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter ... filters) {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            if (filters != null && filters.length != 0) {
                writer.context.configFilter(filters);
            }
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static int writeTo(OutputStream out, Object object, JSONWriter.Feature ... features) {
        JSONWriter writer = JSONWriter.ofUTF8(features);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter writer = JSONWriter.ofUTF8(features);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter writer = JSONWriter.ofUTF8(features);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static boolean isValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(text);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes, offset, length, charset);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static Object toJSON(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        String str = JSON.toJSONString(object);
        return JSON.parse(str);
    }

    public static <T> T to(Class<T> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).to(clazz, new JSONReader.Feature[0]);
        }
        return TypeUtils.cast(object, clazz);
    }

    @Deprecated
    public static <T> T toJavaObject(Object object, Class<T> clazz) {
        return JSON.to(clazz, object);
    }

    public static void mixIn(Class<?> target, Class<?> mixinSource) {
        JSONFactory.defaultObjectWriterProvider.mixIn(target, mixinSource);
        JSONFactory.getDefaultObjectReaderProvider().mixIn(target, mixinSource);
    }

    public static boolean register(Type type, ObjectReader<?> objectReader) {
        return JSONFactory.getDefaultObjectReaderProvider().register(type, objectReader);
    }

    public static boolean register(ObjectReaderModule objectReaderModule) {
        return JSONFactory.getDefaultObjectReaderProvider().register(objectReaderModule);
    }

    public static boolean register(ObjectWriterModule objectWriterModule) {
        return JSONFactory.getDefaultObjectWriterProvider().register(objectWriterModule);
    }

    public static boolean register(Type type, ObjectWriter<?> objectWriter) {
        return JSONFactory.defaultObjectWriterProvider.register(type, objectWriter);
    }
}

