/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.function.BiConsumer;

final class FieldReaderDateFunc<T>
extends FieldReaderImpl<T> {
    final Method method;
    final BiConsumer<T, Date> function;
    DateTimeFormatter formatter;
    ObjectReader dateReader;

    public FieldReaderDateFunc(String fieldName, Class fieldClass, int ordinal, long features, String format, Locale locale, Date defaultValue, JSONSchema schema, Method method, BiConsumer<T, Date> function) {
        super(fieldName, fieldClass, fieldClass, ordinal, features, format, locale, defaultValue, schema);
        this.method = method;
        this.function = function;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void accept(T object, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (this.format != null) {
                DateTimeFormatter formatter = this.getFormatter(null);
                LocalDateTime ldt = this.format.indexOf("HH") == -1 ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
                long millis = zdt.toInstant().toEpochMilli();
                value = new Date(millis);
            }
        }
        this.function.accept(object, (Date)value);
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplDate.INSTANCE : new ObjectReaderImplDate(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        this.function.accept(object, (Date)this.readFieldValue(jsonReader));
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        Date fieldValue;
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            fieldValue = new Date(millis);
        } else if (jsonReader.isNull()) {
            jsonReader.readNull();
            fieldValue = null;
        } else if (this.format != null) {
            if (this.formatter == null) {
                String format = this.format.replaceAll("aa", "a");
                this.formatter = DateTimeFormatter.ofPattern(format);
            }
            String str = jsonReader.readString();
            LocalDateTime ldt = this.format.indexOf("HH") == -1 ? LocalDateTime.of(LocalDate.parse(str, this.formatter), LocalTime.MIN) : LocalDateTime.parse(str, this.formatter);
            ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
            long millis = zdt.toInstant().toEpochMilli();
            fieldValue = new Date(millis);
        } else {
            long millis = jsonReader.readMillisFromString();
            fieldValue = new Date(millis);
        }
        return fieldValue;
    }

    private DateTimeFormatter getFormatter(Locale locale) {
        if (this.formatter != null && locale == null) {
            return this.formatter;
        }
        String format = this.format.replaceAll("aa", "a");
        if (locale != null && locale != Locale.getDefault()) {
            return DateTimeFormatter.ofPattern(format, locale);
        }
        if (this.locale != null) {
            this.formatter = DateTimeFormatter.ofPattern(format, this.locale);
            return this.formatter;
        }
        this.formatter = DateTimeFormatter.ofPattern(format);
        return this.formatter;
    }
}

