/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import java.util.function.Function;
import java.util.function.Supplier;

final class ObjectReader1<T>
extends ObjectReaderBean<T> {
    final long features;
    final Supplier<T> defaultCreator;
    final Function buildFunction;
    final FieldReader fieldReader;
    final long hashCode;
    final long hashCodeLCase;

    ObjectReader1(Class objectClass, long features, JSONSchema schema, Supplier<T> defaultCreator, Function buildFunction, FieldReader fieldReader) {
        super(objectClass, null, schema);
        this.features = features;
        this.defaultCreator = defaultCreator;
        this.buildFunction = buildFunction;
        this.fieldReader = fieldReader;
        this.hashCode = Fnv.hashCode64(fieldReader.getFieldName());
        this.hashCodeLCase = Fnv.hashCode64LCase(fieldReader.getFieldName());
        if (fieldReader.isUnwrapped()) {
            this.extraFieldReader = fieldReader;
        }
        this.hasDefaultValue = fieldReader.getDefaultValue() != null;
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T createInstance(long features) {
        return this.defaultCreator.get();
    }

    @Override
    public T readObject(JSONReader jsonReader) {
        return this.readObject(jsonReader, this.features);
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, long features) {
        Object object;
        ObjectReader autoTypeReader = this.checkAutoType(jsonReader, this.objectClass, this.features | features);
        if (autoTypeReader != null && autoTypeReader != this && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, features);
        }
        if (jsonReader.isArray()) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt != 1) {
                throw new JSONException("not support input entryCount " + entryCnt);
            }
            T object2 = this.defaultCreator.get();
            this.fieldReader.readFieldValue(jsonReader, object2);
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            if (jsonReader.isTypeRedirect()) {
                jsonReader.setTypeRedirect(false);
            } else {
                throw new JSONException("expect object, but " + JSONB.typeName(jsonReader.getType()));
            }
        }
        if ((object = this.defaultCreator != null ? (Object)this.defaultCreator.get() : null) != null && this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        int i = 0;
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == this.getTypeKeyHash() && i == 0) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException("auotype not support : " + typeName);
                }
                if (autoTypeObjectReader != this) {
                    return autoTypeObjectReader.readJSONBObject(jsonReader, features);
                }
            } else if (hashCode != 0L) {
                if (hashCode == this.hashCode) {
                    this.fieldReader.readFieldValueJSONB(jsonReader, object);
                } else if (jsonReader.isSupportSmartMatch(features | this.features) && jsonReader.getNameHashCodeLCase() == this.hashCodeLCase) {
                    this.fieldReader.readFieldValue(jsonReader, object);
                } else {
                    this.processExtra(jsonReader, object);
                }
            }
            ++i;
        }
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    protected void initDefaultValue(T object) {
        this.fieldReader.setDefault(object);
    }

    @Override
    public T readObject(JSONReader jsonReader, long features) {
        Object object;
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, 0L);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray(features | this.getFeatures())) {
            jsonReader.nextIfMatch('[');
            T object2 = this.defaultCreator.get();
            this.fieldReader.readFieldValue(jsonReader, object2);
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException("array to bean end error, " + jsonReader.current());
            }
            jsonReader.nextIfMatch(',');
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        jsonReader.nextIfMatch('{');
        Object t = object = this.defaultCreator != null ? (Object)this.defaultCreator.get() : null;
        if (this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        int i = 0;
        while (!jsonReader.nextIfMatch('}')) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (i == 0 && hashCode == HASH_TYPE) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if ((autoTypeObjectReader != null || (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) != null) && autoTypeObjectReader != this) {
                    object = autoTypeObjectReader.readObject(jsonReader, features);
                    break;
                }
            } else if (hashCode == this.hashCode) {
                this.fieldReader.readFieldValue(jsonReader, object);
            } else if (jsonReader.isSupportSmartMatch(features | this.features) && jsonReader.getNameHashCodeLCase() == this.hashCodeLCase) {
                this.fieldReader.readFieldValue(jsonReader, object);
            } else {
                this.processExtra(jsonReader, object);
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.hashCode) {
            return this.fieldReader;
        }
        return null;
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        if (hashCode == this.hashCodeLCase) {
            return this.fieldReader;
        }
        return null;
    }

    @Override
    public boolean setFieldValue(Object object, String fieldName, long fieldNameHashCode, int value) {
        if (this.hashCode != fieldNameHashCode) {
            return false;
        }
        this.fieldReader.accept(object, value);
        return true;
    }
}

