/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import java.util.function.Function;
import java.util.function.Supplier;

final class ObjectReader5<T>
extends ObjectReaderBean<T> {
    final Supplier<T> defaultCreator;
    final long features;
    final Function buildFunction;
    final FieldReader fieldReader0;
    final FieldReader fieldReader1;
    final FieldReader fieldReader2;
    final FieldReader fieldReader3;
    final FieldReader fieldReader4;
    final long hashCode0;
    final long hashCode1;
    final long hashCode2;
    final long hashCode3;
    final long hashCode4;
    final long hashCode0LCase;
    final long hashCode1LCase;
    final long hashCode2LCase;
    final long hashCode3LCase;
    final long hashCode4LCase;

    ObjectReader5(Class objectClass, Supplier<T> defaultCreator, long features, JSONSchema schema, Function buildFunction, FieldReader fieldReader0, FieldReader fieldReader1, FieldReader fieldReader2, FieldReader fieldReader3, FieldReader fieldReader4) {
        super(objectClass, null, schema);
        this.defaultCreator = defaultCreator;
        this.features = features;
        this.buildFunction = buildFunction;
        this.fieldReader0 = fieldReader0;
        this.fieldReader1 = fieldReader1;
        this.fieldReader2 = fieldReader2;
        this.fieldReader3 = fieldReader3;
        this.fieldReader4 = fieldReader4;
        String fieldName0 = fieldReader0.getFieldName();
        String fieldName1 = fieldReader1.getFieldName();
        String fieldName2 = fieldReader2.getFieldName();
        String fieldName3 = fieldReader3.getFieldName();
        String fieldName4 = fieldReader4.getFieldName();
        this.hashCode0 = Fnv.hashCode64(fieldName0);
        this.hashCode1 = Fnv.hashCode64(fieldName1);
        this.hashCode2 = Fnv.hashCode64(fieldName2);
        this.hashCode3 = Fnv.hashCode64(fieldName3);
        this.hashCode4 = Fnv.hashCode64(fieldName4);
        this.hashCode0LCase = Fnv.hashCode64LCase(fieldName0);
        this.hashCode1LCase = Fnv.hashCode64LCase(fieldName1);
        this.hashCode2LCase = Fnv.hashCode64LCase(fieldName2);
        this.hashCode3LCase = Fnv.hashCode64LCase(fieldName3);
        this.hashCode4LCase = Fnv.hashCode64LCase(fieldName4);
        if (fieldReader0.isUnwrapped()) {
            this.extraFieldReader = fieldReader0;
        }
        if (fieldReader1.isUnwrapped()) {
            this.extraFieldReader = fieldReader1;
        }
        if (fieldReader2.isUnwrapped()) {
            this.extraFieldReader = fieldReader2;
        }
        if (fieldReader3.isUnwrapped()) {
            this.extraFieldReader = fieldReader3;
        }
        if (fieldReader4.isUnwrapped()) {
            this.extraFieldReader = fieldReader4;
        }
        this.hasDefaultValue = fieldReader0.getDefaultValue() != null || fieldReader1.getDefaultValue() != null || fieldReader2.getDefaultValue() != null || fieldReader3.getDefaultValue() != null || fieldReader4.getDefaultValue() != null;
    }

    @Override
    protected void initDefaultValue(T object) {
        this.fieldReader0.setDefault(object);
        this.fieldReader1.setDefault(object);
        this.fieldReader2.setDefault(object);
        this.fieldReader3.setDefault(object);
        this.fieldReader4.setDefault(object);
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, long features) {
        if (jsonReader.isArray()) {
            int entryCnt = jsonReader.startArray();
            T object = this.defaultCreator.get();
            this.fieldReader0.readFieldValue(jsonReader, object);
            this.fieldReader1.readFieldValue(jsonReader, object);
            this.fieldReader2.readFieldValue(jsonReader, object);
            this.fieldReader3.readFieldValue(jsonReader, object);
            this.fieldReader4.readFieldValue(jsonReader, object);
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object);
            }
            return object;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, features);
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            throw new JSONException("expect object, but " + JSONB.typeName(jsonReader.getType()));
        }
        Object object = this.defaultCreator != null ? (Object)this.defaultCreator.get() : null;
        if (object != null && this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == 0L) continue;
            if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode2) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode3) {
                this.fieldReader3.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode4) {
                this.fieldReader4.readFieldValue(jsonReader, object);
                continue;
            }
            if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                this.processExtra(jsonReader, object);
                continue;
            }
            long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
            if (nameHashCodeLCase == this.hashCode0LCase) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode1LCase) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode2LCase) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode3LCase) {
                this.fieldReader3.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode4LCase) {
                this.fieldReader4.readFieldValue(jsonReader, object);
                continue;
            }
            this.processExtra(jsonReader, object);
        }
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, features);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray()) {
            jsonReader.nextIfMatch('[');
            T object = this.defaultCreator.get();
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            this.fieldReader0.readFieldValue(jsonReader, object);
            this.fieldReader1.readFieldValue(jsonReader, object);
            this.fieldReader2.readFieldValue(jsonReader, object);
            this.fieldReader3.readFieldValue(jsonReader, object);
            this.fieldReader4.readFieldValue(jsonReader, object);
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException("array to bean end error, " + jsonReader.current());
            }
            jsonReader.nextIfMatch(',');
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object);
            }
            return object;
        }
        jsonReader.nextIfMatch('{');
        Object object = this.defaultCreator.get();
        if (this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        int i = 0;
        while (!jsonReader.nextIfMatch('}')) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (i == 0 && hashCode == HASH_TYPE) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if ((autoTypeObjectReader != null || (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) != null) && autoTypeObjectReader != this) {
                    object = autoTypeObjectReader.readObject(jsonReader, features);
                    break;
                }
            } else {
                if (hashCode == -1L) break;
                if (hashCode == this.hashCode0) {
                    this.fieldReader0.readFieldValue(jsonReader, object);
                } else if (hashCode == this.hashCode1) {
                    this.fieldReader1.readFieldValue(jsonReader, object);
                } else if (hashCode == this.hashCode2) {
                    this.fieldReader2.readFieldValue(jsonReader, object);
                } else if (hashCode == this.hashCode3) {
                    this.fieldReader3.readFieldValue(jsonReader, object);
                } else if (hashCode == this.hashCode4) {
                    this.fieldReader4.readFieldValue(jsonReader, object);
                } else if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                    this.processExtra(jsonReader, object);
                } else {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    if (nameHashCodeLCase == this.hashCode0LCase) {
                        this.fieldReader0.readFieldValue(jsonReader, object);
                    } else if (nameHashCodeLCase == this.hashCode1LCase) {
                        this.fieldReader1.readFieldValue(jsonReader, object);
                    } else if (nameHashCodeLCase == this.hashCode2LCase) {
                        this.fieldReader2.readFieldValue(jsonReader, object);
                    } else if (nameHashCodeLCase == this.hashCode3LCase) {
                        this.fieldReader3.readFieldValue(jsonReader, object);
                    } else if (nameHashCodeLCase == this.hashCode4LCase) {
                        this.fieldReader4.readFieldValue(jsonReader, object);
                    } else {
                        this.processExtra(jsonReader, object);
                    }
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public T createInstance(long features) {
        return this.defaultCreator.get();
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.hashCode0) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1) {
            return this.fieldReader1;
        }
        if (hashCode == this.hashCode2) {
            return this.fieldReader2;
        }
        if (hashCode == this.hashCode3) {
            return this.fieldReader3;
        }
        if (hashCode == this.hashCode4) {
            return this.fieldReader4;
        }
        return null;
    }
}

