/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

public class JDKUtils {
    public static final int JVM_VERSION;
    static final Class CLASS_SQL_DATASOURCE;
    static final Class CLASS_SQL_ROW_SET;
    public static final boolean HAS_SQL;
    public static final Class CLASS_TRANSIENT;

    public static boolean isSQLDataSourceOrRowSet(Class type) {
        return CLASS_SQL_DATASOURCE != null && CLASS_SQL_ROW_SET.isAssignableFrom(type) || CLASS_SQL_ROW_SET != null && CLASS_SQL_ROW_SET.isAssignableFrom(type);
    }

    public static char[] getCharArray(String str) {
        return str.toCharArray();
    }

    static {
        int jvmVersion = -1;
        try {
            String property = System.getProperty("java.specification.version");
            if (property.startsWith("1.")) {
                property = property.substring(2);
            }
            jvmVersion = Integer.parseInt(property);
        }
        catch (Throwable property) {
            // empty catch block
        }
        boolean hasJavaSql = true;
        Class<?> dataSourceClass = null;
        Class<?> rowSetClass = null;
        try {
            dataSourceClass = Class.forName("javax.sql.DataSource");
            rowSetClass = Class.forName("javax.sql.RowSet");
        }
        catch (Throwable e) {
            hasJavaSql = false;
        }
        CLASS_SQL_DATASOURCE = dataSourceClass;
        CLASS_SQL_ROW_SET = rowSetClass;
        HAS_SQL = hasJavaSql;
        Class<?> transientClass = null;
        try {
            transientClass = Class.forName("java.beans.Transient");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLASS_TRANSIENT = transientClass;
        JVM_VERSION = jvmVersion;
    }
}

